//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//=-                                                                         -=
//=-                   Tauron VGA Utilities Version 3.0                      -=
//=-                      Released September 20, 1998                        -=
//=-                                                                         -=
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//=- Copyright (c) 1997, 1998 by Jeff Morgan  =-= This code is FREE provided -=
//=- All Rights Reserved.                     =-= that you put my name some- -=
//=-                                          =-= where in your credits.     -=
//=- DISCLAIMER:                              =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//=- I assume no responsibility whatsoever for any effect that this package, -=
//=- the information contained therein or the use thereof has on you, your   -=
//=- sanity, computer, spouse, children, pets or anything else related to    -=
//=- you or your existance. No warranty is provided nor implied with this    -=
//=- source code.                                                            -=
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=


#include "defs.h"
#include "config.h"
#include "types.h"

#include "vga.h"
#include "vgaasm.h"


extern void     SetHwCursor(WORD pos);

extern BYTE     CurrentAttrib;
extern VMODE_ST Mode;
extern WORD     CursorScreen;
extern DBLWORD  VidMemBase;
//*********************************************************************

void TextClear(BYTE attrib)
{
  WORD     i,ilim = Mode.width_bytes ;
  DBLWORD  address = VidMemBase;

//   asm {
//   MOV AX,0B800H
//   MOV ES,AX
//   XOR DI,DI

//   MOV AH,attrib
//   MOV AL,' '
//   MOV CX,bytes
//   CLD
//   REP STOSW
//   }
  for(i=0;i<ilim;i++)
  {
    VgaMemoryWriteW(address,(attrib<<8)+' ');
    address++;
//    VgaMemoryWriteB(address,attrib);
    address++;
  }
  CurrentAttrib = attrib;
  CursorScreen = 0;
  SetHwCursor(CursorScreen);
}

//*********************************************************************

void Clear04H()
{
   WORD     i;
   DBLWORD  address = 0xB08000;

//   asm {
//   MOV AX,0B800H
//   MOV ES,AX
//   XOR DI,DI

//   MOV AX,0AAAAH
//   CLD
//   MOV CX,bytes
//   REP STOSW
//   }

   for(i=0;i<Mode.width_bytes;i++)
   {
      VgaMemoryWriteW(address,0xAAAA);
      address++;
      address++;
   }
}

//*********************************************************************

void Clear06H()
{
   WORD     i;

   DBLWORD  address = 0xB08000;

//   asm {
//   MOV AX,0B800H
//   MOV ES,AX
//   XOR DI,DI

//   MOV AX,0FFFFH
//   CLD
//   MOV CX,bytes
//   REP STOSW
//   }
   for(i=0;i<Mode.width_bytes;i++)
   {
      VgaMemoryWriteW(address,0xFFFF);
//      VgaMemoryWriteB(address+1,0xFF);
      address+=2;
   }
}

//*********************************************************************

void Clear0DH(BYTE color)
{
  WORD     i;

  DBLWORD  address = 0xA00000;

//   asm {
//   MOV AX,0A000H
//   MOV ES,AX
//   XOR DI,DI

//   MOV CX,bytes
//   }
//CLEAR_LOOP:
//   asm {
//   MOV DX,03CEH
//   MOV AX,0FF08H
//   OUT DX,AX

//   MOV AX,0
//   XCHG WORD PTR ES:[DI],AX

//   MOV DX,03C4H
//   MOV AH,color
//   MOV AL,2
//   OUT DX,AX

//   MOV WORD PTR ES:[DI],0FFFFH

//   MOV AX,0F02H
//   OUT DX,AX

//   MOV DX,03CEH
//   MOV AX,0FF08h
//   OUT DX,AX

//   ADD DI,2
//   LOOP CLEAR_LOOP
//   }

//    IoPortOutB(0x03CE,0x08);         // Address the data change bitmask
//    IoPortOutB(0x03CF,0xFF);         // Set the bitmask
  VgaIoWriteIx(0x3CE,0xFF08);
//    IoPortOutB(0x03C4,0x02);         // Address the map mask register
//    IoPortOutB(0x03C5,color);        // Write the color
  VgaIoWriteIx(0x3C4,(color<<8)+0x02);

  for(i=0;i<Mode.width_bytes/2;i++)
  {
//    VgaMemoryWrite(address,0x00);
//    VgaMemoryWrite(address+1,0x00);
//    VgaMemoryWriteB(address,0xFF);
    VgaMemoryWriteW(address,0xFFFF);
    address += 2;
   }
   IoPortOutB(0x03C5,0x0F);
}

//*********************************************************************

void Clear13H(BYTE Color)
{

   WORD     i;
   DBLWORD  address = 0xA00000;

//   asm {
//   MOV AX,0A000H
//   MOV ES,AX
//   XOR DI,DI

//   MOV AL,Color
//   MOV AH,AL
//   CLD
//   MOV CX,8000H
//   REP STOSW
//   }
   i=0;
   do
   {
      VgaMemoryWriteB(address,Color);
      address++;
      i++;
   }while(i);
}

//*********************************************************************

void PlanarClear(BYTE color)
{
    DBLWORD  address = 0xA00000;
    WORD   i;
//     unsigned int bytes = Mode.width_bytes/2;

//   asm {
//   MOV AX,0A000H
//   MOV ES,AX
//   XOR DI,DI
//
//   MOV CX,bytes
//   }
//CLEAR_LOOP:
//   asm {
//   MOV DX,03CEH
//   MOV AX,0FF08H
//   OUT DX,AX

//   MOV AX,0
//   XCHG WORD PTR ES:[DI],AX

//   MOV DX,03C4H
//   MOV AH,Color
//   MOV AL,2
//   OUT DX,AX

//   MOV WORD PTR ES:[DI],0FFFFH

//   MOV AX,0F02H
//   OUT DX,AX

//   MOV DX,03CEH
//   MOV AX,0FF08h
//   OUT DX,AX

//   ADD DI,2
//   LOOP CLEAR_LOOP
//   }
//  IoPortOutB(0x03CE,0x08);         // Address the data change bitmask
//  IoPortOutB(0x03CF,0xFF);         // Set the bitmask
  VgaIoWriteIx(0x3CE,0xFF08);
  IoPortOutB(0x3C4,0x02);
  for(i=0;i<Mode.width_bytes/2;i++)
  {
//    VgaMemoryReadW(address);
    VgaMemoryWriteW(address,0x0000);
//    VgaMemoryReadB(address+1);
//    VgaMemoryWriteB(address+1,0x00);
//  IoPortOutB(0x03C4,0x02);         // Address the map mask register
//  IoPortOutB(0x03C5,color);        // Write the color
    IoPortOutB(0x3C5,color);
    VgaMemoryWriteW(address,0xFFFF);
//    VgaMemoryWriteB(address+1,0xFF);
//   IoPortOutB(0x03C4,0x02);         // Address the map mask register
//   IoPortOutB(0x03C5,0x0F);
    IoPortOutB(0x3C5,0x0F);
    address += 2;
   }
}

void UnchainedClear(BYTE Color)
{

   WORD     i;
   DBLWORD  address = 0xA00000;

//   asm {
//   mov   dx, 03C4h         // 03c4h
//   mov   al, 2             // Map Mask Register
//   out   dx, al
//   inc   dx
//   mov   al,00001111B      // Select all planes to write to
//   out   dx, al            // Doing this to clear all planes at once

//   mov   ax,0A000H
//   mov   es, ax
//   XOR DI,DI               // set es:di = Screen Mem
//   mov ah,Color            // move the color into ah
//   mov al,ah               // copy the value to al
//   mov   cx,bytes          // Number of words
//   cld
//   rep   stosw             // clear it
//   }

//  IoPortOutB(0x03C4,0x02);         // Address the data change bitmask
//  IoPortOutB(0x03C5,0x0F);         // Set the bitmask
  VgaIoWriteIx(0x3C4,0x0F02);
  for(i=0;i<Mode.width_bytes/2;i++)
  {
    VgaMemoryWriteW(address,Color);
//    VgaMemoryWriteB(address+1,Color);
    address += 2;
  }
}
