#ifndef CONFIG_H
#define CONFIG_H

#ifndef __AVR_ATmega128__
#define __AVR_ATmega128__
#endif

#include <ioavr.h>


#define ADDRESS_LATCH_ENABLE   PORTG_Bit2    // Output   default= low
#define MEMORY_WRITE           PORTB_Bit7    // Output   default= high
#define MEMORY_READ            PORTB_Bit6    // Output   default= high
#define IO_WRITE               PORTB_Bit5    // Output   default= high
#define IO_READ                PORTB_Bit4    // Output   default= high
#define IO_CH_READY            PINE_Bit2     // Input
#define RESET                  PORTG_Bit3    // Output   default= low
#define BALE                   PORTB_Bit1    // Output   default= low
#define SBHE                   PORTB_Bit3    // Output   default= high
#define MEMCS16                PINE_Bit7     // Input
#define IOCS16                 PINE_Bit6     // Input
#define IRQ4                   PINE_Bit5     // Input
#define IRQ9                   PINE_Bit3     // Input

#define CLOCK_FREQ          (16000000)       // Hz
#define BAUD_RATE           (115200)     	   // bps

//******* Define constant expression ****************************************************

//#define USE_RTC
//#define USE_I2CEEPROM

//#define DEVICE_16                             // If you want use 16 bit addressing device uncomment this line
#define DEVICE_8
#define E24LC128
#define I2C_DEBUG	

// CPU clock speed

#define 	MHZ 							*1000000	          /* number of Hz in a MHz */
#define	  KHZ	              *1000					      /* number of Hz in a kHz */
#define 	XTAL_FREQ 				16MHZ 					    // EDIT THIS LINE !!
//	#define 			XTAL_FREQ 							14745000				// 14.745MHz processor	
//	#define 			XTAL_FREQ 							8000000 				// 8MHz processor
//	#define 			XTAL_FREQ 							7372800 				// 7.37MHz processor
//	#define 			XTAL_FREQ 							4000000 				// 4MHz processor
//	#define 			XTAL_FREQ 							3686400 				// 3.69MHz processor	
#define 	F_CPU 						XTAL_FREQ 			// 16MHz processor
#define 	CYCLES_PER_US     ((F_CPU+500000)/1000000) 	// cpu cycles per microsecond

#define   WDT_TO_16MS       0
#define   WDT_TO_32MS       1
#define   WDT_TO_65MS       2
#define   WDT_TO_130MS      3
#define   WDT_TO_260MS      4
#define   WDT_TO_520MS      5
#define   WDT_TO_1S         6
#define   WDT_TO_2S         7
#define   CLRWDT()          __watchdog_reset
#define  	HIGH						  1
#define  	LOW 						  0
#define   TRUE              1
#define   FALSE             0

//	#define 			UART_SPEED_HIGH	1 											// Uncomment this line if speed is high
#define 	BAUDRATE					57600 			
#define 	BUSCLK400 				400
#define 	BUSCLK1000 		    1000		                  // for 24FC512 1Mhz clock	
#define 	CLK400 		        (XTAL_FREQ/(4*BUSCLK400))-1 	
#define 	CLK1000 				  (XTAL_FREQ/(4*BUSCLK1000))	

#define 	RTS_ON()		      RA5 = 1
#define 	RTS_OFF()					RA5 = 0
#define 	PARAMETER_EEADDR	10					// Beginn the parameters field



#endif

