#include "defs.h"
#include "config.h"
#include "types.h"
#include "vga.h"
#include "vgaasm.h"
#include "modes.h"
#include "palette.h"
#include "font.h"
#include "clear.h"
#include "debug.h"


VMODE_ST Mode;                // Mode info

// Same as Mode 01H
__flash BYTE mode00h[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0x67,      0x00,          0x03,0x08,0x03,0x00,0x02,
// CRTC regs
0x2D,0x27,0x28,0x90,0x2B,0xA0,0xBF,0x1F,0x00,0x4F,0x0D,0x0F,0x00,0x00,0x00,0x00,
0x9C,0x8E,0x8F,0x14,0x1F,0x96,0xB9,0xA3,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x10,0x0E,0x00,0xFF,
// ATTRIBUTE CONTROLLER regs

//0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
//0x04,0x00,0x0F,0x08,0x00
0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x04,0x00,0x0F,0x08,0x00

};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// Same as Mode 02H
__flash BYTE mode03h[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0x67,      0x00,          0x03,0x00,0x03,0x00,0x02,
// CRTC regs
0x5F,0x4F,0x50,0x82,0x55,0x81,0xBF,0x1F,0x00,0x4F,0x0E,0x0F,0x00,0x00,0x00,0x01,
0x9C,0x8E,0x8F,0x28,0x1F,0x96,0xB9,0xA3,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x10,0x0E,0x00,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x04,0x00,0x0F,0x08,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// Same as Mode 05,
__flash BYTE mode04h[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0x63,      0x00,          0x03,0x09,0x03,0x00,0x02,
// CRTC regs
0x2D,0x27,0x28,0x90,0x2B,0x80,0xBF,0x1F,0x00,0x0C1,0x00,0x00,0x00,0x00,0x00,
0x31,0x9C,0x8E,0x8F,0x14,0x00,0x96,0xB9,0x0A2,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x30,0x0F,0x00,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x3B,0x3D,0x3F,0x02,0x04,0x06,0x07,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,
0x01,0x00,0x03,0x00,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE mode06h[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0x63,      0x00,          0x03,0x01,0x01,0x00,0x06,
// CRTC regs
0x5F,0x4F,0x50,0x82,0x54,0x80,0xBF,0x1F,0x00,0x0C1,0x00,0x00,0x00,0x00,0x00,
0x00,0x9C,0x8E,0x8F,0x28,0x00,0x96,0xB9,0x0C2,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0x00,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
0x01,0x00,0x01,0x00,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE mode07h[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0x66,     0x00,          0x03,0x00,0x03,0x00,0x02,
// CRTC regs
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x10,0x0A,0x00,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
0x0E,0x00,0x0F,0x00,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE mode0Dh[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0x63,     0x00,          0x03,0x09,0x0F,0x00,0x06,
// CRTC regs
0x2D,0x27,0x28,0x90,0x2B,0x80,0x0BF,0x1F,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,
0x31,0x9C,0x8E,0x8F,0x14,0x00,0x96,0xB9,0xE3,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x10,0x05,0x00,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x01,0x00,0x0F,0x00,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE mode0Eh[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0x63,      0x00,          0x03,0x01,0x0F,0x00,0x06,
// CRTC regs
0x5F,0x4F,0x50,0x82,0x54,0x80,0x0BF,0x1F,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,
0x59,0x9C,0x8E,0x8F,0x28,0x00,0x96,0xB9,0xE3,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0F,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x01,0x00,0x0F,0x00,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE mode0Fh[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0x0A2,     0x00,          0x03,0x01,0x0F,0x00,0x06,
// CRTC regs
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x05,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x08,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x18,0x00,0x00,
0x0B,0x00,0x05,0x00,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE mode10h[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0x0A3,     0x00,          0x03,0x01,0x0F,0x00,0x06,
// CRTC regs
0x5F,0x4F,0x50,0x82,0x54,0x80,0x0BF,0x1F,0x00,0x40,0x00,0x00,0x00,0x00,0x00,
0x00,0x83,0x85,0x5D,0x28,0x0F,0x63,0x0BA,0xE3,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0F,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x01,0x00,0x0F,0x00,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE mode11h[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0xE3,     0x00,          0x03,0x01,0x0F,0x00,0x06,
// CRTC regs
0x5F,0x4F,0x50,0x82,0x54,0x80,0x0B,0x3E,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x59,
0xEA,0x8C,0x0DF,0x28,0x0F,0x0E7,0x004,0x0C3,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x05,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x08,0x3F,0x3F,0x18,0x18,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
0x01,0x00,0x0F,0x00,0x00

};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE mode12h[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0xE3,     0x00,          0x03,0x01,0x0F,0x00,0x06,
// CRTC regs
0x5F,0x4F,0x50,0x82,0x54,0x80,0x0B,0x3E,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x59,
0xEA,0x8C,0x0DF,0x28,0x00,0x0E7,0x04,0xE3,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0F,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x01,0x00,0x0F,0x00,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE mode13h[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0x63,      0x00,          0x03,0x01,0x0F,0x00,0x0E,
// CRTC regs
0x5F,0x4F,0x50,0x82,0x54,0x80,0xBF,0x1F,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
0x9C,0x0E,0x8F,0x28,0x40,0x96,0xB9,0x0A3,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0F,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
0x41,0x00,0x0F,0x00,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE modeC4[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0x63,      0x00,          0x03,0x01,0x0F,0x00,0x06,
// CRTC regs
0x5F,0x4F,0x50,0x82,0x54,0x80,0xBF,0x1F,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
0x9C,0x0E,0x8F,0x28,0x00,0x96,0xB9,0xE3,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0F,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
0x41,0x00,0x0F,0x00,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE modeJ[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0xa3,      0x00,          0x03,0x01,0x03,0x00,0x02,
// CRTC regs
0x5F,0x4F,0x50,0x82,0x55,0x81,0xBF,0x1F,0x00,0x47,0x0E,0x0F,0x00,0x00,0x00,
0x00,0x83,0x85,0x57,0x28,0x1F,0x60,0xB8,0xA3,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x10,0x0E,0x00,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x0C,0x00,0x0F,0x00,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE modeK[62] = {
// MISC reg,  STATUS reg,    SEQ regs
   0x63,      0x00,          0x03,0x01,0x03,0x00,0x02,
// CRTC regs
0x5F,0x4F,0x50,0x82,0x55,0x81,0xBF,0x1F,0x00,0x47,0x0E,0x0F,0x00,0x00,0x00,
0x00,0x9C,0x8E,0x8F,0x28,0x1F,0x96,0xB9,0xA3,0xFF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x10,0x0E,0x00,0xFF,
// ATTRIBUTE CONTROLLER regs
0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x0C,0x00,0x0F,0x00,0x00
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

__flash BYTE modeL[62] = {
// MISC reg,  STATUS reg,    SEQ regs
    0x67,       0x00,        0x03,0x08,0x03,0x00,0x02,
// CRTC regs
0x2D,0x27,0x28,0x90,0x2B,0x0A0,0x0BF,0x1F,0x00,0x47,0x06,0x07,0x00,0x00,0x00,
0x31,0x83,0x85,0x57,0x14,0x1F,0x60,0x0B8,0x0A3,0x0FF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x10,0x0E,0x00,0x0FF,
// ATTRIBUTE CONTROLLER regs
0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,0x39,0x38,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x0C,0x00,0x0F,0x00,0x00,
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=


__flash BYTE modeM[62] = {
// MISC reg,  STATUS reg,    SEQ regs
0x67,0x00,0x03,0x08,0x03,0x00,0x02,
// CRTC regs
0x2D,0x27,0x28,0x90,0x2B,0x0A0,0x0BF,0x1F,0x00,0x47,0x06,0x07,0x00,0x00,0x00,0x31,
0x9C,0x8E,0x8F,0x14,0x1F,0x96,0x0B9,0x0A3,0x0FF,
// GRAPHICS regs
0x00,0x00,0x00,0x00,0x00,0x10,0x0E,0x00,0x0FF,
// ATTRIBUTE CONTROLLER regs
0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x0C,0x00,0x0F,0x00,0x00,
};
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=


void  ModeSet(BYTE __flash *dataptr)
{

   BYTE i;
//   data  BYTE rr,wr;
//   asm {
//   MOV SI, regs

   // Send MISC regs
//   MOV DX,MISC_ADDR
//   MOV AL,[SI]
//   OUT DX,AL
//   INC SI
    IoPortOutB(MISC_ADDR,0x67);      // Before acess registers must be set address sheme

//      IoPortOutB(0x03D4,0x11);
//      i = IoPortInB(0x03D5);

//      IoPortOutB(0x03D4,0x11);
//      IoPortOutB(0x03D5,0xA5);

//     IoPortOutB(0x03D4,0x11);
//     i = IoPortInB(0x03D5);

    IoPortOutB(MISC_ADDR,*dataptr);
    dataptr++;

//   MOV DX,STATUS_ADDR
//   MOV AL,[SI]
//   OUT DX,AL
//   INC SI
    IoPortOutB(STATUS_ADDR,*dataptr);
    dataptr++;

   // Send SEQ regs
//   MOV CX,0
//REG_LOOP:
//   MOV DX,SEQ_ADDR
//   MOV AL,CL
//   OUT DX,AL

//   MOV DX,SEQ_ADDR
//   INC DX
//   MOV AL,[SI]
//   OUT DX,AL

//   INC SI
//   INC CX
//   CMP CL,5
//   JL REG_LOOP
    for(i=0;i<5;i++)
    {
      IoPortOutB(SEQ_ADDR,i);
      IoPortOutB(SEQ_ADDR+1,*dataptr);
      dataptr++;
    }

   // Clear Protection bits
//   MOV AH,0EH
//   MOV AL,11H
//   AND AH,7FH
//   MOV DX,CRTC_ADDR
//   OUT DX,AX

     VgaIoWriteIx(CRTC_ADDR,0x0E11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0x0E);
     i = VgaIoReadIx(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    i = IoPortInB(CRTC_ADDR+1);


//   // Send CRTC regs
//   MOV CX,0
//REG_LOOP2:
//   MOV DX,CRTC_ADDR
//   MOV AL,CL
//   OUT DX,AL

//   MOV DX,CRTC_ADDR
//   INC DX
//   MOV AL,[SI]
//   OUT DX,AL

//   INC SI
//   INC CX
//   CMP CL,25
//   JL REG_LOOP2

    for(i=0;i<25;i++)
    {
      VgaIoWriteIx(CRTC_ADDR,((*dataptr)<<8)+i);
//      IoPortOutB(CRTC_ADDR,i);
//      IoPortOutB(CRTC_ADDR+1,*dataptr);
      dataptr++;
    }

   // Send GRAPHICS regs
//   MOV CX,0
//REG_LOOP3:
//   MOV DX,GRACON_ADDR
//   MOV AL,CL
//   OUT DX,AL

//   MOV DX,GRACON_ADDR
//   INC DX
//   MOV AL,[SI]
//   OUT DX,AL

//   INC SI
//   INC CX
//   CMP CL,9
//   JL REG_LOOP3
    for(i=0;i<9;i++)
    {
      VgaIoWriteIx(GRACON_ADDR,((*dataptr)<<8)+i);
//      IoPortOutB(GRACON_ADDR,i);
//      IoPortOutB(GRACON_ADDR+1,*dataptr);
      dataptr++;
    }



//   MOV DX,STATUS_ADDR
//   IN AL,DX
   i = IoPortInB(STATUS_ADDR);

// Send ATTRCON regs
//   MOV CX,0
//REG_LOOP4:
//   MOV DX,ATTRCON_ADDR
//   IN AX,DX
//
//   MOV AL,CL
//   OUT DX,AL

//   MOV AL,[SI]
//   OUT DX,AL

//   INC SI
//   INC CX
//   CMP CL,21
//   JL REG_LOOP4

//   MOV AL,20H
//   OUT DX,AL
//   }
    for(i=0;i<21;i++)
    {
      IoPortInB(0x03DA);
      IoPortOutB(ATTRCON_ADDR,i);
      IoPortOutB(ATTRCON_ADDR,*dataptr);
      dataptr++;
    }
   VgaIoWriteIx(0x3CE,0x3A0B);
   IoPortInB(0x03DA);
   IoPortOutB(ATTRCON_ADDR,0x20);
   IoPortOutB(0x3C6,0xFF);
}

//*********************************************************************

void SetVideoMode(BYTE mode)
{

   Mode.mode = mode;
   if (mode == MODE00H)                        // 40 x 25 x 16
   {
      ModeSet(mode00h);
      setpalette16();
      FontsRead(Font8x16,16);

      Mode.width = 40;
      Mode.height = 25;
      Mode.width_bytes = 1000;
      Mode.colors = 16;
      Mode.attrib = TVU_TEXT;
   }
   else if (mode == MODE03H)                   // 80 x 25 x 16
   {
      ModeSet(mode03h);
      setpalette16();
      FontsRead(Font8x16,16);

      Mode.width = 80;
      Mode.height = 25;
      Mode.width_bytes = 2000;
      Mode.colors = 16;
      Mode.attrib = TVU_TEXT;
   }
   else if (mode == MODE04H)                   // 320 x 200 x 4
   {
      ModeSet(mode04h);
      setpalette4();

      Mode.width = 320;
      Mode.height = 200;
      Mode.width_bytes = 8192;
      Mode.colors = 4;
      Mode.attrib = TVU_GRAPHICS;
   }
   else if (mode == MODE06H)                    // 640 x 200 x 2
   {
      ModeSet(mode06h);

      Mode.width = 640;
      Mode.height = 200;
      Mode.width_bytes = 8192;
      Mode.colors = 2;
      Mode.attrib = TVU_GRAPHICS;
   }
   else if (mode == MODE07H)                    // 80 x 25 x 2
   {
      ModeSet(mode07h);

      Mode.width = 80;
      Mode.height = 25;
      Mode.width_bytes = 2000;
      Mode.colors = 2;
      Mode.attrib = TVU_TEXT | TVU_MONOCHROME;
   }
   else if (mode == MODE0DH)                    // 320 x 200 x 16
   {
      ModeSet(mode0Dh);
      setpalette16();

      Mode.width = 320;
      Mode.height = 200;
      Mode.width_bytes = 8000;
      Mode.colors = 16;
      Mode.attrib = TVU_GRAPHICS | TVU_PLANAR;
   }
   else if (mode == MODE0EH)                    // 640 x 200 x 16
   {
      ModeSet(mode0Eh);
      setpalette16();

      Mode.width = 640;
      Mode.height = 200;
      Mode.width_bytes = 16000;
      Mode.colors = 16;
      Mode.attrib = TVU_GRAPHICS | TVU_PLANAR;
   }
   else if (mode == MODE0FH)                    // 640 x 350 x 2
   {
      ModeSet(mode0Fh);

      Mode.width = 640;
      Mode.height = 350;
      Mode.width_bytes = 28000;
      Mode.colors = 2;
      Mode.attrib = TVU_GRAPHICS | TVU_MONOCHROME;
   }
   else if (mode == MODE10H)                    // 640 x 350 x 16
   {
      ModeSet(mode10h);
      setpalette16();

      Mode.width = 640;
      Mode.height = 350;
      Mode.width_bytes = 28000;
      Mode.colors = 16;
      Mode.attrib = TVU_GRAPHICS | TVU_PLANAR;
   }
   else if (mode == MODE11H)                    // 640 x 480 x 2
   {
      ModeSet(mode11h);

      Mode.width = 640;
      Mode.height = 480;
      Mode.width_bytes = 38400u;
      Mode.colors = 2;
      Mode.attrib = TVU_GRAPHICS | TVU_PLANAR;
   }
   else if (mode == MODE12H)                    // 640 x 480 x 16
   {
      ModeSet(mode12h);
      setpalette16();

      Mode.width = 640;
      Mode.height = 480;
      Mode.width_bytes = 38400u;
      Mode.colors = 16;
      Mode.attrib = TVU_GRAPHICS | TVU_PLANAR;
   }
   else if (mode == MODE13H)                    // 320 x 200 x 256
   {
      ModeSet(mode13h);
      setpalette256();

      Mode.width = 320;
      Mode.height = 200;
      Mode.width_bytes = 64000u;
      Mode.colors = 256;
      Mode.attrib = TVU_GRAPHICS;
   }
   else if (mode == CHAIN4)                     // unchained 320 x 200 x 256
   {
      ModeSet(modeC4);
      setpalette256();

      Mode.width = 320;
      Mode.height = 200;
      Mode.width_bytes = 16000;
      Mode.colors = 256;
      Mode.attrib = TVU_GRAPHICS | TVU_UNCHAINED;
   }
   else if (mode == MODE_X)                     // unchained 320 x 240 x 256
   {
      ModeSet(modeC4);

//    outportb(MISC_ADDR,0xE3);
      IoPortOutB(MISC_ADDR,0xE3);

      // turn off write protect
//    outport(CRTC_ADDR,0x2C11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0x2C);
      VgaIoWriteIx(CRTC_ADDR,0x2C11);

      // vertical total
//    outport(CRTC_ADDR,0x0D06);
//    IoPortOutB(CRTC_ADDR,0x06);
//    IoPortOutB(CRTC_ADDR+1,0x0D);
      VgaIoWriteIx(CRTC_ADDR,0x0D06);
      // overflow register
//    outport(CRTC_ADDR,0x3E07);
//    IoPortOutB(CRTC_ADDR,0x07);
//    IoPortOutB(CRTC_ADDR+1,0x3E);
      VgaIoWriteIx(CRTC_ADDR,0x3E07);
      // vertical retrace start
//    outport(CRTC_ADDR,0xEA10);
//    IoPortOutB(CRTC_ADDR,0x10);
//    IoPortOutB(CRTC_ADDR+1,0xEA);
      VgaIoWriteIx(CRTC_ADDR,0xEA10);
      // vertical retrace end AND wr.prot
//    outport(CRTC_ADDR,0xAC11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0xAC);
      VgaIoWriteIx(CRTC_ADDR,0xAC11);
      // vertical display enable end
//    outport(CRTC_ADDR,0xDF12);
//    IoPortOutB(CRTC_ADDR,0x12);
//    IoPortOutB(CRTC_ADDR+1,0xDF);
      VgaIoWriteIx(CRTC_ADDR,0xDF12);
      // start vertical blanking
//    outport(CRTC_ADDR,0xE715);
//    IoPortOutB(CRTC_ADDR,0x15);
//    IoPortOutB(CRTC_ADDR+1,0xE7);
      VgaIoWriteIx(CRTC_ADDR,0xE715);
      // end vertical blanking
//    outport(CRTC_ADDR,0x0616);
//    IoPortOutB(CRTC_ADDR,0x16);
//    IoPortOutB(CRTC_ADDR+1,0x06);
      VgaIoWriteIx(CRTC_ADDR,0x0616);
      setpalette256();
      Mode.width = 320;
      Mode.height = 240;
      Mode.width_bytes = 19200;
      Mode.colors = 256;
      Mode.attrib = TVU_GRAPHICS | TVU_UNCHAINED;
   }
   else if (mode == MODE_A)                     // unchained 320 x 350 x 256
   {
      ModeSet(modeC4);

      // turn off double scanning mode
//    outportb(CRTC_ADDR,9);
//    outportb(CRTC_ADDR+1,inportb(CRTC_ADDR+1) & ~0x1F);
      IoPortOutB(CRTC_ADDR,0x09);
      IoPortOutB(CRTC_ADDR+1,IoPortInB(CRTC_ADDR+1) & ~0x1F);

      // change the vertical resolution flags to 350
//    outportb(MISC_ADDR,(inportb(0x3CC) & ~0xC0) | 0x80);
      IoPortOutB(MISC_ADDR,(IoPortInB(0x3CC) & ~0xC0) | 0x80);

      // turn off write protect
//    outport(CRTC_ADDR,0x2C11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0x2C);
      VgaIoWriteIx(CRTC_ADDR,0x2C11);
      // vertical total
//    outport(CRTC_ADDR,0xBF06);
//    IoPortOutB(CRTC_ADDR,0x06);
//    IoPortOutB(CRTC_ADDR+1,0xBF);
      VgaIoWriteIx(CRTC_ADDR,0xBF06);
      // overflow register
//    outport(CRTC_ADDR,0x1F07);
//    IoPortOutB(CRTC_ADDR,0x07);
//    IoPortOutB(CRTC_ADDR+1,0x1F);
      VgaIoWriteIx(CRTC_ADDR,0x1F07);
      // vertical retrace start
//    outport(CRTC_ADDR,0x8310);
//    IoPortOutB(CRTC_ADDR,0x10);
//    IoPortOutB(CRTC_ADDR+1,0x83);
      VgaIoWriteIx(CRTC_ADDR,0x8310);
      // vertical retrace end AND wr.prot
//    outport(CRTC_ADDR,0x8511);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0x85);
      VgaIoWriteIx(CRTC_ADDR,0x8511);
      // vertical display enable end
//    outport(CRTC_ADDR,0x5D12);
//    IoPortOutB(CRTC_ADDR,0x12);
//    IoPortOutB(CRTC_ADDR+1,0x5D);
      VgaIoWriteIx(CRTC_ADDR,0x5D12);
      // start vertical blanking
//    outport(CRTC_ADDR,0x6315);
//    IoPortOutB(CRTC_ADDR,0x15);
//    IoPortOutB(CRTC_ADDR+1,0x63);
      VgaIoWriteIx(CRTC_ADDR,0x6315);
      // end vertical blanking
//    outport(CRTC_ADDR,0xBA16);
//    IoPortOutB(CRTC_ADDR,0x16);
//    IoPortOutB(CRTC_ADDR+1,0xBA);
      VgaIoWriteIx(CRTC_ADDR,0xBA16);

      setpalette256();
      Mode.width = 320;
      Mode.height = 350;
      Mode.width_bytes = 28000u;
      Mode.colors = 256;
      Mode.attrib = TVU_GRAPHICS | TVU_UNCHAINED;
   }
   else if (mode == MODE_B)                     // unchained 320 x 400 x 256
   {
      ModeSet(modeC4);
      // turn off double scanning mode
//    outportb(CRTC_ADDR,9);
//    outportb(CRTC_ADDR+1,inportb(CRTC_ADDR+1) & ~0x1F);
      IoPortOutB(CRTC_ADDR,0x09);
      IoPortOutB(CRTC_ADDR+1,IoPortInB(CRTC_ADDR+1) & ~0x1F);

      // change the vertical resolution flags to 400
//      outportb(MISC_ADDR,(inportb(0x3CC) & ~0xC0) | 0x40);
      IoPortOutB(MISC_ADDR+1,(IoPortInB(0x3CC) & ~0xC0) | 0x40);

      setpalette256();
      Mode.width = 320;
      Mode.height = 400;
      Mode.width_bytes = 32000;
      Mode.colors = 256;
      Mode.attrib = TVU_GRAPHICS | TVU_UNCHAINED;
   }
   else if (mode == MODE_C)                     // unchained 320 x 480 x 256
   {
      ModeSet(modeC4);

      // turn off double scanning mode
//    outportb(CRTC_ADDR,9);
//    outportb(CRTC_ADDR+1,inportb(CRTC_ADDR+1) & ~0x1F);
      IoPortOutB(CRTC_ADDR,0x09);
      IoPortOutB(CRTC_ADDR+1,IoPortInB(CRTC_ADDR+1) & ~0x1F);

      // change the vertical resolution flags to 480
//    outportb(MISC_ADDR,(inportb(0x3CC) & ~0xC0) | 0xC0);
      IoPortOutB(MISC_ADDR,(IoPortInB(0x3CC) & ~0xC0) | 0xC0);

      // turn off write protect
//    outport(CRTC_ADDR,0x2C11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0x2C);
      VgaIoWriteIx(CRTC_ADDR,0x2C11);
      // vertical total
//    outport(CRTC_ADDR,0x0D06);
//    IoPortOutB(CRTC_ADDR,0x06);
//    IoPortOutB(CRTC_ADDR+1,0x0D);
      VgaIoWriteIx(CRTC_ADDR,0x0D06);
      // overflow register
//    outport(CRTC_ADDR,0x3E07)
//    IoPortOutB(CRTC_ADDR,0x07);
//    IoPortOutB(CRTC_ADDR+1,0x3E);
      VgaIoWriteIx(CRTC_ADDR,0x3E07);
      // vertical retrace start
//    outport(CRTC_ADDR,0xEA10);
//    IoPortOutB(CRTC_ADDR,0x10);
//    IoPortOutB(CRTC_ADDR+1,0xEA);
      VgaIoWriteIx(CRTC_ADDR,0xEA10);
      // vertical retrace end AND wr.prot
//    outport(CRTC_ADDR,0xAC11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0xAC);
      VgaIoWriteIx(CRTC_ADDR,0xAC11);
      // vertical display enable end
//    outport(CRTC_ADDR,0xDF12);
//    IoPortOutB(CRTC_ADDR,0x12);
//    IoPortOutB(CRTC_ADDR+1,0xDF);
      VgaIoWriteIx(CRTC_ADDR,0xDF12);
      // start vertical blanking
//    outport(CRTC_ADDR,0xE715);
//    IoPortOutB(CRTC_ADDR,0x15);
//    IoPortOutB(CRTC_ADDR+1,0xE7);
      VgaIoWriteIx(CRTC_ADDR,0xE715);
      // end vertical blanking
//    outport(CRTC_ADDR,0x0616);
//    IoPortOutB(CRTC_ADDR,0x16);
//    IoPortOutB(CRTC_ADDR+1,0x06);
      VgaIoWriteIx(CRTC_ADDR,0x0616);
      setpalette256();
      Mode.width = 320;
      Mode.height = 480;
      Mode.width_bytes = 38400u;
      Mode.colors = 256;
      Mode.attrib = TVU_GRAPHICS | TVU_UNCHAINED;
   }
   else if (mode == MODE_D)                     // unchained 360 x 200 x 256
   {
      ModeSet(mode13h);

      // Turn off Chain 4
//    outport(SEQ_ADDR,0x0604);
//    IoPortOutB(SEQ_ADDR,0x04);
//    IoPortOutB(SEQ_ADDR+1,0x06);
      VgaIoWriteIx(SEQ_ADDR,0x0604);
      // Activate a synchronous reset
//    outport(SEQ_ADDR,0x0100);
//    IoPortOutB(SEQ_ADDR,0x00);
//    IoPortOutB(SEQ_ADDR+1,0x01);
      VgaIoWriteIx(SEQ_ADDR,0x0100);
      // Select 28 mhz pixel clock
//    outportb(MISC_ADDR,0xE7);
      IoPortOutB(MISC_ADDR,0xE7);

      // Release synchronous reset
//    outport(SEQ_ADDR,0x0300);
//    IoPortOutB(SEQ_ADDR,0x00);
//    IoPortOutB(SEQ_ADDR+1,0x03);
      VgaIoWriteIx(SEQ_ADDR,0x0300);

      // change the vertical resolution flags to 400
//    outportb(MISC_ADDR,(inportb(0x3CC) & ~0xC0) | 0x40);
      IoPortOutB(MISC_ADDR,(IoPortInB(0x3CC) & ~0xC0) | 0x40);

      // turn off write protect
//    outport(CRTC_ADDR,0x2C11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0x2C);
      VgaIoWriteIx(CRTC_ADDR,0x2C11);
//    outport(CRTC_ADDR,0x6B00);
//    IoPortOutB(CRTC_ADDR,0x00);
//    IoPortOutB(CRTC_ADDR+1,0x6B);
      VgaIoWriteIx(CRTC_ADDR,0x6B00);
//    outport(CRTC_ADDR,0x5901);
//    IoPortOutB(CRTC_ADDR,0x01);
//    IoPortOutB(CRTC_ADDR+1,0x59);
      VgaIoWriteIx(CRTC_ADDR,0x5901);
//    outport(CRTC_ADDR,0x5A02);
//    IoPortOutB(CRTC_ADDR,0x02);
//    IoPortOutB(CRTC_ADDR+1,0x5A);
      VgaIoWriteIx(CRTC_ADDR,0x5A02);
//    outport(CRTC_ADDR,0x8E03);
//    IoPortOutB(CRTC_ADDR,0x03);
//    IoPortOutB(CRTC_ADDR+1,0x8E);
      VgaIoWriteIx(CRTC_ADDR,0x8E03);
//    outport(CRTC_ADDR,0x5E04);
//    IoPortOutB(CRTC_ADDR,0x04);
//    IoPortOutB(CRTC_ADDR+1,0x5E);
      VgaIoWriteIx(CRTC_ADDR,0x5E04);
//    outport(CRTC_ADDR,0x8A05);
//    IoPortOutB(CRTC_ADDR,0x05);
//    IoPortOutB(CRTC_ADDR+1,0x8A);
      VgaIoWriteIx(CRTC_ADDR,0x8A05);
//    outport(CRTC_ADDR,0x0008);
//    IoPortOutB(CRTC_ADDR,0x08);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x0008);
//    outport(CRTC_ADDR,0xC009);
//    IoPortOutB(CRTC_ADDR,0x09);
//    IoPortOutB(CRTC_ADDR+1,0xC0);
      VgaIoWriteIx(CRTC_ADDR,0xC009);
//    outport(CRTC_ADDR,0x000A);
//    IoPortOutB(CRTC_ADDR,0x0A);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000A);
//    outport(CRTC_ADDR,0x000B);
//    IoPortOutB(CRTC_ADDR,0x0B);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000B);
//    outport(CRTC_ADDR,0x000C);
//    IoPortOutB(CRTC_ADDR,0x0C);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000C);
//    outport(CRTC_ADDR,0x000D);
//    IoPortOutB(CRTC_ADDR,0x0D);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000D);
//    outport(CRTC_ADDR,0x000E);
//    IoPortOutB(CRTC_ADDR,0x0E);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000E);
//    outport(CRTC_ADDR,0x000F);
//    IoPortOutB(CRTC_ADDR,0x0F);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000F);
//    outport(CRTC_ADDR,0xAC11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0xAC);
      VgaIoWriteIx(CRTC_ADDR,0xAC11);
//    outport(CRTC_ADDR,0x2D13);
//    IoPortOutB(CRTC_ADDR,0x13);
//    IoPortOutB(CRTC_ADDR+1,0x2D);
      VgaIoWriteIx(CRTC_ADDR,0x2D13);
//    outport(CRTC_ADDR,0x0014);
//    IoPortOutB(CRTC_ADDR,0x14);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x0014);
//    outport(CRTC_ADDR,0xE317);
//    IoPortOutB(CRTC_ADDR,0x17);
//    IoPortOutB(CRTC_ADDR+1,0xE3);
      VgaIoWriteIx(CRTC_ADDR,0xE317);
//    outport(CRTC_ADDR,0xFF18);
//    IoPortOutB(CRTC_ADDR,0x18);
//    IoPortOutB(CRTC_ADDR+1,0xFF);
      VgaIoWriteIx(CRTC_ADDR,0xFF18);
      setpalette256();
      Mode.width = 360;
      Mode.height = 200;
      Mode.width_bytes = 18000u;
      Mode.colors = 256;
      Mode.attrib = TVU_GRAPHICS | TVU_UNCHAINED;
   }
   else if (mode == MODE_E)                     // unchained 360 x 240 x 256
   {
      ModeSet(mode13h);

      // Turn off Chain 4
//    outport(SEQ_ADDR,0x0604);
//    IoPortOutB(SEQ_ADDR,0x04);
//    IoPortOutB(SEQ_ADDR+1,0x06);
      VgaIoWriteIx(SEQ_ADDR,0x0604);
      // Activate a synchronous reset
//    outport(SEQ_ADDR,0x0100);
//    IoPortOutB(SEQ_ADDR,0x00);
//    IoPortOutB(SEQ_ADDR+1,0x01);
      VgaIoWriteIx(SEQ_ADDR,0x0100);
      // Select 28 mhz pixel clock
//    outportb(MISC_ADDR,0xE7);
      IoPortOutB(MISC_ADDR,0xE7);

      // Release synchronous reset
//    outport(SEQ_ADDR,0x0300);
//    IoPortOutB(SEQ_ADDR,0x00);
//    IoPortOutB(SEQ_ADDR+1,0x03);
      VgaIoWriteIx(SEQ_ADDR,0x0300);

      // change the vertical resolution flags to 480
//    outportb(MISC_ADDR,(inportb(0x3CC) & ~0xC0) | 0xC0);
      IoPortOutB(MISC_ADDR,(IoPortInB(0x3CC) & ~0xC0) | 0xC0);

      // turn off write protect
//    outport(CRTC_ADDR,0x2C11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0x2C);
      VgaIoWriteIx(CRTC_ADDR,0x2C11);
//    outport(CRTC_ADDR,0x6B00);
//    IoPortOutB(CRTC_ADDR,0x00);
//    IoPortOutB(CRTC_ADDR+1,0x6B);
      VgaIoWriteIx(CRTC_ADDR,0x6B00);
//    outport(CRTC_ADDR,0x5901);
//    IoPortOutB(CRTC_ADDR,0x01);
//    IoPortOutB(CRTC_ADDR+1,0x59);
      VgaIoWriteIx(CRTC_ADDR,0x5901);
//    outport(CRTC_ADDR,0x5A02);
//    IoPortOutB(CRTC_ADDR,0x02);
//    IoPortOutB(CRTC_ADDR+1,0x5A);
      VgaIoWriteIx(CRTC_ADDR,0x5A02);
//    outport(CRTC_ADDR,0x8E03);
//    IoPortOutB(CRTC_ADDR,0x03);
//    IoPortOutB(CRTC_ADDR+1,0x8E);
      VgaIoWriteIx(CRTC_ADDR,0x8E03);
//    outport(CRTC_ADDR,0x5E04);
//    IoPortOutB(CRTC_ADDR,0x04);
//    IoPortOutB(CRTC_ADDR+1,0x5E);
      VgaIoWriteIx(CRTC_ADDR,0x5E04);
//    outport(CRTC_ADDR,0x8A05);
//    IoPortOutB(CRTC_ADDR,0x05);
//    IoPortOutB(CRTC_ADDR+1,0x8A);
      VgaIoWriteIx(CRTC_ADDR,0x8A05);
//    outport(CRTC_ADDR,0x0D06);
//    IoPortOutB(CRTC_ADDR,0x06);
//    IoPortOutB(CRTC_ADDR+1,0x0D);
      VgaIoWriteIx(CRTC_ADDR,0x0D06);
//    outport(CRTC_ADDR,0x3E07);
//    IoPortOutB(CRTC_ADDR,0x07);
//    IoPortOutB(CRTC_ADDR+1,0x3E);
      VgaIoWriteIx(CRTC_ADDR,0x3E07);
//    outport(CRTC_ADDR,0x0008);
//    IoPortOutB(CRTC_ADDR,0x08);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x0008);
//    outport(CRTC_ADDR,0xC009);
//    IoPortOutB(CRTC_ADDR,0x09);
//    IoPortOutB(CRTC_ADDR+1,0xC0);
      VgaIoWriteIx(CRTC_ADDR,0xC009);
//    outport(CRTC_ADDR,0x000A);
//    IoPortOutB(CRTC_ADDR,0x0A);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000A);
//    outport(CRTC_ADDR,0x000B);
//    IoPortOutB(CRTC_ADDR,0x0B);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000B);
//    outport(CRTC_ADDR,0x000C);
//    IoPortOutB(CRTC_ADDR,0x0C);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000C);
//    outport(CRTC_ADDR,0x000D);
//    IoPortOutB(CRTC_ADDR,0x0D);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000D);
//    outport(CRTC_ADDR,0x000E);
//    IoPortOutB(CRTC_ADDR,0x0E);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000E);
//    outport(CRTC_ADDR,0x000F);
//    IoPortOutB(CRTC_ADDR,0x0F);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000F);
//    outport(CRTC_ADDR,0xEA10);
//    IoPortOutB(CRTC_ADDR,0x10);
//    IoPortOutB(CRTC_ADDR+1,0xEA);
      VgaIoWriteIx(CRTC_ADDR,0xEA10);
//    outport(CRTC_ADDR,0xAC11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0xAC);
      VgaIoWriteIx(CRTC_ADDR,0xAC11);
//    outport(CRTC_ADDR,0xDF12);
//    IoPortOutB(CRTC_ADDR,0x12);
//    IoPortOutB(CRTC_ADDR+1,0xDF);
      VgaIoWriteIx(CRTC_ADDR,0xDF12);
//    outport(CRTC_ADDR,0x2D13);
//    IoPortOutB(CRTC_ADDR,0x13);
//    IoPortOutB(CRTC_ADDR+1,0x2D);
      VgaIoWriteIx(CRTC_ADDR,0x2D13);
//    outport(CRTC_ADDR,0x0014);
//    IoPortOutB(CRTC_ADDR,0x14);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x0014);
//    outport(CRTC_ADDR,0xE715);
//    IoPortOutB(CRTC_ADDR,0x15);
//    IoPortOutB(CRTC_ADDR+1,0xE7);
      VgaIoWriteIx(CRTC_ADDR,0xE715);
//    outport(CRTC_ADDR,0x0616);
//    IoPortOutB(CRTC_ADDR,0x16);
//    IoPortOutB(CRTC_ADDR+1,0x06);
      VgaIoWriteIx(CRTC_ADDR,0x0616);
//    outport(CRTC_ADDR,0xE317);
//    IoPortOutB(CRTC_ADDR,0x17);
//    IoPortOutB(CRTC_ADDR+1,0xE3);
      VgaIoWriteIx(CRTC_ADDR,0xE317);
//    outport(CRTC_ADDR,0xFF18);
//    IoPortOutB(CRTC_ADDR,0x18);
//    IoPortOutB(CRTC_ADDR+1,0xFF);
      VgaIoWriteIx(CRTC_ADDR,0xFF18);

      setpalette256();
      Mode.width = 360;
      Mode.height = 240;
      Mode.width_bytes = 21600;
      Mode.colors = 256;
      Mode.attrib = TVU_GRAPHICS | TVU_UNCHAINED;
   }
   else if (mode == MODE_F)                     // unchained 360 x 350 x 256
   {
      ModeSet(mode13h);

      // Turn off Chain 4
//    outport(SEQ_ADDR,0x0604);
//    IoPortOutB(SEQ_ADDR,0x04);
//    IoPortOutB(SEQ_ADDR+1,0x06);
      VgaIoWriteIx(SEQ_ADDR,0x0604);
      // Activate a synchronous reset
//    outport(SEQ_ADDR,0x0100);
//    IoPortOutB(SEQ_ADDR,0x00);
//    IoPortOutB(SEQ_ADDR+1,0x01);
      VgaIoWriteIx(SEQ_ADDR,0x0100);
      // Select 28 mhz pixel clock
//    outportb(MISC_ADDR,0xE7);
      IoPortOutB(MISC_ADDR,0xE7);

      // Release synchronous reset
//    outport(SEQ_ADDR,0x0300);
//    IoPortOutB(SEQ_ADDR,0x00);
//    IoPortOutB(SEQ_ADDR+1,0x03);
      VgaIoWriteIx(SEQ_ADDR,0x0300);

      // change the vertical resolution flags to 350
//    outportb(MISC_ADDR,(inportb(0x3CC) & ~0xC0) | 0x80);
      IoPortOutB(MISC_ADDR,(IoPortInB(0x3CC) & ~0xC0) | 0x80);

      // turn off write protect
//    outport(CRTC_ADDR,0x2C11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0x2C);
      VgaIoWriteIx(CRTC_ADDR,0x2C11);
//    outport(CRTC_ADDR,0x6B00);
//    IoPortOutB(CRTC_ADDR,0x00);
//    IoPortOutB(CRTC_ADDR+1,0x6B);
      VgaIoWriteIx(CRTC_ADDR,0x6B00);
//    outport(CRTC_ADDR,0x5901);
//    IoPortOutB(CRTC_ADDR,0x01);
//    IoPortOutB(CRTC_ADDR+1,0x59);
      VgaIoWriteIx(CRTC_ADDR,0x5901);
//    outport(CRTC_ADDR,0x5A02);
//    IoPortOutB(CRTC_ADDR,0x02);
//    IoPortOutB(CRTC_ADDR+1,0x5A);
      VgaIoWriteIx(CRTC_ADDR,0x5A02);
//    outport(CRTC_ADDR,0x8E03);
//    IoPortOutB(CRTC_ADDR,0x03);
//    IoPortOutB(CRTC_ADDR+1,0x8E);
      VgaIoWriteIx(CRTC_ADDR,0x8E03);
//    outport(CRTC_ADDR,0x5E04);
//    IoPortOutB(CRTC_ADDR,0x04);
//    IoPortOutB(CRTC_ADDR+1,0x5E);
      VgaIoWriteIx(CRTC_ADDR,0x5E04);
//    outport(CRTC_ADDR,0x8A05);
//    IoPortOutB(CRTC_ADDR,0x05);
//    IoPortOutB(CRTC_ADDR+1,0x8A);
      VgaIoWriteIx(CRTC_ADDR,0x8A05);
//    outport(CRTC_ADDR,0xBF06);
//    IoPortOutB(CRTC_ADDR,0x06);
//    IoPortOutB(CRTC_ADDR+1,0xBF);
      VgaIoWriteIx(CRTC_ADDR,0xBF06);
//    outport(CRTC_ADDR,0x1F07);
//    IoPortOutB(CRTC_ADDR,0x07);
//    IoPortOutB(CRTC_ADDR+1,0x1F);
      VgaIoWriteIx(CRTC_ADDR,0x1F07);
//    outport(CRTC_ADDR,0x0008);
//    IoPortOutB(CRTC_ADDR,0x08);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x0008);
//    outport(CRTC_ADDR,0x4009);
//    IoPortOutB(CRTC_ADDR,0x09);
//    IoPortOutB(CRTC_ADDR+1,0x40);
      VgaIoWriteIx(CRTC_ADDR,0x4009);
//    outport(CRTC_ADDR,0x000A);
//    IoPortOutB(CRTC_ADDR,0x0A);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000A);
//    outport(CRTC_ADDR,0x000B);
//    IoPortOutB(CRTC_ADDR,0x0B);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000B);
//    outport(CRTC_ADDR,0x000C);
//    IoPortOutB(CRTC_ADDR,0x0C);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000C);
//    outport(CRTC_ADDR,0x000D);
//    IoPortOutB(CRTC_ADDR,0x0D);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000D);
//    outport(CRTC_ADDR,0x000E);
//    IoPortOutB(CRTC_ADDR,0x0E);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000E);
//    outport(CRTC_ADDR,0x000F);
//    IoPortOutB(CRTC_ADDR,0x0F);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000F);
//    outport(CRTC_ADDR,0x8310);
//    IoPortOutB(CRTC_ADDR,0x10);
//    IoPortOutB(CRTC_ADDR+1,0x83);
      VgaIoWriteIx(CRTC_ADDR,0x8310);
//    outport(CRTC_ADDR,0x8511);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0x85);
      VgaIoWriteIx(CRTC_ADDR,0x8511);
//    outport(CRTC_ADDR,0x5D12);
//    IoPortOutB(CRTC_ADDR,0x12);
//    IoPortOutB(CRTC_ADDR+1,0x5D);
      VgaIoWriteIx(CRTC_ADDR,0x5D12);
//    outport(CRTC_ADDR,0x2D13);
//    IoPortOutB(CRTC_ADDR,0x13);
//    IoPortOutB(CRTC_ADDR+1,0x2D);
      VgaIoWriteIx(CRTC_ADDR,0x2D13);
//    outport(CRTC_ADDR,0x0014);
//    IoPortOutB(CRTC_ADDR,0x14);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x0014);
//    outport(CRTC_ADDR,0x6315);
//    IoPortOutB(CRTC_ADDR,0x15);
//    IoPortOutB(CRTC_ADDR+1,0x63);
      VgaIoWriteIx(CRTC_ADDR,0x6315);
//    outport(CRTC_ADDR,0xBA16);
//    IoPortOutB(CRTC_ADDR,0x16);
//    IoPortOutB(CRTC_ADDR+1,0xBA);
      VgaIoWriteIx(CRTC_ADDR,0xBA16);
//    outport(CRTC_ADDR,0xE317);
//    IoPortOutB(CRTC_ADDR,0x17);
//    IoPortOutB(CRTC_ADDR+1,0xE3);
      VgaIoWriteIx(CRTC_ADDR,0xE317);
//    outport(CRTC_ADDR,0xFF18);
//    IoPortOutB(CRTC_ADDR,0x18);
//    IoPortOutB(CRTC_ADDR+1,0xFF);
      VgaIoWriteIx(CRTC_ADDR,0xFF18);

      setpalette256();
      Mode.width = 360;
      Mode.height = 350;
      Mode.width_bytes = 31500;
      Mode.colors = 256;
      Mode.attrib = TVU_GRAPHICS | TVU_UNCHAINED;
   }
   else if (mode == MODE_G)                     // unchained 360 x 400 x 256
   {
      ModeSet(mode13h);

      // Turn off Chain 4
//    outport(SEQ_ADDR,0x0604);
//    IoPortOutB(SEQ_ADDR,0x04);
//    IoPortOutB(SEQ_ADDR+1,0x06);
      VgaIoWriteIx(SEQ_ADDR,0x0604);
      // Activate a synchronous reset
//    outport(SEQ_ADDR,0x0100);
//    IoPortOutB(SEQ_ADDR,0x00);
//    IoPortOutB(SEQ_ADDR+1,0x01);
      VgaIoWriteIx(SEQ_ADDR,0x0100);
      // Select 28 mhz pixel clock
//    outportb(MISC_ADDR,0xE7);
      IoPortOutB(MISC_ADDR,0xE7);

      // Release synchronous reset
//    outport(SEQ_ADDR,0x0300);
//    IoPortOutB(SEQ_ADDR,0x00);
//    IoPortOutB(SEQ_ADDR+1,0x03);
      VgaIoWriteIx(SEQ_ADDR,0x0300);
      // change the vertical resolution flags to 400
//    outportb(MISC_ADDR,(inportb(0x3CC) & ~0xC0) | 0x40);
      IoPortOutB(MISC_ADDR,(IoPortInB(0x3CC) & ~0xC0) | 0x40);

      // turn off write protect
//    outport(CRTC_ADDR,0x2C11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0x2C);
      VgaIoWriteIx(CRTC_ADDR,0x2C11);
//    outport(CRTC_ADDR,0x6B00);
//    IoPortOutB(CRTC_ADDR,0x00);
//    IoPortOutB(CRTC_ADDR+1,0x6B);
      VgaIoWriteIx(CRTC_ADDR,0x6B00);
//    outport(CRTC_ADDR,0x5901);
//    IoPortOutB(CRTC_ADDR,0x01);
//    IoPortOutB(CRTC_ADDR+1,0x59);
      VgaIoWriteIx(CRTC_ADDR,0x5901);
//    outport(CRTC_ADDR,0x5A02);
//    IoPortOutB(CRTC_ADDR,0x02);
//    IoPortOutB(CRTC_ADDR+1,0x5A);
      VgaIoWriteIx(CRTC_ADDR,0x5A02);
//    outport(CRTC_ADDR,0x8E03);
//    IoPortOutB(CRTC_ADDR,0x03);
//    IoPortOutB(CRTC_ADDR+1,0x8E);
      VgaIoWriteIx(CRTC_ADDR,0x8E03);
//    outport(CRTC_ADDR,0x5E04);
//    IoPortOutB(CRTC_ADDR,0x04);
//    IoPortOutB(CRTC_ADDR+1,0x5E);
      VgaIoWriteIx(CRTC_ADDR,0x5E04);
//    outport(CRTC_ADDR,0x8A05);
//    IoPortOutB(CRTC_ADDR,0x05);
//    IoPortOutB(CRTC_ADDR+1,0x8A);
      VgaIoWriteIx(CRTC_ADDR,0x8A05);
//    outport(CRTC_ADDR,0x0008);
//    IoPortOutB(CRTC_ADDR,0x08);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x0008);
//    outport(CRTC_ADDR,0x4009);
//    IoPortOutB(CRTC_ADDR,0x09);
//    IoPortOutB(CRTC_ADDR+1,0x40);
      VgaIoWriteIx(CRTC_ADDR,0x4009);
//    outport(CRTC_ADDR,0x000A);
//    IoPortOutB(CRTC_ADDR,0x0A);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000A);
//    outport(CRTC_ADDR,0x000B);
//    IoPortOutB(CRTC_ADDR,0x0B);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000B);
//    outport(CRTC_ADDR,0x000C);
//    IoPortOutB(CRTC_ADDR,0x0C);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000C);
//    outport(CRTC_ADDR,0x000D);
//    IoPortOutB(CRTC_ADDR,0x0D);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000D);
//    outport(CRTC_ADDR,0x000E);
//    IoPortOutB(CRTC_ADDR,0x0E);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000E);
//    outport(CRTC_ADDR,0x000F);
//    IoPortOutB(CRTC_ADDR,0x0F);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000F);
//    outport(CRTC_ADDR,0xAC11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0xAC);
      VgaIoWriteIx(CRTC_ADDR,0xAC11);
//    outport(CRTC_ADDR,0x2D13);
//    IoPortOutB(CRTC_ADDR,0x13);
//    IoPortOutB(CRTC_ADDR+1,0x2D);
      VgaIoWriteIx(CRTC_ADDR,0x2D13);
//    outport(CRTC_ADDR,0x0014);
//    IoPortOutB(CRTC_ADDR,0x14);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x0014);
//    outport(CRTC_ADDR,0xE317);
//    IoPortOutB(CRTC_ADDR,0x17);
//    IoPortOutB(CRTC_ADDR+1,0xE3);
      VgaIoWriteIx(CRTC_ADDR,0xE317);
//    outport(CRTC_ADDR,0xFF18);
//    IoPortOutB(CRTC_ADDR,0x18);
//    IoPortOutB(CRTC_ADDR+1,0xFF);
      VgaIoWriteIx(CRTC_ADDR,0xFF18);

      setpalette256();
      Mode.width = 360;
      Mode.height = 400;
      Mode.width_bytes = 36000u;
      Mode.colors = 256;
      Mode.attrib = TVU_GRAPHICS | TVU_UNCHAINED;
   }
   else if (mode == MODE_H)                     // unchained 360 x 480 x 256
   {
      ModeSet(mode13h);

      // Turn off Chain 4
//    outport(SEQ_ADDR,0x0604);
//    IoPortOutB(SEQ_ADDR,0x04);
//    IoPortOutB(SEQ_ADDR+1,0x06);
      VgaIoWriteIx(SEQ_ADDR,0x0604);
      // Activate a synchronous reset
//    outport(SEQ_ADDR,0x0100);
//    IoPortOutB(SEQ_ADDR,0x00);
//    IoPortOutB(SEQ_ADDR+1,0x01);
      VgaIoWriteIx(SEQ_ADDR,0x0100);
      // Select 28 mhz pixel clock
//    outportb(MISC_ADDR,0xE7);
      IoPortOutB(MISC_ADDR,0xE7);

      // Release synchronous reset
//    outport(SEQ_ADDR,0x0300);
//    IoPortOutB(SEQ_ADDR,0x00);
//    IoPortOutB(SEQ_ADDR+1,0x03);
      VgaIoWriteIx(SEQ_ADDR,0x0300);

      // change the vertical resolution flags to 480
//    outportb(MISC_ADDR,(inportb(0x3CC) & ~0xC0) | 0xC0);
      IoPortOutB(MISC_ADDR,(IoPortInB(0x3CC) & ~0xC0) | 0xC0);

      // turn off write protect
//    outport(CRTC_ADDR,0x2C11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0x2C);
      VgaIoWriteIx(CRTC_ADDR,0x2C11);
//    outport(CRTC_ADDR,0x6B00);
//    IoPortOutB(CRTC_ADDR,0x00);
//    IoPortOutB(CRTC_ADDR+1,0x6B);
      VgaIoWriteIx(CRTC_ADDR,0x6B00);
//    outport(CRTC_ADDR,0x5901);
//    IoPortOutB(CRTC_ADDR,0x01);
//    IoPortOutB(CRTC_ADDR+1,0x59);
      VgaIoWriteIx(CRTC_ADDR,0x5901);
//    outport(CRTC_ADDR,0x5A02);
//    IoPortOutB(CRTC_ADDR,0x02);
//    IoPortOutB(CRTC_ADDR+1,0x5A);
      VgaIoWriteIx(CRTC_ADDR,0x5A02);
//    outport(CRTC_ADDR,0x8E03);
//    IoPortOutB(CRTC_ADDR,0x03);
//    IoPortOutB(CRTC_ADDR+1,0x8E);
      VgaIoWriteIx(CRTC_ADDR,0x8E03);
//    outport(CRTC_ADDR,0x5E04);
//    IoPortOutB(CRTC_ADDR,0x04);
//    IoPortOutB(CRTC_ADDR+1,0x5E);
      VgaIoWriteIx(CRTC_ADDR,0x5E04);
//    outport(CRTC_ADDR,0x8A05);
//    IoPortOutB(CRTC_ADDR,0x05);
//    IoPortOutB(CRTC_ADDR+1,0x8A);
      VgaIoWriteIx(CRTC_ADDR,0x8A05);
//    outport(CRTC_ADDR,0x0D06);
//    IoPortOutB(CRTC_ADDR,0x06);
//    IoPortOutB(CRTC_ADDR+1,0x0D);
      VgaIoWriteIx(CRTC_ADDR,0x0D06);
//    outport(CRTC_ADDR,0x3E07);
//    IoPortOutB(CRTC_ADDR,0x07);
//    IoPortOutB(CRTC_ADDR+1,0x3E);
      VgaIoWriteIx(CRTC_ADDR,0x3E07);
//    outport(CRTC_ADDR,0x0008);
//    IoPortOutB(CRTC_ADDR,0x08);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x0008);
//    outport(CRTC_ADDR,0x4009);
//    IoPortOutB(CRTC_ADDR,0x09);
//    IoPortOutB(CRTC_ADDR+1,0x40);
      VgaIoWriteIx(CRTC_ADDR,0x4009);
//    outport(CRTC_ADDR,0x000A);
//    IoPortOutB(CRTC_ADDR,0x0A);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000A);
//    outport(CRTC_ADDR,0x000B);
//    IoPortOutB(CRTC_ADDR,0x0B);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000B);
//    outport(CRTC_ADDR,0x000C);
//    IoPortOutB(CRTC_ADDR,0x0C);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000C);
//    outport(CRTC_ADDR,0x000D);
//    IoPortOutB(CRTC_ADDR,0x0D);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000D);
//    outport(CRTC_ADDR,0x000E);
//    IoPortOutB(CRTC_ADDR,0x0E);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000E);
//    outport(CRTC_ADDR,0x000F);
//    IoPortOutB(CRTC_ADDR,0x0F);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x000F);
//    outport(CRTC_ADDR,0xEA10);
//    IoPortOutB(CRTC_ADDR,0x10);
//    IoPortOutB(CRTC_ADDR+1,0xEA);
      VgaIoWriteIx(CRTC_ADDR,0xEA10);
//    outport(CRTC_ADDR,0xAC11);
//    IoPortOutB(CRTC_ADDR,0x11);
//    IoPortOutB(CRTC_ADDR+1,0xAC);
      VgaIoWriteIx(CRTC_ADDR,0xAC11);
//    outport(CRTC_ADDR,0xDF12);
//    IoPortOutB(CRTC_ADDR,0x12);
//    IoPortOutB(CRTC_ADDR+1,0xDF);
      VgaIoWriteIx(CRTC_ADDR,0xDF12);
//    outport(CRTC_ADDR,0x2D13);
//    IoPortOutB(CRTC_ADDR,0x13);
//    IoPortOutB(CRTC_ADDR+1,0x2D);
      VgaIoWriteIx(CRTC_ADDR,0x2D13);
//    outport(CRTC_ADDR,0x0014);
//    IoPortOutB(CRTC_ADDR,0x14);
//    IoPortOutB(CRTC_ADDR+1,0x00);
      VgaIoWriteIx(CRTC_ADDR,0x0014);
//    outport(CRTC_ADDR,0xE715);
//    IoPortOutB(CRTC_ADDR,0x15);
//    IoPortOutB(CRTC_ADDR+1,0xE7);
      VgaIoWriteIx(CRTC_ADDR,0xE715);
//    outport(CRTC_ADDR,0x0616);
//    IoPortOutB(CRTC_ADDR,0x16);
//    IoPortOutB(CRTC_ADDR+1,0x06);
      VgaIoWriteIx(CRTC_ADDR,0x0616);
//    outport(CRTC_ADDR,0xE317);
//    IoPortOutB(CRTC_ADDR,0x17);
//    IoPortOutB(CRTC_ADDR+1,0xE3);
      VgaIoWriteIx(CRTC_ADDR,0xE317);
//    outport(CRTC_ADDR,0xFF18);
//    IoPortOutB(CRTC_ADDR,0x18);
//    IoPortOutB(CRTC_ADDR+1,0xFF);
      VgaIoWriteIx(CRTC_ADDR,0xFF18);

      setpalette256();
      Mode.width = 360;
      Mode.height = 480;
      Mode.width_bytes = 43200u;
      Mode.colors = 256;
      Mode.attrib = TVU_GRAPHICS | TVU_UNCHAINED;
   }
   else if (mode == MODE_I)                     // 640 x 400 x 16
   {
      ModeSet(mode10h);
//      asm {

//         MOV DX,03CCH
//         IN AL,DX
//         AND AL,03FH
//         OR AL,40H

//         MOV DX,03C2H
//         OUT DX,AL
           IoPortOutB(0x3C2,(IoPortInB(0x3CC)&0x3F)|0x40);

//         MOV DX,CRTC_ADDR
//         MOV AX,9C10H
//         OUT DX,AX
//         IoPortOutB(CRTC_ADDR,0x10);
//         IoPortOutB(CRTC_ADDR+1,0x9C);
           VgaIoWriteIx(CRTC_ADDR,0x9C10);

//         MOV AX,8311H
//         OUT DX,AX
//         IoPortOutB(CRTC_ADDR,0x11);
//         IoPortOutB(CRTC_ADDR+1,0x83);
           VgaIoWriteIx(CRTC_ADDR,0x8311);
//         MOV AX,8F12H
//         OUT DX,AX
//         IoPortOutB(CRTC_ADDR,0x12);
//         IoPortOutB(CRTC_ADDR+1,0x8F);
           VgaIoWriteIx(CRTC_ADDR,0x8F12);

//         MOV AX,9615H
//         OUT DX,AX
//         IoPortOutB(CRTC_ADDR,0x15);
//         IoPortOutB(CRTC_ADDR+1,0x96);
           VgaIoWriteIx(CRTC_ADDR,0x9615);

//         MOV AX,0B916H
//         OUT DX,AX
//         IoPortOutB(CRTC_ADDR,0x16);
//         IoPortOutB(CRTC_ADDR+1,0xB9);
           VgaIoWriteIx(CRTC_ADDR,0xB916);

//      }
      setpalette16();
      Mode.width = 640;
      Mode.height = 400;
      Mode.width_bytes = 32000;
      Mode.colors = 16;
      Mode.attrib = TVU_GRAPHICS | TVU_PLANAR;
   }
   else if (mode == MODE_J)                    // 80 x 43 x 16
   {
      ModeSet(modeJ);
      FontsRead(Font8x8,8);

      Mode.width = 80;
      Mode.height = 43;
      Mode.width_bytes = 3440;
      Mode.colors = 16;
      Mode.attrib = TVU_TEXT;
   }
   else if (mode == MODE_K)                    // 80 x 50 x 16
   {
      ModeSet(modeK);
      FontsRead(Font8x8,8);

      Mode.width = 80;
      Mode.height = 50;
      Mode.width_bytes = 4000;
      Mode.colors = 16;
      Mode.attrib = TVU_TEXT;
   }
   else if (mode == MODE_L)                    // 40 x 43 x 16
   {
      ModeSet(modeL);
      FontsRead(Font8x8,8);

      Mode.width = 40;
      Mode.height = 43;
      Mode.width_bytes = 4000;
      Mode.colors = 16;
      Mode.attrib = TVU_TEXT;
   }
   else if (mode == MODE_M)                    // 40 x 50 x 16
   {
      ModeSet(modeM);
      FontsRead(Font8x8,8);

      Mode.width = 40;
      Mode.height = 50;
      Mode.width_bytes = 4000;
      Mode.colors = 16;
      Mode.attrib = TVU_TEXT;
   }

}
