#include "vgaregs.h"
#include "config.h"
#include "types.h"
#include "debug.h"
#include "vgaasm.h"
#include "vga.h"

void  sub_1E12(void)
{
   IoPortOutB(0x46E8,0x17);
   IoPortOutB(0x0102,IoPortInB(0x0102)|1);
   IoPortOutB(0x46E8,0x00);
}
void  sub_292D(BYTE al, BYTE bl, BYTE bh)
{
 // BYTE ah = al;
  VgaIoWriteIx(0x3DE,((VgaIoReadIx(0x3DE,0x0D)|0x20)<<8)+0x0D);
  IoPortOutB(0x3C8,al);
  IoPortOutB(0x3C9,bh);
  IoPortOutB(0x3C9,bl);
  VgaIoWriteIx(0x3DE,((VgaIoReadIx(0x3DE,0x0D)&0xDF)<<8)+0x0D);
}
//*********************************************************************
BYTE  sub_1CED()
{
  return((VgaIoReadIx(0x3DE,0x10)&0x4F)|(VgaIoReadIx(0x3DE,0x0B)&0xB0));
}
//*********************************************************************
void sub_29E0(void)
{
  if((IoPortInB(0x3DE)&0xE0)==0xA0)
  {
    if (!(sub_1CED()&0x20))
    {
      sub_292D(0x0A,0x02,0x0C);
    }else sub_292D(0x0A,0x03,0x0D);
  }
  else sub_292D(0x0A,0x03,0x0D);
}
//*********************************************************************
void  sub_28AC(BYTE al, BYTE ah)
{
  BYTE bl=al;

  VgaIoWriteIx(0x3DE,((VgaIoReadIx(0x3DE,0x0D)|0x20)<<8)+0x0D);
  al = IoPortInB(0x3C6)&ah;
  ah ^= 0xFF;   // Invert bits
  bl &= ah;
  al |= bl;
  IoPortOutB(0x3C6,al);
  VgaIoWriteIx(0x3DE,((VgaIoReadIx(0x3DE,0x0D)&0xDF)<<8)+0x0D);
}
//*********************************************************************
void  sub_28E2(BYTE al,BYTE ah)
{
   BYTE bl=al,bh=ah;

  VgaIoWriteIx(0x3DE,((VgaIoReadIx(0x3DE,0x0D)|0x20)<<8)+0x0D);
  IoPortOutB(0x3C7,0x0E);
  al = IoPortInB(0x3C9)&bh;
  ah ^= 0xFF;         // invert bits
  bl &= ah;
  bl |= al;
  IoPortOutB(0x3C8,0x0E);
  IoPortOutB(0x3C9,bl);
  VgaIoWriteIx(0x3DE,((VgaIoReadIx(0x3DE,0x0D)&0xDF)<<8)+0x0D);
}
//*********************************************************************
void  sub_2A0F()
{
  sub_28E2(0,8);
  sub_28AC(0,0xBE);
  sub_29E0();
  sub_292D(0,0x11,0x06);
  sub_292D(1,0x11,0x07);
  sub_292D(2,0x06,0x1F);
  sub_292D(3,0x06,0x15);
}
//*********************************************************************
void  OTI077_Init(void)
{ //  subsystem enable already executed
 // WORD  i;
  sub_2A0F();
  VgaIoWriteIx(0x3DE,((VgaIoReadIx(0x3DE,0x0E)&0xDE)<<8)+0x0E);
  sub_1E12();
   IoPortOutB(0x46E8,0x17);
   IoPortOutB(0x0102,IoPortInB(0x0102)|1);
   IoPortOutB(0x46E8,0x0F);

}
//*********************************************************************
//*********************************************************************
//*********************************************************************
//*********************************************************************

void  sub_2148(BYTE v)
{
   IoPortOutB(0x46E8,0x17);
   IoPortOutB(0x0102,IoPortInB(0x0102)|1);
   IoPortOutB(0x46E8,v);
}
//*********************************************************************

void  sub_2167(WORD addr,BYTE v)
{
  BYTE ah;

  ah = IoPortInB(addr);
  IoPortOutB(addr,0x80);
  IoPortOutB(0x102,0x01);
  IoPortOutB(addr,ah);
  IoPortOutB(0x3C3,v);

}
//*********************************************************************
BYTE sub_21C9()
{
  BYTE al=0x55,ah=al;


loc_21D1:
  IoPortOutB(0x3DE,al);
  if(al == ah) return(1);
  al ^= 0xFF; ah ^= 0xFF;
  if(al == 0x55 && ah == 0x55) return(0);
  goto loc_21D1;
}
//*********************************************************************
void  sub_218C(void)
{
  sub_2148(0x0F);
  if(!sub_21C9()) goto loc_21A6;
  sub_2167(0x0094,0x01);
  if(!sub_21C9()) goto loc_21A6;
  sub_2167(0x0394,0x01);
loc_21A6:
  return;
}
//*********************************************************************
void  sub_201B(void)
{
  BYTE ah;

  IoPortInB(0x3C8);
  ah = IoPortInB(0x3C6);
  IoPortInB(0x3C8);
  IoPortInB(0x3C6);
  IoPortInB(0x3C6);
  IoPortInB(0x3C6);
  IoPortInB(0x3C6);
  IoPortOutB(0x3C6,0);
  IoPortInB(0x3C8);
  IoPortOutB(0x3C6,ah);
  IoPortInB(0x3C8);
}
//*********************************************************************
void  sub_58F(BYTE ah, BYTE al)
{
  IoPortOutB(0x1E,al);
  IoPortOutB(0x1F,ah);
}
//*********************************************************************
void  sub_50F(void)
{
  if((VgaIoReadIx(0x3DE,0x07)&0x04)) return;
  sub_58F(0xFF,0x05);
}
//*********************************************************************
BYTE  sub_53D(void)
{
  if(VgaIoReadIx(0x3DE,0x07)&0x04) return(1);
  return(VgaIoReadIx(0x3DE,0x08)&0x03);
}
//*********************************************************************
void  sub_552(void)
{
  if(sub_53D()) return;
  sub_58F(0x07,0x04);
  sub_58F(0xFF,0x05);
  sub_58F((VgaIoReadIx(0x1E,0xFE)|0x40),0xFE);
}
//*********************************************************************
void  sub_21A8(void)
{
  if(VgaIoReadIx(0x3DE,0x07)&0x04)
  {
    sub_2148(0x00);
  }
  else
  {
    sub_2167(0x0094,0x00);
    sub_2167(0x0394,0x00);
  }
}
//*********************************************************************
__flash BYTE Content[]=
{
  0x01,0x29,0x04,0x10,0x07,0x00,0x01,0x3E,
  0x00,0x00,0x80,0x70,0xFF,0x01,0xFF,0xFF,
  0x7F,0x00,0xFF,0xC8,0x00,0x00,0xFF,0x00,
  0x01,0x0F,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x01,0x00,0x08,0x00,0x00,0x00,0xFF,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,0xD8,0xFF,
  0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
  0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x10
};

void  Fill3DE()
{
  BYTE  i;

  for(i=0;i<sizeof(Content);i++)
  {
    VgaIoWriteIx(0x3DE,(Content[i]<<8)+i);
  }
}
//*********************************************************************
#define sub_214D sub_1E12
//*********************************************************************

void OTI0087_Init(void)
{

  IoPortOutB(0x320,1);
  IoPortInB(0x320);
  sub_218C();
  VgaIoWriteIx(0x3DE,((VgaIoReadIx(0x3DE,0x13)&0xBF)<<8)+0x13);
  VgaIoWriteIx(0x3DE,(((VgaIoReadIx(0x3DE,0x0B)&0x0F)|(VgaIoReadIx(0x3DE,0x10))&0xF0)<<8)+0x0B);
  sub_201B();
  sub_50F();
  sub_552();
  IoPortOutB(0x320,2);
  Fill3DE();
  sub_21A8();
  sub_218C();
  IoPortOutB(0x320,0x0c);

  IoPortOutB(0x46E8,0x17);
  IoPortOutB(0x0102,IoPortInB(0x0102)|1);
  IoPortOutB(0x46E8,0x0F);
  Fill3DE();
}

//*********************************************************************
