#include "defs.h"
#include "config.h"
#include "types.h"

#include "vga.h"
#include "modes.h"

__flash BYTE Pal16[192] =
//  R    G    B
{
  0x00,0x00,0x00,       // 0x00
  0x00,0x00,0x2A,       // 0x01
  0x00,0x2A,0x00,       // 0x02
  0x00,0x2A,0x2A,       // 0x03
  0x2A,0x00,0x00,       // 0x04
  0x2A,0x00,0x2A,       // 0x05
  0x2A,0x2A,0x00,       // 0x06
  0x2A,0x2A,0x2A,       // 0x07
  0x00,0x00,0x15,       // 0x08
  0x00,0x00,0x3F,       // 0x09
  0x00,0x2A,0x15,       // 0x0A
  0x00,0x2A,0x3F,       // 0x0B
  0x2A,0x00,0x15,       // 0x0C
  0x2A,0x00,0x3F,       // 0x0D
  0x2A,0x2A,0x15,       // 0x0E
  0x2A,0x2A,0x3F,       // 0x0F
  0x00,0x15,0x00,       // 0x10
  0x00,0x15,0x2A,       // 0x11
  0x00,0x3F,0x00,       // 0x12
  0x00,0x3F,0x2A,       // 0x13
  0x2A,0x15,0x00,       // 0x14
  0x2A,0x15,0x2A,       // 0x15
  0x2A,0x3F,0x00,       // 0x16
  0x2A,0x3F,0x2A,       // 0x17
  0x00,0x15,0x15,       // 0x18
  0x00,0x15,0x3F,       // 0x19
  0x00,0x3F,0x15,       // 0x1A
  0x00,0x3F,0x3F,       // 0x1B
  0x2A,0x15,0x15,       // 0x1C
  0x2A,0x15,0x3F,       // 0x1D
  0x2A,0x3F,0x15,       // 0x1E
  0x2A,0x3F,0x3F,       // 0x1F
  0x15,0x00,0x00,       // 0x20
  0x15,0x00,0x2A,       // 0x21
  0x15,0x2A,0x00,       // 0x22
  0x15,0x2A,0x2A,       // 0x23
  0x3F,0x00,0x00,       // 0x24
  0x3F,0x00,0x2A,       // 0x25
  0x3F,0x2A,0x00,       // 0x26
  0x3F,0x2A,0x2A,       // 0x27
  0x15,0x00,0x15,       // 0x28
  0x15,0x00,0x3F,       // 0x29
  0x15,0x2A,0x15,       // 0x2A
  0x15,0x2A,0x3F,       // 0x2B
  0x3F,0x00,0x15,       // 0x2C
  0x3F,0x00,0x3F,       // 0x2D
  0x3F,0x2A,0x15,       // 0x2E
  0x3F,0x2A,0x3F,       // 0x2F
  0x15,0x15,0x00,       // 0x30
  0x15,0x15,0x2A,       // 0x31
  0x15,0x3F,0x00,       // 0x32
  0x15,0x3F,0x2A,       // 0x33
  0x3F,0x15,0x00,       // 0x34
  0x3F,0x15,0x2A,       // 0x35
  0x3F,0x3F,0x00,       // 0x36
  0x3F,0x3F,0x2A,       // 0x37
  0x15,0x15,0x15,       // 0x38
  0x15,0x15,0x3F,       // 0x39
  0x15,0x3F,0x15,       // 0x3A
  0x15,0x3F,0x3F,       // 0x3B
  0x3F,0x15,0x15,       // 0x3C
  0x3F,0x15,0x3F,       // 0x3D
  0x3F,0x3F,0x15,       // 0x3E
  0x3F,0x3F,0x3F        // 0X3F
};



__flash BYTE Pal[768] = {
 0,  0,  0,  0,  0, 42,  0, 42,  0,  0, 42, 42, 42,  0,  0, 42,  0, 42,
42, 21,  0, 42, 42, 42, 21, 21, 21, 21, 21, 63, 21, 63, 21, 21, 63, 63,
63, 21, 21, 63, 21, 63, 63, 63, 21, 63, 63, 63,  0,  0,  0,  5,  5,  5,
 8,  8,  8, 11, 11, 11, 14, 14, 14, 17, 17, 17, 20, 20, 20, 24, 24, 24,
28, 28, 28, 32, 32, 32, 36, 36, 36, 40, 40, 40, 45, 45, 45, 50, 50, 50,
56, 56, 56, 63, 63, 63,  0,  0, 63, 16,  0, 63, 31,  0, 63, 47,  0, 63,
63,  0, 63, 63,  0, 47, 63,  0, 31, 63,  0, 16, 63,  0,  0, 63, 16,  0,
63, 31,  0, 63, 47,  0, 63, 63,  0, 47, 63,  0, 31, 63,  0, 16, 63,  0,
 0, 63,  0,  0, 63, 16,  0, 63, 31,  0, 63, 47,  0, 63, 63,  0, 47, 63,
 0, 31, 63,  0, 16, 63, 31, 31, 63, 39, 31, 63, 47, 31, 63, 55, 31, 63,
63, 31, 63, 63, 31, 55, 63, 31, 47, 63, 31, 39, 63, 31, 31, 63, 39, 31,
63, 47, 31, 63, 55, 31, 63, 63, 31, 55, 63, 31, 47, 63, 31, 39, 63, 31,
31, 63, 31, 31, 63, 39, 31, 63, 47, 31, 63, 55, 31, 63, 63, 31, 55, 63,
31, 47, 63, 31, 39, 63, 45, 45, 63, 49, 45, 63, 54, 45, 63, 58, 45, 63,
63, 45, 63, 63, 45, 58, 63, 45, 54, 63, 45, 49, 63, 45, 45, 63, 49, 45,
63, 54, 45, 63, 58, 45, 63, 63, 45, 58, 63, 45, 54, 63, 45, 49, 63, 45,
45, 63, 45, 45, 63, 49, 45, 63, 54, 45, 63, 58, 45, 63, 63, 45, 58, 63,
45, 54, 63, 45, 49, 63,  0,  0, 28,  7,  0, 28, 14,  0, 28, 21,  0, 28,
28,  0, 28, 28,  0, 21, 28,  0, 14, 28,  0,  7, 28,  0,  0, 28,  7,  0,
28, 14,  0, 28, 21,  0, 28, 28,  0, 21, 28,  0, 14, 28,  0,  7, 28,  0,
 0, 28,  0,  0, 28,  7,  0, 28, 14,  0, 28, 21,  0, 28, 28,  0, 21, 28,
 0, 14, 28,  0,  7, 28, 14, 14, 28, 17, 14, 28, 21, 14, 28, 24, 14, 28,
28, 14, 28, 28, 14, 24, 28, 14, 21, 28, 14, 17, 28, 14, 14, 28, 17, 14,
28, 21, 14, 28, 24, 14, 28, 28, 14, 24, 28, 14, 21, 28, 14, 17, 28, 14,
14, 28, 14, 14, 28, 17, 14, 28, 21, 14, 28, 24, 14, 28, 28, 14, 24, 28,
14, 21, 28, 14, 17, 28, 20, 20, 28, 22, 20, 28, 24, 20, 28, 26, 20, 28,
28, 20, 28, 28, 20, 26, 28, 20, 24, 28, 20, 22, 28, 20, 20, 28, 22, 20,
28, 24, 20, 28, 26, 20, 28, 28, 20, 26, 28, 20, 24, 28, 20, 22, 28, 20,
20, 28, 20, 20, 28, 22, 20, 28, 24, 20, 28, 26, 20, 28, 28, 20, 26, 28,
20, 24, 28, 20, 22, 28,  0,  0, 16,  4,  0, 16,  8,  0, 16, 12,  0, 16,
16,  0, 16, 16,  0, 12, 16,  0,  8, 16,  0,  4, 16,  0,  0, 16,  4,  0,
16,  8,  0, 16, 12,  0, 16, 16,  0, 12, 16,  0,  8, 16,  0,  4, 16,  0,
 0, 16,  0,  0, 16,  4,  0, 16,  8,  0, 16, 12,  0, 16, 16,  0, 12, 16,
 0,  8, 16,  0,  4, 16,  8,  8, 16, 10,  8, 16, 12,  8, 16, 14,  8, 16,
16,  8, 16, 16,  8, 14, 16,  8, 12, 16,  8, 10, 16,  8,  8, 16, 10,  8,
16, 12,  8, 16, 14,  8, 16, 16,  8, 14, 16,  8, 12, 16,  8, 10, 16,  8,
 8, 16,  8,  8, 16, 10,  8, 16, 12,  8, 16, 14,  8, 16, 16,  8, 14, 16,
 8, 12, 16,  8, 10, 16, 11, 11, 16, 12, 11, 16, 13, 11, 16, 15, 11, 16,
16, 11, 16, 16, 11, 15, 16, 11, 13, 16, 11, 12, 16, 11, 11, 16, 12, 11,
16, 13, 11, 16, 15, 11, 16, 16, 11, 15, 16, 11, 13, 16, 11, 12, 16, 11,
11, 16, 11, 11, 16, 12, 11, 16, 13, 11, 16, 15, 11, 16, 16, 11, 15, 16,
11, 13, 16, 11, 12, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 0,  0,  0,  0,  0,  0,  0,  0,  0, 63, 63, 63
};


//*********************************************************************
void setpal(BYTE color, BYTE r, BYTE g, BYTE b)
{
//   asm {
   // Send color
//   MOV AX,color
//   MOV DX,03C8H
//   OUT DX,AL
   IoPortOutB(0x03C8,color);


   // Write R value
//   MOV DX,03C9H
//   MOV AL,r
//   OUT DX,AL
   IoPortOutB(0x03C9,r);
   // Write G value
//   MOV DX,03C9H
//  MOV AL,g
//   OUT DX,AL
   IoPortOutB(0x03C9,g);
   // Write B value
//   MOV DX,03C9H
//   MOV AL,b
//   OUT DX,AL
   IoPortOutB(0x03C9,b);
}

//*********************************************************************

void setpalette4()
{
   setpal( 0,  0,  0,  0);
   setpal( 1,  0, 42, 42);
   setpal( 2, 42,  0, 42);
   setpal( 3, 63, 63, 63);
}

//*********************************************************************

void setpalette16()
{
   WORD j = 0;
   WORD i;
   for (i = 0; i < 192; i+=3)
   {
      setpal(j, Pal16[i], Pal16[i+1], Pal16[i+2]);
      j++;
   }
}

//*********************************************************************

void setpalette256()
{
   WORD j = 0;
   WORD i;
   for (i = 0; i < 768; i+=3)
   {
      setpal(j, Pal[i], Pal[i+1], Pal[i+2]);
      j++;
   }

}

//*********************************************************************
