//#include <stdio.h>
//#include <stdlib.h>
//#include <pgmspace.h>
//#include <ina90.h>
//#include <string.h>
#include "defs.h"
#include "config.h"
#include "types.h"
//#include "timer.h"
#include "vga.h"
//#include "modes.h"
//#include "clear.h"
//#include "txtrtne.h"
//#include "debug.h"
#include "vgaasm.h"
#include "tests.h"
//#include "palette.h"
//#include "kb.h"
//#include "uart2.h"
//#include "menu.h"

extern   DBLWORD  VidMemBase;
extern   VMODE_ST Mode;

static   BYTE   ScrPage=0;

         WORD   CursorScreen = 0;
         BYTE   CurrentAttrib = 0x0F;

//*********************************************************************
void  NextScrPage()   // Set the new screen page (max 8)
{
  WORD  i,addr;

  ScrPage++;
  addr = 2000*(ScrPage&0x07);   // Calculate CRTC new video address
  for(i=0;i<4000;i++)           // Copy the old content to new place
  {
    VgaMemoryWriteB(VidMemBase+4000+i,VgaMemoryReadB(VidMemBase+i));
  }
  VgaIoWriteIx(0x3D4,((addr/256)<<8)+0x0C);
  VgaIoWriteIx(0x3D4,((addr%256)<<8)+0x0D);
  VidMemBase = 0xB08000 + (addr<<1);
}
//*********************************************************************
void  PrevScrPage()             // Set previous screen page
{
  WORD  addr;

  ScrPage--;
  addr = 2000*(ScrPage&0x07);
  VgaIoWriteIx(0x3D4,((addr/256)<<8)+0x0C);
  VgaIoWriteIx(0x3D4,((addr%256)<<8)+0x0D);
  VidMemBase = 0xB08000 + (addr<<1);
}
//*********************************************************************
void  SetScrPage(BYTE page)     // Set desired screen page
{
  WORD  addr;

  addr = 2000*(page&0x07);
  VgaIoWriteIx(0x3D4,((addr/256)<<8)+0x0C);
  VgaIoWriteIx(0x3D4,((addr%256)<<8)+0x0D);
  VidMemBase = 0xB08000 + (addr<<1);
}
//*********************************************************************
void  CursorOn(void)
{
  VgaIoWriteIx(0x3D4,((VgaIoReadIx(0x3D4,0x0A)&(0xFF-0x20))<<8)+0x0A);
}
//********************************************************************
void  CursorOff(void)
{
  VgaIoWriteIx(0x3D4,((VgaIoReadIx(0x3D4,0x0A)|0x20)<<8)+0x0A);
}
//********************************************************************
void  SetHwCursor(WORD pos)
{
    VgaIoWriteIx(0x3D4,((CursorScreen/256)<<8)+0x0E);
    VgaIoWriteIx(0x3D4,((CursorScreen%256)<<8)+0x0F);
}
//*********************************************************************
void TextLineScrllUp(void)
{
  BYTE  h;
  BYTE  w,tmp1=Mode.width<<1;// Note: if you use 132 width mode then use WORD type
  WORD  tmp2;
  DBLWORD   vidmemdst;

  for(h=0;h<(Mode.height);h++)
  {
    tmp2 = h*tmp1;
    for(w=0;w<tmp1;w +=2)
    {
      VgaMemoryWriteW(VidMemBase+tmp2+w,VgaMemoryReadW(VidMemBase+tmp1+tmp2+w));

//      d = VgaMemoryReadB(VidMemBase+tmp1+tmp2+w);
//      VgaMemoryWriteB(VidMemBase+tmp2+w,d);
//      d = VgaMemoryReadB(VidMemBase+1+tmp1+tmp2+w);
//      VgaMemoryWriteB(VidMemBase+1+tmp2+w,d);
    }
  }
  vidmemdst = VidMemBase+((Mode.width_bytes-Mode.width)<<1);
  tmp2 = (CurrentAttrib<<8)+0x20;
  for(w=0;w<tmp1;w++)       // Clear bottom line
  {
     VgaMemoryWriteW(vidmemdst,tmp2);
//     VgaMemoryWriteB(vidmemdst,0x20);
     vidmemdst++;
//     VgaMemoryWriteB(vidmemdst,CurrentAttrib);
     vidmemdst++;
  }
}
//*********************************************************************
void Gotoxy(BYTE x, BYTE y)
{
  CursorScreen = (x-1)+((y-1)*Mode.width);
  SetHwCursor(CursorScreen);
}
//*********************************************************************
void SetForeColor(BYTE col)
{
  CurrentAttrib = (CurrentAttrib&0xF0) | (col&0x0F);
}
//*********************************************************************
void SetBackColor(BYTE col)
{
  CurrentAttrib = (CurrentAttrib&0x0F) | (col&0xF0);
}
//*********************************************************************
void SetColor(BYTE att)         // (Back<<8)+Fore
{
   CurrentAttrib = att;
}
//*********************************************************************
