#include <avr_macros.h>
#include <stdio.h>
#include <pgmspace.h>
#include "vgaregs.h"
#include "defs.h"
#include "config.h"
#include "types.h"
#include "vga.h"
#include "vgaasm.h"
#include "uart2.h"
#include "timer.h"

#define  ADDRESS_HIGH   PORTD
#define  ADDRESS_MID    PORTC
#define  ADDRESS_LOW    PORTA           // Latched address use ADDRESS_LATCH_ENABLE


extern  PREDIR_EN   PutRedirection;
extern  GREDIR_EN   GetRedirection;
        BYTE  RegOld_O,RegOld_N;

#define BASE  0x3C0
//*********************************************************************
void  DumpIndexed(WORD baseIx)
{
  BYTE i,j,rv;

  i = 0;
  printf_P("Base reg = 0x%04x\r\n",baseIx);
  printf_P("=Addr==0==1==2==3==4==5==6==7==8==9==A==B==C==D==E==F==\r\n");
	do
	{
    printf_P("0x%02x ",i*16);
		for (j = 0; j < 16; j++)
		{
		  if(baseIx == 0x3C0)
		  {
		    rv = IoPortInB(0x3DA);
		    IoPortOutB(0x3C0,(i*16)+j);
		    rv = IoPortInB(0x3C0);
		  }
		  else
		  {
		    rv = VgaIoReadIx(baseIx,(i*16)+j);
		  }
		  printf_P(" %02x", (WORD) rv);		
		}
		printf_P("\r\n");
		i++;
  }while(i <16);
  printf_P("=========================================================\r\n");
}
//*********************************************************************
void  DumpBase(void)
{
  BYTE i,j,rv;

  i = 0;
  printf_P("Base start = 0x%04x\r\n",BASE);
  printf_P("==Addr===0==1==2==3==4==5==6==7==8==9==A==B==C==D==E==F==\r\n");
	do
	{
    printf_P("0x%04x ", BASE+(i * 16));
		for (j = 0; j < 16; j++)
		{
		  rv = IoPortInB(BASE+(i*16)+j);
		  printf_P(" %02x", (WORD) rv);
		}
		printf_P("\r\n");
		i++;
  }while(i <3);
  printf_P("=========================================================\r\n");
}
//*********************************************************************
void  DumpIoRegs(void)
{
//  BYTE  i,j,rv;

  PutRedirection = RS232TX;             // Set direction to RS232
//  DumpBase();
  DumpIndexed(0x3C0);
  IoPortOutB(0x3C0,0x20);
  DumpIndexed(0x3C4);
  DumpIndexed(0x3CE);
  DumpIndexed(0x3D4);
  PutRedirection = VGA_TEXT;             // Set direction to VGA screen

}
//*********************************************************************
void SendReadBack(WORD Base,WORD IxBase,BYTE Ix,BYTE Command)
{
  BYTE  i;

  putchar(0x7E);
  putchar(IoPortInB(Base));
  if(Command&32)                 // If oldmode
  {
    VgaIoWriteIx(0x3C4,0x000B);
  }
  else VgaIoReadIx(0x3C4,0x0B);

  putchar(VgaIoReadIx(IxBase,Ix));
  i=0;
  do
  {
    if(Command&32)                 // If oldmode
    {
      VgaIoWriteIx(0x3C4,0x000B);
    }
    else VgaIoReadIx(0x3C4,0x0B);
    putchar(VgaIoReadIx(IxBase,i));
    DelayUs(2);
    i++;
  }while(i);
  putchar(0x7E);
}
//*********************************************************************
BYTE  Remote(void)
{
    WORD  Base,IxBase;
    BYTE  Bval,Ix,IxVal,Command,Key;

    GetRedirection = RS232RX;
    PutRedirection = RS232TX;
   // uartFlushReceiveBuffer(1);

    if(getchar()==0x7E)
    {
      while(uartReceivedBytes(1)!= 10);
      Command = getchar();
      Base    = getchar();
      Base   += getchar()<<8;
      Bval    = getchar();
      IxBase  = getchar();
      IxBase += getchar()<<8;
      Ix      = getchar();
      IxVal   = getchar();
      Key     = getchar();
      if(getchar() == 0x7E)
      {
        if(Command&0x80)
        {
          SendReadBack(Base,IxBase,Ix,Command);
        }
        else if(!(Command&0x01))
        {
          IoPortOutB(Base,Bval);
          SendReadBack(Base,IxBase,Ix,Command);
        }
        else
        {
          if(Command&32)                 // If oldmode
          {
            VgaIoWriteIx(0x3C4,0x000B);
          }
          else VgaIoReadIx(0x3C4,0x0B);
          VgaIoWriteIx(IxBase,(IxVal<<8)+Ix);
          SendReadBack(Base,IxBase,Ix,Command);
        }
        if(Command&16)                  // Reinit ?
        {
          RESET = 1;                    // Now begin reset
          DelayMs(200);
          RESET = 0;                    // Reset end
          VgaInit();
          Key = '4';
        }
        else if(!(Command&8))
        {
          Key = 0;
        }
      } else Key = 0;
    }
    GetRedirection = PS2_KEYB;
    PutRedirection = VGA_TEXT;

    return(Key);
}
//*********************************************************************
