#include <avr_macros.h>
#include <ina90.h>
#include "modes.h"
#include "defs.h"
#include "config.h"
#include "types.h"
#include "debug.h"
#include "vgaasm.h"
#include "timer.h"

extern  void RTGInitNew(void);
extern  void TR9000i_Init(void);
extern  void TR9000B_Init(void);
extern  void TR8900CL_Init(void);
extern  void TR8900D_Init(void);
extern  void OTI077_Init(void);
extern  void OTI0087_Init(void);

//********************************************************
// RTG3105
// Not documented  (bit 4)
//
//  3d4h index 1Ah:
//  bit 6-7  Chip version.
//           0 = Version 0  (RTG3103 ?)
//           1 = Version 1  (RTG31030?/RTG3105)
//           2 = Version 2  (RTG3106)
//           3 = Version x ??
//  bit 4    Enable Acess Clock divider  0CEH index 0x0B
//
//  0x3CE.0x15 = 0x7B
//
//********************************************************


#define  ADDRESS_HIGH   PORTD
#define  ADDRESS_MID    PORTC
#define  ADDRESS_LOW    PORTA             // Latched address use ADDRESS_LATCH_ENABLE

//*********************************************************************
void  VgaReset(void)
{
    RESET = 1;                    // Start reset
    DelayMs(50);
    RESET = 0;                    // Reset end
    DelayMs(1);
}
//*********************************************************************
//*********************************************************************
void  IoPortOutB(register WORD add,register BYTE val)
{

   ADDRESS_HIGH &= 0x0F;               // AddressHigh 4 bit and Reset is low
   DDRA = 0xFF;                        // ADDRESS_LOW is output
   ADDRESS_LOW  = add%256;             // Place the A0..A7 bit to BUS low
   ADDRESS_MID = add/256;              // Place the A8..A15 bit to BUS mid
   ADDRESS_LATCH_ENABLE = 1;           // Latch the value
   ADDRESS_LATCH_ENABLE = 0;
   ADDRESS_LOW = val;                  // Place the data to BUS low
   IO_WRITE = 0;                       // Write to addressed io port
   _NOP();
   while(!IO_CH_READY);
   ADDRESS_LOW = val;                  // Place the data to BUS low
   IO_WRITE = 1;
   _NOP();
   DDRA = 0x00;                        // ADDRESS_LOW is input
   PORTA = 0xFF;
}
//*********************************************************************

void  IoPortOutW(register WORD add,register WORD val)
{

   ADDRESS_HIGH &= 0x0F;               // AddressHigh 4 bit and Reset is low
   DDRA = 0xFF;                        // ADDRESS_LOW is output
   ADDRESS_LOW  = add%256;             // Place the A0..A7 bit to BUS low
   ADDRESS_MID = add/256;              // Place the A8..A15 bit to BUS mid
   ADDRESS_LATCH_ENABLE = 1;           // Latch the value
   ADDRESS_LATCH_ENABLE = 0;
   ADDRESS_LOW = val%256;              // Place the data to BUS low
   ADDRESS_MID = val/256;
   IO_WRITE = 0;                       // Write to addressed io port
   _NOP();
   while(!IO_CH_READY);
   IO_WRITE = 1;
   _NOP();
   DDRA = 0x00;                        // ADDRESS_LOW is input
   PORTA = 0xFF;
}

//*********************************************************************

BYTE IoPortInB(WORD add)
{
   register BYTE  val;

   ADDRESS_HIGH &= 0x0F;               // AddressHigh 4 bit is low
   DDRA = 0xFF;                        // ADDRESS_LOW is output
   ADDRESS_LOW  = add%256;             // Place the A0..A7 bit to BUS low
   ADDRESS_MID  = add/256;             // Place the A8..A15 bit to BUS mid
   ADDRESS_LATCH_ENABLE = 1;           // Latch the value
   ADDRESS_LATCH_ENABLE = 0;
   DDRA = 0x00;                        // ADDRESS_LOW is input mode
//   ADDRESS_LOW = 0xFF;                 // Set the open drain outputs high
   IO_READ = 0;                        // Activate control line
   _NOP();

   while(!IO_CH_READY);
//   _NOP();
   val = PINA;                         // Read the addressed io port
   IO_READ = 1;                        // Control line inactive
   return(val);
}
//*********************************************************************

WORD IoPortInW(WORD add)
{

   register WORD  val;

   ADDRESS_HIGH &= 0x0F;               // AddressHigh 4 bit is low
   DDRA = 0xFF;                        // ADDRESS_LOW is output
   ADDRESS_LOW  = add%256;             // Place the A0..A7 bit to BUS low
   ADDRESS_MID = add/256;              // Place the A8..A15 bit to BUS mid
   ADDRESS_LATCH_ENABLE = 1;           // Latch the value
   ADDRESS_LATCH_ENABLE = 0;
   DDRA = 0x00;                        // ADDRESS_LOW is input mode
   DDRC = 0x00;                        // ADDRESS_MID is high byte input
//   ADDRESS_LOW = 0xFF;               // Set the open drain outputs high
   IO_READ = 0;                        // Activate control line
   _NOP();

   while(!IO_CH_READY);
//   _NOP();
   val = (PINC<<8)+PINA;               // Read the addressed io ports
   IO_READ = 1;                        // Control line inactive
   DDRC = 0xFF;
   return(val);
}

//*********************************************************************

BYTE tstrg(WORD rg,BYTE msk)          // Returns true if the bits in MSK
{                                     // of register PT are read/writable
  BYTE old,nw1,nw2;

  old = IoPortInB(rg);
  IoPortOutB(rg,old & ~msk);
  nw1 = IoPortInB(rg) & msk;
  IoPortOutB(rg,old | msk);
  nw2 = IoPortInB(rg) & msk;
  IoPortOutB(rg,old);
  return((nw1==0) & (nw2==msk));
}
//*********************************************************************
BYTE testinx2(WORD rg,BYTE ix, BYTE msk)// Returns true if the bits in MSK
                                        // of register PT index RG are
                                        // read/writable
{
  BYTE old,nw1,nw2;

  old = VgaIoReadIx(rg,ix);
  VgaIoWriteIx(rg,((old & ~msk)<<8)+ix);
  nw1 = VgaIoReadIx(rg,ix) & msk;
  VgaIoWriteIx(rg,((old | msk)<<8)+ix);
  nw2 = VgaIoReadIx(rg,ix) & msk;
  VgaIoWriteIx(rg,(old<<8)+ix);
  return((nw1==0) & (nw2==msk));
}

//*********************************************************************
BYTE  testinx(WORD pt,BYTE rg)        //{Returns true if all bits of
                                      //     register PT index RG are
                                      //     read/writable.
{
  return(testinx2(pt,rg,0xFF));
}

//*********************************************************************
void TRSubsEnable(void)
{
   IoPortOutB(0x03C3,0x00);
   IoPortOutB(0x46E8,0x16);
   IoPortOutB(0x46E9,0x00);
   IoPortOutB(0x0102,0x01);
   IoPortOutB(0x0103,0x00);
   IoPortOutB(0x46E8,0x0E);
   IoPortOutB(0x46E9,0x00);
   IoPortOutB(0x4AE8,0x00);
   IoPortOutB(0x4AE9,0x00);
//   IoPortOutB(0x3C2,0x23);
}
//*********************************************************************
void  RTGSubsEnable(void)
{
   IoPortOutB(0x46E8,0x16);
   IoPortOutB(0x46E9,0x00);
   IoPortOutB(0x0102,0x01);
   IoPortOutB(0x0103,0x00);
   IoPortOutB(0x46E8,0x0E);
   IoPortOutB(0x46E9,0x00);
   IoPortOutB(0x4AE8,0x00);
   IoPortOutB(0x4AE9,0x00);
   IoPortOutB(0x3C2,0x23);
   VgaIoWriteIx(0x3CE,0x000F);
}

//*********************************************************************

void  OAKSubsEnable(void)
{
   IoPortOutB(0x46E8,0x17);
   IoPortOutB(0x0102,IoPortInB(0x0102)|1);
   IoPortOutB(0x46E8,0x0F);
}

//*********************************************************************

void  CIRRSubsEnable(void)
{
  VgaIoWriteIx(0x46E8,0x001E);
  IoPortOutB(0x0102,0x01);
  VgaIoWriteIx(0x4AE8,0x0000);
  IoPortOutB(0x0103,0x00);
  IoPortOutB(0x03C2,0x01);
  IoPortOutB(0x03B8,0x01);

  IoPortOutB(0x0102,0x01);
  VgaIoWriteIx(0x46E8,0x000E);

}
//*********************************************************************

void  Unlock()                  // Relatek unlock
{
   IoPortOutB(0x3D4,0x1A);
   IoPortOutB(0x3D5,(IoPortInB(0x3D5)&0xEF)|0x10);
}
//*********************************************************************
// #define ATTRCON_ADDR					    0x03C0   ix 0x00-0x14
// #define MISC_ADDR                0x03C2
// #define VGAENABLE_ADDR           0x03C3
// #define SEQ_ADDR                 0x03C4   ix 0x00-0x04
// #define GRACON_ADDR              0x03CE   ix 0x00-0x08
// #define CRTC_ADDR                0x03D4   ix 0x00-0x18
// #define STATUS_ADDR              0x03DA


__flash  BYTE  INIT_GRC_EXTEND1[]=         // Begin 0x09
   {0x00,0x01,0x3A,0x80,0x0B,0x0E,0x00};
__flash  BYTE  INIT_CRTC_EXTEND1[]=        // Begin 0x19
   {0x00,0x50,0x4B,0x6D,0x94,0x01,0x30};

__flash  BYTE  INIT_GRC_EXTEND2[]=         // Begin 0x09
   {0x00,0x01,0x00,0x04,0x04,0x0F,0x00};
__flash  BYTE  INIT_CRTC_EXTEND2[]=        // Begin 0x19
   {0x00,0x50,0xF0,0xFC,0xDF,0x00,0x00};
   // Note ^ the  INIT_CRTC_EXTEND[1]= 0x50 is initial
   // unlocked state. ( locked default is 0x40)
   // Followed bytes require unlocking state
   // Leather set to the locked state

CHIP_TYPE_EN  RTGInit()
{
  BYTE i;
  CHIP_TYPE_EN ChpType = RTG3105iEH;

  IoPortOutB(0x3D8,0x69);
  IoPortOutB(0x3C6,0xFF);
  IoPortOutB(0x3C7,0x03);
  IoPortOutB(0x3C8,0x01);
  IoPortOutB(0x3C9,0x00);
  IoPortOutB(0x3CA,0x01);
  IoPortOutB(0x3CB,0xFF);
  IoPortOutB(0x3CD,0xFF);
  IoPortOutB(0x3D9,0x30);
  IoPortOutB(0x3DD,0x00);
  IoPortOutB(MISC_ADDR,0x67);   // Set the addressing 3D4
  for(i=0;i<7;i++)
  {
    IoPortOutB(0x03CE,i+0x09);
    IoPortOutB(0x03CF,INIT_GRC_EXTEND1[i]);
    IoPortOutB(0x03D4,i+0x19);
    IoPortOutB(0x03D5,INIT_CRTC_EXTEND1[i]);
  }
  if(IoPortInB(0x3CC)==0xFF)
  {
    VgaReset();
    RTGSubsEnable();
    for(i=0;i<7;i++)
    {
      IoPortOutB(0x03CE,i+0x09);
      IoPortOutB(0x03CF,INIT_GRC_EXTEND2[i]);
      IoPortOutB(0x03D4,i+0x19);
      IoPortOutB(0x03D5,INIT_CRTC_EXTEND2[i]);
      ChpType = RTG3105;
    }
  }
  IoPortOutB(0x03CE,0x15);
  IoPortOutB(0x03CF,0x7B);
  return(ChpType);
}
//*********************************************************************

CHIP_TYPE_EN  TestRTG(void)
{
  CHIP_TYPE_EN   chiptype;

  VgaReset();
  Unlock();                     // Realtek unlock
  RTGSubsEnable();
  if (testinx2(0x3D4,0x1F,0x3F) && tstrg(0x3D6,0x0F) && tstrg(0x3D7,0x0F))
  {
    switch (VgaIoReadIx(0x3D4,0x1A)>>6)
    {
      case 0:
        chiptype = RTG3103;
        RTGInit();
        break;
      case 1:
        chiptype = RTGInit();
        break;
      case 2:
        chiptype = RTG3106;
        RTGInit();
        break;
    }
    return(chiptype);
  }
  return(UNKNOWN);
}
///*********************************************************************
CHIP_TYPE_EN  TestTR(void)                  // Test Trident chips
{
  BYTE  value,old,chp;
  CHIP_TYPE_EN chiptype = UNKNOWN;

  VgaReset();
  TRSubsEnable();
  VgaIoWriteIx(0x3C4,0x000B);     //  Force old_mode_registers
  chp = IoPortInB(0x3C5);         //  Read chip ID and switch to new_mode_registers}
  old = VgaIoReadIx(0x3C4,0x0E);
  IoPortOutB(0x3C5,0x00);
  value = IoPortInB(0x3C5) & 0x0F;
  IoPortOutB(0x3C5,old);

  if(value==2)
  {
    IoPortOutB(0x3C5,old^2);
    switch(chp)
    {
      case 0x01:
        chiptype = TR8800BR;
        break;
      case 0x02:
        chiptype = TR8800CS;
        break;
      case 0x03:
        chiptype = TR8900;
        break;
      case 0x04:
      case 0x13:
        chiptype = TR8900C;
        TR8900D_Init();
        break;
      case 0x23:
        chiptype = TR9000;
        TR9000i_Init();
        break;
    case 0x33:
        chiptype = TR8900CLD;
        TR8900D_Init();
        break;
      case 0x43:
        chiptype = TR9000i;
        TR9000i_Init();
        break;
      case 0x53:
        chiptype = TR8900CXr;
        break;
      case 0x63:
        chiptype = LCD9100B;
        break;
      case 0x83:
        chiptype = LX8200;
        break;
      case 0x93:
        chiptype = TVGA9400CXi;
        break;
      case 0xA3:
        chiptype = LCD9320;
        break;
      case 0x73:
      case 0xF3:
        chiptype = GUI9420;
    }
  }
  else if( (chp==1) & testinx2(0x3C4,0x0E,6))
  {
    chiptype = TVGA8800BR;     //Haven't tested this yet
  }
  return(chiptype);
}

///*********************************************************************

CHIP_TYPE_EN  TestOAK(void)
{
  CHIP_TYPE_EN   chiptype = UNKNOWN;

  VgaReset();
  OAKSubsEnable();
  if (testinx2(0x3DE,0x0D,0x38))
  {
    // { We have an OAK }
    if (testinx2(0x3DE,0x23,0x1F))
    {
      if((VgaIoReadIx(0x3DE,0x00)& 0x02)==0)
      {
        chiptype = OAK_087;
        OTI0087_Init();
      }else chiptype = OAK_083;
    }
    else
    {
      switch(IoPortInB(0x3DE)/32)
      {
        case 0:
          chiptype = OAK_037C;
          break;
        case 2:
          chiptype = OAK_067;
          break;
        case 5:
          chiptype = OAK_077;
          OTI077_Init();
          break;
        case 7:
          chiptype = OAK_057;
      }
    }
  }
  return(chiptype);
}

///*********************************************************************

CHIP_TYPE_EN TestCIRRUS(void)
{

  BYTE            old,SubVers;
  CHIP_TYPE_EN    chiptype = UNKNOWN;

  VgaReset();
  CIRRSubsEnable();
  old = VgaIoReadIx(0x3C4,0x06);
  VgaIoWriteIx(0x3C4,0x0006);
  if (VgaIoReadIx(0x3C4,0x06)==0x0F)
  {
    VgaIoWriteIx(0x3C4,0x1206);
    if((VgaIoReadIx(0x3C4,0x06)==0x12)&& testinx2(0x3C4,0x1E,0x3F))
    {
      SubVers=VgaIoReadIx(0x3D4,0x27);
      if(testinx(0x3CE,0x09))
      {
        switch(SubVers)
        {
          case 0x88:
            chiptype = CL_GD5402;
            break;
          case 0x89:
            chiptype = CL_GD5402R1;
            break;
          case 0x8A:
            chiptype = CL_GD5420;
            break;
          case 0x8B:
            chiptype = CL_GD5420R1;
            break;
          case 0x8C||0x8D||0x8E||0x8F:
            chiptype = CL_GD5422;
            break;
          case 0x90:
          case 0x91:
          case 0x92:
          case 0x93:
            chiptype = CL_GD5426;
            break;
          case 0x94:
          case 0x95:
          case 0x96:
          case 0x97:
            chiptype = CL_GD5424;
            break;
          case 0x98:
          case 0x99:
          case 0x9A:
          case 0x9B:
            chiptype = CL_GD5428;
            break;
          case 0xA0:
          case 0xA1:
          case 0xA2:
          case 0xA3:
            chiptype = CL_GD5430;
            break;
          case 0xA8:
          case 0xA9:
          case 0xAA:
          case 0xAB:
            chiptype = CL_GD5434;
            break;
        }
      }
      else if(testinx(0x3C4,0x19))
      {
        switch(SubVers>>6)
        {
          case 0:
            chiptype = CL_GD6205;
          case 1:
            chiptype = CL_GD6235;
          case 2:
            chiptype = CL_GD6215;
          case 3:
            chiptype = CL_GD6225;
        }
      }
      else chiptype = AVGA2_5402;
    }
  }
  VgaIoWriteIx(0x3C4,(old<<8)+0x06);
  return(chiptype);
}
///*********************************************************************

CHIP_TYPE_EN  VgaInit()
{
  CHIP_TYPE_EN chiptype = UNKNOWN;

  ADDRESS_LATCH_ENABLE =  0;    // Output   default= low
  MEMORY_WRITE         =  1;    // Output   default= high
  MEMORY_READ          =  1;    // Output   default= high
  IO_WRITE             =  1;    // Output   default= high
  IO_READ              =  1;    // Output   default= high
  IO_CH_READY          =  1;    // Input
  RESET                =  0;    // Output   default= low
  BALE                 =  1;
  SBHE                 =  1;

  if (chiptype =TestRTG())                 // Detect Realtek
  {
    return(chiptype);
  }
  else if(chiptype = TestTR())             // Else detect Trident
  {
    return(chiptype);
  }
  else if(chiptype = TestOAK())           // Else detect OAK
  {
    return(chiptype);
  }
  else if(chiptype = TestCIRRUS())        // Else detect Cirrus
  {
    return(chiptype);
  }
  return(UNKNOWN);
}



























