#include "config.h"
#include "types.h"
#include <ina90.h>
#include <pgmspace.h>
#include <stdio.h>
#include "kb.h"
#include "scancodes.h"


#define ESC 0x1b
char CLR[] =
{
	ESC, '[', 'H', ESC, '[', '2', 'J', 0
};

#define BUFF_SIZE 64

unsigned char edge, bitcount; 							 // 0 = neg.	1 = pos.

unsigned char kb_buffer[BUFF_SIZE];
unsigned char* inpt, * outpt;
unsigned char buffcnt;

//*********************************************************************

BYTE GetSwitchState()
{
	DDRF = 0x00;
	asm("nop");
	asm("nop"); 			
	asm("nop");
	asm("nop"); 			
	asm("nop");
	asm("nop"); 			
	asm("nop");
	asm("nop"); 			

	SW_state = PINF & 0x0F;
	SW_state ^= 0x0F ;		
	return (SW_state);
}

//*********************************************************************

void init_kb(void)
{
	inpt = kb_buffer; 											  // Initialize buffer
	outpt = kb_buffer;
	buffcnt = 0;

	EICRB = (EICRB&(0xFF-3))|2;								// INT4 interrupt on falling edge
	edge = 0; 																// 0 = falling edge  1 = rising edge
	bitcount = 11;
	EIMSK_INT4 = 1; 													// Enable INT4 interrupt
}

//*********************************************************************

#pragma vector=INT4_vect
__interrupt void INT4_interrupt(void)
{
	static unsigned char data;								// Holds the received scan code

	if (!edge)																// Routine entered at falling edge
	{
		if (bitcount <11 && bitcount> 2)		    // Bit 3 to 10 is data. Parity bit,
		{
			// start and stop bits are ignored.
			data = (data >> 1);
			if (PIN_KB & (1 << DATAPIN))
			{
				data = data | 0x80; 					      // Store a '1'
			}
		}

		EICRB = (EICRB&(0xFF-3))|3;						  // Set interrupt on rising edge
		edge = 1;
	}
	else
	{
		// Routine entered at rising edge
		// PORTB = PORTB & ~(1<<PORTB5);
		EICRB = (EICRB&(0xFF-3))|2;					    // Set interrupt on falling edge
		edge = 0;

		if (--bitcount == 0)										// All bits received
		{
			decode(data);
			bitcount = 11;
		}
	}
}
//*********************************************************************
void decode(unsigned char sc)
{
	static enum _KEY_STATE_EN
	{
	  NORMAL,
    EXTEND,
	  BREAK
	}key_state_en = NORMAL;

	static enum _SHIFT_STATE_EN
	{
	  NOSHIFT,
	  LSHIFT,
	  RSHIFT
	}shift_state_en = NOSHIFT;
    	
	BYTE i;

	if (key_state_en != BREAK ) 	// Last data received was the up-key identifier
	{
		switch (sc)
		{
		case 0xF0 :
			// The up-key identifier
			key_state_en = BREAK;
			break;

		case 0x12 :
			// Left SHIFT
			shift_state_en = LSHIFT;
			break;
		case 0x59 :
			// Right SHIFT
			shift_state_en = RSHIFT;
			break;
		case 0x05 :		
			// F1
			break;
    case 0xE0 :
      key_state_en = EXTEND;
      break;
		default:
      if(key_state_en == NORMAL)
      {
		    switch(shift_state_en)
		    {
		    case NOSHIFT:
				  // do a table look-up
		      for (i = 0; unshifted[i][0] != sc && unshifted[i][0]; i++);
				  if (unshifted[i][0] == sc)
				  {
				  	put_kbbuff(unshifted[i][1]);
				  }
	    	  break;
	      case LSHIFT:
	      case RSHIFT:			
			    // If shift pressed
				  for (i = 0; shifted[i][0] != sc && shifted[i][0]; i++);
				  if (shifted[i][0] == sc)
				  {
				    put_kbbuff(shifted[i][1]);
				  }
			    break;
			  }
      }
      else if(key_state_en == EXTEND)
      {
          put_kbbuff(0xE0);
          put_kbbuff(sc);
      }
		}
	}
	else
	{
		switch (sc)             // Hendle the various break statement
		{
		case 0x12 :
			// Left SHIFT
		case 0x59 :
			// Right SHIFT
			shift_state_en = NOSHIFT;
			break;
    case 0xE0 :
    	key_state_en = NORMAL;	
      break;
    default:
      key_state_en = NORMAL;
		}
	}
}
//*********************************************************************
void put_kbbuff(unsigned char c)
{
	if (buffcnt < BUFF_SIZE)										// If buffer not full
	{
		*inpt = c;																// Put character into buffer
		inpt++; 																	// Increment pointer

		buffcnt++;

		if (inpt >= kb_buffer + BUFF_SIZE)				// Pointer wrapping
			inpt = kb_buffer;
	}
}
//*********************************************************************
int GetCharKb(void)
{
	int byte;
	if (buffcnt == 0)
		return(0xffff); 											    // Wait for data

	byte = *outpt;															// Get byte
	outpt++;																		// Increment pointer

	if (outpt >= kb_buffer + BUFF_SIZE) 				// Pointer wrapping
		outpt = kb_buffer;
  if (byte == 0xE0)
  {
    byte = (byte<<8)+(*outpt);
	  outpt++;																		// Increment pointer
	  if (outpt >= kb_buffer + BUFF_SIZE) 				// Pointer wrapping
		  outpt = kb_buffer;
    buffcnt--;
  }
	buffcnt--;																	// Decrement buffer count

	return byte;
}
//*********************************************************************


