#ifndef TYPES_H
#define TYPES_H

//typedef enum _BOOL { FALSE = 0, TRUE } BOOL;		This is definition take larger code
typedef unsigned char BYTE;                 // 8-bit
typedef unsigned char U8;                   // 8-bit
typedef char          I8;                   // 8-bit
typedef unsigned short int  WORD;           // 16-bit
typedef unsigned short int  U16;            // 16-bit
typedef          short int  I16;            // 16-bit
typedef unsigned long       DBLWORD;        // 32-bit
typedef unsigned long       U32;            // 32-bit
typedef          long       I32;            // 32-bit

typedef DBLWORD	TIME_T;	

typedef union _WORD_VAL
{
    WORD Val;
    BYTE v[2];
} WORD_VAL;

typedef union _DWORD_VAL
{
    DBLWORD Val;
    BYTE v[4];
} DWORD_VAL;

typedef struct  _BOX_CHARS
{
  BYTE  TopLeftChar;
  BYTE  HorizontalChar;
  BYTE  TopRightChar;
  BYTE  VerticalChar;
  BYTE  BotLeftChar;
  BYTE  BotRightChar;
  BYTE  HseparLeftChar;
  BYTE  HseparatorChar;
  BYTE  HseparRightChar;
  BYTE  VseparTopChar;
  BYTE  VseparatorChar;
  BYTE  VseparBotChar;
}BOX_CHARS;

typedef struct  _MENU_ITEMS_ST
{
  const char  __farflash  *Text;
  const char              Key;
}MENU_ITEMS_ST;

typedef enum  _PREDIR_EN
{
  RS232TX,
  VGA_TEXT,
}PREDIR_EN;

typedef enum  _GREDIR_EN
{
  RS232RX,
  PS2_KEYB
}GREDIR_EN;

typedef struct  _MENU_PROP_ST
{
  BYTE          TopLeftX;
  BYTE          TopLeftY;
  BYTE          Width;
  BYTE          Height;
  const char __farflash *Name;
  BYTE          NameColor;
  BYTE          BoxSetIx;
  BYTE          BoxColor;
  BYTE          AreaColor;
  BYTE          SelectorColor;  // Combined color (back<<8)+fore
  BYTE          ItemNbr;
  MENU_ITEMS_ST __farflash* Items;
}MENU_PROP_ST;

typedef struct  _PROG_LINE_ST
{
  BYTE  Tolt;
  BYTE  Jel1;
  BYTE  Hof;
  BYTE  CirOI;
  BYTE  CirIO;
  BYTE  Jel2;
  BYTE  MgsIx;
  BYTE  Leer;
}PROG_LINE_ST;

typedef struct  _DYEING_PROG_ST
{
  BYTE          ProgNmbr[10];   // size 10
  BYTE          ProgName[30];   // size 30
  PROG_LINE_ST  ProgLines[16];  // size 16 x 8 = 128
}DYEING_PROG_ST;                // size 168

// Videomode Info Structure
typedef struct _VMODE_ST
{
   BYTE mode;                       // Videomode Number
   WORD width;                      // Width in pixels
   WORD height;                     // Height in pixels
   WORD width_bytes;                // Number of bytes per screen
   WORD colors;                     // Number of colors
   WORD attrib;                     // Videomode attributes
}VMODE_ST;

typedef enum _CHIP_TYPE_EN
{
  UNKNOWN,
  RTG3103,
  RTG3105,
  RTG3105iEH,
  RTG3106,
  TR8800BR,
  TR8800CS,
  TR8900,
  TR8900C,
  TR9000,
  TR8900CLD,
  TR9000i,
  TR8900CXr,
  LCD9100B,
  LX8200,
  TVGA9400CXi,
  LCD9320,
  GUI9420,
  TVGA8800BR,
  OAK_037C,
  OAK_057,
  OAK_067,
  OAK_077,
  OAK_083,
  OAK_087,
  CL_GD5402,
  CL_GD5402R1,
  CL_GD5420,
  CL_GD5420R1,
  CL_GD5422,
  CL_GD5426,
  CL_GD5424,
  CL_GD5428,
  CL_GD5430,
  CL_GD5434,
  CL_GD6205,
  CL_GD6235,
  CL_GD6215,
  CL_GD6225,
  AVGA2_5402
}CHIP_TYPE_EN;
#endif
