#ifndef _DEFINITIONS_H_
#define DEFINITIONS_H_

// Heater-signals
#define HEAT1 P2_4
#define HEAT2 P2_3

// Temperature IC signals
#define SO  P2_0
#define NCS P2_1
#define SCK P2_2

// LCD signals
#define LCD_RS  P2_5
#define LCD_RnW P2_6
#define LCD_E   P2_7
#define LCD_DAT P0

// LED outputs
#define LED1 P3_7
#define LED2 P3_6
#define LED3 P3_5


// Timer 0 count (at 6MHz)
#define T0COUNTVAL 2000

// keyboard const
#define DEBOUNCEVAL  5
#define KEYFIRSTREPEATVAL 30
#define KEYREPEATVAL 15

#define NRPROFILES 10				// max nr of profiles stored in EEPROM

#define MENU_START  1
#define MENU_EDIT   2
#define MENU_LOG    3
#define MENU_CAL	4
#define MENU_MAX    4
#define MENU_MIN	1


struct Tprofile 
{
  unsigned int pre_slope;		// max slope in the preheat phase in 0.2 C / sec. Reccomm. is 2C/sec to 3C/sec
  unsigned int pre_endtemp;		// end temp in the preheat phase in 1 C. Reccomm. is 100 to 120 C
  unsigned int soak_time;			// time spend in soakphase in seconds. Reccomm. is 1min to 4 min
  unsigned int soak_endtemp;		// the endtemp in the soakphase en 1 C. Recomm. is 175 to 180 C
  unsigned int reflow_time;			// the time spend in reflowphase in seconds
  unsigned int reflow_peaktemp;		// the max temperature reached in reflowphase.
};
#define PROFILES_START_ADR 2		// Start adres of profile-settings in EEPROM Memory
#define LOG_START_ADR 16			// Start adres of temperaturelog in EEPROM Memory
#define LOG_END_ADR 65532			// End adres of temperaturelog in EEPROM Memory
// function prototyps for ovencontrol.c
void wait_1ms (void);
void wait_10ms (void);
extern char str_buf[20];

#endif
