#include <stdio.h>
#include <regat89c51.h>
#include "definitions.h"
#include "lcd.h"




void lcd_wait_busy()
{
  unsigned char temp;
  LCD_DAT = 0xff; // all datasignals High-Z
  LCD_RS=0;	      // Select Status_register
  LCD_RnW = 1;    // Define Read-operation
  temp = 0xff;
  while ((temp&0x80)!=0)
  {
    LCD_E = 1;
    temp = LCD_DAT;
    LCD_E = 0;
  }
}

void lcd_write_cmd (unsigned char dat)
{
  lcd_wait_busy();
  LCD_DAT = dat;
  LCD_RS=0;		// Select Command/Status register
  LCD_RnW = 0;  // Define Write operation
  LCD_E = 1;	// Enable pulse for the LCD
  LCD_E = 0;
}

void lcd_write_dat (char dat)
{ unsigned char t;
  for (t=0;t<25;t++){};
//  lcd_wait_busy();
  LCD_DAT = dat;
  LCD_RS =1;		// Select data transfer
  LCD_RnW =0;		// Define Write operation
  LCD_E = 1;		// Enable pulse for the LCD
  LCD_E = 0;
}

void lcd_print_at (char* text, unsigned char x,y)
{
  unsigned char cmd;
  cmd = 0x80 + x;
  if (y!=0) cmd = cmd+0x40;
  lcd_write_cmd (cmd); // Goto XY location (x,y)
  while ( *text != 0 )
  {
    lcd_write_dat (*text++);
  }
}

void lcd_print_line (char* text, unsigned char line)
{
  unsigned char x;
  x=0;
  if (line == 0) lcd_write_cmd (0x80); else lcd_write_cmd (0xc0);
  lcd_wait_busy();
  while (*text != 0)
  {
    lcd_write_dat (*text++);
	x++;
  }
  while (x++<16)
  {
    lcd_write_dat (' ');
  }
}

void lcd_init (void)
{
  LCD_E=0;	            // Start with a low voltage on the LCD_Enable;
  lcd_write_cmd (0x38);	// Function set : 8-bits,  1/16 Duty cycle, 5x7 dots
  lcd_write_cmd (0x01); // Clear display;
  lcd_write_cmd (0x02);	// Undo shift
  lcd_write_cmd (0x06);	// Shift cursor to the right
  lcd_write_cmd (0x0c);	// Display ON, cursor ON, blink OFF
  lcd_write_cmd (0x40);	// CGRAM pointer at location 0
  lcd_write_cmd (0x80);	// DDRAM pointer at location 0
}

