#include <stdio.h>
#include "regat89c51.h"
#include "max6675.h"

#define MAX_SO  P2_0
#define MAX_NCS P2_1
#define MAX_SCK P2_2

unsigned int read_temperature (void)
{
  unsigned int shiftreg = 0;
  unsigned char count;
  MAX_SO  = 1;		// SO is input
  MAX_SCK = 0;		// clock is low, needed for first time use
  MAX_NCS = 0;		// Select the max6675 and stop conversion
  for (count=0;count<13;count++)
  {
    MAX_SCK=1;
    shiftreg = shiftreg << 1;
	if (MAX_SO == 1) shiftreg=shiftreg +1;
	MAX_SCK=0;
  }
  for (count=0;count<3;count++)  // disregard the last 3 bytes
  {
    MAX_SCK=1;
	MAX_SCK=0;
  }
  MAX_NCS = 1;		// Start next conversion
  return shiftreg;
}
