#include <stdio.h>
#include <string.h>
#include <regat89c51.h>
#include "definitions.h"
#include "rs_232.h"

volatile bit ti_busy; rx_valid;
volatile char rx_char;

void serialhandler (void) interrupt SIO_VECTOR using 3
{
  if (TI==1) {ti_busy=0;TI=0;}
  if (RI==1) {rx_char=SBUF; RI=0;}
}

void init_rs232 (void)
{
  TI = 0;
  RI = 0;
  ti_busy=0;
  rx_valid=0;
}

void printchar_rs232 (char ch)
{
  while (ti_busy==1){};				// Wait until last transmission is completed
  ti_busy=1; SBUF= ch;				// start a new transmission
}

void printstr_rs232 (char* str)

{
  while (*str!=0)					// Repeat until end of string
  {
    while (ti_busy==1){};			// Wait for the last transmission to complete
	ti_busy=1; SBUF=*(str++);		// transmit a new character and increase the pointer
  }
}

unsigned char getchar_rs232 (void)
{
  if (rx_valid)
  {
    rx_valid=0;
	return rx_char;
  }
  else return 0;
}


