program profil;
{Geschwindigkeitsmessung fr ScopeCard 220}
{Test: Abholung von 32000 Sample-Daten (beide Kanle)}
{$G+,S-}
const
 PortBase:Word=$100;

procedure access1(buf:PChar; buflen:Word); assembler;
{Originalroutine wie in SCOPE1.DLL}
 asm	les	di,[buf]
	mov	cx,[buflen]
	mov	dx,[PortBase]
	add	dx,2
	mov	bx,0
@@l:	mov	al,bl
	out	dx,al
	inc	dx
	mov	al,bh
	out	dx,al
	in	al,dx
	cbw
	mov	es:[di],ax
	dec	dx
	in	al,dx
	cbw
	mov	es:[di],ax
	add	di,2
	inc	bx
	loop	@@l
 end;

procedure access2(buf:PChar; buflen:Word); assembler;
{Verbesserte Routine mit 16-Bit-Zugriffen, kompatibel zu SCOPE1.DLL}
 asm	les	di,[buf]
	mov	cx,[buflen]
	mov	dx,[PortBase]
	add	dx,2
	mov	ax,0
@@l:	out	dx,ax		{Adresse ausgeben}
	insw			{Datenwort einlesen nach ES:DI}
	inc	ax		{knnte auch grere Sprnge machen!}
	loop	@@l
 end;

procedure access3(buf:PChar; buflen:Word); assembler;
{Versuch, Adressen-Zugriffe zu minimieren, kompatibel zu SCOPE1.DLL}
 asm	les	di,[buf]
	mov	cx,[buflen]
	mov	dx,[PortBase]
	add	dx,2
	mov	ax,0
@@16bit:
	out	dx,ax		{Adresse komplett ausgeben}
	jmp	@@1
@@l:	or	al,al
	jz	@@16bit		{gelegentlicher Aussprung!}
	out	dx,al
@@1:	insw			{Datenwort einlesen nach ES:DI}
	inc	ax
	loop	@@l
 end;

procedure access4(buf:PChar; buflen:Word); assembler;
{Wenn wir ein ordentliches FPGA htten...}
 asm	les	di,[buf]
	mov	cx,[buflen]
	mov	dx,[PortBase]
	add	dx,2
	mov	ax,0
	out	dx,ax		{Adresse ausgeben}
	rep	insw		{Datenworte einlesen nach ES:DI}
 end;

procedure access5(buf:PChar; buflen:Word); assembler;
{Was macht ein 32-Bit-Zugriff an Geschwindigkeit?}
 asm	les	di,[buf]
	mov	cx,[buflen]
	shr	cx,1		{Nicht vergessen!}
	mov	dx,[PortBase]
	mov	ax,0
	out	dx,ax		{Adresse ausgeben}
	db $66; rep insw	{= rep insd}
 end;

var
 buf:PChar;
begin			{Testsystem: mein AMD K6/2 350MHz, Win95A}
 GetMem(buf,32000*2);	{Zeit	Netto	Brutto}
 access1(buf,32000);	{200ms	320kB/s	640kB/s}
 access2(buf,32000);	{150ms	426kB/s	850kB/s}
 access3(buf,32000);	{125ms	512kB/s	768kB/s}
 access4(buf,32000);	{ 74ms	850kB/s	=netto}
 access5(buf,32000);	{ 62ms	> 1MB/s	=netto}
 FreeMem(buf,32000*2);
end.

{Auf dem 2. Testrechner (486/66 mit Win95C) unterscheiden sich die Werte
 nur minimal; erstaunlich ist, dass dieser bei "rep insw" und "rep insd"
 noch schneller ist als der K6/2}
