library IEEE;
use IEEE.STD_LOGIC_1164.all;
--use IEEE.NUMERIC_STD.all;
--use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

-- 15-bit-Zhler mit einstellbarer Schrittweite
entity z15 is
 port(
  Clock: in STD_LOGIC;	-- Takt (steigend)
  Reset: in STD_LOGIC;	-- Rcksetzen (H-aktiv)
  step: in STD_LOGIC_VECTOR (2 downto 0);	-- Zhlschrittweite 1..128
  Q: out STD_LOGIC_VECTOR (14 downto 0)		-- Zhlerstand
 );
end z15;

architecture a_z15 of z15 is
begin
 process(Clock,Reset,step)
 variable QQ: STD_LOGIC_VECTOR(14 downto 0);
 begin
  if Reset='1' then
   QQ := "000000000000000";
  elsif RISING_EDGE(Clock) then
   QQ := QQ + TO_STDLOGICVECTOR("00000001" sll CONV_INTEGER(step));
  end if;
  Q <= QQ;
 end process;
end a_z15;


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

entity alles is
 port(
  dd: inout UNSIGNED (7 downto 0);	-- ISA-Datenbus
  a: in UNSIGNED (2 downto 0);		-- ISA-Adressbus
  iord,iowr,iocs,clrsc: in STD_LOGIC;		-- ISA-Steuerbus
  diva,divb: out UNSIGNED(2 downto 0);	-- Analog
  ainsel,binsel: out STD_LOGIC;			-- Analog
  ut: out UNSIGNED (15 downto 0);	-- RAM-Adresse und IRQ(?)
  inl,inh: in UNSIGNED (7 downto 0);		-- ADU-Eingang
  clksc: in STD_LOGIC;				-- Takt
  ch1in,ch2in,extin: in STD_LOGIC;		-- (analoge) Trigger
  tpin,adcoe,ramcs,ramwr: out STD_LOGIC		-- ADC-Takt, ADC-OE, RAM-CS, RAM-WR
 );
end alles;

architecture a_alles of alles is
 signal sample_z: UNSIGNED (15 downto 0);
 signal ram_z: UNSIGNED (14 downto 0);
 signal sample_ff: UNSIGNED (15 downto 0);
 signal trigger_ff: UNSIGNED (7 downto 0);
 signal step_ff: UNSIGNED (7 downto 0);
 signal digi_ff: UNSIGNED (7 downto 0);
 signal ana_ff: UNSIGNED (7 downto 0);
 signal sample_ct: UNSIGNED (15 downto 0);
 signal clk_sa: STD_LOGIC;			-- (heruntergeteilter) Sample-Takt
 signal tr: STD_LOGIC;				-- (gemultiplextes) Trigger-Signal
 signal tp: STD_LOGIC;				-- Trigger-Impuls
begin
-- der Ausgabe-Multiplexer
-- (reine Kombinatorik, deshalb alle Signale in Ereignisliste)
 process(iord,iocs,a,inl,inh,sample_z,ram_z)
 begin
  if iocs='0' and iord='0' then
   case a is
    when "000" => dd<=inh;
    when "001" => dd<=inl;
    when "010" => dd<=inh;
    when "011" => dd<=inl;
    when "100" => dd<=sample_z (7 downto 0);
    when "101" => dd<=sample_z (15 downto 8);
    when "110" => dd<=ram_z (7 downto 0);
    when "111" => dd(6 downto 0)<=ram_z (14 downto 8); dd(7)<='X';
   end case;
  else
   dd<="ZZZZZZZZ";		-- hochohmig
  end if;
 end process;

-- die Registerbank mit Reset
 process(iowr,iocs,clrsc)
 begin
  if clrsc='1' then
   sample_ff <="0000000000000000";
   trigger_ff<="00000000";
   step_ff   <="00000000";
   digi_ff   <="00000000";
   ana_ff    <="00000000";
  elsif RISING_EDGE(iowr and iocs) then
   case a is
    when "000" => sample_ff(7 downto 0)<=dd;
    when "001" => sample_ff(15 downto 8)<=dd;
    when "010" => trigger_ff <=dd;
    when "011" => step_ff	 <=dd;
    when "100" => digi_ff	 <=dd;
    when "101" => ana_ff	 <=dd;
    when others =>
   end case;
  end if;
 end process;

-- Durchreichen von ana_ff an Analog-Steuerausgnge
-- (nicht mal Kombinatorik, nur 8 Strippen)
 process(ana_ff)
 begin
  binsel <=ana_ff(7);
  divb   <=ana_ff(6 downto 4);
  ainsel <=ana_ff(3);
  diva   <=ana_ff(2 downto 0);
 end process;
-- noch eine Durchreiche: fr RAM-Adressen
 process(ram_z)
 begin
  ut(14 downto 0) <= ram_z;
 end process;

-- Sampleraten-Teiler
 process(clksc)
 begin
  if RISING_EDGE(clksc) then
   if sample_ct = 0 then
    sample_ct <= sample_ff;
   else
    sample_ct <= sample_ct - 1;
   end if;
  end if;
 end process;
 
 process(clksc,sample_ct)
 begin
  if (clksc='1' and sample_ct=0) then
   clk_sa <= '1';
   tpin <= '0';
  else
   clk_sa <= '0';
   tpin <= '1';
  end if;
 end process;

-- RAM-Zhler
 process(clk_sa)
 begin
  if RISING_EDGE(clk_sa) then
	--idiotisch, ja, aber ich konnte es nicht anders beibringen!
   case step_ff(2 downto 0) is
    when "000" => ram_z <= ram_z + 1;
    when "001" => ram_z <= ram_z + 2;
    when "010" => ram_z <= ram_z + 4;
    when "011" => ram_z <= ram_z + 8;
    when "100" => ram_z <= ram_z + 16;
    when "101" => ram_z <= ram_z + 32;
    when "110" => ram_z <= ram_z + 64;
    when "111" => ram_z <= ram_z + 128;
   end case;
--   ram_z <= ram_z + to_unsigned(1 sll conv_integer(step_ff(2 downto 0)));
  end if;
 end process;

-- Trigger-Auswahl (Komparator und Multiplexer)
 process(inh,inl,trigger_ff,digi_ff,ch1in,ch2in,extin)
 variable comp2: UNSIGNED(7 downto 0);
 begin
  if digi_ff(0) = '0' then
   comp2 := inh;
  else
   comp2 := inl;	-- vorher multiplexen!
  end if;
  case digi_ff(2 downto 0) is
   when "000" => tr <= ch1in;
   when "001" => tr <= ch2in;
   when "010" or "011" => if comp2 > trigger_ff then tr<='1'; else tr<='0'; end if;
   when others => tr <= extin;
  end case;
 end process;

end a_alles;
											  