// Alle Arten von Datenquellen
#ifndef QUELLE_H
#define QUELLE_H

#ifndef WIN32
// Nur fr GMEM_FIXED:
# define GlobalAlloc(s,f) ((LPVOID)MAKELONG(0,GlobalAlloc(s,f)))
# define GlobalReAlloc(p,f,s) ((LPVOID)MAKELONG(0,GlobalReAlloc((HGLOBAL)HIWORD(p),f,s)))
# define GlobalFree(p) ((LPVOID)MAKELONG(0,GlobalFree((HGLOBAL)HIWORD(p))))
#endif

// zur Ersparnis von Schreibarbeit - und evtl. Umsetzung zur Registry
#define WriteString(s,k,v) WritePrivateProfileString(s,k,v,StdProfile)
#define GetString(s,k,d,b,l) GetPrivateProfileString(s,k,d,b,l,StdProfile)
#define GetInt(s,k,d) GetPrivateProfileInt(s,k,d,StdProfile)

// flags
#define Q_NONINTERLACED 0x01	// Sampledaten nicht verzahnt
#define Q_CONTINUOUS	0x02	// Sampledaten lckenlos (geringe Abtastfr.)
#define Q_SOFTTRIGGER	0x04	// Oszi-Software muss Trigger suchen
#define Q_ASYNC		0x08	// WaitMessage() unzulssig
//#define Q_FULL		0x10	// Puffer gefllt
#define Q_ARMED		0x80	// "scharfgestellt": wird bei Triggerereignis
				// zurckgesetzt, wenn nicht lckenlos
typedef void(NEAR*GETPROC) (NPVOID,LPWAVEHDR NEAR*);
typedef UINT(NEAR*TRIGPROC)(LPSTR,UINT);
typedef void(NEAR*PRAEPROC)(LPSTR,UINT);
typedef int(_fastcall *GETSAMPLE)(LPSTR,BYTE);
typedef void(_fastcall *MAKESUB)(void);

#ifdef __cplusplus
// Zur softwaremigen Suche einer Pegeltriggerung
// fr steigende und fallende Flanken
// als globale Variable im Oszi-Programm(!)
struct SOFT_TRIGGER {
 GETSAMPLE getsample;	// Funktionszeiger, liefert <int>-aufgeblasenen Wert
 TRIGPROC trigproc;	// Trigger-Funktion
 PRAEPROC praeproc;	// Vor-Trigger-Funktion (DC-Pegel anpassen usw.)
 MAKESUB makesub;	// Die Funktion, die "sub" nachfhrt
 BYTE mask;		// der Parameter fr getsample
 BYTE blockadd;		// zur Korrektur des Zeigers fr GetSample
 int xor;		// 0 fr steigende, -1 fr fallende Flanke
 long sub;		// Festkomma-Subtrahend, Null fr DC, mitlaufend fr AC
 int cmp1;		// Vergleichswerte fr Hysterese beim Trigger
 int cmp2;		// Differenz muss mindestens 1 betragen!
 int y;			// Alter Wert fr nchsten Vergleich
 UINT timestart;	// Sample-Zhler-Start fr Tiefpass (LF)
 UINT timedown;		// Sample-Zhlerstand fr Tiefpass (LF)
 UINT blockalign;	// zur Inkrementierung des Zeigers
 long pre;		// Prtrigger IN BYTES, nicht in Samples!
 int min;		// FF80h oder 8000h
 int max;		// 7Fh (8 bit) oder 7FFFh (16 bit)
 inline void Reset() {y=((((unsigned)-1)>>1)-1)^xor;};
};

extern SOFT_TRIGGER st;
#define GET_SUB(x) ((int)((x)>>ACTIME))

bool FindTrigger();
// Der WAVEHDR ist eigentlich auch global!!
// GetProc geht an den Treiber, mit LPWAVEHDR FAR* als LPARAM

/* Liest nacheinander Wave-Datenblcke via <getproc> ein und sucht
   die Triggerbedingung darin:  Schlsseltechnologie!
				^^^^^^^^^^^^^^^^^^^^
   Nebenbei wird - bei simulierter AC-Kopplung - der Triggerpegel
   dem Signal nachgefhrt (aber wie???),
   und schnell soll die Routine ja ganz nebenbei auch noch sein...

PARAMETER:
Der eingegebene LPWAVEHDR hat folgende Interpretation:
.lpData		= Puffer (vom Anwender zur Verfgung gestellt, darf huge sein)
.dwBufferLength	= Gre des Puffers (auch huge!)
.dwBytesRecorded= Fllstand des Puffers mit NEUEN Daten
		   Wird von FindTrigger inkrementiert 
.dwUser		= ab da beginnen die NOCH ALTEN Daten (Start mit dwBufferLength)
		   Wird von FindTrigger inkrementiert 
.dwFlags	= Flags (aber auf keinen Fall eins fr Rollbetrieb!)
	WHDR_DONE	= Keine weiteren ZUSAMMENHNGENDEN Daten mehr!
			  (bspw. 32-Kilobyte-Puffer leergesaugt)
			   wird von FindTrigger gesetzt 
	WHDR_BEGINLOOP	= Datenbereich zwischen Anfang und .dwLoops
			  ist mit einer Runde Pr-Trigger-Daten gefllt.
			   wird von FindTrigger gesetzt 
	WHDR_ENDLOOP	= Keine Triggersuche.  Wird von FindTrigger gesetzt,
			  sobald ein Trigger gefunden wurde 
	WHDR_PREPARED	= Interruptgesteuerter "Paketdienst",
			   wird von FindTrigger gesetzt 
.dwLoops	= Wenn WHDR_BEGINLOOP gesetzt, ist hier die Grenze zwischen
		  neuen und alten Pr-Trigger-Daten festgehalten.
		  Ist dann stets kleiner/gleich .reserved.
		   wird von FindTrigger gesetzt 
		  Sollte zwecks einfacher Auswertung auf 0 gesetzt werden.
.lpNext		= interner Zeiger auf "gerade auszusaugenden" Wave-Block
.reserved	= Triggerposition (vorzeichenbehaftet!)  wird von FindTrigger
		  inkrementiert, sofern negativ, und WHDR_ENDLOOP 
Alle Angaben in Bytes, nicht Samples.

Beim erstmaligen Aufruf muss .lpNext Null sein! Ansonsten muss der
Aufrufer .lpNext in Ruhe lassen

FindTrigger fhrt niemals von selbst ein Wrap-Around aus!
Der Aufrufer muss bei .dwBytesRecorded==.dwBufferLength==.dwUser
.dwBytesRecorded und, wenn gewnscht, .dwUser auf Null setzen,
bspw. beim Rollbetrieb.
Ausnahme: .reserved==.dwBufferLength (aber das sieht nur so aus, s.u.)

Der Rollbetrieb wird vom Aufrufer realisiert, indem ausgehend von
.dwUser via .dwBufferLength bis hin zu .dwBytesRecorded ein Trace
rechtsbndig ausgegeben wird. WHDR_ENDLOOP ist zu setzen.
Ebenso muss sich der Aufrufer um das effektive Anzeigen monstrser
Datenmengen kmmern! .lpData darf auch auf eine speicher-eingeblendete
Datei zeigen. Auch an ein "mitwachsendes" .lpData wurde gedacht;
deshalb der Verbot von automatischen Wrap-Arounds.
FindTrigger schaufelt Daten nur von den Quell-Waveheadern zum
Ziel-Waveheader, das Ziel ist write-only.

Eine Reduktion der Datenmenge beim Kopieren ist vorerst nicht vorgesehen.
[Wre ein Fall fr einen 3. Funktionszeiger mit Refrenzdaten:
typedef UINT(NEAR*SampleCopy)(NPVOID,char huge*,LPSTR,UINT); ]

Der Bereich von Anfang bis .reserved wird - auch ohne Trigger -
zum "Auffangen" mglicher Pr-Trigger-Daten gebraucht,
hierzu _simuliert_ die Routine hier das Schieben der Daten;
d.h. sobald WHDR_BEGINLOOP gesetzt ist, gilt die Regel
"neue Daten bis .dwBytesRecorded" nicht mehr; dann sind die neuen
Daten 1. zwischen .dwLoops und .reserved und 2. zwischen
Anfang und .dwLoops
Der visuelle Effekt bei langsamer Abtastung ist, dass
* rechts vom Triggerkreuz die alten Sampledaten zunchst stehen bleiben,
* links vom Trigger die Samples von links nach rechts gezeichnet werden,
* beim Erreichen des Triggers NUR LINKS VOM TRIGGER ein Rollbetrieb
  einsetzt
* bei Triggerbedingung das Zeichnen nach rechts unter berschreibung
  der alten Daten fortgesetzt wird
* Ein angemessenes Hold-Off muss dafr sorgen, dass das Bild etwas
  stehen bleibt...
Bei schneller Abtastung sollte es ein Bildschirm-Update nur geben,
wenn der Puffer wirklich voll ist
(WHDR_ENDLOOP und .dwBytesRecorded==.dwBufferLength)
Nach dem Triggern sind die 3. Daten zwischen .reserved und .dwBytesRecorded

Mit dem Setzen von WHDR_ENDLOOP kann der _Aufrufer_ eine erfolglose
Triggersuche beenden (= "automatischer Trigger").

Ein negatives .reserved sorgt fr Triggerverzgerung. Wenn der Trigger
gefunden wurde (WHDR_ENDLOOP), inkrementiert FindTrigger .reserved
bis zur Null; ab dann werden Samples in den Puffer kopiert.
Bei Verwendung von Auto-Trigger sollte der Aufrufer .reserved ebenso
von negativ auf Null stellen, um unntige Verzgerung zu vermeiden.
Mehr als 100 % Prtrigger ist dagegen systembedingt nicht mglich,
simuliert hchstens ber eine 2. Zeitbasis.

Beachte: GETPROC bekommt eine "Referenz" auf einen FAR-Zeiger auf eine
WAVEHDR-Struktur! Die "Referenz" ist niemals NULL, der FAR-Zeiger schon.
Ist dieser Zeiger ungleich NULL, kann der hiermit geleerte Wave-Block
umgehend wieder verwendet werden, bspw. mittels waveInAddBuffer().
Die Funktion sollte einen neuen (teilweise oder voll gefllten)
Wave-Block-Zeiger einsetzen; ist keiner da, kann NULL eingesetzt werden,
um anzuzeigen, dass NOCH nichts da ist.
Ein gltiger WAVEHDR, der _nicht gefllt_ (.dwBytesRecorded=0)
ist, zeigt an, dass die Sampledaten zu Ende sind; FindTrigger setzt
daraufhin WHDR_DONE.
Das Bit WHDR_PREPARED wird zum Aufrufer durchgereicht.
Win16: Die Puffer des WAVEHDR der GETPROC-Routine drfen nicht huge sein.

TRIGPROC muss in den (FAR-, nicht HUGE-) Speicherblcken nach einer
Triggerbedingung suchen, als Hilfsdaten bekommt es das NPVOID
bergeben (fr die Vorgeschichte).

Win16: Beide Routinen mssen dem SMALL-Speichermodell entsprechen!
Beim Umzug in die .EXE (von DLL aufrufbar) wird's dann irgendwann MEDUIM?

Das Oszi-Programm ruft FindTrigger via Q_POLL auf.

RETURN:
Die Funktion liefert <true>, wenn neue Daten hinzugekommen sind.
Der Puffer muss aber deswegen nicht voll sein!
Bei Rckgabe von <false> darf sich der Aufrufer per WaitMessage
schlafen legen, wenn der Datenlieferant mit Interrupt arbeitet,
angezeigt mit WHDR_PREPARED. Ansonsten gibt es auer Timer keinen
Weckdienst; dann muss wieder nachgefragt werden.
<false> wird (auch) geliefert, wenn:
* der LPWAVEHDR==NULL ist
* WHDR_DONE gesetzt ist,
* .dwBytesRecorded==.dwBufferLength ist, AUSSER wenn
  .reserved==.dwBufferLength UND .dwFlags&WHDR_ENDLOOP==0 ist

Aufwand?
Die Funktion arbeitet single-threaded wegen Lauffhigkeit unter Win32s
und Win16 - und um sich Synchronisationsprobleme vom Hals zu halten.
 */

//void _fastcall DcMakeSub(long&,int);
//void _fastcall AcMakeSub(long&,int);
#define ACTIME 8	// dualer Logarithmus der Zeitkonstante in Samples?
#endif //__cplusplus
// BASISKLASSE

typedef struct{
 BYTE flags;		// Q-Flags (s. oben)
 BYTE bits;		// Gltige Bits; |maximaler Wert|=1<<(bits-1)
 BYTE numchan;		// Anzahl der Kanle
 BYTE numtrig;		// Anzahl der Trigger-Kanle (>=numchan)
 float rateminmax[2];	// Abtastrate minimal/maximal
 float ratecont;	// max. Abtastrate bei kontinulierlichem Betrieb, 0=kein
 DWORD depth;		// Speichertiefe fr Sampledaten, in Samples, 0=INF
 GETSAMPLE getsample;	// Zeiger auf GetSample-Prozedur
 UINT blockalign;	// Block-Ausrichtung in Bytes
}SYSINFO, *PSYSINFO, NEAR*NPSYSINFO, FAR*LPSYSINFO;

typedef struct{
 BYTE ch;		// Welchen Kanal betreffend? (INPUT!)
 BYTE couplings;	// DC,AC,GND;INV;R50
 BYTE byteoffset;	// zum Zugriff via GetSample: Adress-Offset
 BYTE mask;		// Bitmaske (fr Logikanalysator) fr GetSample
 float voltminmax[2];	// Minimale und maximale (absolute!) VoltProLsb
}CHANINFO, *PCHANINFO, NEAR*NPCHANINFO, FAR*LPCHANINFO;
#define CHANINFO_DC	1	// Bitmaske fr couplings
#define CHANINFO_AC	2	// (DC-Kopplung kann nicht simuliert werden!)
#define CHANINFO_GND	4
#define CHANINFO_INV	8	// nur bei _echter_ Inversion
#define CHANINFO_R50	16
#define CHANINFO_CAL	128	// Wirklich kalibriert

typedef struct{
 BYTE ch;		// Welchen Kanal betreffend?
 BYTE what;		// Was setzen? (volt,coupling,inv siehe unten)
 BYTE coupling;		// Kopplung (DC,AC,GND;INV)
 BYTE resistance;	// Eingangswiderstand (Zuschaltbarer 50-Ohm-Widerstand)
 float volt;		// Wenn negativ gegebem, dann wird "inv" gedreht
 float dcoffset;	// blicherweise vom Gert nicht untersttzt: Null
}CHAN, *PCHAN, NEAR*NPCHAN, FAR*LPCHAN;
#define CHAN_COUPLING	1	// Masken fr <what>
#define CHAN_INV	2
#define CHAN_VOLT	4
#define CHAN_DCOFFSET	8
#define CHAN_DC		0	// Werte fr <coupling>
#define CHAN_AC		1
#define CHAN_GND	2
#define CHAN_R1M	0	// Werte fr <resistance>
#define CHAN_R50	1

typedef struct{		// NUR LESEN, je nach aktueller Triggerquelle
 BYTE couplings;	// Kopplungsarten (Bitmaske DC,AC,HF,LF,TVH,TVL;PAT),
 BYTE unused;		// Richtige Kopplungen (unsimuliert)
 BYTE edges;		// Flanken (Bitmaske)
 BYTE type;		// Name, 0=normaler Kanal, 1=extern, 2=Netz
}TRIGINFO, *PTRIGINFO, NEAR*NPTRIGINFO, FAR*LPTRIGINFO;
#define TRIGINFO_DC	1	// Bitmasken fr <couplings>
#define TRIGINFO_AC	2
#define TRIGINFO_HF	4
#define TRIGINFO_LF	8
#define TRIGINFO_TVH	16
#define TRIGINFO_TVL	32
#define TRIGINFO_PAT	128
#define TRIGINFO_RISE	1	// Bitmasken fr <edges>
#define TRIGINFO_FALL	2
#define TRIGINFO_CHAN	0	// Enum fr <type>
#define TRIGINFO_EXT	1
#define TRIGINFO_LINE	2

typedef struct{
 BYTE what;		// Was setzen (source,coupling,edge,post,level,pattern)
 BYTE source;		// Triggerquelle
 BYTE coupling;		// Kopplung
 BYTE edge;		// Flankenrichtung (0=+ oder 1=-)
 long pre;		// Prtrigger in Samples, negativ=Triggerverzgerung
 union{
  int level;		// Triggerpegel (nur bei DC?)
  BYTE patternXorAnd[16];// oder Triggermuster (als Logikanalysator) 2*64 bit
 };
}TRIG, *PTRIG, NEAR*NPTRIG, FAR*LPTRIG;
#define TRIG_SOURCE	1	// Bitmasken fr <what>
#define TRIG_COUPLING	2
#define TRIG_EDGE	4
#define TRIG_PRE	8
#define TRIG_LEVEL	16
#define TRIG_PATTERN	32
#define TRIG_DC		0	// Werte fr <coupling>
#define	TRIG_AC		1
#define TRIG_HF		2
#define TRIG_LF		3
#define TRIG_TVH	4
#define TRIG_TVL	5
#define TRIG_PAT	7
#define TRIG_RISE	0	// Werte fr <edge>
#define TRIG_FALL	1

typedef float FLOAT, *PFLOAT, NEAR*NPFLOAT, FAR*LPFLOAT;

typedef struct {	// fr Setup-Dialoge
 HWND parent;		// Elternfenster
 HWND FAR*kbHand;	// entscheidend fr moduslosen Dialog
 UINT idreserved;	// wird von Datenquelle mit ID berschrieben
}DLGINFO, *PDLGINFO, NEAR*NPDLGINFO, FAR*LPDLGINFO;

typedef enum {
 Q_INIT=1,	// Initialisierung, kann Auswahldialog zeigen
 Q_DONE,
 Q_SETUPDLG,	// Einrichtungs-Dialog (allgemein)
 Q_ARM,		// scharfstellen (bspw. WaveInStart)
 Q_UNARM,	// "sichern" (bspw. WaveInReset)
// Q_TRIGGER,	// Automatischer Trigger
// Q_DATACHANGED,
 Q_POLL,	// lParam=LPWAVEHDR	(nchsten) Datenblock abholen

 Q_GETSYSINFO,	// lParam=LPSYSINFO	allgemeine Information
 Q_GETCHANINFO,	// lParam=LPCHANINFO fr angegebenen Kanal
 Q_SETCHAN,	// lParam=LPCHAN	-"-
 Q_GETTRIGINFO,	// lParam=LPTRIGINFO fr aktuellen Trigger-Kanal
 Q_SETTRIG,	// lParam=LPTRIG	Trigger setzen/ndern/abfragen
 Q_SETRATE,	// lParam=LPFLOAT	Samplerate setzen/abfragen (0 zum Lesen)
// Q_ALLOC	// GlobalAlloc() mit lParam=Samples fr <buffer>
		// Ggf. ReAlloc() - bzw. Free() fr wParam=0
}Q_MSG;

/*********************************************
 ** Ab hier wird es eigentlich Privatsache! **
 **   Knftig wird nur noch je ein	    **
 **   Funktionszeiger "herausgucken"!	    **
 *********************************************/
#include "dso.h"
#include "inout.h"

typedef struct{
 HWND hDlg;		// Setup-Dialog-Handle, solange er luft
 HWND FAR*kbHand;	// Tastatur-Handler-Zentrale fr IsDlgMessage()
 DLGPROC dlgProc;	// Dialogprozedur (fr DialogBox/CreateDialog)
 UINT helpId;		// sowohl Dialog- als auch Hilfe-ID
}SETUPDLG;

#ifdef __cplusplus
class QUELLE{
public:
 SETUPDLG sd;
 virtual bool RelayMsg(Q_MSG,LPVOID);
protected:
 BYTE trcoupling;	// (simulierte) Triggerkopplung
 BYTE state;		// Q_FULL u..
};


// ABGELEITETE KLASSEN
class Q_ZUFALL:public QUELLE {
 virtual bool RelayMsg(Q_MSG,LPVOID);
};

class Q_DSO220:public QUELLE {
 void SetDSO();
 virtual bool RelayMsg(Q_MSG,LPVOID);
 INITPARAMS ip;
public:
 LPVOID p;
 HANDLE hPortTalk;
};

class Q_SOUND:public QUELLE {
 MMRESULT WaveOpen();
 MMRESULT NearestRate(DWORD);
 void MaxChannels();
 void MaxBits();
 virtual bool RelayMsg(Q_MSG,LPVOID);
public:
 void NextWaveHdr(LPWAVEHDR FAR&whp);
 HWAVEIN handle;	// Wave-Eingabe-Handle
#ifdef WIN32
 HMIXER hMixer;
 DWORD dwLineID,dwControlID;	// Gefundener Regler
#endif
 UINT DevID;		// Wave-Eingabe-Nummer (zwecks Sampleraten-nderung)
 WAVEFORMATEX wf;	// Momentan aktive Wave-Information
 WAVEHDR wh[16];	// zugehrige Kpfe
 int currentblock;	// Momentaner Wave-Header
 DWORD MinRate,MaxRate;	// Beim Initialisieren abgefragte Grenzwerte
 float lsb_volt;	// Setup-Einstellung; ohne Balance fr beide Kanle
 BYTE coupling;		// Setup-Einstellung
 BYTE byteshift;	// 0 (8 bit) oder 1 (16 bit), zweckmiger!
 bool bekloppt;		// TRUE wenn der Treiber ohne zu murren 1MSa/s schluckt
};
#endif //__cplusplus
#endif

