#define WIN32_LEAN_AND_MEAN
#include "wutils.h"
#ifdef WIN32
HINSTANCE HInstance;	// Diese Programm-Datensegment (_DS bei Win16)
#endif
PTSTR MBoxTitle;

/******************************************************************
 ** Die langweilige Routinensammlung ("Alles was Windows fehlt") **
 ** aus WUTILS.PAS bzw. mittlerweile dem SENSOKOM-Projekt	 **
 ******************************************************************/
int  _defentry_ Limit(int x, int u, int o) {
 return x<u?u:x>o?o:x;
}

#ifdef WIN32	// da braucht man gelegentlich dies:
bool ScreenToClientS(HWND w,POINTS*ps) {
 POINT p;
 p.x=ps->x;
 p.y=ps->y;
 if (!ScreenToClient(w,&p)) return false;
 ps->x=(short)p.x; ps->y=(short)p.y; return true;
}
bool ClientToScreenS(HWND w,POINTS*ps) {
 POINT p;
 p.x=ps->x;
 p.y=ps->y;
 if (!ClientToScreen(w,&p)) return false;
 ps->x=(short)p.x; ps->y=(short)p.y; return true;
}
bool PtInRectS(PCRECT r, POINTS ps) {
 POINT p;
 p.x=ps.x;
 p.y=ps.y;
 return PtInRect(r,p);
}
#else		// dafr braucht man jene Extrawurst:
long _defentry_ LimitL(long x, long u, long o) {
 return x<u?u:x>o?o:x;
}
#endif

UINT _defentry_ InitStruct(void*buf, unsigned len) {
 ZeroMemory(buf,len);
 *(unsigned*)buf=len;
 return 0;
}

int  _defentry_ vMBox(HWND Wnd, UINT id, UINT style, va_list arglist) {
 TCHAR buf1[256],buf2[256];
 LoadString(HInstance,id,buf1,elemof(buf1));
 wvsprintf(buf2,buf1,arglist);
 return MessageBox(Wnd,buf2,MBoxTitle,style);
}

int _cdecl MBox(HWND Wnd, UINT id, UINT style,...) {
 return vMBox(Wnd,id,style,(va_list)(&style+1));
}

void _defentry_ SetEditFocus(HWND Wnd, UINT id) {
 Wnd=GetDlgItem(Wnd,id);
 SetFocus(Wnd);
 Edit_SetSel(Wnd,0,(UINT)-1);   // Message Cracker macht den Rest
}

PTSTR _defentry_ GetFileNamePtr(PTSTR s) {
 PTSTR r;
 TCHAR c;
 for (r=s;;) {
  c=*s; s=(PTSTR)CharNext(s);
  switch (c) {
   case ':':
   case '\\':
   case '/': r=s; break;
   case 0: return r;
  }
 }
}

static BYTE ShiftRect(PINT r, const int *r2) {
// Hilfsfunktion, schiebt horizontal bzw. vertikal
 int ax,dx;             // jaja, Assembler
 ax=r2[0]-r[0];         // Differenz links bzw. oben
 if (!ax) return 0;
 if (ax<0) {
  dx=r2[2]-r[2];        // Differenz rechts bzw. unten
  if (dx>=0) return 0;
  if (ax<dx) ax=dx;     // die kleinere Zahl
 }
 r[0]+=ax;
 r[2]+=ax;
 return ax<0?(BYTE)4:(BYTE)1;	// rechts=4, links=1
}

BYTE _defentry_ MoveRectIntoRect(PRECT R, PCRECT R2) {
// Falls R in R2 teilweise oder vollstndig auerhalb liegt,
// wird R verschoben und TRUE zurckgeliefert, um maximale Sichtbarkeit
// zu realisieren.
// Dient zum Hineinholen von auerhalb liegenden Fenstern in den Desktop.
 return (BYTE)(ShiftRect((PINT)&R->left,(PINT)&R2->left)
       +(ShiftRect((PINT)&R->top, (PINT)&R2->top)<<1));
}

void _defentry_ GetFullScreenRect(PRECT R) {
// Ermittelt das Rechteck fr maximierte Fenster, d.h. die Startleiste
// von Win9x bereits abgezogen, ideal fr R2 in MoveRectIntoRect
 R->left=R->top=0;
 R->right=GetSystemMetrics(SM_CXFULLSCREEN);
 R->bottom=GetSystemMetrics(SM_CYFULLSCREEN)+GetSystemMetrics(SM_CYCAPTION);
}

BYTE _defentry_ MoveRectIntoFullScreen(PRECT R) {
// die logische Kombination beider o.g. Routinen
 RECT R2;
 GetFullScreenRect(&R2);
 return MoveRectIntoRect(R,&R2);
}

static int GetMoveR(int ra,int re,int va,int ve,int ba,int be) {
// Interne Routine fr MoveRectNoIntersect()
 re-=ra;	
 if (be-ve>=re) return ve-ra;	// Verschiebung nach unten/rechts
 if (va-ba>=re) return va-re-ra;// Verschiebung nach oben/links
 return 0;
}

int _defentry_ MoveRectNoIntersect(PRECT R, PCRECT vis, PCRECT border) {
 int x;
 RECT RR;
 if (!IntersectRect(&RR,R,vis)) return 0;
 x=GetMoveR(R->top,R->bottom,vis->top,vis->bottom,border->top,border->bottom);
 if (x) {R->top+=x; R->bottom+=x; return x;}
			// Erst in zweiter Instanz nach links/rechts schieben
 x=GetMoveR(R->left,R->right,vis->left,vis->right,border->left,border->right);
 if (x) {R->left+=x, R->right+=x;} return x;
}

BOOL _defentry_ EnableDlgItem(HWND Wnd, UINT id, BOOL state) {
 return EnableWindow(GetDlgItem(Wnd,id),state);
}

int _defentry_ GetRadioCheck(HWND Wnd, UINT u, UINT o) {
 UINT i;
 for (i=u; i<=o; i++) if (IsDlgButtonChecked(Wnd,i)==1) return i-u;
 return -1;	// Nicht gefunden
}

UINT _defentry_ GetCheckboxGroup(HWND Wnd, UINT u, UINT o) {
 UINT v,m;
 for (v=0,m=1; u<=o; u++,m+=m) if (IsDlgButtonChecked(Wnd,u)==1) v|=m;
 return v;
}

void _defentry_ SetCheckboxGroup(HWND Wnd, UINT u, UINT o, UINT v) {
 for (; u<=o; u++,v>>=1) CheckDlgButton(Wnd,u,v&1);
}

void _defentry_ EnableMenuGroup(HMENU m,UINT u, UINT o, UINT mask, UINT flags) {
 for(;u<=o; u++,mask>>=1) EnableMenuItem(m,u,flags|(mask&1?MF_ENABLED:MF_GRAYED));
}

BOOL _defentry_ GetModifiedEditText(HWND w, PTSTR buf, UINT buflen) {
 if (!Edit_GetModify(w)) return FALSE;
 GetWindowText(w,buf,buflen);
 Edit_SetModify(w,FALSE);
 return TRUE;
}

BOOL _defentry_ GetModifiedEditItemText(HWND w, UINT id, PTSTR buf, UINT buflen) {
 return GetModifiedEditText(GetDlgItem(w,id),buf,buflen);
}

void _defentry_ StripAmp(PTSTR s) {	// Kaufmanns-Und wegschneiden
 PTSTR d=s;
 for (;;) {
  TCHAR c=*s++;		// lodsb
  if (c==T('&')) c=*s++;
  *d++=c;		// stosb
  if (!c) return;
 }
}

void _defentry_ InsertAmp(PTSTR s, int pos) {	// Kaufmanns-Und einfgen
// Bei negativem "pos" ausgehend vom Ende, sonst vom Anfang einfgen
// Nicht fr DBCS geeignet! (pos darf nicht auf ein Trail-Byte verweisen)
 int l=lstrlen(s);
 if (pos<0) pos+=l;
 if ((unsigned)pos>=(unsigned)l) return;	// zu weit vorn oder hinten
 s+=pos;
 MoveMemory(s+1,s,l-pos+1);	// Platz machen, Null-Terminierung mitbewegen
 *s=T('&');
}

int _defentry_ iitrafo(int x, int a, int e, int A, int E) {
//Transformation von INT zu INT (mit Rundung), kein Problem bei a=e
 e-=a;
 if (!e) return 0;
 return MulDiv(x-a,E-A,e)+A;
}

int _defentry_ bsf(UINT w) {	// Niederwertigstes Bit suchen
 register int i;
 if (!w) return -1;
 for (i=0; w&1; i++) w>>=1;
 return i;
}

int _defentry_ bsr(UINT w) {	// Hchstwertigstes Bit suchen, -1 bei w=0
 register int i;
 for (i=-1; w; i++) w>>=1;
 return i;
}

