/*********************************************************
 **   WUTILS.H - als Gegenstck zum PASCAL WUTILS.PAS   **
 *********************************************************
 * Dient 1. zur Anpassung der Unterschiede Win16<->Win32 *
 * und 2. zur Nachbildung der "fehlenden" Funktionen     *
 * haftmann#software 07/04				 *
 *
 * Die wutils.obj ist im Gegensatz zur wutils.tpw fr	 *
 * jedes Projekt neu zu erzeugen und ggf. nicht benutzte *
 * Funktionen zu entfernen (.obj ist keine .lib bei	 *
 * BorlandC); der Kode ist abhngig von Speichermodell	 *
 * und Aufrufkonvention					 */

#ifndef WUTILS_H
#define WUTILS_H

/* Erster Teil: Standard-Includes sowie Unterschiede bgeln */
#define STRICT
#define _WIN32_WINNT 0x0400
#include <windows.h>
#include <windowsx.h>	// Message-Cracker-Makros (un[ter]dokumentiert)
#include <mmsystem.h>

#define VPOINTERS(struc) typedef struc *P##struc,NEAR*NP##struc,FAR*LP##struc;
#define CPOINTERS(struc) typedef const struc *PC##struc,NEAR*NPC##struc,FAR*LPC##struc;
#define POINTERS(struc) VPOINTERS(struc) CPOINTERS(struc)

#ifdef WIN32
# if defined(UNICODE) && !defined(_UNICODE)
#  define _UNICODE	// windows.h will UNICODE, tchar.h will _UNICODE
# endif
# include <tchar.h>	// "Umschalt-Makros" _tcschr, _stscanf, _stprintf
# include <commctrl.h>
typedef LPCTSTR PCTSTR;
# define huge		// wird zu nichts
# ifndef __cplusplus
typedef enum {false,true} bool;	// gibt's nicht in C!
# endif
#else	// Win16, getestet ist's zurzeit nur mit Borland C++ 3.1
typedef int INT;
typedef char CHAR,TCHAR;
typedef void*PVOID;
typedef enum {false,true} bool;	// gibt's nicht in BC3.1!
typedef LPSTR LPTSTR;
typedef LPCSTR LPCTSTR;
typedef const CHAR *PCTSTR;
typedef UINT FAR*LPUINT;
typedef POINT POINTS;	// Point-Short
POINTERS(POINTS)
typedef struct {
 WORD	wFormatTag;
 WORD	nChannels;
 DWORD	nSamplesPerSec;
 DWORD	nAvgBytesPerSec;
 WORD	nBlockAlign;
 WORD	wBitsPerSample;
 WORD	cbSize;		// Extra-Information NACH cbSize! Meist 0
}WAVEFORMATEX;
POINTERS(WAVEFORMATEX)
# define waveInOpen(a,b,c,d,e,f) waveInOpen(a,b,(LPWAVEFORMAT)c,d,e,f)
# define GetCurrentThread() GetCurrentTask()
# include <stddef.h>
typedef wchar_t const far*LPCWSTR;
# include "commctrl.h"	// eigene Version vorziehen
# include <commdlg.h>	// Standard bei Win32
# include <ddeml.h>	// Standard bei Win32
# include <string.h>	// memset u..
# define _stdcall _cdecl
# define va_list const void far*
# define _fastcall _fastcall near
//#define min(a,b) ((a)<(b)?(a):(b))
//#define max(a,b) ((a)>(b)?(a):(b))
typedef TCHAR*PTSTR;
typedef UINT MMRESULT;
# define TEXT(x) x
# define ZeroMemory(p,l) memset(p,0,l)
# define CharNext(s) (LPTSTR)AnsiNext(s)
# define CopyMemory(d,s,l) hmemcpy(d,s,l)
# define MoveMemory(d,s,l) memmove(d,s,l)
# define GET_WM_COMMAND_CMD(w,l) HIWORD(l)
# define _tcschr strchr
# define _stscanf sscanf
# define _stprintf sprintf

# define IDC_SIZEALL IDC_SIZE
# define MAKEWORD(l,h) (((h)<<8)|(l))
# define MAKEPOINTS MAKEPOINT
# define GET_X_LPARAM(lp) (short)LOWORD(lp)
# define GET_Y_LPARAM(lp) (short)HIWORD(lp)
# define MAX_PATH 80		// fr KURZE Dateinamen!
# define IDHELP 9
# define MFT_RADIOCHECK 0x200
# define CP_WINNEUTRAL CP_WINANSI

# define VK_XBUTTON1		0x05
# define VK_XBUTTON2		0x06
# define VK_KANA		0x15
# define VK_JUNJA		0x17
# define VK_FINAL		0x18
# define VK_KANJI		0x19
# define VK_NONCONVERT		0x1D
# define VK_ACCEPT		0x1E
# define VK_MODECHANGE		0x1F
# define VK_PRINT		0x2A
# define VK_LWIN		0x5B
# define VK_RWIN		0x5C
# define VK_APPS		0x5D	// ContextKey
# define VK_SLEEP		0x5F
# define VK_LSHIFT		0xA0
# define VK_RSHIFT		0xA1
# define VK_LCONTROL		0xA2
# define VK_RCONTROL		0xA3
# define VK_LMENU		0xA4
# define VK_RMENU		0xA5
# define VK_BROWSER_BACK	0xA6
# define VK_BROWSER_FORWARD	0xA7
# define VK_BROWSER_REFRESH	0xA8
# define VK_BROWSER_STOP	0xA9
# define VK_BROWSER_SEARCH	0xAA
# define VK_BROWSER_FAVORITES	0xAB
# define VK_BROWSER_HOME	0xAC
# define VK_VOLUME_MUTE		0xAD
# define VK_VOLUME_DOWN		0xAE
# define VK_VOLUME_UP		0xAF
# define VK_MEDIA_NEXT_TRACK	0xB0
# define VK_MEDIA_PREV_TRACK	0xB1
# define VK_MEDIA_STOP		0xB2
# define VK_MEDIA_PLAY_PAUSE	0xB3
# define VK_LAUNCH_MAIL		0xB4
# define VK_LAUNCH_MEDIA_SELECT	0xB5
# define VK_LAUNCH_APP1		0xB6
# define VK_LAUNCH_APP2		0xB7

# define WM_MOUSEWHEEL		0x020A
# define MSH_MOUSEWHEEL		"MSWHEEL_ROLLMSG"
# define WHEEL_DELTA		120
# define WM_SIZING		0x0214
# define WM_MOVING		0x0216
# define WMSZ_LEFT		1
# define WMSZ_RIGHT		2
# define WMSZ_TOP		3
# define WMSZ_TOPLEFT		4
# define WMSZ_TOPRIGHT		5
# define WMSZ_BOTTOM		6
# define WMSZ_BOTTOMLEFT	7
# define WMSZ_BOTTOMRIGHT	8
# define WM_PRINT			0x0317
# define WM_PRINTCLIENT			0x0318
# define WM_NOTIFY			0x004E
# define WM_INPUTLANGCHANGEREQUEST	0x0050
# define WM_INPUTLANGCHANGE		0x0051
# define WM_TCARD			0x0052
# define WM_HELP			0x0053
# define WM_CONTEXTMENU			0x007B
# define WM_STYLECHANGING		0x007C
# define WM_STYLECHANGED		0x007D
# define WM_DISPLAYCHANGE		0x007E
# define WM_NCMOUSEHOVER		0x02A0	/*??*/
# define WM_MOUSEHOVER			0x02A1
# define WM_NCMOUSELEAVE		0x02A2	/*??*/
# define WM_MOUSELEAVE			0x02A3
# define CF_SELECTSCRIPT	0x00400000L
# define CF_NOSCRIPTSEL		0x00800000L
# define CF_NOVERTFONTS		0x01000000L
# define OFN_LONGNAMES		0x00200000L
# define INVALID_HANDLE_VALUE	((HANDLE)-1)
# define WF_WINNT		0x4000
typedef struct{
 UINT cbSize;
 int iContextType;
 int iCtrlId;
 HWND hItemHandle;
 DWORD dwContextId;
 DWORD MousePos;
}HELPINFO;
VPOINTERS(HELPINFO)
# define HELPINFO_WINDOW	1
# define HELPINFO_MENUITEM	2
#endif //WIN32

typedef VOID NEAR*NPVOID;
CPOINTERS(RECT)
CPOINTERS(POINT)
CPOINTERS(HELPINFO)

#ifdef UNICODE
# define FORMATPSTR L"%S"	// Formatier-Anweisung fr "normalen" String
# define FORMATPWSTR L"%s"	// Formatier-Anweisung fr "weiten" String
#else
# define FORMATPSTR "%s"
# define FORMATPWSTR "%S"
#endif

// Extrem wichtige ("fehlende") Makros fr Win16 UND Win32
#define T(x) TEXT(x)		// Schreibfaulheit...
#define elemof(x) (sizeof(x)/sizeof(*(x)))	// Elemente eines Arrays
#define nobreak			// expliziter Durchlauf bei switch/case

/* Zweiter Teil: "Fehlende" Funktionen nachbilden */
#ifdef __cplusplus
extern "C" {
#endif

#ifdef __BORLANDC__		// Sorgendkind BC31: bei <extern "C">
# define _defentry_ PASCAL	// schaltet er auf stets auf <cdecl> um,
#else				// aber eben nicht bei C (ohne ++):
# define _defentry_		// Kollision der Objektdateien bei C++-
#endif				// Programmierung

#ifdef WIN32
extern HINSTANCE HInstance;	// Diese Programm-Datensegment
#else
#define HInstance (HINSTANCE)_DS// Datensegmentregister bei BC und Win16
#endif				// (eigentlich nur bei SMALL und COMPACT!)

extern PTSTR MBoxTitle;

int  _defentry_ Limit(int x, int u, int o);
#ifdef WIN32
# define LimitL Limit	// dasselbe
bool ScreenToClientS(HWND w,POINTS*ps);	// Short-Punkt-Version
bool ClientToScreenS(HWND w,POINTS*ps);
bool PtInRectS(PCRECT r,POINTS p);
// Das folgende Makro expandiert wParam,lParam fr Send/PostMessage
# define CONTROLPARAMS(id,wnd,notify) MAKELONG((id),(notify)),(LPARAM)(wnd)
#else
long _defentry_ LimitL(long x, long u, long o);
# define ScreenToClientS ScreenToClient
# define ClientToScreenS ClientToScreen
# define PtInRectS PtInRect
# define CONTROLPARAMS(id,wnd,notify) (id),MAKELONG((wnd),(notify))
#endif
//Die folgenden Makros erzeugen die Argumente fr Send/PostMessage,
//am einfachsten sit CONTROLPARAMS3 zu verwenden
#define CONTROLPARAMS2(wnd,notify) CONTROLPARAMS(GetDlgCtrlID(wnd),wnd,notify)
#define CONTROLPARAMS3(msg,wnd,notify) GetParent(wnd),(msg),CONTROLPARAMS2(wnd,notify)
#define CONTROLPARAMS4(msg,id,wnd,notify) GetParent(wnd),(msg),CONTROLPARAMS(id,wnd,notify)
#define CONTROLPARAMS5(dst,msg,id,wnd,notify) (dst),(msg),CONTROLPARAMS(id,wnd,notify)
UINT _defentry_ InitStruct(void*buf, unsigned len);
int  _defentry_ vMBox(HWND Wnd, UINT id, UINT style, va_list arglist);
int  _cdecl MBox(HWND Wnd, UINT id, UINT style,...);
void _defentry_ SetEditFocus(HWND Wnd, UINT id);
PTSTR _defentry_ GetFileNamePtr(PTSTR s);
PTSTR _defentry_ GetFileNameExt(PTSTR s);
BYTE _defentry_ MoveRectIntoRect(PRECT R, PCRECT R2);
void _defentry_ GetFullScreenRect(PRECT R);
BYTE _defentry_ MoveRectIntoFullScreen(PRECT R);
int  _defentry_ MoveRectNoIntersect(PRECT R, PCRECT vis, PCRECT border);
BOOL _defentry_ EnableDlgItem(HWND Wnd, UINT id, BOOL state);
int  _defentry_ GetRadioCheck(HWND Wnd, UINT u, UINT o);
UINT _defentry_ GetCheckboxGroup(HWND Wnd, UINT u, UINT o);
void _defentry_ SetCheckboxGroup(HWND Wnd, UINT u, UINT o, UINT v);
void _defentry_ EnableMenuGroup(HMENU m,UINT u, UINT o, UINT mask, UINT flags);
BOOL _defentry_ GetModifiedEditText(HWND w, PTSTR buf, UINT buflen);
BOOL _defentry_ GetModifiedEditItemText(HWND w, UINT id, PTSTR buf, UINT buflen);
void _defentry_ StripAmp(PTSTR s);		// Kaufmanns-Und wegschneiden
void _defentry_ InsertAmp(PTSTR s, int pos);	// Kaufmanns-Und einfgen
int  _defentry_ iitrafo(int x, int a, int e, int A, int E);
int  _defentry_ bsf(UINT w);	// Niederwertigstes Bit suchen, Nummer liefern
int  _defentry_ bsr(UINT w);	// Hchstwertiges Bit suchen, -1 bei w=0
// Kodes fr MoveRectIntoRect(), MoveRectIntoFullScreen()
#define MOVERECT_LEFT	1	// nach rechts(!), weil links berhngend
#define MOVERECT_TOP	2	// nach unten(!), weil oben berhngend
#define MOVERECT_RIGHT	4	// usw.
#define MOVERECT_BOTTOM	8	// (passend zur RECT-Struktur-Komponenten)

#ifdef __cplusplus
}
#endif

#endif //WUTILS_H
