/* Jaja, eine grssliche Headerdatei!! */

extern COLORREF GridColor;
extern POINT step;		// Gitternetz-Schrittweite
extern POINT tick;
extern POINT Kaestel;
extern POINT SubTick;
extern POINT bmext;		// (nicht mehr!!) Bitmap-Gre
extern RECT Rand;		// Gitternetz-Rand (im Client-Bereich)
extern POINT Mitte;
extern COLORREF BackColor;
extern HPEN XorPen;
extern HBITMAP blt[];
extern HBITMAP NullBitmap[];
extern POINT lastmouse;	// Fadenkreuz-Position
extern HDC bltdc[];
extern HPEN BackPen;
extern HPEN GridPen;
extern HBRUSH BackBrush;
extern COLORREF AuswahlFarbe;
extern POINT ClientExt;	// auch Gre der beiden Hintergrund-Bitmaps
extern UINT DispOpt;		// Anzeige- und Gitter-Optionen (=0)
void SetDispOpt(UINT,UINT);
void Gitternetz(HDC dc);
void Fadenkreuz(HDC dc=bltdc[0]);
void MaleHinterGraf(HDC dc);
void MaleGraf(HDC dc);
void BltAlles(HDC dc);
void wmSize(int x, int y);

#define DO_LINE	 1	// PolyLine statt Punkte
#define DO_XOR	 2	// Linie/Pixel mit R2_XORPEN statt R2_COPYPEN ausgeben
#define DO_DB	 4	// DoubleBuffer
#define DO_GRID	 8	// Groe Kstchen
#define DO_TICK	16	// Kleine Marker
#define DO_CROSS 32	// Fadenkreuz
#define DO_BACK 64	// Hintergrundpinsel (stets vorhanden)
#define DO_TB	128	// Dreifach-Puffer (Alles hinter dem Kurvenzug)
#define DO_DB_INVAL	0x8000U
#define DO_TB_INVAL	0x4000U

void Inval(bool background=false, LPRECT rcitem=NULL);
void _stdcall Line(HDC dc, int x1, int, int, int);
//void PaintWinBitmap(HDC dc,int x, int y, HBITMAP bm);
void _stdcall ShowPopupMenu(HMENU, int, int);
// Aufruf TrackPopupMenu an Client-Koordinaten x und y

// Ein vollstndig verketteter Baum
struct KNOTEN;		// Vorausdeklaration
struct NODE{		// Pseudoknoten fr Wald-Wurzeln
 KNOTEN *sub;		// Erstes Kind
 inline NODE() {sub=NULL;};	// ZeroMemory-Konstruktor
};
struct KNOTEN:NODE {	// Richtiger Knoten fr Bume
 NODE *parent;		// Elter (jeder verbundene Knoten hat eins)
 KNOTEN *next;		// nchstes Geschwister (Nachfolger)
 KNOTEN *prev;		// vorheriges Geschwister (Vorgnger)
 void SetParent(NODE*);	// Als erstes Kind von <p> setzen
 void SetSibling(KNOTEN*);// Als Vorgnger von <b> setzen
 inline KNOTEN(NODE*p) {parent=NULL; SetParent(p);};
 virtual ~KNOTEN();
 virtual void Paint(HDC);	// extra fr Geschwindigkeit
 virtual bool RelayMsg(UINT,WPARAM,LPARAM);
private:
 void remove();		// Herausnehmen
};

#ifndef WIN32
typedef enum {TTM_ADDTOOL,TTM_NEWTOOLRECT,TTM_DELTOOL};
#endif

struct MINIWND:KNOTEN {
 RECT rcitem;	// in Bitmap-Koordinaten (= Client)
 LPCTSTR hint;
 UINT id;
 BYTE style;	// hmove=1,vmove=2,hsize=4,vsize=8
 BYTE state;	// Hover, Focus...
 BYTE where;	// Auf welchem Rand ist die Maus?
 POINTS drag;	// Klickposition bei WM_xBUTTONDOWN
 MINIWND(NODE*,RECT*,LPCTSTR,UINT,BYTE);
 MINIWND(NODE*);
 void Inval() {::Inval(true,&rcitem);};
 void SetState(BYTE);
 void SetState(BYTE,BYTE);	// mit AND und XOR
 void SetParent(NODE*);
 inline void Moved() {ToolMessage(TTM_NEWTOOLRECT);};
 void ToolMessage(UINT Msg);
 virtual ~MINIWND() {ToolMessage(TTM_DELTOOL);};
 void Schieb(int,int,bool);	// Fenster verschieben, ggf. Maus mitnehmen
			// Vernderung des Rechtecks oder von "Rand"
 virtual void Paint(HDC);
 virtual bool RelayMsg(UINT,WPARAM,LPARAM);
 static MINIWND* _stdcall MiniWndFromPoint(POINTS);
};

struct TOOLTIP:MINIWND {
 TCHAR hintbuf[256];
 TOOLTIP();
 virtual ~TOOLTIP();
 void _cdecl SetTip(PCRECT,LPCTSTR,...);
 virtual void Paint(HDC);
 virtual bool RelayMsg(UINT,WPARAM,LPARAM);	// fr Timer
 COLORREF TextColor;	// gleichzeitig Randfarbe
 COLORREF BackColor;	// Hintergrund frs Rundeck (?)
 HBRUSH Back;
 HPEN Pen;
 HFONT Font;
 BYTE GdiObj;
 void CreateGdiObj();
 void DeleteGdiObj();
};

struct GITTER:MINIWND {
 GITTER();
 virtual void Paint(HDC dc) {MINIWND::Paint(dc); if (DispOpt&DO_GRID) ::Gitternetz(dc);};
 virtual bool RelayMsg(UINT,WPARAM,LPARAM);	// fr ToolTip
};

//Verwaltung eines einfachen, grafischen Knopfes (Mini-Objekt)
struct MYBUTTON:MINIWND{
 typedef enum {ENGER,WEITER,TIEFER,HOEHER,EINAUS,PLAY,PAUSE} EBild;
 MYBUTTON(NODE*,RECT*,LPCTSTR,UINT,EBild);
 void SetState(BYTE);	// nicht-virtuell!! (idiotisch, jaja)
 void Enable(BOOL);
 virtual void Paint(HDC dc);
 virtual bool RelayMsg(UINT,WPARAM,LPARAM);
 EBild bild;		// Bild-Index
};
/* Irgendwie braucht man unter Windows immer wieder das gleiche Bitregister:
 * 0 - gedrckt (zu zeichnen, HOVER)
 * 1 - gesperrt (zu zeichnen, grau)
 * 2 - fokussiert (zu zeichnen, punktierte Umrandung)
 * 3 - selektiert (zu zeichnen, blau)
 * 4 - wurde gedrckt (fr HOVER)
 * 5 - Maus befindet sich ber dem Rechteck */
#define STA_PRESSED	0x01
#define STA_GRAYED	0x02
#define STA_FOCUSED	0x04
#define STA_SELECTED	0x08
#define STA_KLICKED	0x10
#define STA_HOVER	0x20

/********************************************************
 ** Klasse M_K: Basis fr Massesymbol und Triggerkreuz **
 ********************************************************/
struct M_K:MINIWND {	// Masse- oder Triggersymbol
 POINT mitte;		// (echte) Mittenposition
 BYTE aussen;	// Bits zur Markierung, dass Kreuz auerhalb ist
 void SetGdiObjekte(COLORREF);
 M_K(NODE*p):MINIWND(p) {PolygonPinsel=0;};
 virtual ~M_K() {SetGdiObjekte((COLORREF)-1);};
private:
// HPEN PfeilStift;
 HBRUSH PolygonPinsel;	// Der Stift fr den Polygonrand ist global
protected:
 void CalcRect(RECT*);	// aus Mitte Begrenzungsrechteck berechnen
 void PaintPoly(HDC,const POINT*,int);
 void Hilfspfeil(HDC);
};

struct KANAL;		// Vorausdeklaration
struct MASSE:M_K {
 KANAL *k;
 MASSE(KANAL*);
 virtual void Paint(HDC dc);
 virtual bool RelayMsg(UINT,WPARAM,LPARAM);
 void CalcRect(RECT*);
 bool Update(BYTE);		// hier: neue Y-Position (k->nulllinie)
 inline void UpdateGdiObjekte();
};

struct TRIGG;
struct KREUZ:M_K {
 TRIGG *t;
 KREUZ(TRIGG*);
 virtual void Paint(HDC dc);
 virtual bool RelayMsg(UINT,WPARAM,LPARAM);
 void CalcRect(RECT*);
 bool Update(BYTE);		// bei nderung von t->pretrig und/oder t->pegel
 inline void UpdateGdiObjekte();
};

// Ein Wald aus 3 Bumen, nur Pseudoknoten
extern NODE Anker[];
// Anker[0] = TOPMOST, Anker[1] = NORMAL, Anker[2] = HIDDEN
extern MINIWND *FocusOwner;
extern GITTER *gitter;

extern HWND MainWnd;
extern int numkanal;
extern KANAL *kanal;
#ifdef WIN32
extern HWND Tooltip;
#endif
extern TOOLTIP *tip;
extern HBITMAP WinBitmaps[];
