#define ELEN 8		// Puffergre fr Einheit
#define ELENSTR T("7")	// dito als String (fr sscanf), 1 Zeichen Luft
typedef TCHAR EINHEIT[ELEN];	// ein (ausreichender) Einheiten-Puffer

#include "resource.h"

#define SUB_XABLENK	0	// Nummer des Popup-Mens: Koeffizient
#define SUB_RATE	1	// Samplerate (durchaus nicht zusammenhngend!)
#define SUB_XFARBE	2	// Farbe der Zeitbasis
#define WAS_XABLENK	0x01	// Bitmaske fr InfoNeu() und Update()
#define WAS_RATE	0x02	// Abtastrate (nur Zeitbasis "A")
#define WAS_XANF	0x04	// Anfang der Verschiebung (brige Zeitbasen)
#define WAS_SAMPLES	0x08	// Anzahl der Abtastwerte

#define WAS_FARBE	0x40	// Farbe fr Kurvenzug, Masse- und Triggersymbol
#define WAS_ONOFF	0x80	// Ein/Ausschalten von ReadOut (Bit 0) und Kurve (Bit 7)

bool GetNameList(PCTSTR n, PTSTR buf, BYTE*bitnr);
bool FarbAuswahl(HWND,COLORREF&);
BYTE PointIntoRect(const RECT*rc, POINT*pt);
int rund(float f);


#define SUB_YVOR	1	// Nummer Popup (Vorteiler)
#define SUB_YINV	2	// Nummer des Menpunktes (hier: kein Popup)
#define SUB_YABL	3	// Nummer des Popup-Mens
#define SUB_YKOP	4	// Nummer Popup
#define SUB_YNUL	6	// kein Popup-Men hier, aber trotzdem modifizierbar!
#define SUB_YNAM	7
#define SUB_YFARBE	8

#define WAS_YNAM	0x01
#define WAS_YVOR	(1<<SUB_YVOR)
#define WAS_YINV	(1<<SUB_YINV)
#define WAS_YABL	(1<<SUB_YABL)
#define WAS_YKOP	(1<<SUB_YKOP)
#define WAS_YNUL	0x20

struct KANALANZEIGE;

struct GRUPPE{
 TCHAR name[8];
 int ref;		// Referenzzhler (Anzahl der Eingangskanle)
 bool SetVar(int,PCTSTR);
 bool GetVar(int,PTSTR);
};

struct KANAL;
typedef int (_fastcall *GETKANALSAMPLE)(KANAL*,LPSTR);

struct KANAL:GRUPPE{
 float voltprolsb;	// Aktueller Koeffizient fr ADU
 float voltoffset;	// Aktuelle Gleichspannungs-Verschiebung (meistens fest Null)
 float fTastkopf;	// >1 fr Dmpfung (bspw. 10:1), <1 fr aktiven Tastkopf
 EINHEIT einheit;	// Standardmig Volt
 TCHAR sTastkopf[16];	// als String zur bequemen Ein/Ausgabe
 TCHAR sNamen[16];	// Name:BitNr fr Zusammenfassung (Logikan.)
 WORD  praefixe;	// Erlaubte Prfixe (Standard: V .. kV)
 float nulllinie;	// in div!
 float div;		// in <einheit>/div
 float min,max;		// Minimum und Maximum fr Spannung/div (ohne Vorteiler)
 HMENU submenu;		// Zugehriger Men-Ast
 COLORREF farbe;
// UINT flags;		// "div" ungenau
// short*data;
 POINT*poly;
 int polycount,polyc2;	// kann durch Optimierung weniger sein als zeit.samples
 int kn;		// Kanalnummer (0-basiert)
 UINT idhigh;
 UINT kopplung;		// notfalls: simulierte Kopplung
 BYTE byteoffset;	// von CHANINFO-Struktur
 BYTE maske;		// von CHANINFO-Struktur
 long sub;		// Zur Simulation von AC-Kopplung
 GETKANALSAMPLE getsample;	// Routine je nach (simulierter) Kopplung


 void Konstruktor(int);	// Irgendwie geht das mit Konstruktor und Destruktor
 void Destruktor();	// grndlich in die Hose!
 bool InfoNeu(BYTE);	// neue Beschreibung frs Men und Schnellzugriff
 void DarstellungNeu();	// Neue Y-Ausdehnung (an Treiber weiterreichen)
 void MaleKurve(HDC dc);
 void CalcGraf();	// Kurvenzugpunkte aus Sampledaten berechnen
// bool RelayMsg(K_MSG,WPARAM,LPARAM);
 inline bool GetNameList(PTSTR buf, BYTE*bitnr) {return ::GetNameList(sNamen,buf,bitnr);};
 bool HatName(PCTSTR n);	// Testet, ob Name enthalten ist
 MASSE *masse;		// Massesymbol (gehrt NICHT zur Kanalanzeige!!)
 KANALANZEIGE *anzeige;
 KANAL() {masse=NULL; anzeige=NULL; poly=NULL;};
 int GetTastkopfIndex();	// Index frs Men usw.
 bool SetNamen(PCTSTR);
 bool SetTastkopf(PCTSTR);	// vom Dialog oder von .INI-Datei
	// frisst auch Inversion und Einheit
	// frisst auch Inversion, Einheit und Kopplung (Suffix =~_)
	// Erhhung auf nchsten "Rastwert" mit "++", Erniedrigung mit "--"
	// Kleine Vernderung mit "+" oder "-", mit Shift: "+?" oder "-?"
 bool SetAblenkung(PCTSTR);	// vom Dialog oder von .INI-Datei
 bool SetAblenkung(float);	// in Volt pro Div, liefert stets TRUE
 bool SetNulllinie(PCTSTR);
	// Erhhung um 1 Skalenteil mit "++", Erniedrigung mit "--"
	// Kleine Vernderung mit "+" oder "-" (fr DDE)
	// Stufung fr Gruppe mittels @ als Trennzeichen
 bool SetNulllinie(float);	// in Volt, liefert stets TRUE
 bool SetKopplung(PCTSTR);	// frisst "DC","AC","GND","R50","INV","=","~","_"
 bool SetKopplung(UINT k);	// liefert stets TRUE?
 bool SetFarbe(PCTSTR);
 bool SetFarbe(COLORREF);
// Allgemeiner Zugriff auf alle kanalbezogenen Variablen
 bool SetVar(int,PCTSTR);	// nummeriert
 bool SetVar(PCTSTR,PCTSTR);	// mit Name
 bool SetVar(HSZ,PCTSTR);	// mit DDE-Stringhandle
 bool GetVar(int,PTSTR);	// dito zum Lesen (Puffergre 32 Zeichen)
 bool GetVar(PCTSTR,PTSTR);	// Bei unterschiedlichen Gruppenmitgliedern
 bool GetVar(HSZ,PTSTR);	// ...mit angehngtem Fragezeichen
 void FarbAuswahl(HWND w) {COLORREF c=farbe; if (::FarbAuswahl(w,c)) SetFarbe(c);};
// void SetAnzeigen(BYTE,BYTE);	// Anzeigen-Status setzen ("Fokussierung")
protected:
 void LadeAblenkListe();	// Neues Men erzeugen und einhngen
 void LadeVorgabe();		// Laden von .INI-Datei oder Registry
 bool RetteVorgabe();		// Speichern in .INI-Datei
 void GetInfoString(PTSTR);	// ASCII-Kurzbeschreibung frs Men
};



struct TRIGGERANZEIGE;
struct TRIGG{
 TCHAR name[8];
 HMENU submenu;
 KREUZ *kreuz;
 KANAL *k;		// zeigt auf die jeweilige Quelle
 TRIGGERANZEIGE *anzeige;
 TRIGG() {kreuz=NULL; k=NULL; anzeige=NULL;};
 enum MODUS{TM_AUTO,TM_NORMAL,TM_SINGLE} modus;
// BUG: Eigentlich ist MODUS ein Bitfeld, bestehend aus:
// * AutoTrigger (Gegenteil: Normal), * AutoArm (Gegenteil: Single),
// * Run (Gegenteil Stop)
// Und im Fall von AutoArm braucht man noch eine "Triggerblindheit" (hold-off),
// die aber nur bei synchroner Datenquelle sinnvoll umsetzbar ist.
 int quelle;		// Kanal (oder extern)
 float pegel;		// in div!
 int pretrig;		// zurzeit in Prozent
 enum FLANKE{TF_STEIG,TF_FALL} flanke;
 enum KOPPLUNG{TK_DC, TK_AC, TK_LF, TK_HF, TK_TVH, TK_TVL, TK_PAT=7} kopplung;
 COLORREF farbe;
 void Konstruktor(int);	// Irgendwie geht das mit Konstruktor und Destruktor
 void Destruktor();	// grndlich in die Hose!
 bool SetModus(PCTSTR);		// frisst Strings und auch Zahlen (0..2)
 bool SetModus(enum MODUS);
 bool SetQuelle(PCTSTR);	// frisst Strings und auch Zahlen (0..?)
 bool SetQuelle(int);
 bool SetPegel(PCTSTR);
 bool SetPegel(float);
 bool SetPretrig(PCTSTR);
 bool SetPretrig(int);
 bool SetFlanke(PCTSTR);	// frisst Strings und auch Zahlen (0 und 1)
 bool SetFlanke(enum FLANKE);
 bool SetKopplung(PCTSTR);	// frisst Strings und auch Zahlen (0..7)
 bool SetKopplung(enum KOPPLUNG);
 bool SetFarbe(PCTSTR);		// Farbe und auch Position sind...
 bool SetFarbe(COLORREF);	// Eigenschaft von ANZEIGE!
// Allgemeiner Zugriff auf alle triggerbezogenen Variablen
 bool SetVar(int,PCTSTR);	// nummeriert
 bool SetVar(PCTSTR,PCTSTR);	// mit Name
 bool SetVar(HSZ,PCTSTR);	// mit DDE-Stringhandle
 bool GetVar(int,PTSTR);	// dito zum Lesen (Puffergre 32 Zeichen)
 bool GetVar(PCTSTR,PTSTR);
 bool GetVar(HSZ,PTSTR);
 void FarbAuswahl(HWND w) {COLORREF c=farbe; if (::FarbAuswahl(w,c)) SetFarbe(c);};
protected:
 void LadeVorgabe();		// Laden von .INI-Datei oder Registry
 bool RetteVorgabe();		// Speichern in .INI-Datei
 void LadeQuelleMenu();		// Men auffllen beim Konstruktor
 bool InfoNeu(BYTE);		// Men, Anzeige, DDE, Kreuz aktualisieren
};
#define SUB_TMODUS	0	// Untermen-Indizes
#define SUB_TQUELLE	1
#define SUB_TFLANKE	2
#define SUB_TKOPPLUNG	3
#define SUB_TPEGEL	4	// kein Untermen, nur fr Update();
#define SUB_TPRETRIG	5	// Untermen mit ein paar fixen Werten??
#define SUB_TFARBE	6

#define WAS_TMODUS	(1<<SUB_TMODUS)
#define WAS_TQUELLE	(1<<SUB_TQUELLE)
#define WAS_TFLANKE	(1<<SUB_TFLANKE)
#define WAS_TKOPPLUNG	(1<<SUB_TKOPPLUNG)
#define WAS_TPEGEL	(1<<SUB_TPEGEL)
#define WAS_TPRETRIG	(1<<SUB_TPRETRIG)


struct ZEITANZEIGE;
struct ZEIT{
 TCHAR name[8];		// "A" oder "B" (oder weitere Zeitbasen)
 float div;		// wird angezeigt bei YT-Betrieb
 float min,max;		// Sinnvolle Minima und Maxima fr Zeit/div
 union {
  float rate;		// NUR 1. Zeitbasis!
  float anfang;	// Jede andere Zeitbasis hat einen "Anfang" in die 1. Zeitbasis
 };
 float minrate,maxrate;	// NUR 1. Zeitbasis!
 DWORD samples;
// UINT flags;		// Bit 0: "div" ungenau
 UINT kn,idhigh;	// Nummer, 0=Zeitbasis A
 HMENU submenu;
 COLORREF farbe;
 ZEITANZEIGE *anzeige;
 ZEIT() {anzeige=NULL;};
 void Konstruktor(int);	// Irgendwie geht das mit C++-Konstruktor und Destruktor
 void Destruktor();	// grndlich in die Hose!
// void LadeXAblenkString(PTSTR);
 bool SetAblenkung(PCTSTR);	// vom Dialog oder von .INI-Datei
 bool SetAblenkung(float);	// in Sekunden pro Div
 bool SetRate(PCTSTR);		// Samplerate setzen (nur fr 1. Zeitbasis!)
 bool SetRate(float);
 bool SetAnfang(PCTSTR);	// Anfang setzen (nur fr sonstige Zeitbasen)
 bool SetAnfang(float);
 bool SetSamples(PCTSTR);
 bool SetSamples(DWORD);
 bool SetFarbe(PCTSTR);
 bool SetFarbe(COLORREF);
 bool SetVar(int,PCTSTR);	// nummeriert
 bool SetVar(PCTSTR,PCTSTR);	// mit Name
 bool SetVar(HSZ,PCTSTR);	// mit DDE-Stringhandle
 bool GetVar(int,PTSTR);	// dito zum Lesen (Puffergre 32 Zeichen)
 bool GetVar(PCTSTR,PTSTR);
 bool GetVar(HSZ,PTSTR);
 void FarbAuswahl(HWND w) {COLORREF c=farbe; if (::FarbAuswahl(w,c)) SetFarbe(c);};
protected:
 void LadeAblenkListe();	// Popup-Men laden
 void LadeRateListe();
 void LadeListenVonRateMinMax();
 void LadeVorgabe();
 bool RetteVorgabe();
 bool InfoNeu(BYTE);
};
//#define OF_VAR	0x01	// "Variable" Einstellung
//#define OF_INV	0x02	// Invertierte Darstellung
//#define OF_XY	0x04	// XY-Betrieb (nur fr "Zeitbasis" -> "Abtastrate")

/**********************************************************
 ** Anzeigen: Basisklasse, Kanal, Zeit, Trigger, Messung **
 **********************************************************/

struct ANZEIGE:MINIWND{
 MYBUTTON *nagel;	// Pin zum Verschieben, Ein/Ausschalten und als Systemmen
 int grenzen[5];	// von string1 und Font abhngige Mausklick-Bereiche
 BYTE hitkode;		// Worber die Maus gerade schwebt...
 TCHAR string1[32],string2[32];
 MYBUTTON *knopf[2];	// Bis zu 2 Knpfe (rauf, runter)
 ANZEIGE();
 virtual ~ANZEIGE() {delete nagel;};
 virtual void Paint(HDC);
 virtual bool RelayMsg(UINT,WPARAM,LPARAM);
// virtual void PAS Update(BYTE);
 void setTextColor(HDC,COLORREF);
};
// Hit-Kodes
#define HK_PRI	0x40	// Primrer Textbereich (bspw. Zeitbasis)
#define HK_SEC	0x80	// Sekundrer Textbereich (bspw. Samplerate)
#define HK_SYS	0xC0	// obere beide Bits gesetzt: System-Men-Feld
#define HK_BUT0	0xC1	// Erster Knopf
#define HK_BUT1	0xC2	// Zweiter Knopf usw.

struct KANALANZEIGE:ANZEIGE{
 KANAL *k;		// Rckwrts-Link
 MINIWND *kurve;	// zur Darstellung der Pixel, zum Anklicken knnen...
 KANALANZEIGE(KANAL*k);
 ~KANALANZEIGE() {delete knopf[1];delete knopf[0];};
 void SetKnopfRect(RECT*,int);
 virtual void Paint(HDC);
 virtual bool RelayMsg(UINT,WPARAM,LPARAM);
 void Update(BYTE);
};

struct ZEITANZEIGE:ANZEIGE{
 ZEIT *z;		// zugehrige Zeitbasis
 ZEITANZEIGE(ZEIT*);
 virtual ~ZEITANZEIGE() {delete knopf[1];delete knopf[0];};
 virtual void Paint(HDC);
 virtual bool RelayMsg(UINT,WPARAM,LPARAM);
 void Update(BYTE);
};

struct TRIGGERANZEIGE:ANZEIGE{
 TRIGG *t;		// zugehriger Trigger (vorerst nur einer!)
 TRIGGERANZEIGE(TRIGG*);	// string1 etwa: "+Y1: 4 V DC", Nr.2 = "PT 25%"
 virtual ~TRIGGERANZEIGE() {delete knopf[0];};
 virtual void Paint(HDC);
 virtual bool RelayMsg(UINT,WPARAM,LPARAM);
 void Update(BYTE);
};

