/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class blue_car
extends MIDlet
implements CommandListener {
    public Display display;
    public Form discoveryForm;
    public Form readyToConnectForm;
    public ImageItem mainImageItem;
    public Image mainImage;
    public Image bt_logo;
    public TextField addressTextField;
    public TextField subjectTextField;
    public TextField messageTextField;
    public Command selectCommand;
    public Command exitCommand;
    public Command connectCommand;
    public List devicesList;
    public Thread btUtility;
    public String btConnectionURL;
    public boolean sendData = false;
    public byte[] outSerial = new byte[]{0};
    private KeyCodeCanvas canvas;
    public String serialView_out = "0";
    public String buttonID = "_";
    public String HDLED = "Head Lights OFF";
    public String BRKLED = "Brake Lights OFF";

    public blue_car() {
        this.display = Display.getDisplay((MIDlet)this);
        this.discoveryForm = new Form("Blue Car Remote");
        try {
            this.mainImage = Image.createImage((String)"/btcar.png");
            this.bt_logo = Image.createImage((String)"/btlogo.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mainImageItem = new ImageItem("R/C Car Remote over Bluetooth", this.mainImage, 3, "");
        this.discoveryForm.append((Item)this.mainImageItem);
        this.btUtility = new BTUtility();
        this.exitCommand = new Command("Exit", 7, 1);
        this.discoveryForm.addCommand(this.exitCommand);
        this.discoveryForm.setCommandListener((CommandListener)this);
        this.devicesList = new List("Select Bluetooth-enabled Car", 3, new String[0], new Image[0]);
        this.selectCommand = new Command("Select", 8, 1);
        this.devicesList.addCommand(this.selectCommand);
        this.devicesList.addCommand(this.exitCommand);
        this.devicesList.setCommandListener((CommandListener)this);
        this.devicesList.setSelectedFlags(new boolean[0]);
        this.readyToConnectForm = new Form("Ready to Connect");
        this.readyToConnectForm.append("The selected Bluetooth device is ready to connect.");
        this.connectCommand = new Command("Connect", 8, 1);
        this.readyToConnectForm.addCommand(this.connectCommand);
        this.readyToConnectForm.addCommand(this.exitCommand);
        this.readyToConnectForm.setCommandListener((CommandListener)this);
        this.canvas = new KeyCodeCanvas();
        this.canvas.addCommand(this.exitCommand);
        this.canvas.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable d) {
        if (command == this.selectCommand) {
            this.btUtility.start();
        }
        if (command == this.exitCommand) {
            this.sendData = false;
            this.destroyApp(true);
        }
        if (command == this.connectCommand) {
            COMMReader commReaderThread = new COMMReader();
            commReaderThread.start();
            this.display.setCurrent((Displayable)this.canvas);
        }
    }

    public void startApp() {
        this.display.setCurrent((Displayable)this.discoveryForm);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean b) {
        this.notifyDestroyed();
    }

    class KeyCodeCanvas
    extends Canvas {
        byte star_stat = 0;
        byte zero_stat = 0;
        byte square_stat = 0;

        protected void paint(Graphics g) {
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(0, 0, 255);
            g.setFont(Font.getFont((int)64, (int)0, (int)16));
            g.drawString(blue_car.this.serialView_out, 165, 65, 72);
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, 85, this.getHeight());
            g.setColor(0, 0, 0);
            g.setFont(Font.getFont((int)64, (int)1, (int)16));
            g.drawString("Serial I/O:", this.getWidth() / 2, 25, 65);
            g.setFont(Font.getFont((int)64, (int)4, (int)16));
            g.drawString("Output:", 15, 65, 68);
            g.setColor(0, 0, 0);
            g.setFont(Font.getFont((int)64, (int)0, (int)0));
            g.drawString(blue_car.this.buttonID, this.getWidth() / 2, 105, 65);
            g.setFont(Font.getFont((int)64, (int)0, (int)16));
            g.drawString(blue_car.this.HDLED, 20, 135, 68);
            g.drawString(blue_car.this.BRKLED, 20, 155, 68);
        }

        protected void keyPressed(int keyCode) {
            switch (keyCode) {
                case 50: {
                    blue_car.this.outSerial[0] = (byte)(blue_car.this.outSerial[0] | 0x10);
                    blue_car.this.buttonID = "UP";
                    break;
                }
                case 53: {
                    blue_car.this.outSerial[0] = (byte)(blue_car.this.outSerial[0] | 0x20);
                    blue_car.this.buttonID = "DOWN";
                    break;
                }
                case 52: {
                    blue_car.this.outSerial[0] = (byte)(blue_car.this.outSerial[0] | 4);
                    blue_car.this.buttonID = "LEFT";
                    break;
                }
                case 54: {
                    blue_car.this.outSerial[0] = (byte)(blue_car.this.outSerial[0] | 8);
                    blue_car.this.buttonID = "RIGHT";
                    break;
                }
                case 42: {
                    if (this.star_stat == 0) {
                        blue_car.this.outSerial[0] = (byte)(blue_car.this.outSerial[0] | 0x80);
                        this.star_stat = 1;
                        blue_car.this.HDLED = "Head Lights ON";
                    } else {
                        blue_car.this.outSerial[0] = (byte)(blue_car.this.outSerial[0] & 0x7C);
                        this.star_stat = 0;
                        blue_car.this.HDLED = "Head Lights OFF";
                    }
                    blue_car.this.buttonID = "STAR";
                    break;
                }
                case 35: {
                    if (this.square_stat == 0) {
                        blue_car.this.outSerial[0] = (byte)(blue_car.this.outSerial[0] | 0x40);
                        this.square_stat = 1;
                        blue_car.this.BRKLED = "Brake Lights ON";
                    } else {
                        blue_car.this.outSerial[0] = (byte)(blue_car.this.outSerial[0] & 0xBC);
                        this.square_stat = 0;
                        blue_car.this.BRKLED = "Brake Lights OFF";
                    }
                    blue_car.this.buttonID = "SQUARE";
                    break;
                }
                default: {
                    blue_car.this.buttonID = "Invalid";
                }
            }
            blue_car.this.canvas.repaint();
        }

        protected void keyReleased(int keyCode) {
            switch (keyCode) {
                case 50: {
                    blue_car.this.outSerial[0] = (byte)(blue_car.this.outSerial[0] & 0xEC);
                    blue_car.this.buttonID = " ";
                    break;
                }
                case 53: {
                    blue_car.this.outSerial[0] = (byte)(blue_car.this.outSerial[0] & 0xDC);
                    blue_car.this.buttonID = " ";
                    break;
                }
                case 52: {
                    blue_car.this.outSerial[0] = (byte)(blue_car.this.outSerial[0] & 0xF8);
                    blue_car.this.buttonID = " ";
                    break;
                }
                case 54: {
                    blue_car.this.outSerial[0] = (byte)(blue_car.this.outSerial[0] & 0xF4);
                    blue_car.this.buttonID = " ";
                    break;
                }
                default: {
                    blue_car.this.buttonID = " ";
                }
            }
            blue_car.this.canvas.repaint();
        }
    }

    class COMMReader
    extends Thread {
        public void run() {
            try {
                StreamConnection connection = (StreamConnection)Connector.open((String)blue_car.this.btConnectionURL);
                OutputStream out = connection.openOutputStream();
                byte temp = 0;
                blue_car.this.sendData = true;
                while (blue_car.this.sendData) {
                    if (blue_car.this.outSerial[0] != temp) {
                        temp = blue_car.this.outSerial[0];
                        out.write(blue_car.this.outSerial[0]);
                        blue_car.this.serialView_out = Integer.toBinaryString(blue_car.this.outSerial[0]);
                    }
                    blue_car.this.canvas.repaint();
                }
                connection.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    class BTUtility
    extends Thread
    implements DiscoveryListener {
        Vector remoteDevices = new Vector();
        Vector deviceNames = new Vector();
        DiscoveryAgent discoveryAgent;

        public BTUtility() {
            try {
                LocalDevice localDevice = LocalDevice.getLocalDevice();
                this.discoveryAgent = localDevice.getDiscoveryAgent();
                blue_car.this.discoveryForm.append("Searching for Bluetooth devices in the vicinity...");
                this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
            }
            catch (BluetoothStateException e) {
                blue_car.this.discoveryForm.append("Failed to iniate bluetooth module.");
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass cod) {
            try {
                blue_car.this.discoveryForm.append("\nfound: " + remoteDevice.getFriendlyName(true));
            }
            catch (Exception e) {
                e.printStackTrace();
                blue_car.this.discoveryForm.append("\nfound: " + remoteDevice.getBluetoothAddress());
            }
            finally {
                this.remoteDevices.addElement(remoteDevice);
            }
        }

        public void inquiryCompleted(int discType) {
            if (this.remoteDevices.size() > 0) {
                for (int i = 0; i < this.remoteDevices.size(); ++i) {
                    try {
                        blue_car.this.devicesList.append(((RemoteDevice)this.remoteDevices.elementAt(i)).getFriendlyName(true), blue_car.this.bt_logo);
                        continue;
                    }
                    catch (Exception e) {
                        blue_car.this.devicesList.append(((RemoteDevice)this.remoteDevices.elementAt(i)).getBluetoothAddress(), blue_car.this.bt_logo);
                    }
                }
                blue_car.this.display.setCurrent((Displayable)blue_car.this.devicesList);
            } else {
                blue_car.this.discoveryForm.append("\nNo Devices Found.");
            }
        }

        public void run() {
            try {
                RemoteDevice remoteDevice = (RemoteDevice)this.remoteDevices.elementAt(blue_car.this.devicesList.getSelectedIndex());
                blue_car.this.btConnectionURL = "btspp://" + remoteDevice.getBluetoothAddress() + ":1;authenticate=false;encrypt=false;master=false";
                blue_car.this.display.setCurrent((Displayable)blue_car.this.readyToConnectForm);
                blue_car.this.readyToConnectForm.append("\n\nThe Bluetooth connection address is: " + remoteDevice.getBluetoothAddress());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        }

        public void serviceSearchCompleted(int transID, int respCode) {
        }
    }
}

