/*
;==========================================================================
; File name: klq_demo.c
;==========================================================================

; C Source code for the Keeloq decryption algorithm

;==========================================================================
; Copyright Notice
;==========================================================================

; (C) Microchip Technology Inc.
; Microchip Technology Inc. retains copyright of this source code.  The 
; code is distributed to authorised system developers using Keeloq (R)
; code hopping products.  The decryption algorithm is regarded as a trade
; secret and may only be used with the written consent of Microchip 
; Technology Inc.

;==========================================================================
; Disclaimer
;==========================================================================

;  The information contained in this Application Note is for suggestion 
;  only.  It is your responsibility to ensure that your application meets 
;  with your specifications.  No representation or warranty is given and 
;  no liability is assumed by Microchip Technology Incorporated with 
;  respect to the accuracy or use of such information or infringement of 
;  patents or other intellectual property arising from such use or 
;  otherwise.

;==========================================================================
; Revision History
;==========================================================================

; 1.1 First release Jan van Niekerk Sept 94

;==========================================================================
*/

#define revision "1.1"

#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <stdlib.h>

/* create a byte data type */

typedef unsigned char byte;
typedef unsigned int word;

/* function definitions */

void display_shfreg	(void); /* to display 32-bit data */
void display_keyreg	(void); /* to display 64-bit key */
void load_key		(void); /* to initialise secret 64-bit key */

byte ggetbit 		(byte *s, byte n); /* returns a bit's value */
void ssetbit 		(byte *s, byte n); /* sets a single bit */
void lright_shift_carry 	(byte *s); /* right shift through carry */

void decrypt		(void); /* to decrypt 32-bit data */
void lleft_shift_carry 	(byte *s); /* left shift through carry */

/* global variables */

byte keyreg[8]; /* 64-bit secret decryption key */
byte shfreg[4]; /* 32-bit data */
byte carry;     /* used as a carry bit */
char ch=0;
word n;
FILE *fl1,*fl2,*fl3;
unsigned long val;

/* defines */

#define left_shift_carry(x)  lleft_shift_carry(&(x)) /* inserts the & */
#define right_shift_carry(x)  lright_shift_carry(&(x)) /* inserts the & */
#define setbit(x,y)  ssetbit(&(x),y)        /* inserts the & operator */
#define getbit(x,y)  ggetbit(&(x),y)        /* inserts the & operator */
#define ifbit(x,y)   if (ggetbit(&(x),y))   /* bit test using getbit */
#define XOR ^				    /* for those */

/**/
/* main: demonstrates decryption
/**/

void main()

{
  word  i;
  clrscr();
  fl2=fopen("dec.txt","wt");
  load_key(); /* load the secret 64-bit decryption key */
  do
  {
    printf("Keeloq  Demo\n");
    printf("============\n\n");
    printf("Current key = ");
    display_keyreg();
    printf("\nD. Decrypt\n");
    printf("K. Change key\n\n");
    printf("ESC to quit\n");
    ch=toupper(getch());
    switch (ch)
    {
      case 'K' :  printf("Enter most significant 32 bits of key in hex  : ");
	                scanf("%lX",&val);
  	              keyreg[7]=(byte)(val>>24);
  	              keyreg[6]=(byte)(val>>16);
  	              keyreg[5]=(byte)(val>>8);
                  keyreg[4]=(byte)(val>>0);
                  printf("Enter least significant 32 bits of key in hex : ");
	                scanf("%lX",&val);
  	              keyreg[3]=(byte)(val>>24);
  	              keyreg[2]=(byte)(val>>16);
  	              keyreg[1]=(byte)(val>>8);
                  keyreg[0]=(byte)(val>>0);
                  break;
      case 'D' :  printf("Enter encrypted 32 bit hex value : ");
	                scanf("%lX",&val);
  	              shfreg[3]=(byte)(val>>24);
  	              shfreg[2]=(byte)(val>>16);
  	              shfreg[1]=(byte)(val>>8);
                  shfreg[0]=(byte)(val>>0);
      	          display_shfreg(); printf("=>");
      	          decrypt();
	                display_shfreg();
	                printf("\n\n");
                  break;
    }
  }
  while (ch!=27);
  fcloseall();
}


/**/
/* ggetbit: get the n-th bit in a byte
/**/

byte ggetbit(byte *s, byte n)

{
  return (*s & (((byte)1)<<n)) ? (byte)1 : (byte)0 ;
}

/**/
/* ssetbit: sets the n-th bit in a byte
/**/

void ssetbit(byte *s, byte n)

{
  *s|=(((byte)1)<<n);
}

/**/
/* right_shift_carry: right "rotate" through carry
/**/

void lright_shift_carry(byte *s)

{
  byte temp;
  temp = getbit(*s,0); /* grab the rightmost bit */
  *s >>= 1; /* shift 1 right */
  *s |= carry<<7; /* move the carry into leftmost */
  carry = temp; /* carry now becomes the bit that shifted out */
}

/**/
/* load_key: load a key into the key register
/**/

void load_key(void)

{
  /* the secret key is 2f197b2e cd1f92c9 Hex */
  keyreg[7] = 0x2f;
  keyreg[6] = 0x19;
  keyreg[5] = 0x7b;
  keyreg[4] = 0x2e;
  keyreg[3] = 0xcd;
  keyreg[2] = 0x1f;
  keyreg[1] = 0x92;
  keyreg[0] = 0xc9;
}

/**/
/* display_shfreg: display the data shift register
/**/

void display_shfreg(void)
{
  printf(" ");
  printf("%02X",shfreg[3]&0xff);
  printf("%02X",shfreg[2]&0xff);
  printf("%02X",shfreg[1]&0xff);
  printf("%02X  ",shfreg[0]&0xff);
}

/**/
/* display_keyreg: display the data shift register
/**/

void display_keyreg(void)
{
  printf("%02X", keyreg[7]&0xff);
  printf("%02X", keyreg[6]&0xff);
  printf("%02X", keyreg[5]&0xff);
  printf("%02X ", keyreg[4]&0xff);
  printf("%02X", keyreg[3]&0xff);
  printf("%02X", keyreg[2]&0xff);
  printf("%02X", keyreg[1]&0xff);
  printf("%02X", keyreg[0]&0xff);
}

/**/
/* decrypt: 32-bit decryption
/**/

void decrypt(void)

{

  byte index;
  int count;

  byte table[32] = /* a lookup table */
  { 0,1,1,1,0,1,0,0,0,0,1,0,1,1,1,0,0,0,1,1,1,0,1,0,0,1,0,1,1,1,0,0 };


  for(count=0; count < (528+48); count++)
  {

    if (count>=528) goto rotate_key; /* last 48 rotates restore the key */

    fprintf(fl2,"%04d ",count);
    fprintf(fl2,"%02X",shfreg[3]&0xff);
    fprintf(fl2,"%02X",shfreg[2]&0xff);
    fprintf(fl2,"%02X",shfreg[1]&0xff);
    fprintf(fl2,"%02X\n",shfreg[0]&0xff);

    index = 0;
    ifbit (shfreg[0],0) setbit(index,0);
    ifbit (shfreg[1],0) setbit(index,1);
    ifbit (shfreg[2],3) setbit(index,2);
    ifbit (shfreg[3],1) setbit(index,3);
    ifbit (shfreg[3],6) setbit(index,4); /* prepare for lookup table */

    carry =  getbit(shfreg[1],7)  XOR  getbit(shfreg[3],7)  XOR
	     getbit(keyreg[1],7)  XOR  table[index];

    left_shift_carry(shfreg[0]); /* shift in the new bit */
    left_shift_carry(shfreg[1]);
    left_shift_carry(shfreg[2]);
    left_shift_carry(shfreg[3]);

rotate_key:

    carry = getbit(keyreg[7],7); /* get the leftmost key bit */
    left_shift_carry(keyreg[0]);
    left_shift_carry(keyreg[1]);
    left_shift_carry(keyreg[2]);
    left_shift_carry(keyreg[3]);
    left_shift_carry(keyreg[4]);
    left_shift_carry(keyreg[5]);
    left_shift_carry(keyreg[6]);
    left_shift_carry(keyreg[7]); /* left-rotate the 64-bit key */

    /* the key is rotated 576 times, which is a multiple of 64 */
    /* the key therefore remains unchanged */

  }

    fprintf(fl2,"0528 ");
    fprintf(fl2,"%02X",shfreg[3]&0xff);
    fprintf(fl2,"%02X",shfreg[2]&0xff);
    fprintf(fl2,"%02X",shfreg[1]&0xff);
    fprintf(fl2,"%02X\n",shfreg[0]&0xff);

}

/**/
/* left_shift_carry: left "rotate" through carry
/**/

void lleft_shift_carry(byte *s)

{
  byte temp;
  temp = getbit(*s,7); /* grab the leftmost bit */
  *s <<= 1; /* shift 1 left */
  *s |= carry; /* move the carry into rightmost */
  carry = temp; /* carry now becomes the bit that shifted out */
}


/**/
/* end of file klq_demo.c
/**/
