
#include <avr/io.h>
#include <util/delay.h>
#include "DSOneWire.h"

static unsigned char DS_BIT;

static inline void
SET_DS_PIN(unsigned char PinNo)
{
	DS_BIT=1<<PinNo;
}

static inline void
RELEASE_THE_BUS ()
{
  DS_DDR |= DS_BIT;//output
  DS_PORT |= DS_BIT;//set 1
}

static inline void
DQ_LOW ()
{
  DS_DDR |= DS_BIT;//output
  DS_PORT &= ~DS_BIT;//set 0
}

static inline unsigned char
SAMPLE_THE_BIT_VALUE ()
{
  DS_DDR &= ~DS_BIT;//input
  DS_PORT|= DS_BIT;//

  if ((DS_PIN & DS_BIT))//read input
    {
      return 1;
    }
  return 0;
}

//-----------------------------------------------------------------------------
// Generate a 1-Wire reset, return "non zero value" if no detect was found,
// return 0 otherwise.
//
unsigned char
DSTouchReset (void)
{
  unsigned char result;

  DQ_LOW ();			// Drives DQ low
  _delay_us(455);         //480us
  _delay_us (25);

  RELEASE_THE_BUS ();		// Releases the bus - adott biten bemenet
  _delay_us (65);
  _delay_us (5);

  result = SAMPLE_THE_BIT_VALUE ();	// Sample for presence pulse from slave - 0 = device(s) present, 1 = no device present
  
  _delay_us (390);                   //410us
  		                     // Complete the reset sequence recovery
  _delay_us (20);

  return result;		    // Return sample presence pulse result
}
unsigned char
DSReadBit (void)
{

  unsigned char Dbit;
  // Change direction of data_pin to output
  DQ_LOW ();			// Drives DQ low
  // 6us delay
  _delay_us (6);
  RELEASE_THE_BUS ();		// Releases the bus
  // 9us delay
  _delay_us (9);

  Dbit = SAMPLE_THE_BIT_VALUE ();	// Sample the bit value from the slave   

  //55us delay
  _delay_us (55);

  return Dbit;
}


void
DSWriteBit (unsigned char Dbit)
{

  if (Dbit == 1)
    {
      // Write '1' bit

      // Change direction of data_pin to output

      DQ_LOW ();		// Drives DQ low

      // 6us delay
      _delay_us (6);

      RELEASE_THE_BUS ();	// Releases the bus

      //64us delay
      _delay_us (64);
    }
  else
    {
      // Write '0' bit

      DQ_LOW ();		// Drives DQ low

      _delay_us (60);		//60us delay

      RELEASE_THE_BUS ();	// Releases the bus      
      _delay_us (10);		//!Complete the time slot and 10us recovery 
    }
}


unsigned char
DSReadByte (void)
{
  unsigned char Dbyte = 0;			//intiallize byte variable
  unsigned char i = 8;

  do
    {
      Dbyte >>= 1;		// shift the result to get it ready for the next bit      
      if (DSReadBit () == 1)	// if result is one, then set MS bit     
	Dbyte |= 0x80;
    }
  while (--i);

  return Dbyte;
}

unsigned int
DSReadByte9 (void)
{
  unsigned int Dbyte = 0;			//intiallize byte variable
  unsigned char i = 9;

  do
    {
      Dbyte >>= 1;		// shift the result to get it ready for the next bit      
      if (DSReadBit () == 1)	// if result is one, then set MS bit     
	Dbyte |= 0x8000;
    }
  while (--i);
	
	Dbyte >>= 7;
  return Dbyte;
}



void
DSWriteByte (unsigned char Dbyte)
{
  unsigned char i = 8;
  do
    {
      DSWriteBit (Dbyte & 0x01);
      Dbyte >>= 1;		// shift the data byte for the next bit
    }
  while (--i);
}

void DSInitPin (unsigned char PinNo)
{
	SET_DS_PIN(PinNo);
	RELEASE_THE_BUS ();	
}
void
DSStartQueryT (unsigned char PinNo)
{

	SET_DS_PIN(PinNo);
 	DSTouchReset ();
	
  	DSWriteByte (0xEE);		// Start Convert
  	RELEASE_THE_BUS ();		// Releases the bus
	_delay_us (20);

}
void
DSStopQueryT (unsigned char PinNo)
{

	SET_DS_PIN(PinNo);
 	DSTouchReset ();
	
  	DSWriteByte (0x22);		// Stop Convert
  	RELEASE_THE_BUS ();		// Releases the bus
	_delay_us (20);

}

unsigned char
DSQueryT (unsigned char PinNo)
{
	unsigned char Temp;

	SET_DS_PIN(PinNo);

 	DSTouchReset ();
  
  	DSWriteByte (0xAA);		// READ TEMPERATURE 

    Temp=DSReadByte (); //Respons

  	RELEASE_THE_BUS ();		// Releases the bus
	_delay_us (20);

	return Temp;
}
void
DSQueryTremain (unsigned char PinNo,unsigned int *COUNT_REMAIN,unsigned int *COUNT_PER_C)
{
	SET_DS_PIN(PinNo);

    //--read COUNT_REMAIN
 	DSTouchReset ();
  
  	DSWriteByte (0xA0);		// Read Counter

    *COUNT_REMAIN=DSReadByte9(); //Respons

  	RELEASE_THE_BUS ();		// Releases the bus
	_delay_us (20);

	//--Load Counter
 	DSTouchReset ();
  
  	DSWriteByte (0x41);		// Load Counter

  	RELEASE_THE_BUS ();		// Releases the bus
	_delay_us (20);


	//---COUNT_PER_C
 	DSTouchReset ();
  
  	DSWriteByte (0xA0);		// Read Counter

    *COUNT_PER_C=DSReadByte9(); //Respons

  	RELEASE_THE_BUS ();		// Releases the bus

	_delay_us (20);
}

unsigned char
DSQuerySts (unsigned char PinNo)
{
	unsigned char sts;
	SET_DS_PIN(PinNo);
 	DSTouchReset ();
  
  	DSWriteByte (0xAC);		// READ STATUS

    sts=DSReadByte (); //Respons

  	RELEASE_THE_BUS ();		// Releases the bus
	_delay_us (20);

	return sts;
}


void
DSWriteSts (unsigned char PinNo,unsigned char Sts)
{
	SET_DS_PIN(PinNo);
 	DSTouchReset ();
  
  	DSWriteByte (0x0C);		// WRITE STATUS

  	DSWriteByte (Sts);		// STATUS

  	RELEASE_THE_BUS ();		// Releases the bus
	_delay_us (20);

}



