#include <avr/io.h>
#include <util/delay.h>
#include "LCD.h"

#define LCD_CMD_SET_4BIT 0x02

//LCDByte felepites 0 0 RS RW D7 D6 D5 D4
#define LCD_BYTE_RS	0x20
#define LCD_BYTE_RW	0x10
#define LCD_BYTE_D7	0x08
#define LCD_BYTE_D6	0x04
#define LCD_BYTE_D5	0x02
#define LCD_BYTE_D4	0x01


#define LCD_BYTE_SET_BIT(lcd_byte,bit)	if(lcd_byte & LCD_BYTE_ ## bit)LCD_PORT_ ## bit|=(1<<LCD_BIT_ ## bit); \
																	else LCD_PORT_ ## bit &=~(1<<LCD_BIT_ ## bit);
#define LCD_SET_DDR_BIT(bit) LCD_DDR_ ## bit |= (1<<LCD_BIT_ ## bit)
#define LCD_SET_PORT_BIT(bit) LCD_PORT_ ## bit |= (1<<LCD_BIT_ ## bit)

#define LCD_CLEAR_DDR_BIT(bit) LCD_DDR_ ## bit &=~ (1<<LCD_BIT_ ## bit)
#define LCD_CLEAR_PORT_BIT(bit) LCD_PORT_ ## bit &=~ (1<<LCD_BIT_ ## bit)

#define LCD_BYTE_READ_BIT(lcd_byte,bit)	if(LCD_PIN_ ## bit &(1<<LCD_BIT_ ## bit))lcd_byte |= LCD_BYTE_ ## bit; \
																	else lcd_byte &=~(1<<LCD_BIT_ ## bit);

void LCDSetDataOutput()
{
	//minden OUTPUT

	LCD_SET_DDR_BIT(D7);
	LCD_SET_DDR_BIT(D6);
	LCD_SET_DDR_BIT(D5);
	LCD_SET_DDR_BIT(D4);
}
void LCDSetDataInput()
{
	//minden INPUT

	LCD_CLEAR_DDR_BIT(D7);
	LCD_CLEAR_DDR_BIT(D6);
	LCD_CLEAR_DDR_BIT(D5);
	LCD_CLEAR_DDR_BIT(D4);
}

void LCDInit()
{
	//minden OUTPUT
	LCD_SET_DDR_BIT(RW);
	LCD_SET_DDR_BIT(RS);
	LCD_SET_DDR_BIT(E);

	
	LCDSetDataOutput();

	LCDSet4bitMode();
}

void LCDWriteData(unsigned char LCDByte)
{
	LCD_BYTE_SET_BIT(LCDByte,D7);
	LCD_BYTE_SET_BIT(LCDByte,D6);
	LCD_BYTE_SET_BIT(LCDByte,D5);
	LCD_BYTE_SET_BIT(LCDByte,D4);

	
}
unsigned char LCDReadData(unsigned char Delay)
{
	unsigned char LCDByte=0;
	LCD_SET_PORT_BIT(E);
	_delay_us(Delay);

	LCD_BYTE_READ_BIT(LCDByte,D7);
	LCD_BYTE_READ_BIT(LCDByte,D6);
	LCD_BYTE_READ_BIT(LCDByte,D5);
	LCD_BYTE_READ_BIT(LCDByte,D4);

	
	LCD_CLEAR_PORT_BIT(E);
	_delay_us(1);
	return LCDByte;
}

void LCDWriteCmd(unsigned char LCDByte)
{
	LCD_BYTE_SET_BIT(LCDByte,RS);
	LCD_BYTE_SET_BIT(LCDByte,RW);
}

void LCDSetEnabled()
{
	LCD_SET_PORT_BIT(E);
	_delay_us(1);
	LCD_CLEAR_PORT_BIT(E);
	_delay_us(1);
}

void LCDSetCmd(unsigned char CmdByte,unsigned char DataByte)
{
	LCDWriteCmd(CmdByte);
	//h 4 bit
	LCDWriteData((DataByte>>4));
	LCDSetEnabled();

	//l 4 bit
	LCDWriteData(DataByte&0x0F);
	LCDSetEnabled();
}
void LCDSet4bitMode()
{
	LCDWriteCmd(0);
	LCDWriteData(LCD_CMD_SET_4BIT);
	LCDSetEnabled();
	_delay_us(39);//cmd execution time
	
}

void LCDClearDisplay()
{
	LCDSetCmd(0x00,0x01);
	_delay_ms(2);
}
void LCDReturnHome()
{
	LCDSetCmd(0x00,0x02);
	_delay_ms(2);
}
void LCDEntryModeSet(unsigned char CmdByte)
{
	LCDSetCmd(0x00,(CmdByte&0x07)|0x04);
	_delay_us(39);
}
void LCDDisplayControl(unsigned char CmdByte)
{
	LCDSetCmd(0x00,(CmdByte&0x0F)|0x08);
	_delay_us(39);
}
void LCDCursorDisplayShift(unsigned char CmdByte)
{
	LCDSetCmd(0x00,(CmdByte&0x1F)|0x10);
	_delay_us(39);
}
void LCDFunctionSet(unsigned char CmdByte)
{
	LCDSetCmd(0x00,(CmdByte&0x3F)|0x20);
	_delay_us(39);
}
void LCDSetCGRAMAddress(unsigned char CmdByte)
{
	LCDSetCmd(0x00,(CmdByte&0x7F)|0x40);
	_delay_us(39);
}
void LCDSetDDRAMAddress(unsigned char CmdByte)
{
	LCDSetCmd(0x00,CmdByte|0x80);
	_delay_us(39);
}
void LCDWriteDataToRAM(unsigned char CmdByte)
{
	LCDSetCmd(LCD_BYTE_RS,CmdByte);
	_delay_us(43);
}
unsigned char LCDReadBusyAndAddress(void)
{
	unsigned char RespByte;
	LCDSetDataInput();

	LCDWriteCmd(LCD_BYTE_RW);
	_delay_us(1);

	//h 4 bit
	RespByte=LCDReadData(1)<<4;
	

	_delay_us(1);

	//l 4 bit
	RespByte|=LCDReadData(1);


	LCDSetDataOutput();
	return RespByte;
}
unsigned char LCDReadDataFromRAM(void )
{
	unsigned char RespByte;
	LCDSetDataInput();

	LCDWriteCmd(LCD_BYTE_RS|LCD_BYTE_RW);
	_delay_us(1);

	//h 4 bit
	RespByte=LCDReadData(43)<<4;


	//l 4 bit
	RespByte|=LCDReadData(1);


	LCDSetDataOutput();
	return RespByte;
}
