
#define LCD_PORT_RS_NAME	B
#define LCD_BIT_RS			5

#define LCD_PORT_RW_NAME	B
#define LCD_BIT_RW			4

#define LCD_PORT_E_NAME		B
#define LCD_BIT_E			3

#define LCD_PORT_D7_NAME	B
#define LCD_BIT_D7			2

#define LCD_PORT_D6_NAME	B
#define LCD_BIT_D6			1

#define LCD_PORT_D5_NAME	C
#define LCD_BIT_D5			5

#define LCD_PORT_D4_NAME	C
#define LCD_BIT_D4			4

#define LCD_CONCAT(a,b) a ## b

#define LCD_PORT_M(name) LCD_CONCAT(PORT, name)
#define LCD_DDR_M(name)  LCD_CONCAT(DDR, name)
#define LCD_PIN_M(name)  LCD_CONCAT(PIN, name)



#define LCD_PORT_RS LCD_PORT_M(LCD_PORT_RS_NAME)
#define LCD_DDR_RS  LCD_DDR_M(LCD_PORT_RS_NAME)
#define LCD_PIN_RS  LCD_PIN_M(LCD_PORT_RS_NAME)

#define LCD_PORT_RW LCD_PORT_M(LCD_PORT_RW_NAME)
#define LCD_DDR_RW  LCD_DDR_M(LCD_PORT_RW_NAME)
#define LCD_PIN_RW  LCD_PIN_M(LCD_PORT_RW_NAME)

#define LCD_PORT_E LCD_PORT_M(LCD_PORT_E_NAME)
#define LCD_DDR_E  LCD_DDR_M(LCD_PORT_E_NAME)
#define LCD_PIN_E  LCD_PIN_M(LCD_PORT_E_NAME)

#define LCD_PORT_D7 LCD_PORT_M(LCD_PORT_D7_NAME)
#define LCD_DDR_D7  LCD_DDR_M(LCD_PORT_D7_NAME)
#define LCD_PIN_D7  LCD_PIN_M(LCD_PORT_D7_NAME)

#define LCD_PORT_D6 LCD_PORT_M(LCD_PORT_D6_NAME)
#define LCD_DDR_D6 	LCD_DDR_M(LCD_PORT_D6_NAME)
#define LCD_PIN_D6  LCD_PIN_M(LCD_PORT_D6_NAME)

#define LCD_PORT_D5 LCD_PORT_M(LCD_PORT_D5_NAME)
#define LCD_DDR_D5  LCD_DDR_M(LCD_PORT_D5_NAME)
#define LCD_PIN_D5  LCD_PIN_M(LCD_PORT_D5_NAME)

#define LCD_PORT_D4 LCD_PORT_M(LCD_PORT_D4_NAME)
#define LCD_DDR_D4  LCD_DDR_M(LCD_PORT_D4_NAME)
#define LCD_PIN_D4  LCD_PIN_M(LCD_PORT_D4_NAME)


void LCDInit();
void LCDSet4bitMode();
void LCDClearDisplay();
void LCDReturnHome();
#define LCD_CMD_SH	0x01	//1-display shift ON 0-OFF
#define LCD_CMD_ID	0x02	//1-cursor increment 0-decrement
void LCDEntryModeSet(unsigned char CmdByte);

#define LCD_CMD_B	0x01	//1-Blinking ON 0-OFF
#define LCD_CMD_C	0x02	//1-Cursor ON 0-OFF
#define LCD_CMD_D	0x04	//1-Display ON 0-OFF
void LCDDisplayControl(unsigned char CmdByte);

#define LCD_CMD_RL	0x04	//1-right shift 0-left shift
#define LCD_CMD_SC	0x08	//1-screen shift 0-cursor shift
void LCDCursorDisplayShift(unsigned char CmdByte);

#define LCD_CMD_F	0x04	//1-5*11 dots 0-5*8 dots
#define LCD_CMD_N	0x08	//1-2 line 0- 1 line
#define LCD_CMD_DL	0x10	//1-8 bit 0- 4 bit
void LCDFunctionSet(unsigned char CmdByte);

//AC0..5 0x00..0x3f 0..63
void LCDSetCGRAMAddress(unsigned char CmdByte);

//AC0..6 0x00..0x7f 0..127
//1. line 0x00..0x0F 
//2. line 0x40..0x4F
void LCDSetDDRAMAddress(unsigned char CmdByte);

//D0..7 0x00..0xff 0..255
void LCDWriteDataToRAM(unsigned char CmdByte);

//AC0..6 0x00..0x7f 0..127 DB7=Busy flag
#define LCD_BUSY_FLAG 0x80
unsigned char LCDReadBusyAndAddress(void);

//D0..7 0x00..0xff 0..255
unsigned char LCDReadDataFromRAM(void);


