//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "stdio.h"
#include "usb.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
#define USBCMD_LCD_LCDSet4bitMode		0
#define USBCMD_LCD_LCDClearDisplay		1
#define USBCMD_LCD_LCDReturnHome			2
#define USBCMD_LCD_LCDEntryModeSet		3
#define USBCMD_LCD_LCDDisplayControl		4
#define USBCMD_LCD_LCDCursorDisplayShift	5
#define USBCMD_LCD_LCDFunctionSet		6
#define USBCMD_LCD_LCDSetCGRAMAddress	7
#define USBCMD_LCD_LCDSetDDRAMAddress	8
#define USBCMD_LCD_LCDWriteDataToRAM		9
#define USBCMD_LCD_LCDReadBusyAndAddress	10
#define USBCMD_LCD_LCDReadDataFromRAM	11
#define USBCMD_LCD_LCDReadBusyAndAddress_ret	12
#define USBCMD_LCD_LCDReadDataFromRAM_ret	13

#define LCD_CMD_SH	0x01	//1-display shift ON 0-OFF
#define LCD_CMD_ID	0x02	//1-cursor increment 0-decrement

#define LCD_CMD_B	0x01	//1-Blinking ON 0-OFF
#define LCD_CMD_C	0x02	//1-Cursor ON 0-OFF
#define LCD_CMD_D	0x04	//1-Display ON 0-OFF

#define LCD_CMD_RL	0x04	//1-right shift 0-left shift
#define LCD_CMD_SC	0x08	//1-screen shift 0-cursor shift

#define LCD_CMD_F	0x04	//1-5*11 dots 0-5*8 dots
#define LCD_CMD_N	0x08	//1-2 line 0- 1 line
#define LCD_CMD_DL	0x10	//1-8 bit 0- 4 bit

TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void PrintMsg(char*errstr)
{
    Form1->Memo1->Lines->Add(errstr);
}
#define USB_ERROR_NOTFOUND  1
#define USB_ERROR_ACCESS    2
#define USB_ERROR_IO        3
static int  usbGetStringAscii(usb_dev_handle *dev, int index, int langid, char *buf, int buflen)
{
char    buffer[256];
int     rval, i;

    if((rval = usb_control_msg(dev, USB_ENDPOINT_IN, USB_REQ_GET_DESCRIPTOR, (USB_DT_STRING << 8) + index, langid, buffer, sizeof(buffer), 1000)) < 0)
        return rval;
    if(buffer[1] != USB_DT_STRING)
        return 0;
    if((unsigned char)buffer[0] < rval)
        rval = (unsigned char)buffer[0];
    rval /= 2;
    /* lossy conversion to ISO Latin1 */
    for(i=1;i<rval;i++){
        if(i > buflen)  /* destination buffer overflow */
            break;
        buf[i-1] = buffer[2 * i];
        if(buffer[2 * i + 1] != 0)  /* outside of ISO Latin1 range */
            buf[i-1] = '?';
    }
    buf[i-1] = 0;
    return i-1;
}

static int usbOpenDevice(usb_dev_handle **device, int vendor, char *vendorName, int product, char *productName)
{
struct usb_bus      *bus;
struct usb_device   *dev;
usb_dev_handle      *handle = NULL;
int                 errorCode = USB_ERROR_NOTFOUND;
static int          didUsbInit = 0;
char errstr[200];
    if(!didUsbInit){
        didUsbInit = 1;
        usb_init();
    }
    usb_find_busses();
    usb_find_devices();
    for(bus=usb_get_busses(); bus; bus=bus->next){
        for(dev=bus->devices; dev; dev=dev->next){
            if(dev->descriptor.idVendor == vendor && dev->descriptor.idProduct == product){
                char    string[256];
                int     len;
                handle = usb_open(dev); /* we need to open the device in order to query strings */
                if(!handle){
                    errorCode = USB_ERROR_ACCESS;
                    sprintf(errstr, "Warning: cannot open USB device: %s\n", usb_strerror());
                    PrintMsg(errstr);
                    continue;
                }
                if(vendorName == NULL && productName == NULL){  /* name does not matter */
                    break;
                }
                /* now check whether the names match: */
                len = usbGetStringAscii(handle, dev->descriptor.iManufacturer, 0x0409, string, sizeof(string));
                if(len < 0){
                    errorCode = USB_ERROR_IO;
                    sprintf(errstr, "Warning: cannot query manufacturer for device: %s\n", usb_strerror());
                    PrintMsg(errstr);
                }else{
                    errorCode = USB_ERROR_NOTFOUND;
                    /* sprintf(errstr, "seen device from vendor ->%s<-\n", string); */
                    if(strcmp(string, vendorName) == 0){
                        len = usbGetStringAscii(handle, dev->descriptor.iProduct, 0x0409, string, sizeof(string));
                        if(len < 0){
                            errorCode = USB_ERROR_IO;
                            sprintf(errstr, "Warning: cannot query product for device: %s\n", usb_strerror());
                            PrintMsg(errstr);
                        }else{
                            errorCode = USB_ERROR_NOTFOUND;
                            /* sprintf(errstr, "seen product ->%s<-\n", string); */
                            if(strcmp(string, productName) == 0)
                                break;
                        }
                    }
                }
                usb_close(handle);
                handle = NULL;
            }
        }
        if(handle)
            break;
    }
    if(handle != NULL){
        errorCode = 0;
        *device = handle;
    }
    return errorCode;
}

#define USBDEV_SHARED_VENDOR    0x16C0  /* VOTI */
#define USBDEV_SHARED_PRODUCT   0x05DC  /* Obdev's free shared PID */

usb_dev_handle      *UsbHandle = NULL;
void __fastcall TForm1::Button1Click(TObject *Sender)
{
unsigned char       buffer[8];
int                 nBytes;
char errstr[200];
    if(usbOpenDevice(&UsbHandle, USBDEV_SHARED_VENDOR, "obdev.at", USBDEV_SHARED_PRODUCT, "Template") != 0)
    {
        sprintf(errstr, "Could not find USB device \"PowerSwitch\" with vid=0x%x pid=0x%x\n", USBDEV_SHARED_VENDOR, USBDEV_SHARED_PRODUCT);
        PrintMsg(errstr);
    }
    else
    {
        PrintMsg("Ok");
    }

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
unsigned char       buffer[8];
int                 nBytes;
char errstr[200];
    nBytes = usb_control_msg(UsbHandle, USB_TYPE_VENDOR | USB_RECIP_DEVICE | USB_ENDPOINT_IN
        , 0    //cmd        byte
        , 0             //value  word
        , 0             //index  word
        , (char *)buffer
        , sizeof(buffer)
        , 5000);  //tmo

    if(nBytes<0)
    {
        sprintf(errstr, "error: %s", usb_strerror());
        PrintMsg(errstr);
    }
    else
    {
        memcpy(errstr,buffer,nBytes);
        errstr[nBytes]='\0';
        PrintMsg(errstr);
    }
//    usb_close(handle);

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
unsigned char       buffer[8];
int                 nBytes;
float COUNT_REMAIN,COUNT_PER_C;
char errstr[200];
    nBytes = usb_control_msg(UsbHandle, USB_TYPE_VENDOR | USB_RECIP_DEVICE | USB_ENDPOINT_IN
        , 11   //cmd        byte
        , 0             //value  word
        , 0             //index  word
        , (char *)buffer
        , sizeof(buffer)
        , 5000);  //tmo

    if(nBytes<0)
    {
        sprintf(errstr, "error: %s", usb_strerror());
        PrintMsg(errstr);
    }
    else
    {
        COUNT_REMAIN=(((unsigned short)buffer[1])<<8)|( (unsigned short)buffer[2]);
        COUNT_PER_C=(((unsigned short)buffer[3])<<8)|( (unsigned short)buffer[4]) ;
        sprintf(errstr, "Homerseklet=%02X rem=%04x c=%04x busy=%1X %.3f",(int)buffer[0]
            ,(int)((((unsigned short)buffer[1])<<8)|( (unsigned short)buffer[2]) )  //COUNT_REMAIN
            ,(int)((((unsigned short)buffer[3])<<8)|( (unsigned short)buffer[4]) )  //COUNT_PER_C
            ,(int)buffer[5]
            ,((float)((char)buffer[0]))-0.5+((COUNT_PER_C-COUNT_REMAIN)/COUNT_PER_C));
        PrintMsg(errstr);
    }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button4Click(TObject *Sender)
{
unsigned char       buffer[8];
int                 nBytes;
char errstr[200];
    nBytes = usb_control_msg(UsbHandle, USB_TYPE_VENDOR | USB_RECIP_DEVICE | USB_ENDPOINT_IN
        , 12   //cmd        byte
        , 0             //value  word
        , 0             //index  word
        , (char *)buffer
        , sizeof(buffer)
        , 5000);  //tmo

    if(nBytes<0)
    {
        sprintf(errstr, "error: %s", usb_strerror());
        PrintMsg(errstr);
    }
    else
    {
        sprintf(errstr, "Statusz=%02X",(int)buffer[0]);
        PrintMsg(errstr);
    }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button5Click(TObject *Sender)
{
unsigned char       buffer[8];
int                 nBytes;
char errstr[200];
    nBytes = usb_control_msg(UsbHandle, USB_TYPE_VENDOR | USB_RECIP_DEVICE | USB_ENDPOINT_IN
        , 10   //cmd        byte
        , 0             //value  word
        , 0             //index  word
        , (char *)buffer
        , sizeof(buffer)
        , 5000);  //tmo

    if(nBytes<0)
    {
        sprintf(errstr, "error: %s", usb_strerror());
        PrintMsg(errstr);
    }
    else
    {
        PrintMsg("StartQuery OK");
    }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button6Click(TObject *Sender)
{
unsigned char       buffer[8];
int                 nBytes;
char errstr[200];
int val=0;

    val|=(CB_p0->Checked?0x01:0);
    val|=(CB_p1->Checked?0x02:0);
    val|=(CB_p2->Checked?0x04:0);
    val|=(CB_p3->Checked?0x08:0);
    val|=(CB_p4->Checked?0x10:0);
    val|=(CB_p5->Checked?0x20:0);
    val|=(CB_p6->Checked?0x40:0);
    val|=(CB_p7->Checked?0x80:0);

    val|=(CB_p8->Checked?0x100:0);
    val|=(CB_p9->Checked?0x200:0);
    val|=(CB_p10->Checked?0x400:0);

    nBytes = usb_control_msg(UsbHandle, USB_TYPE_VENDOR | USB_RECIP_DEVICE | USB_ENDPOINT_IN
        , 1   //cmd        byte
        , val             //value  word
        , 0             //index  word
        , (char *)buffer
        , sizeof(buffer)
        , 5000);  //tmo

    if(nBytes<0)
    {
        sprintf(errstr, "error: %s", usb_strerror());
        PrintMsg(errstr);
    }
    else
    {
        sprintf(errstr,"Set DIR OK %03X %s%s%s %s%s%s%s %s%s%s%s"
            ,val
            ,(val&0x400?"1":"0")
            ,(val&0x200?"1":"0")
            ,(val&0x100?"1":"0")

            ,(val&0x80?"1":"0")
            ,(val&0x40?"1":"0")
            ,(val&0x20?"1":"0")
            ,(val&0x10?"1":"0")
            ,(val&0x08?"1":"0")
            ,(val&0x04?"1":"0")
            ,(val&0x02?"1":"0")
            ,(val&0x01?"1":"0")
            );
        PrintMsg(errstr);
    }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button7Click(TObject *Sender)
{
unsigned char       buffer[8];
int                 nBytes;
char errstr[200];
int val=0;

    val|=(CB_d0->Checked?0x01:0);
    val|=(CB_d1->Checked?0x02:0);
    val|=(CB_d2->Checked?0x04:0);
    val|=(CB_d3->Checked?0x08:0);
    val|=(CB_d4->Checked?0x10:0);
    val|=(CB_d5->Checked?0x20:0);
    val|=(CB_d6->Checked?0x40:0);
    val|=(CB_d7->Checked?0x80:0);

    val|=(CB_d8->Checked?0x100:0);
    val|=(CB_d9->Checked?0x200:0);
    val|=(CB_d10->Checked?0x400:0);
    WritePin(val,true);

}
int __fastcall TForm1::WritePin(int val,bool bShowMsg)
{
unsigned char       buffer[8];
int                 nBytes;
char errstr[200];

    nBytes = usb_control_msg(UsbHandle, USB_TYPE_VENDOR | USB_RECIP_DEVICE | USB_ENDPOINT_IN
        , 2   //cmd        byte
        , val             //value  word
        , 0             //index  word
        , (char *)buffer
        , sizeof(buffer)
        , 5000);  //tmo

    if(bShowMsg)
    {
        if(nBytes<0)
        {
            sprintf(errstr, "error: %s", usb_strerror());
            PrintMsg(errstr);
        }
        else
        {
            sprintf(errstr,"Write pin OK %03X %s%s%s %s%s%s%s %s%s%s%s"
                ,val
                ,(val&0x400?"1":"0")
                ,(val&0x200?"1":"0")
                ,(val&0x100?"1":"0")

                ,(val&0x80?"1":"0")
                ,(val&0x40?"1":"0")
                ,(val&0x20?"1":"0")
                ,(val&0x10?"1":"0")
                ,(val&0x08?"1":"0")
                ,(val&0x04?"1":"0")
                ,(val&0x02?"1":"0")
                ,(val&0x01?"1":"0")
                );
            PrintMsg(errstr);
        }
    }

    return nBytes;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button8Click(TObject *Sender)
{
unsigned char       buffer[8];
int                 nBytes;
char errstr[200];
int val=0;

    nBytes = usb_control_msg(UsbHandle, USB_TYPE_VENDOR | USB_RECIP_DEVICE | USB_ENDPOINT_IN
        , 3   //cmd        byte
        , 0             //value  word
        , 0             //index  word
        , (char *)buffer
        , sizeof(buffer)
        , 5000);  //tmo

    if(nBytes<0)
    {
        sprintf(errstr, "error: %s", usb_strerror());
        PrintMsg(errstr);
    }
    else
    {
        val=((int)buffer[1])<<8 ;
        val|=buffer[0] ;
        sprintf(errstr, "Read Pin OK %03X %s%s%s %s%s%s%s %s%s%s%s",val
            ,(val&0x400?"1":"0")
            ,(val&0x200?"1":"0")
            ,(val&0x100?"1":"0")

            ,(val&0x80?"1":"0")
            ,(val&0x40?"1":"0")
            ,(val&0x20?"1":"0")
            ,(val&0x10?"1":"0")
            ,(val&0x08?"1":"0")
            ,(val&0x04?"1":"0")
            ,(val&0x02?"1":"0")
            ,(val&0x01?"1":"0")
            );
        PrintMsg(errstr);
    }


}
//---------------------------------------------------------------------------
unsigned char GetHex(char h)
{
    unsigned char hex=0;
    if(h>='0'&&h<='9')
    {
        hex=h-'0';
    }
    else
    {
        if(h>='a'&&h<='f')
        {
            hex=h-'a'+10;
        }
        else
        {
            if(h>='A'&&h<='F')
            {
                hex=h-'A'+10;
            }
        }
    }
    return hex;
}
void __fastcall TForm1::Button9Click(TObject *Sender)
{
unsigned char       buffer[8];
int                 nBytes;
char errstr[200];
int val=0;
    int i,j;
    int c=0,bc=0;
    AnsiString str;
    for(i=0;i<Memo2->Lines->Count;i++)
    {
        str=Memo2->Lines->Strings[i];
        j=1;
        while(j<str.Length()-1)
        {
            if(str[j]!=' ')
            {
                val=GetHex(str[j]);
                val<<=8;
                val|=(GetHex(str[j+1])<<4)|GetHex(str[j+2]);
                j+=3;
                nBytes=WritePin(val,true);

                if(nBytes<0)
                {
                    bc++;
                }
                else
                {
                    c++;
                }

            }
            else
            {
                j++;
            }

        }
    }

    sprintf(errstr, "%d Byte written Bad:%d",c,bc);
    PrintMsg(errstr);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button10Click(TObject *Sender)
{
int val=0;
char tmp[100];
    val|=(CB_d0->Checked?0x01:0);
    val|=(CB_d1->Checked?0x02:0);
    val|=(CB_d2->Checked?0x04:0);
    val|=(CB_d3->Checked?0x08:0);
    val|=(CB_d4->Checked?0x10:0);
    val|=(CB_d5->Checked?0x20:0);
    val|=(CB_d6->Checked?0x40:0);
    val|=(CB_d7->Checked?0x80:0);

    val|=(CB_d8->Checked?0x100:0);
    val|=(CB_d9->Checked?0x200:0);
    val|=(CB_d10->Checked?0x400:0);

    if(Memo2->Lines->Count==0)
    {
        sprintf(tmp,"%03X",val);
        Memo2->Lines->Add(tmp);
    }
    else
    {
        sprintf(tmp," %03X",val);
        Memo2->Lines->Strings[Memo2->Lines->Count-1]=Memo2->Lines->Strings[Memo2->Lines->Count-1]+tmp;
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button11Click(TObject *Sender)
{
unsigned char       buffer[8];
int                 nBytes;
char errstr[200];
int val=0;
int val2=0;
    int i,j;
    int c=0,bc=0;
    AnsiString str;
    for(i=0;i<Memo3->Lines->Count;i++)
    {
        str=Memo3->Lines->Strings[i];
        j=1;
        while(j<str.Length())
        {
            if(str[j]!=' ')
            {
                val2=(GetHex(str[j])<<4)|GetHex(str[j+1]);
//B7 RS
//B6 RW
//B5 E
//B4 LED
//B3 D7
//B2 D6
//B1 D5
//B0 D4
                //bit forgatas
                val=(val2&0x0f)<<4;//B3..0->B7..4
                if(val2&0x80)val|=0x400;//rs
                if(val2&0x40)val|=0x200;//rw
                if(val2&0x20)val|=0x100;//e

                j+=2;
                nBytes=WritePin(val,true);

                if(nBytes<0)
                {
                    bc++;
                }
                else
                {
                    c++;
                }

            }
            else
            {
                j++;
            }

        }
    }

    sprintf(errstr, "%d Byte written Bad:%d",c,bc);
    PrintMsg(errstr);

}
//---------------------------------------------------------------------------

void __fastcall TForm1::LCDCmd(int Value,char* CmdTxt)
{
unsigned char       buffer[8];
int                 nBytes;
char errstr[200];
    nBytes = usb_control_msg(UsbHandle, USB_TYPE_VENDOR | USB_RECIP_DEVICE | USB_ENDPOINT_IN
        , 20   //cmd        byte
        , Value             //value  word
        , 0             //index  word
        , (char *)buffer
        , sizeof(buffer)
        , 5000);  //tmo

    if(nBytes<0)
    {
        sprintf(errstr, "%s error: %s",CmdTxt, usb_strerror());
        PrintMsg(errstr);
    }
    else
    {
        if(buffer[0]&0x03)
        {
            sprintf(errstr, "%s(%02X) error: %s",CmdTxt,(Value&0xf0)>>4,(buffer[0]&0x01?"Foglalt":"hibs krs") );
        }
        else
        {
            if(nBytes==1)
            {
                sprintf(errstr, "%s(%02X) OK",CmdTxt,(Value&0xff00)>>8);
            }
            else
            {
                sprintf(errstr, "%s(%02X) Ret=%02X",CmdTxt,(Value&0xff00)>>8,(int)buffer[1]);
            }
        }
        PrintMsg(errstr);
    }


}

void __fastcall TForm1::Button13Click(TObject *Sender)
{
    LCDCmd(USBCMD_LCD_LCDSet4bitMode,"LCDSet4bitMode");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button14Click(TObject *Sender)
{
    LCDCmd(USBCMD_LCD_LCDClearDisplay,"LCDClearDisplay");

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button15Click(TObject *Sender)
{
    LCDCmd(USBCMD_LCD_LCDReturnHome,"LCDReturnHome");

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button16Click(TObject *Sender)
{
    int val=0;
    if(CheckBox2->Checked)val|=LCD_CMD_SH;
    if(CheckBox1->Checked)val|=LCD_CMD_ID;
    val<<=8;
    LCDCmd(USBCMD_LCD_LCDEntryModeSet|val,"LCDEntryModeSet");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button17Click(TObject *Sender)
{
    int val=0;
    if(CheckBox3->Checked)val|=LCD_CMD_D;
    if(CheckBox4->Checked)val|=LCD_CMD_C;
    if(CheckBox5->Checked)val|=LCD_CMD_B;
    val<<=8;

    LCDCmd(USBCMD_LCD_LCDDisplayControl|val,"LCDDisplayControl");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button18Click(TObject *Sender)
{
    int val=0;
    if(CheckBox6->Checked)val|=LCD_CMD_SC;
    if(CheckBox7->Checked)val|=LCD_CMD_RL;
    val<<=8;
    LCDCmd(USBCMD_LCD_LCDCursorDisplayShift|val,"LCDCursorDisplayShift");

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button19Click(TObject *Sender)
{
    int val=0;
    if(CheckBox8->Checked)val|=LCD_CMD_DL;
    if(CheckBox9->Checked)val|=LCD_CMD_N;
    if(CheckBox10->Checked)val|=LCD_CMD_F;
    val<<=8;

    LCDCmd(USBCMD_LCD_LCDFunctionSet|val,"LCDFunctionSet");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button20Click(TObject *Sender)
{
    int val=0;
    AnsiString str;
    str=Edit1->Text.Trim();
    if(str.Length()==1)
    {
        val= GetHex(str[1]) ;
    }
    else
    {
        if(str.Length()==2)
        {
            val= (GetHex(str[1])<<4)| GetHex(str[2]);
        }
    }
    val<<=8;

    LCDCmd(USBCMD_LCD_LCDSetCGRAMAddress|val,"LCDSetCGRAMAddress");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button21Click(TObject *Sender)
{
    int val=0;
    AnsiString str;
    str=Edit2->Text.Trim();
    if(str.Length()==1)
    {
        val= GetHex(str[1]) ;
    }
    else
    {
        if(str.Length()==2)
        {
            val= (GetHex(str[1])<<4)| GetHex(str[2]);
        }
    }
    val<<=8;
    LCDCmd(USBCMD_LCD_LCDSetDDRAMAddress|val,"LCDSetDDRAMAddress");

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button22Click(TObject *Sender)
{
    int val=0;
    AnsiString str;
    str=Edit3->Text.Trim();
    if(str.Length()==1)
    {
        val= GetHex(str[1]);
    }
    else
    {
        if(str.Length()==2)
        {
            val= (GetHex(str[1])<<4)| GetHex(str[2]);
        }
    }
    val<<=8;
    LCDCmd(USBCMD_LCD_LCDWriteDataToRAM|val,"LCDWriteDataToRAM");

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button23Click(TObject *Sender)
{
    LCDCmd(USBCMD_LCD_LCDReadBusyAndAddress,"LCDReadBusyAndAddress");

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button24Click(TObject *Sender)
{

    LCDCmd(USBCMD_LCD_LCDReadDataFromRAM,"LCDReadDataFromRAM");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button12Click(TObject *Sender)
{
    LCDCmd(USBCMD_LCD_LCDReadBusyAndAddress_ret,"LCDReadBusyAndAddress_ret");

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button25Click(TObject *Sender)
{

    LCDCmd(USBCMD_LCD_LCDReadDataFromRAM_ret,"LCDReadDataFromRAM_ret");
}
//---------------------------------------------------------------------------

