#define _TESTING_

#include "fitting.h"
#include "w_fitting.h"
#include "i_fitting.h"
#include "math.h"
#ifdef _TESTING_
	#include <stdio.h>
#endif

#define XY_POINTS_CNT 8
#define PERCENT_CHANGE_MIN 1
#define DOUBLE_MAX 10000000

typedef struct _XYPoint {
	double x;
	double y;
} XYPoint;

typedef struct _XYPointList {
	XYPoint xyPoints[XY_POINTS_CNT];
	unsigned int cnt;
} XYPointList;

XYPointList xyPointList;

static double fitting_modelExponenial(double x, double T, double y0);
static double fitting_calculateSumOfErrorSquare(double T, double y0);
static double fitting_double_abs(double in);

void init_fitting(void) {
	fitting_clearPoints();
}

void do_fitting(void) {
}

void fitting_clearPoints(void) {
	unsigned int x = 0;
	xyPointList.cnt = 0;
	for (x = 0; x < (sizeof(xyPointList.xyPoints) / sizeof(*xyPointList.xyPoints)); x++) {
		xyPointList.xyPoints[x].x = 0;
		xyPointList.xyPoints[x].y = 0;
	}
}

void fitting_addPoint(double x, double y) {
	if (xyPointList.cnt < (sizeof(xyPointList.xyPoints) / sizeof(*xyPointList.xyPoints))) {
		xyPointList.xyPoints[xyPointList.cnt].x = x;
		xyPointList.xyPoints[xyPointList.cnt].y = y;
		xyPointList.cnt++;
	} else {
	}	
}

void fitting_calculateFitting(double *th, double *y0, double *t1) {
	unsigned int x = 0;
	if (xyPointList.cnt > 0) {
		double firstPoint = xyPointList.xyPoints[0].y;
		double percentOfChange = PERCENT_CHANGE_MIN * xyPointList.xyPoints[xyPointList.cnt - 1].y / 100;
		unsigned int deadTimePlace = 0;
		for (x = 0; x < xyPointList.cnt; x++) {
			if ((xyPointList.xyPoints[x].y - firstPoint) > percentOfChange) {
				*th = xyPointList.xyPoints[x].x;
				deadTimePlace = x;
				break;
			}
		}
		if (deadTimePlace > 0) {
			unsigned int maxIterationRetry = 1024;
			double t1_fitted = 1;
			double dt = 0.3 / xyPointList.cnt;
			double y0_fitted = 1;
			double dy0 = 0.3 / xyPointList.cnt;

			double previousError = 0;
			double currentError = 0;

			double currentDeltaError = 0;

			if (deadTimePlace > 1) {
				for (x = 0; x < xyPointList.cnt - (deadTimePlace - 1); x++) {
					xyPointList.xyPoints[x].x = xyPointList.xyPoints[x + deadTimePlace].x;
					xyPointList.xyPoints[x].y = xyPointList.xyPoints[x + deadTimePlace].y;
				}
				xyPointList.cnt -= (deadTimePlace - 1);
			}

			previousError = fitting_calculateSumOfErrorSquare(t1_fitted, y0_fitted);
			currentError = 0.33;
			while (maxIterationRetry) {
				
				t1_fitted += (dt * currentError);
				currentError = fitting_calculateSumOfErrorSquare(t1_fitted, y0_fitted);
				currentDeltaError = currentError - previousError;
				if ((currentDeltaError < 0.01) && (currentDeltaError > -0.01)) {
					break;
				}
				if (currentDeltaError > 0) {
					dt = -dt;
				}
				previousError = currentError;
				
				y0_fitted += (dy0 * currentError);
				currentError = fitting_calculateSumOfErrorSquare(t1_fitted, y0_fitted);
				currentDeltaError = currentError - previousError;
				if ((currentDeltaError < 0.01) && (currentDeltaError > -0.01)) {
					break;
				}
				if (currentDeltaError > 0) {
					dy0 = -dy0;
				}
				previousError = currentError;

				maxIterationRetry--;
			}

			*y0 = y0_fitted;
			*t1 = t1_fitted;
		}
	}
}

#ifdef _TESTING_
void fitting_loadTestData1(void) {
	fitting_clearPoints(); 
	fitting_addPoint(0, 0);// T = 3 Y = 7
	fitting_addPoint(1, 1.9841);
	fitting_addPoint(2, 3.4060);
	fitting_addPoint(3, 4.4248);
	fitting_addPoint(4, 5.1548);
	fitting_addPoint(5, 5.6778);
	fitting_addPoint(6, 6.0526);
	fitting_addPoint(7, 6.5136);
	fitting_addPoint(8, 6.6514);
	fitting_addPoint(9, 6.7502);
}

void fitting_loadTestData2(void) {
	unsigned int x = 0;
	fitting_clearPoints();
	for (x = 0; x < 10; x++) {
		fitting_addPoint(x, fitting_modelExponenial(x, 3, 7));// T = 3 Y = 7
	}
}

void fitting_loadTestData3(void) {
	fitting_clearPoints(); 
	fitting_addPoint(0, 0);// T = 1 Y = 7
	fitting_addPoint(1, 4.4248);
	fitting_addPoint(2, 6.0526);
	fitting_addPoint(3, 6.6514);
	fitting_addPoint(4, 6.8717);
	fitting_addPoint(5, 6.9528);
	fitting_addPoint(6, 6.9826);
	fitting_addPoint(7, 6.9936);
}

void fitting_test1(void) {
	double th = 0;
	double y0 = 0;
	double t1 = 0;
	fitting_loadTestData3();
	fitting_calculateFitting(&th, &y0, &t1);
	printf("Th: %f Y0: %f T1: %f \n", th, y0, t1);
	fitting_loadTestData1();
	fitting_calculateFitting(&th, &y0, &t1);
	printf("Th: %f Y0: %f T1: %f \n", th, y0, t1);
	fitting_loadTestData2();
	fitting_calculateFitting(&th, &y0, &t1);
	printf("Th: %f Y0: %f T1: %f \n", th, y0, t1);
}
#endif

static double fitting_calculateSumOfErrorSquare(double T, double y0) {
	double result = 0;
	unsigned int x = 0;
	for (x = 0; x < xyPointList.cnt; x++) {
		double modell = fitting_modelExponenial(xyPointList.xyPoints[x].x, T, y0);
		double current = xyPointList.xyPoints[x].y;
		double diff = current - modell;
		double power = diff * diff;
		result += power;
	}
	return result;
}

static double fitting_modelExponenial(double x, double T, double y0) {
	double result = 0;
	result = y0 * (1 - exp(- x/ T));
	return result;
}

static double fitting_double_abs(double in) {
	if (in < 0) {
		return -in;
	} else {
		return in;
	}
}