;Project Lynxmotion Phoenix
;Description: Phoenix, control file.
;		The control input subroutine for the phoenix software is placed in this file.
;		Can be used with V2.0 and above
;Configuration version: V1.0
;Date: 08-01-2009
;Programmer: Jeroen Janssen (aka Xan)
;Special Thanks to: Kurt (aka Kurte) Assembly
;
;Hardware setup: DIY RC version
;
;NEW IN V1.0
;	- First Release
;
;
;PS2 CONTROLS:
;	- Left Stick	(WalkMode) Body Height / Rotate
;					(Translate Mode) Body Height / Rotate body Y	
;					(Rotate Mode) Body Height / Rotate body Y
;					(Single leg Mode) Move Tars Y	
;
;	- Right Stick	(WalkMode) Walk/Strafe
;			 		(Translate Mode) Translate body X/Z
;					(Rotate Mode) Rotate body X/Z
;					(Single leg Mode) Move Tars X/Z
;
; 	- Left Slider	Speed
;	- Right Slider	Leg Lift Height
;
;	- A				Walk Mode
;	- B				Translate Mode
;	- C				Rotate Mode
;	- D				Single Leg Mode
;	- E				Balance Mode on/off
;
;	- 0				Turn on/off the bot
;
;	- 1-8			(Walk mode) Switch gaits
;	- 1-6			(Single leg mode) Switch legs
;
;====================================================================
;[DEBUG]
;DEBUG con 1
;--------------------------------------------------------------------
;[CONSTANTS]
WalkMode		con 0
TranslateMode	con 1
RotateMode		con 2
SingleLegMode	con 3
GPPlayerMode	con 4
;--------------------------------------------------------------------
;[RC Controller Constands]
RCCh0		con P0		;RC Remote Left Stick Up/Down (THRO)
RCCh1		con P1		;RC Remote Right Stick Up/Down (AILE)
RCCh2		con P2		;RC Remote Right Stick Left/Right (ELEV)
RCCh3		con P3		;RC Remote Left Stick Left/Right (RUDD)
RCCh4		con P4		;RC Remote Left Slider (GEAR)
RCCh5		con P5		;RC Remote Right Slider (AUX1)
RCCh6		con P6		;RC Remote Buttons (AUX2)
;--------------------------------------------------------------------
;[RC Controller Variables]
awPulsesIn			var word(7) 
bPulseTimeout		var byte 

awPulsesPrev		var word(7) 
fPulseChanged		var bit      ; we had a channel change 
fNoTransmitter      var bit      ; did we detect no transmitter... 
fLostTransmitter	var bit      ; We lost contact with transmitter 

i               	var byte 
Buttons				var byte 
LastButtons			var byte
pulse_slop			con 2 

ControlMode			var byte
;--------------------------------------------------------------------
InitController:
   ; Make sure all 7 pins are marked for input... 
   input RCCh0 
   input RCCh1 
   input RCCh2 
   input RCCh3 
   input RCCh4 
   input RCCh5 
   input RCCh6 
    
   fNoTransmitter = 0      ; assume we have a transmitter. 
   fLostTransmitter = 0 
   
   ControlMode = WalkMode
return
;--------------------------------------------------------------------
;[ControlInput] reads the input data from the RC-Remote and processes the
;data to the parameters.
ControlInput:

  ;Read input pulse lengths
  GOSUB Pulsein7
  
  ; if we get a timeout and it is channel 0 then we now the receiver is not on... 
  if (bPulseTimeout) then 
    ; we detected no tranmitter at startup... 
    if fNoTransmitter = 0 then 
#IFDEF Debug
      serout s_out, i9600, ["No Transmitter at power up(",hex bPulseTimeout, ")", 13 ] 
#ENDIF
	  sound P9,[100\600, 100\400, 100\600]
      fNoTransmitter = 1 
    endif 
  elseif awPulsesIn(0) < 950 
    ; On Bind we set channel 1 to about 800 normal is usually > 1000 so if under 950 
    ; we probably lost our connection with the transmitter 
    if fLostTransmitter = 0 then 
#IFDEF Debug
      serout s_out, i9600, ["Lost contact with transmitter", 13] 
#ENDIF
  	  sound P9,[100\600]
      fLostTransmitter = 1 
    endif 
    
  else 
    ; Ok we have a message so reset our error codes 
    fNoTransmitter = 0      ; assume we have a transmitter. 
    fLostTransmitter = 0 

    fPulseChanged = 0 
    for i = 0 to 6 
      if (awPulsesIn(i) > (awPulsesPrev(i)+pulse_slop)) or (awPulsesIn(i) < (awPulsesPrev(i)-pulse_slop)) then 
        fPulseChanged = 1 
        awPulsesPrev(i) = awPulsesIn(i) 
      endif 
    next 
       
    if fPulseChanged or bPulseTimeout  then 
      if awPulsesIn(6) < 1135 then  
        Buttons = 0xff 
      else 
        Buttons = (awPulsesIn(6)+15 - 1150) / 50  ; add in some slope as we could be slight 
      endif 
     
#IFDEF Debug
      serout s_out, i9600, [hex bPulseTimeout, ":", hex Buttons, ":" ] 
      for i = 0 to 6 
        serout s_out, i9600, [dec awPulsesIn(i)," "] 
      next 
      serout s_out, i9600,[13] 
#ENDIF

    endif

    ;Turn on / off
    IF ((Buttons=0 AND LastButtons<>0)) THEN
      IF HexOn THEN ;0 Button test
	    ControlMode=WalkMode      
	    BodyPosX = 0
	    BodyPosY = 0
	    BodyPosZ = 0
	    BodyRotX = 0
	    BodyRotY = 0
	    BodyRotZ = 0
	    TravelLengthX = 0
	    TravelLengthZ = 0
	    TravelRotationY = 0
	    
	    SelectedLeg=255 ; none
	    SLHold=0
		
  	    HexOn = 0
      ELSE
        ;Turn on
	    HexOn = 1	
      ENDIF
    ENDIF

    IF HexOn THEN
 
      IF Buttons = 0x0A and LastButtons <> 0x0A THEN ;A Button Walk Mode
        sound p9, [50\4000]
        ControlMode = WalkMode
      ENDIF

      IF Buttons = 0x0B and LastButtons <> 0x0B THEN ;B Button Translate Mode
        sound p9, [50\4000]
        ControlMode = TranslateMode
      ENDIF
      
      IF Buttons = 0x0C and LastButtons <> 0x0C THEN ;C Button Rotate Mode
        sound p9, [50\4000]
        ControlMode = RotateMode
      ENDIF
      
      IF Buttons = 0x0D and LastButtons <> 0x0D THEN ;D Button Single Leg Mode
        sound p9, [50\4000]
        IF SelectedLeg=255 THEN ; none
          SelectedLeg=cRF
        ELSEIF ControlMode=SingleLegMode ;Double press to turn all legs down
          SelectedLeg=255 ; none
        ENDIF
        ControlMode=SingleLegMode        
      ENDIF

      IF Buttons = 0x0E and LastButtons <> 0x0E THEN ;E Button Balance Mode on/off
		IF BalanceMode = 0 THEN
		  BalanceMode = 1
		  sound P9,[100\4000, 50\8000]
	  	ELSE
		  BalanceMode = 0
		  sound P9,[250\3000]
	    ENDIF  
      ENDIF   
      
      IF Buttons = 0x0F and LastButtons <> 0x0F  AND GPEnable THEN ;F Button GP Player Mode Mode on/off
        sound P9, [50\4000]
        
        BodyPosX = 0
	    BodyPosZ = 0
	    BodyRotX = 0
	    BodyRotY = 0
	    BodyRotZ = 0
	    TravelLengthX = 0
	    TravelLengthZ = 0
	    TravelRotationY = 0
	    
	    SelectedLeg=255 ; none
	    SLHold=0
        
        ControlMode = GPPlayerMode
      ENDIF
    
      ;Switch gait
      IF ControlMode=WalkMode & Buttons>=1 & Buttons<=8 & Buttons<>LastButtons THEN	;1-8 Button Gait select	  
        IF ABS(TravelLengthX)<cTravelDeadZone & ABS(TravelLengthZ)<cTravelDeadZone & ABS(TravelRotationY*2)<cTravelDeadZone THEN

	      ;Switch Gait type
	      GaitType = Buttons-1
	      Sound P9,[50\4000]
	  	  GOSUB GaitSelect
  	    ENDIF
  	  ENDIF

	  ;Switch single leg
	  IF ControlMode=SingleLegMode THEN	  
	    IF Buttons>=1 & Buttons<=6 & Buttons<>LastButtons THEN
	      Sound P9,[50\4000]
	      SelectedLeg = Buttons-1
	      SLHold=0
	    ENDIF
	    
	    IF Buttons = 9 & Buttons<>LastButtons THEN ;Switch Directcontrol
	      sound p9, [50\4000]
		  SLHold = SLHold^1 	;Toggle SLHold
	    ENDIF
	  ELSEIF ControlMode=Walkmode
	    SelectedLeg=255	; none
	    SLHold=0
	  ENDIF
	  
	  ;Body Height
	  BodyPosY = (awPulsesIn(0)-1000)/8
	
	  ;Leg lift height
      LegLiftHeight = 30 + (awPulsesIn(5)-1010)/20
    
	  ;Walk mode			
	  IF (ControlMode=WalkMode) THEN 			
	    TravelLengthX = -(awPulsesIn(2)-1500)/4
	    TravelLengthZ = -(awPulsesIn(1)-1500)/4
	    TravelRotationY = -(awPulsesIn(3)-1500)/12
	  ENDIF
	
	  ;Body move	
	  IF (ControlMode=TranslateMode) THEN	
	    BodyPosX = (awPulsesIn(2)-1500)/10
	    BodyPosZ = (awPulsesIn(1)-1500)/8
	    BodyRotY = (awPulsesIn(3)-1500)/20
	  ENDIF		
		
	  ;Body rotate	
	  IF (ControlMode=RotateMode) THEN	
	    BodyRotX = (awPulsesIn(1)-1500)/20
	    BodyRotY = (awPulsesIn(3)-1500)/20
	    BodyRotZ = -(awPulsesIn(2)-1500)/20
	  ENDIF
	
	  ;Single Leg Mode
	  IF (ControlMode = SingleLegMode) THEN
	    SLLegX = (awPulsesIn(2)-1500)/5
	    SLLegZ = -(awPulsesIn(1)-1500)/5
	    SLLegY = -(awPulsesIn(3)-1500)/20
	  ENDIF
	  
	  IF (ControlMode = GPPlayerMode & Buttons>=1 & Buttons<=9 & Buttons<>LastButtons) THEN	;1-9 Button Play GP Seq
	    IF (GPStart = 0) THEN
	      GPSEQ = Buttons-1
	    ENDIF
	    GPStart = 1
	  ENDIF
	
	  ;Calculate walking time delay
	  InputTimeDelay = 128 - (ABS((awPulsesIn(1)-1500)/4) MIN ABS(((awPulsesIn(2)-1500)/4))) MIN ABS(((awPulsesIn(3)-1500)/6)) + (128 -(awPulsesIn(4)-1010)/8)
	ENDIF
  ENDIF
  
  LastButtons = Buttons
return	
;------------------------------------------------------------------- 
;[Pulsein7] Read in all 7 servo values in one pass.
Pulsein7: 
    ; Make sure all 7 IOs are set to input. 
    PMR5 = 0 ; all IO lines are general IO 
    PCR5 = 0 ; All are input  (may want to leave bit 7 alone... 
    
    ; Ok now lets transisiton to assembly language. 
    ; 
;    bMask = 0x7f                      ; set a mask of which bits we are needing... 
;                                 ; Mask could be 0xFE for pins 1-7, need to make array 8 not 7 
    mov.b   #0x7f, r1l                  ; Ok R1l will be our mask for outstanding IO port bytes. 

    ; wait until none of the IO lines are high... 
;    while PDR5 & bMask 
;        ; 
;    wend 
   mov.l   #250000,er2                  ;(4) - setup timeout counter    
_PI7_WAIT_FOR_ALL_LOW: 
   mov.b   @PDR5:8, r0l 
   and.b   r1l, r0l         ; see if any of the IO bits is still on... 
   beq      _PI7_WAIT_FOR_NEXT_IO_TO_GO_HIGH:8   ; all zero go to wait for one to go high... 
   dec.l   #1,er2                     ;(2)    
   bne      _PI7_WAIT_FOR_ALL_LOW:8   ; an IO pin is high and we have not timed out, keep looping until none are high 
   ; We timed out waiting for all inputs to be low, so error out... 
   bra      _P17_RETURN_STATUS:16         ; will return status that all timed out... 

;    while bMask    

_PI7_WAIT_FOR_NEXT_IO_TO_GO_HIGH: 
   mov.l   #250000,er2                  ;(4) - setup timeout counter 
    
_PI7_WAIT_FOR_NEXT_IO_TO_GO_HIGH2: 
        ; we still need some 1 or more of the pulses... 
;        while (PDR5 & bMask) = 0          ; waiting for a pulse to go high. 
   mov.b   @PDR5:8, r0l               ;(4) 
   and.b   r1l, r0l                  ;(*2) see if any of the IO bits is still on... 
   bne      _P17_IO_WENT_HIGH:8            ;(*4) One went high so go process 
   dec.l   #1,er2                     ;(2)    
   bne      _PI7_WAIT_FOR_NEXT_IO_TO_GO_HIGH2:8   ; (4) Not a timeout go try again. 
; we timed out... 
   bra      _P17_RETURN_STATUS:16         ; will return status of what timed out... 
    
;      wend 
;        iPin = ???; TBD: convert which bit is high to IO line number 0-6 
;   see which bit is on in the mask 
_P17_IO_WENT_HIGH: 
   xor.w   r2,r2                     ;(*2) 
   xor.b   r0h, r0h                  ;(*2) 
   mov.l   #AWPULSESIN,er3               ;(*6) 
_P17_WHICH_BIT_LOOP:    
   shlr.b   r0l                        ;(@2) 
   bcs      _P17_WHICH_BIT_LOOP_DONE:8      ;(@4) 
   inc.b   r0h                        ;(@2) 
   inc.l   #2, er3                     ;(@2)  - point to the next place in the array. 
   add.w   #18,r2                     ;(@4)  - we do 18 clocks for each pass through this loop 
   bra      _P17_WHICH_BIT_LOOP:8         ;(@4) 
_P17_WHICH_BIT_LOOP_DONE: 
;        bMaskBit = 1 << iPin   ; get the mask for which pin... 
   xor.b   r1h,r1h                     ;(*2) 
   bset.b   r0h,r1h                     ;(*2) ok we have the mask 
   bclr.b   r0h,r1l                     ;(*2) and clear it from our global mask of ones we are waiting for 

                                 ; = (22) - count so far of clocks after went high 
    
;       iPinLoopCnt = 0          ; This may be replaced with time calculations... 
;        while (PDR5 & bMaskBit) 
;            iPinLoopCnt = iPinLoopCnt + 1  ; how long until it goes low again 
;        wend 
_P17_WAIT_FOR_IO_GO_BACK_LOW: 
   mov.b   @PDR5:8, r0l               ;(#4) 
   and.b   r1h, r0l                  ;(#2) 
   beq      _P17_IO_WENT_BACK_LOW:8         ;(#4) 
   add.w   #18,r2                     ;(#4) - number of cyles per loop 
   bcc      _P17_WAIT_FOR_IO_GO_BACK_LOW:8   ;(#4) 
    
   ; we had a timeout return the status. 
   bset.b   r0h, r1l                  ; turn back on the bit we were waiting for... 
   bra      _P17_RETURN_STATUS:8         ; 

_P17_IO_WENT_BACK_LOW: 
   ; need to calculate the pulse width in ms... need to divide calculated clocks by 16 
   add.w   #22,r2                     ; (4) ; need to add the rest of the overhead(*-1 loop above) in... 
   shlr.w   r2                        ; (2) 
   shlr.w   r2                        ; (2) 
   shlr.w   r2                        ; (2) 
   shlr.w   r2                        ; (2) / 16 (for clock speed) 
    
;        aPulses(iPin) = iPinLoopCnt ; convert loop count to pulse width... 
   mov.w   r2,@er3                     ; Save away the value 
    
 ;       bMask = bMask & ~bMaskBit    ; turn off waiting for this one... 
    or      r1l,r1l                     ; (2) see if we are done or not 
;     wend 
   bne      _PI7_WAIT_FOR_NEXT_IO_TO_GO_HIGH:16 ;(6)our mask has not gone to zero so wait for the next one. 
    
_P17_RETURN_STATUS:    
   mov.b   r1l,@BPULSETIMEOUT 
; finally transisition back to basic and return. 
return 
;--------------------------------------------------------------------