//========================================================================================
//   NOM:      lcd.c                                                                      
//   Date:     11/10/2003                                                                     
//   Version:  1.11                                                                       
//   Circuit:  circuit final Scope  /  Afficheur LCD graphique + Clavier matric                                 
//   Auteur:   SJ                                                                          
//   Micro:    PIC16F877  24MHz -> tcycl = 0.1666 us (1/6 us)                                                                             
//========================================================================================
#include	"lcd.h"
extern unsigned char lcd_x, lcd_y, lcd_z;

static bit tmpGIE;						// flag pour GIE
#define FLAG_GIE_SAVE tmpGIE = 0;if (GIE) tmpGIE = 1;GIE = 0;
#define FLAG_GIE_REST if (tmpGIE) GIE = 1;
// SAVE+REST = 7 ROM

//========================================================================================
// (essayer de passer sur 7bits!!!!)
// table de caracteres Font 5x7  (95x5octets = 475 octets)
//========================================================================================
#include "font5x7.c"		

#define	XTAL_FREQ	16MHZ	

volatile unsigned char touche;
unsigned char tmp1; // pour asm (DS1627)

//========================================================================================
/* Temporisation I2C */
DelayMs(unsigned char cnt){
	TEMPO(); TEMPO();
}

/*
DelaySec(char sec){
	char loop;
	for(loop=0;loop<=(sec<<2);loop++) DelayMs(250); // sec*4
}*/


//========================================================================================
tempo_x65ms(unsigned char nbr){
	unsigned char tmp1b, tmp2, tmp3; // tmp1=255: 65ms     
	for(tmp3=nbr;tmp3>0;tmp3--){
		for(tmp1b=255;tmp1b>0;tmp1b--)
			for(tmp2=255;tmp2>0;tmp2--)asm("nop");
	}
}

//========================================================================================
/* Temporisation pour le LCD */
// 513us (asm:579.25us (2317 cycles)) 16MHz
//========================================================================================
TEMPO(void){
	unsigned char tmp1b, tmp2; // tmp1=2: 512.75us     
	for(tmp1b=2;tmp1b>0;tmp1b--)
		for(tmp2=255;tmp2>0;tmp2--)asm("nop");
}

DELAY500(void){					// tempo 125us (500/4)
	unsigned char tmp;
	for(tmp=125;tmp>0;tmp--)asm("nop");
}

X_DELAY500(unsigned char val){	// val * 125us
	unsigned char tmp;
	for(tmp=val;tmp>0;tmp--) DELAY500();
}


//========================================================================================
// initialise le LCD 
//========================================================================================
lcd_init_both(unsigned char yMax){
	lcd_right();
	lcd_init(yMax);
	lcd_left();								// LCD initialis ligne 0, colonne 0, Z=0, cot gauche
	lcd_init(64);
}

lcd_init(unsigned char yMax){			// yMax = 63 : effacement total
	unsigned char x, y;
	lcd_disp_on_off(1);					// display ON
	lcd_startZ(0);
	for(x=8; x!=0; x--){				
		lcd_pageX(x);
		lcd_addressY(0);					
		for(y=yMax; y!=0; y--){		
			lcd_putdata(0);	
		}		
	}
	lcd_addressY(0);
	lcd_pageX(0);
}

//========================================================================================
// envoie une commande au LCD 
//========================================================================================
lcd_putcmd(unsigned char cmd){
	FLAG_GIE_SAVE;
	lcd_busy(); 							//			while(lcd_busy());				 
	LCD_TRIS 	= 0x00;					// out
	LCD_RS_DI	= 0; 
	LCD_R_W		= 0;
	LCD_DATA		= cmd;	
	lcd_strobe();
	FLAG_GIE_REST;
}

//========================================================================================
// lit l'tat du LCD 
//========================================================================================
/*unsigned char
lcd_status(void){
	unsigned char stat;
	//FLAG_GIE_SAVE;
	LCD_TRIS 	= 0xFF;					// in
	LCD_RS_DI	= 0; 
	LCD_R_W		= 1;
	LCD_EN 		= 1;
	asm("nop");
	asm("nop");
	stat			= LCD_DATA;	
	LCD_EN 		= 0;
	//FLAG_GIE_REST;
	return stat;
}*/

//========================================================================================
// envoie une donne au LCD 
//========================================================================================
lcd_putdata(unsigned char data){
	FLAG_GIE_SAVE;
	lcd_busy(); 							//			while(lcd_busy());
	LCD_TRIS 	= 0x00;					// out 
	LCD_RS_DI	= 1; 
	LCD_R_W		= 0;
	LCD_DATA		= data;	
	lcd_strobe();
	FLAG_GIE_REST;
}

//========================================================================================
// lit une donne du LCD 
//========================================================================================
unsigned char
lcd_getdata(void) {
	unsigned char data;
	FLAG_GIE_SAVE;
	lcd_busy(); 							//			while(lcd_busy());		 
	LCD_TRIS 	= 0xFF;					// in
	LCD_RS_DI	= 1; 
	LCD_R_W		= 1;
	LCD_EN 		= 1;
	asm("nop");								// 450ns min
	asm("nop");
	asm("nop");
	data			= LCD_DATA;	
	LCD_EN 		= 0;
	FLAG_GIE_REST;
	return data;
}

//========================================================================================
// busy	LCD 
//========================================================================================
lcd_busy(void){
	unsigned char stat;

	if ((!LCD_CS1)&&(!LCD_CS2)) LCD_CS1 = 1;	
		// danger si CS1 et CS2 dsactivs -> blocage while(lcd_busy);

	//FLAG_GIE_SAVE;
	LCD_TRIS 	= 0xFF;					// in
	LCD_RS_DI	= 0; 
	LCD_R_W		= 1;


	//busy_lbl:
	
	do{
		LCD_EN 		= 1;
		asm("nop");
		asm("nop");
		stat			= LCD_DATA;	
		LCD_EN 		= 0;
		//FLAG_GIE_REST;
		//return stat;
		
		//while(lcd_status()&0x80);
	} while(stat&0x80);
	//if (stat&0x80) goto busy_lbl;	
}

//========================================================================================
// display ON/OFF     LCD 		1:ON  0:OFF
//========================================================================================
lcd_disp_on_off(unsigned char disp){
	lcd_putcmd(0x3E | (disp & 0x01) );
}

//========================================================================================
// set Y adresse		LCD 		position horizontale [0-63]  (auto-incrmente  chaque
// 																			lecture/criture)
//========================================================================================
lcd_addressY(unsigned char adr){
	lcd_putcmd(0x40 | (adr & 0x3F) );
}

//========================================================================================
// set X page			LCD 		position verticale [0-7] (par paquets de 8)
//========================================================================================
lcd_pageX(unsigned char adr){
	lcd_putcmd(0xB8 | (adr & 0x07) );
}

//========================================================================================
// set start line		LCD 		position Z vertical [0-63] (scrolling?)
//========================================================================================
lcd_startZ(unsigned char adr){
	lcd_putcmd(0xC0 | (adr & 0x3F) );
}


//========================================================================================
//   LCD fonctions de positionnement
// Va a la position specifiee  (posX[0-7], posY[0-127])
//    __________           posY -->  
//   |          |  posX |  
//   |__________|      \-/
//========================================================================================
lcd_goto(unsigned char posX, unsigned char posY){
	if (posY<64)	{lcd_left();}			// [0-127]   en 1er en cas de chgt de page !!!
	else				{lcd_right();}			// (posY-64) masquage dans addressY Utile???
			
	lcd_pageX(lcd_x = posX);				// [0-7]   positionne la page (ligne%8)
	lcd_addressY(lcd_y = posY);			// [0-127] positionne la colonne
}

//========================================================================================
// gre les compteur lcd_x, lcd_y (LCD)
//========================================================================================
lcd_compteur(void){
	lcd_y++;
	if ((lcd_y>=64)&&(!LCD_CS2)) {
			lcd_right();								// change de cote
			lcd_pageX(lcd_x);
			lcd_addressY(lcd_y);						// lcd_addressY(lcd_y-64); inutile masquage
	}
	if (lcd_y==128)	lcd_pageX(lcd_x++);		// ligne suivante
	if (lcd_x>=8)	{
		lcd_left();
		lcd_pageX(lcd_x = 0);						// ligne 0
		lcd_addressY(lcd_y = 0);					// colonne 0
	}
}

//========================================================================================
// affiche un demi-bitmap sur le LCD  
//========================================================================================
lcd_half_bitmap(void){
	signed char x, y;
	lcd_x = 0;	lcd_y = 0;

	for(x=7; x>=0; x--){
		lcd_pageX(lcd_x);
		lcd_addressY(0);
		for(y=63; y>=0; y--){
			lcd_putdata(i2c_read(1));					// lecture continue I2C bitmap	
		}
	lcd_x++;
	}
}

//========================================================================================
// affiche un bitmap sur le LCD
//  n image (128*64)  0     1     2   ..  31
//  nbImage           0x00  0x04  0x08     0x7C
//  1024 = 2^10 soit 32 images (128*64) ou 128 images (32*32)
//========================================================================================
lcd_bitmap(unsigned char nbImage){
	
bmp_start:
	i2c_start();
	if(!i2c_write(0xa0)) goto bmp_start;			// adresse sur 15 bits
	i2c_write((nbImage)&0x7F);							// x6543210		 adr MSB = 0
   i2c_write(0);											// adr LSB  
   i2c_repStart();
	if(!i2c_write(0xa1)) goto bmp_start;
	
	//lcd_clear();											// efface le LCD  
	//  >>> amelioration : initialisation ligne, colonne dans lcd_half_bitmap(..) 
	//  ecrasement de l'image affiche par le bitmap	//lcd_clear();											// efface le LCD  
/*	//  >>> amelioration : initialisation ligne, colonne dans lcd_half_bitmap(..) <<<
	lcd_left();												// lcd cote gauche
*/
	//  <<<
	lcd_left();												// lcd cote gauche
	lcd_half_bitmap();									// demie-image cote gauche
	lcd_right();											// lcd cote droit
	lcd_half_bitmap();									// demie-image cote droit
	i2c_read(0);											// nack pour fin de transfert
	i2c_stop();												// stop bus i2c
	//lcd_x = 8;												// mj coordonnes LCD ??
	//lcd_y = 128;
}

//========================================================================================
// ecrit un caractre sur le LCD  
//========================================================================================
lcd_putchar(unsigned char c){
	//	FONT_MIN = 32 -esp- 20				// 5 octets par caractre
	// FONT_MAX = 126  ~ - 7E			
	unsigned char cpt;
	unsigned int index;
	if ((c<FONT_MIN)||(c>FONT_MAX)) c='?';		
	index = (c-FONT_MIN)*5;					// *5=*(4+1)= <<2 +1
	for(cpt=5; cpt>0; cpt--){
		lcd_putdata(ascii[index++]);
		lcd_compteur();
	}
	lcd_putdata(0);							// 1 colonne vide (espace inter caractres)
	lcd_compteur();
}

//========================================================================================
// ecrit une string de caracteres sur le LCD 
//========================================================================================
lcd_puts(const char * s){
	while(*s) lcd_putchar(*s++);
}

//========================================================================================
// Ecrit une string au coordonnees ligne[0-7], colonne [0-127]
//========================================================================================
lcd_string_loc_lc(const char *s, unsigned char ligne, unsigned char colonne){
	lcd_goto(ligne, colonne);	
	lcd_puts(s);
}

//========================================================================================
// convertit un nombre hexadecimal en ascii
//========================================================================================
unsigned char
hexa2ascii(unsigned char tmp){
	tmp += 0x30;
	if (tmp>0x39) tmp+=7;
	return tmp;
}

//========================================================================================
// ecrit un nombre en hexa sur le LCD 
//========================================================================================
lcd_hexa(unsigned char c){
	lcd_putchar( hexa2ascii(c >> 4) );
	lcd_putchar( hexa2ascii(c & 0x0F) );
}

//========================================================================================
// lcd_uchar : affiche un unsigned char
//========================================================================================
lcd_uchar(const char *str, unsigned char ligne, unsigned char col, unsigned char val){
	unsigned char tmp;
	///###lcd_string_loc_lc(str, ligne, col);
	lcd_goto(ligne, col);	
	lcd_puts(str);

	tmp = val;
	lcd_putchar(val/100 + 0x30);
	val = val%100;
	lcd_putchar(val/10 + 0x30);
	lcd_putchar(val%10 + 0x30);
}

//========================================================================================
// Fonctions graphiques : point(on/off), ligne, rectangle(fill on/off), cercle(fill on/off)
// plot : a ameliorer
//========================================================================================
lcd_plot(unsigned char posX, unsigned char posY, unsigned char fill){
	unsigned char tmp, tmp2;
	lcd_goto(posX>>3, posY);					// /8  ;  position en pixel et non en pageX
	lcd_getdata();									// dummy access
	tmp = lcd_getdata();							// read data
	tmp2 = 1<<(posX & 0x07);					// posX%8		// ROTATION INEFFICACE EN 'C' bcf 0
	tmp &= ~tmp2;									// masquage ex : 0b1111x111
	if (fill) {
		tmp |= tmp2;								// forcage  ex : 0byyyy1yyy
		lcd_goto(posX>>3, posY);				// /8	 ;  position en pixel et non en pageX
		lcd_putdata(tmp);
	}
}

//========================================================================================
// plot 8 pixels ON
//========================================================================================
lcd_plot_8(unsigned char posX, unsigned char posY){
	lcd_goto(posX>>3, posY);					// /8  ;  position en pixel et non en pageX
	lcd_putdata(0xFF);
}

//========================================================================================
// ligne LCD  :  x1, y1, x2, y2
// ROM + 179
//========================================================================================
/*
signed char
abs_char(signed char a) {
	if(a < 0) return -a;
	return a;
}

void  
lcd_line(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2) {
	unsigned char x, y;
	signed char a, c;
	signed int b;
	
	a = y1-y2;
	b = x1*y2-y1*x2;
	c = x1-x2;
	
	if ((c==0) || (a==0)) return;				// ligne horizontale / verticale
	
	if (c==0) {
		if (y1>y2) { a=y1; b=y2; }
		else { a=y2; b=y1; }
		lcd_line_H(x1, 1, b, a);	//x1,1,y1,y2 sens ??? 1 / -1
		return;
	}
	if (a==0) {
		if (x1>x2) { a=x1; b=x2; }
		else { a=x2; b=x1; } 
		lcd_line_V(y1, 1, b, a);	//y1,1,x1,x2 sens ??? 1 / -1
		return;
	}
	
	if (abs_char(c) >= abs_char(a)) {		// Delta x > Delta y
		for(x=x1; x<=x2; x++){
			y = (a*x+b)/c;
			lcd_plot(x, y, 1);
		}	
	}
	else {											// Delta y > Delta x
		for(y=y1; y<=y2; y++){
			x = (y*c-b)/a;
			lcd_plot(x, y, 1);
		}	
	}
}
*/
//========================================================================================
// ligne horizontale LCD  :  y1, y2
//========================================================================================
lcd_line_H(unsigned char xref, unsigned char ypas, unsigned char y1, unsigned char y2){
	unsigned char y;
	for(y=y1; y<=y2; y += ypas){
		lcd_plot(xref, y, 1);
	}	
}

//========================================================================================
// ligne verticale LCD  :  x1, x2  // a ameliorer ou #define lcd_lineV lcd_lineH
// 	utiliser lcd_plot8 si xpas == 1;
//========================================================================================
lcd_line_V(unsigned char yref, unsigned char xpas, unsigned char x1, unsigned char x2){
	unsigned char x;
	for(x=x1; x<=x2; x+=xpas){
		lcd_plot(x, yref, 1);
	}	
}

//========================================================================================
// grille scope  10*8 /////////Pb debordement cf call-graph///// A REVOIR 2 points en trop
//========================================================================================
//###############DEBORD
lcd_grille(void){
	signed char tmpY, pasY;
	//unsigned char x; // lcd_line_V + H
	for(tmpY=84; tmpY>=20; tmpY-=8) {		// 92 12 -8
		if (tmpY!=52)	pasY = 8;
		else 				pasY = 4;
		lcd_line_V(tmpY, pasY, 0, 63);		// 10 lignes
		//for(x=0; x<=63; x+=pasY){
		//	lcd_plot(x, tmpY, 1);
		//}	
	}
	lcd_line_H(32, 4, 12, 92);					// Xref, pasY, y1, y2
	//for(x=12; x<=92; x += 4){	//y
	//	lcd_plot(32, x, 1);		//y
	//}	
	////lcd_rect(0,12, 63, 92);	
	lcd_line_H(0, 1, 12, 92);
	lcd_line_H(63, 1, 12, 92);
	lcd_line_V(12, 1, 0, 63);
	lcd_line_V(92, 1, 0, 63);
}

//========================================================================================
// rectangle (coin bas gauche, coin haut droit)
//========================================================================================
lcd_rect(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2){
	lcd_line_H(x1, 1, y1, y2);
	lcd_line_H(x2, 1, y1, y2);
	lcd_line_V(y1, 1, x1, x2);
	lcd_line_V(y2, 1, x1, x2);
}

//========================================================================================
// sinus = 32*sin(PI/2*alpha/32)
// cosinus = 32*cos(PI/2*alpa32)
//========================================================================================
/*
const char sinTab[33] = {0,2,3,5,6,8,9,11,12,14,15,17,18,19,20,22,23,24,25,
									26,27,27,28,29,30,30,31,31,31,32,32,32,32};

//{0,13,25,37,50,62,74,86,98,109,120,131,142,152,162,171,180,189,
//197,205,212,219,225,231,236,240,244,247,250,252,254,255,255};


signed char
sin32(unsigned char alpha){
	if (alpha<=32) return sinTab[alpha];
	if (alpha<=64) return sinTab[64-alpha];
	return 0;
}

signed char
sinus(signed char alpha){
	if (alpha<0) return -sin32(-alpha);	
	else return sin32(alpha);
}

signed char
cos32(unsigned char alpha){
	unsigned char tmp;
	tmp = sinTab[32-alpha];
	if (alpha<=32) return tmp;
	if (alpha<=64) return -tmp;
	return 0;	
}

signed char
cosinus(signed char alpha){
	if (alpha<0) return cos32(-alpha);
	else return cos32(alpha);
}

//========================================================================================
// Cercle de centre (posX, posY)
//		Rayon   32  16  8  4
//		d       1    2  3  4
//========================================================================================
cercle(unsigned char posX, unsigned char posY, unsigned char d){
	signed char a;
	for(a=-32; a<=32; a++){
		lcd_plot(posX+cosinus(a)/d, posY+sinus(a)/d,1);			// bas
		lcd_plot(posX-cosinus(a)/d, posY-sinus(a)/d,1);			// haut
	}
}

//========================================================================================
// from HD61202.c
//    Author:     Gregor Horvat                                           
//    www:     		http:\\www.silon.si\grega\index.html                  
//    email:     	grega@silon.si                                         
//========================================================================================
void 
lcd_cercle(unsigned char cx, unsigned char cy, unsigned char radius){
	int tswitch;
	unsigned char y, x = 0;
	char d; // ???

	d = cy - cx;
	y = radius;
	tswitch = 3 - 2 * radius;
	while (x <= y) {
		lcd_plot(cx + x,		cy + y, 1);
		lcd_plot(cx + x,		cy - y, 1);
		lcd_plot(cx - x,		cy + y, 1);     
		lcd_plot(cx - x,		cy - y, 1);
		lcd_plot(cy + y - d, cy + x, 1); 
		lcd_plot(cy + y - d, cy - x, 1);
		lcd_plot(cy - y - d, cy + x, 1); 
		lcd_plot(cy - y - d, cy - x, 1);

		if (tswitch < 0) tswitch += (4 * x + 6);
		else {
			tswitch += (4 * (x - y) + 10);
			y--;
		}
		x++;
	}
}

*/

//========================================================================================
// Curseur du trigger
//========================================================================================
lcd_trig(unsigned char val){
	unsigned char pos, posX;
	// efface le curseur
	for(posX=8; posX!=0; posX--){
		lcd_goto(posX, 10);
		lcd_putdata(0x00);								// col 10
		lcd_putdata(0x00);								// col 11
	}
	
	if (val>4)	pos = 62-(val>>2);	
	else pos = 62;
	lcd_plot(pos ,11 ,1);								// 93
	lcd_plot(pos+1, 10, 1);								// 94
	lcd_plot(pos-1, 10, 1);								// 94
}

//========================================================================================
// Curseur debuts canaux A+B
//========================================================================================
lcd_start_ch(unsigned char nbCanal){
	unsigned char pos;

	if ((nbCanal!=0) && (!bit_chb_off)) {		// 2CH voie B on
		pos = convert_lcd(CHB, 1);						// index 1
		lcd_string_loc_lc("B", pos>>3, 0);
	}
	
	pos = convert_lcd(CHA, 1);							// index 1	
	lcd_string_loc_lc("A", pos>>3, 5);
}

//========================================================================================
//  DS1267 (S10) : potentiometre numerique 256 positions  (CLK = 10MHz max)
//   Trame : stack select bit, D7-D0 potA, D7-D0 potB
//========================================================================================
ds1267(unsigned char potA, unsigned char potB){
	unsigned char cpt;
	TRISD = DS_TRIS;						// output portD
	DS_CLK = 0;//?
	
	DS_RST = 1;								// start transfert
	DS_DQ = 0;								// stack select bit = 0 (ou 1)
	asm("nop");	asm("nop");	asm("nop");
	DS_CLK = 1;
	asm("nop");	asm("nop");	asm("nop");
	DS_CLK = 0; 
	asm("nop"); asm("nop");	asm("nop");

	tmp1 = potA;							// potentiometre A
	for(cpt=8; cpt>0; cpt--){
		#asm
			btfss	_tmp1,7		; //,0 teste le bit
			bcf DS_DQ_asm		; DQ = 0
			btfsc	_tmp1,7		; //,0
			bsf DS_DQ_asm		; DQ = 1
			rlf	_tmp1,f		; //rrf
		#endasm
		asm("nop"); asm("nop");
		DS_CLK = 1;							// strobe
		asm("nop"); asm("nop");	asm("nop");
		DS_CLK = 0;
		asm("nop"); asm("nop");
	}

	tmp1 = potB;							// potentiometre B
	for(cpt=8; cpt>0; cpt--){
		DS_CLK = 0;
		#asm
			btfss	_tmp1,7		; //,0 teste le bit
			bcf DS_DQ_asm		; DQ = 0
			btfsc	_tmp1,7		; //,0
			bsf DS_DQ_asm		; DQ = 1
			rlf	_tmp1,f		; //rrf		
		#endasm
		asm("nop"); asm("nop");
		DS_CLK = 1;							// strobe
		asm("nop");	asm("nop");	asm("nop");
	}
	DS_RST = 0;
	DS_CLK = 0;
}

//========================================================================================
// commutation pour max114
//========================================================================================
commut_114(unsigned char canal){
	unsigned char tmp;
	ADC = 1;									// max114 HZ
	OC = 1;									// latch 573 HZ
	LCD_EN	= 0;							// bloque lcd // ?
	CAN_TRIS = 0xFF;						// input sur bus

// ANA_CHA = 0 ... ANA_CHD = 3	
	tmp = 3 - canal;
	CAN_A0 = tmp & 0x01;			//&& ??? warning -W-3   +5 compilation!
	CAN_A1 = tmp >> 1;; 	
}

//========================================================================================
// 1 mesure ana 1 canal
//========================================================================================
unsigned char
ana_114(unsigned char canal){
	unsigned char val;
	commut_114(canal);
	ADC = 0;
	asm("nop"); 
	ADC = 1;																		// mesure 
	asm("nop"); asm("nop");asm("nop");asm("nop");					// min 610ns
	ADC = 0;	
	asm("nop"); 
	val = CAN_PORT;															// lit mesure n-1
	ADC = 1;																		// libere le portD
	return val;
}

//========================================================================================
// trigger avec timeout
//========================================================================================
unsigned char
ana_trig(unsigned char canal, unsigned char trigger, unsigned char front, 
			unsigned int tempo, unsigned char timeout){
	unsigned char val1, val2, tmr0H;	

	// timeout sur timer 0	:	tmr0H * 10ms
	tmr0H = timeout;	

	ana_114(canal); 

	if (trigger==0) return 0;								// pas de trig.

	TMR0 = 0;								// remonter ???
	OPTION = OPTION_TMR0;

	// 1 mesure toutes les div/8 pour trigger le signal

	do{
		ADC = 0;
		asm("nop");
		val1 = CAN_PORT;
		ADC = 1;

		// tempo xx us		(6.25us a 2500us) - 5.1666us acquisition
		// initialisation TMR1(tempo);	// prescaler 1 -> 0-65535*tcyc = 0-10922.5us
		TMR1H = tempo >> 8;																	// +2		(23)
		TMR1L = tempo & 0x00FF;																// +2		(25)
		T1CON = 0b00000001;					// presc 1:1 osc/4 stop timer1 on	// +2		(27)
		while(TMR1H != 0); 																	// + xx us +3 (30)
		TMR1ON = 0;								// stop timer1								// +1		(31)
	
		if (T0IF)	{							// toutes les 10ms
			tmr0H--;
			T0IF = 0;
			///OPTION = OPTION_TMR0;
			//############ Test clavier Rapide : si touche -> return 0;
			CLAV_DATA = 0x0F;						// 4 diodes lignes D0, D1, D2, D3
			asm("nop"); asm("nop");
			TRISD = TRIS_CLAV; 
			if ((CLAV_DATA & 0x70)||RCIF) {				// + RCIF ? pour rs232
				TRISD = 0xFF;
				return 0;	// si colonne D4, D5 ou D6 -> touche enfoncee !
			}
			TRISD = 0xFF;							// input
			//#############
		}

		ADC = 0;
		ADC = 1;
		
		ADC = 0;
		asm("nop");
		val2 = CAN_PORT;
		ADC = 1;

		if (front == TRIG_DOWN){								// front descendant														
			if ((val2<trigger)&&(val1>trigger)) return 1;	// detecte
		}
		else{															// front montant
			if ((val2>trigger)&&(val1<trigger)) return 1;	// detecte
		}

		// test T0IF

	}while(tmr0H);
	return 0;
}

//========================================================================================
// Affiche AC / DC sur le lcd
//========================================================================================
lcd_ac_dc(unsigned char etat){
	if (etat)	lcd_puts("dc");
	else			lcd_puts("ac");	
}

//========================================================================================
// lecture log8 (8 entrees logiques)
//========================================================================================
unsigned char
read_log8(void){
	unsigned char val;
	ADC = 1;									// max114 HZ
	OC = 1;									// latch 573 HZ
	LCD_EN	= 0;							// bloque lcd		// ?
	LOG_TRIS = 0xFF;						// input sur bus
	
	OC = 0;									// read 573 
	asm("nop");asm("nop");asm("nop");asm("nop");
	val = LOG_PORT;
	OC = 1;									// latch 573 HZ : libere le port
	return val;
}

//========================================================================================
//  CLAVIER
//  Renvoie le numero de touche appuyee dans 'touche' et dans w (2.33ms 9331 c)
//========================================================================================
unsigned char
clavier(void){ 
	// #debug
	if (RCIF) {
		touche = rx232();
		if (touche>='1') { //&&(touche<='<')) {
			tx232(touche);	
			return (touche-'0');	// -48
		// '1' -> 1, ..., '9' -> 9, ':' -> 0, ';' -> *, '<' -> #  	
		}
	}
	FLAG_GIE_SAVE;
	TRISD = TRIS_CLAV;
	CLAV_DATA = 0x01;	//D0
	TEMPO();
#asm
	clrf	_touche			; touche = 0
	movlw	0			; aucune touche
	btfsc	CLAV_PORT,4	; bp 1
	movlw	1
	btfsc	CLAV_PORT,5	; bp 2
	movlw	2
	btfsc	CLAV_PORT,6	; bp 3
	movlw	3
	movwf	_touche			; sauvegarde touche
#endasm
	CLAV_DATA = 0x02;	// D1
	TEMPO();
#asm
	movf	_touche,w		; restauration touche
	btfsc	CLAV_PORT,4	; bp 4
	movlw	4
	btfsc	CLAV_PORT,5	; bp 5
	movlw	5
	btfsc	CLAV_PORT,6	; bp 6
	movlw	6
	movwf	_touche			; sauvegarde touche
#endasm
	CLAV_DATA = 0x04;	// D2
	TEMPO();
#asm
	movf	_touche,w		; restauration touche
	btfsc	CLAV_PORT,4	; bp 7
	movlw	7
	btfsc	CLAV_PORT,5	; bp 8
	movlw	8
	btfsc	CLAV_PORT,6	; bp 9
	movlw	9
	movwf	_touche			; sauvegarde touche		
#endasm
	CLAV_DATA = 0x08;	// D3
	TEMPO();
#asm
	movf	_touche,w		; restauration touche
	btfsc	CLAV_PORT,4	; bp *
	movlw	11
	btfsc	CLAV_PORT,5	; bp 0
	movlw	10
	btfsc	CLAV_PORT,6	; bp #
	movlw	12
	movwf	_touche
#endasm
	CLAV_DATA = 0;
///	TRISD = TRIS_NORM;
	TRISD = 0xFF;		// all input
	FLAG_GIE_REST;
	return touche;
}

//========================================================================================
// antirebond touche x
//========================================================================================
clavier_antirebond(unsigned char touche){
	while(clavier()==touche); 								// antirebond 2 passes
	tempo_x65ms(1);											// pause 43ms
}			
	
//========================================================================================
// Entree analogique  Mode 8 bits (justify)
//   Renvoie la tension d'alim 12V 
//========================================================================================
unsigned char
ana12(void){ 
	unsigned char volt;
	ADGO = 1;
	while(ADGO);
	volt = ADRESH + (ADRESH>>3);	// volt = ADRESH*(1+1/8)
	return volt;	
}

//========================================================================================
//  Port Serie RS232   8bits, no parity, 1 bit de stop 
//========================================================================================
init232(char debit){
	// Baud Rate = Fosc/(16(SPBRG+1))
	SPBRG = debit;   					
	// 103 : 9600bds, 51 : 19200bds, 16 : 57600bds, 8: 115kbds, 255 : 1Mbps!!! pour 16MHz
	// 155 : 9600bds, 77 : 19200bds, 25 : 57600bds, 12 : 115kbds pour 24MHz
	TXSTA = 0b00100100;//0b10100100;     		// Asynchronous, 8bits, TXEN, Asynchronous, High speed
	RCSTA = 0b10010000;				// SPEN : enable port, CREN : reception continue
	rx232();								// correction bug bootloader (sinon port bloque ?)
}

tx232(char val){
	while(TRMT==0); 					// attendre que le tampon soit vide
	TXREG = val;						// emet le caractere
}

char
rx232(void){
  unsigned char tmp; // #### UTILE ??? cf doc MidRange
	if (OERR==1) { 					//overrun Error
		CREN = 0;
		CREN = 1;
		tmp = RCREG;
	}
	RCIF = 0;							// reset flag ISR
	return RCREG;						// retourne le caractere recu
}

// ecrit une string de caracteres sur le port serie
tx232_puts(const char * s){
	while(*s)
		tx232(*s++);
}
 
/*// detection de reception
char
rx232_detc(void){
	while(!RCIF);
	return rx232();
}*/

// ecrit 2 caracteres ascii
tx232_2ascii(unsigned char car){
	tx232(hexa2ascii(car >> 4));
	tx232(hexa2ascii(car & 0x0F));
}


//========================================================================================
// LECTURE d'un octet dans l'EEPROM 
//========================================================================================
unsigned char
readEE(unsigned char adr){
	//return EEPROM_READ(adr);	// bug -W-3 no effect !!
	EEADR = adr;							// selectionne la bonne adresse
	EEPGD = 0;								// memoire donnees
	RD = 1;									// commence la lecture
	return EEDATA;							// renvoie l'octet lu-
}

//========================================================================================
// ECRITURE d'un octet dans l'EEPROM 
//========================================================================================
writeEE(unsigned char adr, unsigned char data){
	//EEPROM_WRITE(adr, data);			// avec blocage ISR + remise en route ISR
	/*//char tmp;
	if (GIE==1) CARRY = 1; 				// tmp = 1;
	else CARRY = 0;						// tmp = 0;
	while (WR==1);							// attend la fin de l'ecriture precedante
	EEADR = adr;							// selectionne la bonne adresse
	EEDATA = data;							// donnee a ecrire
	EEPGD = 0;								// memoire donnees
	WREN = 1;								// autorise l'ecriture
	GIE = 0;									// desactive les ISR si activees
	EECON2 = 0x55;							// nombres magiques
	EECON2 = 0xAA;							// 
	WR = 1;									// commence l'ecriture
	GIE = CARRY; //(bit)tmp;						// reactive les interruptions
	WREN = 0;								// interdit l'ecriture
*/
// HI-TECH macro + Microchip P43 ex4-2
	while(WR)continue;					// attends la fin de l'ecriture precedante
	EEADR=adr;								// selectionne la bonne adresse
	EEDATA=data;							// donnee a ecrire
	EEPGD=0;									// memoire donnees
	WREN=1;									// autorise l'ecriture
	CARRY=0;									// sauvegarde & desactive GIE
	if(GIE) CARRY=1;		
	GIE=0;									// desactive les ISR si activees
	EECON2=0x55;							// nombres magiques
	EECON2=0xAA;
	WR=1;										// commence l'ecriture
	if(CARRY) GIE=1;						// reactive les interruptions
	WREN=0;									// interdit l'ecriture 
}

/*
// ajoute 37 octets ROM		// A TESTER
//========================================================================================
// STOCKAGE variables RAM persistant
//========================================================================================
// LECTURE d'une suite d'octet dans l'EEPROM : ZONE PERSISTANTE
//		appel : read_from_eeprom(_Lnvram, _Hnvram-_Lnvram);
//========================================================================================
read_from_eeprom(char * start, unsigned char length){
	unsigned char i;
	for(i=0; i<length; i++){ 
		*start = readEE(i);
		start++;	
	}		
}

//========================================================================================
// ECRITURE d'une suite d'octet dans l'EEPROM : ZONE PERSISTANTE
//		appel : write_to_eeprom(_Lnvram, _Hnvram-_Lnvram);
//========================================================================================
write_to_eeprom(char * start, unsigned char length){
	unsigned char i;
	for(i=0; i<length; i++){ 
		writeEE(i, *start);
		start++;	
	}
}*/

//========================================================================================
// LECTURE d'un 14tet dans la FLASH 
//========================================================================================
//unsigned int flash_read(unsigned int adr){
//	return FLASH_READ(adr);
/*	EEADR=((addr)&0xff);
	EEADRH=((addr)>>8);	
	WREN=0;			
	EEPGD = 1;		
	RD=1;			
	asm("nop");		
	asm("nop");		
	return ((EEDATH << 8) | EEDATA)
*/
//}

//========================================================================================
// ECRITURE d'un 14tet dans la FLASH 
//========================================================================================
//flash_write(unsigned char adr, unsigned int data){
//	FLASH_WRITE(adr, data);	
/*
	EEADR=((addr)&0xff);	
	EEADRH=((addr)>>8);	
	EEDATH=((value)>>8);
	EEDATA=((value)&0xff);	
	EEPGD = 1;		
	WREN=1;
	CARRY=0;if(GIE)CARRY=1;GIE=0;		// bloquer ISR 
	EECON2 = 0x55;		
	EECON2 = 0xaa;		
	WR=1;			
	asm("nop");		
	asm("nop");
	if(CARRY)GIE=1;	// reautoriser ISR 
	WREN=0;
*/
//}

//========================================================================================
/* BUS I2C */
//========================================================================================
i2c_init(void) {
	TRISC3=1;	TRISC4=1;			// set SCL and SDA pins as inputs
	SSPCON = 0x38;						// set I2C master mode
	SSPCON2 = 0x00;					
	SSPADD = 0x0E;						// Fi2c= Fosc/(4*(SSPADD+1))   ; 0x0C 400kHz bus with 20MHz xtal
	STAT_CKE=0;							// use I2C levels      worked also with '0'
	STAT_SMP=0;							// disable slew rate control  worked also with '0'
	PSPIF=0;								// clear SSPIF interrupt flag
	BCLIF=0;								// clear bus collision flag
}
//========================================================================================
i2c_waitForIdle(void) {
	while (( SSPCON2 & 0x1F ) | STAT_RW ) {}; // wait for idle and not writing
}
//========================================================================================
i2c_start(void) {
	i2c_waitForIdle();
	SEN=1;
}
//========================================================================================
i2c_repStart(void) {
	i2c_waitForIdle();
	RSEN=1;
}
//========================================================================================
i2c_stop(void){
	i2c_waitForIdle();
	PEN=1;
}
//========================================================================================
int 
i2c_read( unsigned char ack ){
	unsigned char i2cReadData;
	i2c_waitForIdle();
	RCEN=1;
	i2c_waitForIdle();
	i2cReadData = SSPBUF;
	i2c_waitForIdle();
	if (ack)	ACKDT=0;
	else		ACKDT=1;
	ACKEN=1;               			// send acknowledge sequence
	return( i2cReadData );
}
//========================================================================================
unsigned char 
i2c_write( unsigned char i2cWriteData ){
	i2c_waitForIdle();
	SSPBUF = i2cWriteData;
	return ( ! ACKSTAT  ); 			// function returns '1' if transmission is acknowledged
}
//========================================================================================
/*
rw_start_eeprom(unsigned int address, unsigned char data){
	i2c_start();
	i2c_write(0xa0);
	i2c_write(address >> 8);
	i2c_write(address & 0x00FF);	
}*/
//========================================================================================
/*
write_ext_eeprom(unsigned int address, unsigned char data){
	rw_start_eeprom(address, data);
	i2c_write(data);
	i2c_stop();
	DelayMs(11);
}*/
//========================================================================================
/*unsigned char 
read_ext_eeprom(unsigned int address){
	unsigned char data;
	rw_start_eeprom(address, data);	
	i2c_repStart();
	i2c_write(0xa1);
	data = i2c_read(0);							// nack (1 data  lire)
	i2c_stop();
	return(data);
}*/


//EOF//


