// lcd.h //

#ifndef LCD_H
#define	LCD_H
#include	"lcdgraph.h"

// pour fonctions : commut_114, ana_114, relais_ac_dc
#define	ANA_CHA	0
#define	ANA_CHB	1
#define	ANA_CHC	2
#define	ANA_CHD	3
// pour fonction  : relais_ac_dc
#define	AC			0
#define	DC			1
// pour fonction ana_trig
#define	TRIG_UP		1
#define	TRIG_DOWN	0


//========================================================================================
//   Temporisation I2C  
//========================================================================================
#define	DelayUs(x)	{ unsigned char _dcnt; \
			  _dcnt = (x); \
			  while(--_dcnt != 0) \
				  continue; }
// x*16/12=2
DelayMs(unsigned char);
//void DelaySec(char sec);

//========================================================================================
//   Temporisation pour le LCD  
//========================================================================================
tempo_x65ms(unsigned char nbr);
TEMPO(void);													// 513us (lcd + clavier)
DELAY500(void);												// 125us (500/4)
X_DELAY500(unsigned char val);							// val * 125us

//========================================================================================
//   LCD 
//========================================================================================
#define lcd_left()	LCD_CS1 = 1;	LCD_CS2 = 0;	// slectionne la partie gauche du LCD 
#define lcd_right()	LCD_CS1 = 0;	LCD_CS2 = 1;	// slectionne la partie droite du LCD
//#define lcd_both()	LCD_CS1 = 1;	LCD_CS2 = 1;	// slectionne les 2 parties du LCD
//#define lcd_none()	LCD_CS1 = 0;	LCD_CS2 = 0;	// deslectionne les 2 parties du LCD
#define lcd_strobe() LCD_EN = 1; asm("nop");	asm("nop");LCD_EN = 0;// strobe la donne

//========================================================================================
//   Initialise le LCD 
//========================================================================================
lcd_init_both(unsigned char yMax);						// initialise le LCD 
lcd_init(unsigned char yMax);								// jusqu'a posY = yMax
#define lcd_clear()	lcd_init_both(64)					// efface le LCD 

//========================================================================================
//   Commandes de base du LCD
//========================================================================================
lcd_putcmd(unsigned char cmd);							// envoie une commande		
unsigned char lcd_status(void);							// lit l'tat du LCD 			

lcd_putdata(unsigned char data);							// envoie une donne 				
																				
unsigned char lcd_getdata(void);							// lit une donne

lcd_busy(void);												// busy	LCD 

lcd_disp_on_off(unsigned char disp);					// display ON/OFF 1:ON  0:OFF


//========================================================================================
//   LCD  Positionnement
//========================================================================================
// set Y adresse : position horizontale [0-63]  (auto-incrmente  chaque lecture/criture)
lcd_addressY(unsigned char adr);

// set X page : position verticale [0-7] (par paquets de 8)
lcd_pageX(unsigned char adr);

// set start line : position Z vertical [0-63] (scrolling)
lcd_startZ(unsigned char adr);
 
//========================================================================================
//   LCD fonctions de positionnement
//========================================================================================
// Va a la position specifiee  posX : pageX[0-7], posY : addressY[0-127] 
lcd_goto(unsigned char posX, unsigned char posY);	

// gre les compteur lcd_x, lcd_y (LCD) (utile pour putchar->puts)
lcd_compteur(void); 

//========================================================================================
//   LCD bitmaps
//========================================================================================
// affiche un demi-bitmap sur le LCD  
lcd_half_bitmap(void);

// affiche un bitmap sur le LCD  
lcd_bitmap(unsigned char nbImage);
 
  
//========================================================================================
//   LCD strings
//========================================================================================
#define LCD_CENT(x) ((128-6*x)/2)			// calcul du centrage du texte
lcd_putchar(unsigned char c);					// ecrit un caractre sur le LCD  
lcd_puts(const char * s);						// ecrit une string de caracteres sur le LCD 
														// Ecrit une string au coordonnees ligne, colonne
lcd_string_loc_lc(const char *s, unsigned char ligne, unsigned char colonne); 

unsigned char hexa2ascii(unsigned char tmp);	// convertit un nombre hexadecimal en ascii
lcd_hexa(unsigned char c);						// ecrit un nombre en hexa sur le LCD 

//========================================================================================
//   lcd_uchar : affiche un unsigned char
//========================================================================================
lcd_uchar(const char *str, unsigned char ligne, unsigned char col, unsigned char val);

//========================================================================================
//   Fonctions graphiques 
//========================================================================================
// Points coordonnees x, y, ON/OFF
//		|        -- y++ -->
//   \|/ x++
//========================================================================================
lcd_plot(unsigned char x, unsigned char y, unsigned char fill);		// 1 points
lcd_plot_8(unsigned char posX, unsigned char posY);						// 8 points

//========================================================================================
//   Lignes graphiques Horizontales / Verticales
//========================================================================================
// ligne LCD  :  x1, y1, x2, y2
void
lcd_line(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2);

// ligne horizontale LCD  :  y1, y2
lcd_line_H(unsigned char xref, unsigned char ypas, unsigned char y1, unsigned char y2);

// ligne verticale LCD  :  x1, x2
lcd_line_V(unsigned char yref, unsigned char xpas, unsigned char x1, unsigned char x2);

//========================================================================================
//   Grilles / rectangles (utilise lcd_line_H + _V)
//========================================================================================
lcd_grille(void);									// grille scope
														// rectangle (coin bas gauche, coin haut droit)
#define lcd_eff_grille()	lcd_init_both(28)			// efface la grille (posY = 0  92=64+28)
 
lcd_rect(unsigned char x1, unsigned char y1, unsigned char x2, unsigned char y2);

//========================================================================================
//   Fonctions mathematiques sinus + cosinus pour les cercles
//========================================================================================
// sinus = 32*sin(PI/2*alpha/32)
/*signed char sin32(unsigned char alpha);
signed char sinus(signed char alpha);
signed char cos32(unsigned char alpha);
signed char cosinus(signed char alpha);

// Cercle de centre (posX, posY)  Rayon   32(1)  16(2)  8(3)  4(4)
cercle(unsigned char posX, unsigned char posY, unsigned char diam);
*/
//========================================================================================
// Curseurs scope ...
//========================================================================================
// Curseur du trigger
lcd_trig(unsigned char val);

// Curseur debuts canaux A+B
lcd_start_ch(unsigned char nbCanal);

//========================================================================================
//   DS1267 (S10) : potentiometre numerique 256 positions  (CLK = 10MHz max)
//========================================================================================
ds1267(unsigned char potA, unsigned char potB);

//========================================================================================
//   Commutation pour max114
//========================================================================================
commut_114(unsigned char canal);

//========================================================================================
//   1 mesure ana 1 canal
//========================================================================================
unsigned char ana_114(unsigned char canal);

//========================================================================================
// trigger avec timeout
//========================================================================================
unsigned char
ana_trig(unsigned char canal, unsigned char trigger, unsigned char front,
			unsigned int tempo, unsigned char timeout);

//========================================================================================
// Affiche AC / DC sur le lcd
//========================================================================================
lcd_ac_dc(unsigned char etat);

//========================================================================================
//   Lecture log8 (8 entrees logiques)
//========================================================================================
unsigned char read_log8(void);

//========================================================================================
//   CLAVIER  
//========================================================================================
// Lecture de la touche appuyee (clavier matrice) : 1-9, 10(0), 11(*), 12(#)
unsigned char clavier(void);

// antirebond touche x
clavier_antirebond(unsigned char touche);

//========================================================================================
//   Entree analogique  12V  Mode 8 bits (justify)
//      Renvoie la tension d'alim 12V 
//========================================================================================
unsigned char ana12(void);

//========================================================================================
//   RS232
//========================================================================================
init232(char debit);
tx232(char val);
char rx232(void);

tx232_puts(const char * s);		// ecrit une string de caracteres sur le port serie
tx232_2ascii(unsigned char car);	// ecrit 2 caracteres ascii 

//========================================================================================
//    LECTURE et ECRITURE dans l'EEPROM 
//========================================================================================
// LECTURE d'un octet dans l'EEPROM 
unsigned char readEE(unsigned char adr);
// ECRITURE d'un octet dans l'EEPROM 
writeEE(unsigned char adr, unsigned char data);

// STOCKAGE variables RAM persistant 		// ajoute 37 octets ROM		// A TESTER
// LECTURE 		appel : read_from_eeprom(_Lnvram, _Hnvram-_Lnvram);
//read_from_eeprom(char * start, unsigned char length);
// ECRITURE 	appel : write_to_eeprom(_Lnvram, _Hnvram-_Lnvram);
//write_to_eeprom(char * start, unsigned char length);

// LECTURE d'un 14tet dans la FLASH 
//unsigned int flash_read(unsigned int adr);
// ECRITURE d'un 14tet dans la FLASH 
//flash_write(unsigned char adr, unsigned int data);
	
//========================================================================================
//   BUS I2C : fonctions de base
//========================================================================================
i2c_init(void);										// i2c_init  - initialize I2C functions
i2c_waitForIdle(void);
i2c_start(void);										// i2c_start - issue Start condition
i2c_repStart(void);									// i2c_repStart- issue Repeated Start condition
i2c_stop(void);										// i2c_stop  - issue Stop condition
int  i2c_read( unsigned char ack );				// i2c_read(x) - receive unsigned char 
															// - x=0, don't acknowledge - x=1, acknowledge
															// i2c_write - write unsigned char - returns ACK
unsigned char i2c_write( unsigned char i2cWriteData );

//========================================================================================
// memoire I2C		24LC256 (32ko)
//========================================================================================
rw_start_eeprom(unsigned int address, unsigned char data);		// start read/write
write_ext_eeprom(unsigned int address, unsigned char data);		// ecriture
unsigned char read_ext_eeprom(unsigned int address);						// lecture

#endif
// EOF //
