// gbf01.h     //

#ifndef LCDGRAPH_H
#define LCDGRAPH_H

#include	<pic.h>
#include	<math.h>
//#include	<stdio.h>
#include <stdlib.h>
#include "lcd_port.h"


//#define	OPTION_REG	0b00000000

/* Temporisation pour le LCD */
/*
#ifndef	XTAL_FREQ
#define	XTAL_FREQ	16MHZ		// Crystal frequency in MHz 
#endif
*/

#define	MHZ	*1000L			/* number of kHz in a MHz */
#define	KHZ	*1			/* number of kHz in a kHz */


// Code Inefficace!! ->remplacer en assembleur
// bsf & bcf 
#define bitset(var,bitno) ((var) |= 1 << (bitno))
#define bitclr(var,bitno) ((var) &= ~(1 << (bitno)))
// Test d'un bit d'un registre (pas tres efficace!) 
#define testbit_on(data,bitno) ((data>>bitno)&0x01)	// remplacer par data & 0x01 ou &0x02 ou 0x04 ...

// TOUCHES du CLAVIER 
#define ECHAP		11
#define ENTER		12

// TOUCHES NON VALIDES 
#define RETOUR		114			//14	// pour retour menu
#define DISPLAY 	115			//15	// pour affichage : refresh
#define SAVE 		12


/*typedef struct{
	unsigned char reg;
	unsigned char max;
	unsigned char min;
}cna;*/

extern bit bit_chb_off;					// si == 1 : voie B  = off

//   initialise le timer 1 pour des temporisations (pour acquisition 50ms/div  100s/div)
void init_TMR1(void);
//void init_TMR1(unsigned int tempo);

// conversion acquisition -> lcd
#define CHA	0
#define CHB	1
#define CHC	2
#define CHD	3
unsigned char convert_lcd(unsigned char canal, unsigned char index);

//		Somme canal (pour calcul de la moyenne d'un canal)
unsigned char somme_ch(unsigned char canal, unsigned char index);

//========================================================================================
// affiche les voies A et B en mode dot
//========================================================================================
///lcd_ch_dot(unsigned char canal);

// affiche une voie en mode continu : renvoie la moyenne du canal
unsigned char lcd_ch_ab(unsigned char canal);

// affiche une ligne entre 2 points (mode scope)
lcd_ch_ab_once(unsigned char Val, unsigned char * ValOld, unsigned char coordY);

// affiche les voies A et B en mode dot XY
lcd_ch_dotXY(void);
// affiche un point en mode XY
lcd_ch_dotXY_once(unsigned char compt);

//========================================================================================
//   Menus de configuration 
//========================================================================================
menu_bord(void);

menu_config(void);
menu_scope(void);
menu_log8(void);

// menu principal
#define menu_config() 	lcd_bitmap(bmp16)	//16*4)
// menu scope
#define menu_scope()		lcd_bitmap(bmp17)	//17*4)
// menu log8
#define menu_log8()		lcd_bitmap(bmp18)	//18*4)
// menu tra2 (transfert bootlaoder)
#define menu_tranf()		lcd_bitmap(bmp19)


//   Menu dessin (test fct plot x,y)
menu_dessin(unsigned char clav, unsigned char *c_x, unsigned char *c_y);

//========================================================================================
//   Modifie puis affiche les parametres de l'oscillo : A ac/dc xxx mV/div Time/ xx us/div ...
//========================================================================================
param_scope(unsigned char *gamme1, unsigned char *gamme2, unsigned char *timeB, unsigned char sonde1, unsigned char sonde2, unsigned char trigType, unsigned char clav);

// commut. AC/DC CHA+B
relais_ac_dc_clav(unsigned char clav);


//  initialisation des parametres (entrees / sorties, peripheriques...)
init_system(void);

//  initialisation Affichage Introduction
init_intro(void);


//========================================================================================
// acquisition  666khz			( 1.5us/pts soit 12us/div (8pts) )	
//========================================================================================
acq_ch_12us(unsigned char canal, unsigned char trigger, unsigned char front, unsigned char timeout);	

//========================================================================================
// acquisition de 50us  20ms/div sur CHA+CHB
// 25 instr par boucle soit 4.1666us/ech -> 33.3us/div (8pts)
//========================================================================================
acq_ch_33us(unsigned char trigger, unsigned char front, unsigned char timeout);

//========================================================================================
// acquisition de 50us  20ms/div sur CHA+CHB
//========================================================================================
acq_ch_50us_20ms( unsigned char trigger, unsigned char front, unsigned char timeout); //unsigned int tempo,


//========================================================================================
// acquisition de 50ms/div  100s/div sur CHA+CHB AVEC ISR TMR1 !!!
// stockage + affichage sur ISR timer1
//========================================================================================
//################################################################################################
acq_ch_50ms_100s(unsigned char eff); //unsigned int tempo, 
// acquisition d'un echantillon sur CH1 + 2 (avec FSR)
acq_ech(void);

//========================================================================================
// Transfert data CHA/B/C/D
//========================================================================================
transfert_ch(unsigned char canal);
// Transfert data rs232
transfert232(unsigned char g1, unsigned char g2, unsigned char timeB,
				 unsigned char trigType, unsigned char trigger);


//========================================================================================
// Bitmap en memoire i2c 24C256
//           pageMem    // Description		       pageMemReel = pageMem>>1
//========================================================================================
#define bmp0	0			// seb scope				
#define bmp1	4			// winamp					
#define bmp2	8			// symbol
#define bmp3	20			// USA
#define bmp4	16			// go wild
#define bmp5	12			// graph data
#define bmp6	24			// Alarme (voiture)		
#define bmp7	28			// G12032
#define bmp8	32			// lextronic
#define bmp9	36			// V
#define bmp10	40			// V
#define bmp11	44			// V
#define bmp12	48			// V
#define bmp13	52			// V
#define bmp14	56			// V
#define bmp15	60			// V
#define bmp16	64			// menu Principal
#define bmp17	68			// menu Scope
#define bmp18	72			// menu Dat8
#define bmp19	76			// menu Tra2	(transfert Bootloader)
#define bmp20	80			// menuCal2	: ampoule off
#define bmp21	84			// menuCal2	: ampoule on
#define bmp22	88			// menuSco3 : menu param scope
#define bmp23	92			// menuI2C  : transfert bitmap
#define bmp24	96			// menuAide : copyright
#define bmp25	100		// V
#define bmp26	104		// V
#define bmp27	108		// V
#define bmp28	112		// V
#define bmp29	116		// V
#define bmp30	120		// V
#define bmp31	124		// V


#endif
// EOF
