


	LIST P=16F84A, R=DEC    ; Use the PIC16F84 and decimal system 

        #include "P16F84A.INC"  ; Include header file 

        __config  _XT_OSC & _WDT_OFF & _PWRTE_ON




	goto lbl_1	; lbl_1 = 0xFA
	ORG 0x4
	goto lbl_1

;---------prijem znaku z MT---------------------
lbl_20	bsf STATUS,C
	clrf 0xC			;zde jsou po provedeni pozadovana data (na tato adrese)
	rrf 0xC,f
lbl_2	btfsc PORTA,0
	goto lbl_2	; lbl_2 = 0x8
	movlw 6H	; d'6' b'110' a''
	movwf 0xD
lbl_3	decfsz 0xD,f
	goto lbl_3	; lbl_3 = 0xC
lbl_7	movlw 0DH	; d'13' b'1101' a''
	movwf 0xD
lbl_4	decfsz 0xD,f
	goto lbl_4	; lbl_4 = 0x10
	btfsc PORTA,0
	goto lbl_5	; lbl_5 = 0x16
	bcf STATUS,C
	goto lbl_6	; lbl_6 = 0x17
lbl_5	bsf STATUS,C
lbl_6	rrf 0xC,f
	btfss STATUS,C
	goto lbl_7	; lbl_7 = 0xE
	movlw 7H	; d'7' b'111' a''
	movwf 0xD
lbl_8	decfsz 0xD,f
	goto lbl_8	; lbl_8 = 0x1C
	return

;------------Vyslani znaku na seriak --------------------------------------
lbl_15	bsf PORTA,1
	movlw 9H	; d'9' b'1001' a''
	movwf 0xF
	bcf PORTA,1
lbl_14	movlw 0CH	; d'12' b'1100' a''
	movwf 0xD
lbl_9	decfsz 0xD,f
	goto lbl_9	; lbl_9 = 0x25
	decfsz 0xF,f
	goto lbl_10	; lbl_10 = 0x2F
	bsf PORTA,1
	movlw 0CH	; d'12' b'1100' a''
	movwf 0xD
lbl_11	decfsz 0xD,f
	goto lbl_11	; lbl_11 = 0x2C
	return
lbl_10	rrf 0xE,f
	btfsc STATUS,C
	goto lbl_12	; lbl_12 = 0x34
	bcf PORTA,1
	goto lbl_13	; lbl_13 = 0x35
lbl_12	bsf PORTA,1
lbl_13	goto lbl_14	; lbl_14 = 0x23

lbl_23	movwf 0xE
	call lbl_15	; lbl_15 = 0x1F
	return

;---------------casovaci rutina-------------------------------------
lbl_28	bsf STATUS,RP0	; switch to bank 1
	movlw 07H	; d'7' b'111' a''
	movwf OPTION_REG
	bcf STATUS,RP0	; switch to bank 0
	clrf 0xD
lbl_17	clrf TMR0
lbl_16	btfss TMR0,7
	goto lbl_16	; lbl_16 = 0x3F
	incf 0xD,f
	btfss 0xD,2
	goto lbl_17	; lbl_17 = 0x3E
	return

;------------------casovaci rutina---------Delicka 1:256x4096xtrvani 1 instrukcniho cyklu,pri 3,579 MHz to je
; 1,171 sec.------------------
lbl_29	bsf STATUS,RP0	; switch to bank 1	;
	movlw 07H	; d'7' b'111' a''
	movwf OPTION_REG
	bcf STATUS,RP0	; switch to bank 0
	clrf 0xD
lbl_19	clrf TMR0
lbl_18	btfss TMR0,7
	goto lbl_18	; lbl_18 = 0x4B
	incf 0xD,f
	btfss 0xD,5
	goto lbl_19	; lbl_19 = 0x4A
	return

;-------Nacte pocet znaku ze seriaku podle cisla v W, vysledek je na adr. 0CH-----------------------------------------------------
lbl_26	movwf 0x10
lbl_21	call lbl_20	; lbl_20 = 0x5		;nacti znak z MT
	decfsz 0x10,f			
	goto lbl_21	; lbl_21 = 0x52
	return
;------------------------------------------------------------
;precte data z EEPROM
lbl_32	bsf STATUS,RP0	; switch to bank 1
	bsf EECON1,RD
	bcf STATUS,RP0	; switch to bank 0
	movf EEDATA,w
	return
;------------------------------------------------------------

;-----------------------Ulozi data do EEPROM------------------
lbl_45	bsf STATUS,RP0	; switch to bank 1
	bsf EECON1,WREN
	movlw 055H	; d'85' b'1010101' a'U'
	movwf EECON2
	movlw 0AAH	; d'170' b'10101010' a''
	movwf EECON2
	bsf EECON1,WR
lbl_22	btfsc EECON1,WR
	goto lbl_22	; lbl_22 = 0x62
	bcf EECON1,WREN
	bcf STATUS,RP0	; switch to bank 0
	return
;---------------------------------------------------------------
;-----------posle prikaz AT+ -----------------------
lbl_24	movlw 41H	; d'65' b'1000001' a'A'
	call lbl_23	; lbl_23 = 0x36
	movlw 54H	; d'84' b'1010100' a'T'
	call lbl_23
	movlw 2BH	; d'43' b'101011' a'+'
	call lbl_23
	return
;---------------------------------------------------

;------------posle prikaz ATH a enter to je ZAVESIT--------------
lbl_30	movlw 041H	; d'65' b'1000001' a'A'
	call lbl_23
	movlw 54H	; d'84' b'1010100' a'T'
	call lbl_23
	movlw 48H	; d'72' b'1001000' a'H'
	call lbl_23
	movlw 0DH	; d'13' b'1101' a''
	call lbl_23
	return
;-----------------------------------------------------------------

;ulozi (asi nuluje) do RAM hodnotu FF
lbl_31	movlw 0FFH	; d'255' b'11111111' a''
	movwf 0x13
	movwf 0x14
	movwf 0x15
	movwf 0x16
	movwf 0x17
	movwf 0x18
	movwf 0x19
	movwf 0x1A
	movwf 0x1B
	movwf 0x1C
	movwf 0x1D
	movwf 0x1E
	return

lbl_27	call lbl_20			;cti 12znaku ze seriaku
	movf 0xC,w
	movwf 0x13
	call lbl_20
	movf 0xC,w
	movwf 0x14
	call lbl_20
	movf 0xC,w
	movwf 0x15
	call lbl_20
	movf 0xC,w
	movwf 0x16
	call lbl_20
	movf 0xC,w
	movwf 0x17
	call lbl_20
	movf 0xC,w
	movwf 0x18
	call lbl_20
	movf 0xC,w
	movwf 0x19
	call lbl_20
	movf 0xC,w
	movwf 0x1A
	call lbl_20
	movf 0xC,w
	movwf 0x1B
	call lbl_20
	movf 0xC,w
	movwf 0x1C
	call lbl_20
	movf 0xC,w
	movwf 0x1D
	call lbl_20
	movf 0xC,w
	movwf 0x1E
	return
;-----------------vycteni telef. cisla z MT --------------------
;posli prikaz
lbl_36	call lbl_24	; lbl_24 = 0x67
	movlw 043H	; d'67' b'1000011' a'C'
	call lbl_23
	movlw 50H	; d'80' b'1010000' a'P'
	call lbl_23
	movlw 42H	; d'66' b'1000010' a'B'
	call lbl_23
	movlw 52H	; d'82' b'1010010' a'R'
	call lbl_23
	movlw 3DH	; d'61' b'111101' a'='
	call lbl_23
	movf	21H,W	;podle cisla na adrese 21H vola cislo z pozice na SIM,pozor pri ladeni cislo je v ASCII
	call lbl_23
	movlw 0DH	; d'13' b'1101' a''
	call lbl_23
;---cti data z MT---------------------
lbl_25	call lbl_20
	movlw 22H	; d'34' b'100010' a'"'		;nacti ASCII znak uvozovek
	bcf STATUS,Z
	subwf 0xC,w						;testuj dosazeni,pokud nejsou,cti znovu seriak
	btfss STATUS,Z
	goto lbl_25	; lbl_25 = 0xB9
	movlw 1H	; d'1' b'1' a''			;prisli uvozovky,zacina tlf. cislo,zadej do W
	call lbl_26	; lbl_26 = 0x51			;precte znak + a zahodi ho,bude pridan pri volani cisla
	call lbl_27	; lbl_27 = 0x85			;precte 12 znaku ze seriaku
	call lbl_28	; lbl_28 = 0x39			;odcasuje
	return

;-----------------vytoci telefonni cislo-------------------------
;prikaz
lbl_37	movlw 41H	; d'65' b'1000001' a'A'
	call lbl_23
	movlw 54H	; d'84' b'1010100' a'T'
	call lbl_23
	movlw 44H	; d'68' b'1000100' a'D'
	call lbl_23
	movlw 2BH	; d'43' b'101011' a'+'
	call lbl_23
;doplni prikaz tel. cislem z pameti
	movf 0x13,w
	call lbl_23
	movf 0x14,w
	call lbl_23
	movf 0x15,w
	call lbl_23
	movf 0x16,w
	call lbl_23
	movf 0x17,w
	call lbl_23
	movf 0x18,w
	call lbl_23
	movf 0x19,w
	call lbl_23
	movf 0x1A,w
	call lbl_23
	movf 0x1B,w
	call lbl_23
	movf 0x1C,w
	call lbl_23
	movf 0x1D,w
	call lbl_23
	movf 0x1E,w
	call lbl_23
	movlw 3BH	; d'59' b'111011' a';'
	call lbl_23
	movlw 0DH	; d'13' b'1101' a''
	call lbl_23
	call lbl_29	; lbl_29 = 0x45
	call lbl_29
	call lbl_29
	call lbl_29
	call lbl_29
	call lbl_29
	call lbl_29
	call lbl_29
	call lbl_29		;zvoni,zvoni, casovaci rutiny
	call lbl_29
	call lbl_29
	call lbl_29
	call lbl_29
	call lbl_29
	call lbl_29
	call lbl_30	; lbl_30 = 0x6E		;zavesi
	call lbl_28		;odcasuje
	return



;zacatek
lbl_1	bcf STATUS,RP0	; switch to bank 0
	bcf STATUS,RP1
	movlw 1CH	;b'00011100' ;kvuli prechodu do nabijeni je nejprve out linka  v L na cca 2 sec
	movwf PORTA
	call lbl_29		;cekej sekundu	
	call lbl_29		;cekej sekundu
	movlw 1EH	;b'00011110'
	movwf PORTA

	movlw 0EFH	; d'239' b'11101111' a''
	movwf PORTB
	bsf STATUS,RP0	; switch to bank 1
	movlw 1H	; d'1' b'1' a''
	movwf TRISA
	movlw 0EFH	; b'11101111' a''
	movwf TRISB
	bsf STATUS,RP0	; switch to bank 1
	movlw 03H	; d'3' b'11' a''
	movwf OPTION_REG
	movlw 0	; d'0' b'0' a''
	movwf INTCON
	clrf 0x91
;-----------------HLAVNI SMYCKA---------------------------
;pri spusteni poplachu testuje 10 sec., zda nebylo tlacitko stisknuto,pokud ne vola MT. Pokud ano, dojde k odstaveni
;az do dalsi deaktivace poplachu (zabouchnuti dveri). Pak jiz zase pracuje normalne
lbl_42	bcf STATUS,RP0	; switch to bank 0
	call lbl_31	; lbl_31 = 0x77	;nuluj RAM
	movlw 1	; d'0' b'0' a''	;
	movwf EEADR				;cti data z adresy 1 EEPROM
	call lbl_32	; lbl_32 = 0x56	;rutina cteni z eeprom
	movwf 0x12				;testuj data
	btfsc 0x12,0			;pokud je nula,bylo pred resetem rele vypnute
	goto lbl_33	; lbl_33 = 0x115	;jinak bylo zapnute, zapni a pokracuj
	bcf PORTB,4				;vypni rele
	goto lbl_34	; lbl_34 = 0x116	
lbl_33	bsf PORTB,4
lbl_34	nop
	btfss 0x11,7			;testuj priznak OK prijmu SMS, nastaven=prozvon
	goto lbl_35	; lbl_35 = 0x120	;
	call lbl_29
	call lbl_29
	call lbl_29
	movlw	'1'				;zadej prvni pozici na SIM
	movwf	21H
	call lbl_36	; lbl_36 = 0xAA		;vycteni tlf. cisla z MT
	call lbl_37	; lbl_37 = 0xC4		;vytoci tlf.cislo
	call lbl_31					;nuluje RAM pro tlf. cislo
	bcf 0x11,7					;prozvoneno po SMS, shod flag
;
lbl_35	bsf PORTA,3		;zhasni LED
	btfss PORTA,0		;testuj uroven z mobilu
	goto lbl_35			;dokud neni H, opakuj
	call lbl_28			;volani casovaci rutiny
	bcf PORTA,3			;rozsvit LED
	movlw 0AH	; d'10' b'1010' a''	;nacti hodnotu poctu obehu programu do lbl_40
	movwf 0x1F			;uloz na adresu
lbl_40	btfsc PORTB,0	;testuj vstup poplachu,pokud je poplach, je bit v L
	goto lbl_38	; lbl_38 = 0x133	;neni poplach, pokracuj
	btfsc 0x11,0			;byl uz volan poplach?
	goto lbl_39	; lbl_39 = 0x134	;ano, nevolej
	bsf 0x11,0			;nastav flag zda byl uz poplach vyvolan - pri pozadavku rucniho spusteni pred opustenim presunout nastaveni tohoto
						;priznaku do rutiny s navestim poplach na zacatek 
	movlw	0AH			;nacti pocet opakovani 1 sec. zpozdeni na 10x cili 10 sec.
	movwf	020H			;uloz na adresu
opak	btfsc	PORTB,3		;testuj,pokud je v L,tak se odcasujeje,v H poplach odstaven
	goto	lbl_39		;pokud je v H,testuj 10 vterin stav,pokud prejde do 
	call lbl_29			;casovaci rutina 10x cca 1,1 sec.
	btfss	PORTA,3		;tohle smeti je jen kvuli blikani LED (jo neni nad instrukci CPL u x51)
	goto	zhasni
	bcf PORTA,3		;rozsvit LED
	goto	pokr_1
zhasni	bsf PORTA,3		;zhasni LED
pokr_1	decfsz	020H		;dekrementuj pocet opakovani	
	goto	opak			;znovu testuj odstaveni poplachu a cekej 1 sec.		
poplach
	bcf PORTA,3			;rozsvit LED	;aby zustala svitit po blikani v casovani vyse 
;-------------------------Prvni cislo ze SIM-------------------------
	movlw	'1'				;zadej prvni pozici na SIM
	movwf	21H
	call lbl_36	; lbl_36 = 0xAA		;vycteni tlf. cisla z MT
	call lbl_37	; lbl_37 = 0xC4		;vytoci tlf.cislo
	call lbl_31					;nuluje RAM pro tlf. cislo
;-------------------------Druhe cislo ze SIM-------------------------
	movlw	'2'				;zadej prvni pozici na SIM
	movwf	21H
	call lbl_36	; lbl_36 = 0xAA		;vycteni tlf. cisla z MT
	call lbl_37	; lbl_37 = 0xC4		;vytoci tlf.cislo
	call lbl_31					;nuluje RAM pro tlf. cislo
;-------------------------Treti cislo ze SIM-------------------------
	movlw	'3'				;zadej prvni pozici na SIM
	movwf	21H
	call lbl_36	; lbl_36 = 0xAA		;vycteni tlf. cisla z MT
	call lbl_37	; lbl_37 = 0xC4		;vytoci tlf.cislo
	call lbl_31					;nuluje RAM pro tlf. cislo
;-------------------------Ctvrte cislo ze SIM-------------------------
	movlw	'4'				;zadej prvni pozici na SIM
	movwf	21H
	call lbl_36	; lbl_36 = 0xAA		;vycteni tlf. cisla z MT
	call lbl_37	; lbl_37 = 0xC4		;vytoci tlf.cislo
	call lbl_31					;nuluje RAM pro tlf. cislo
	goto lbl_39
lbl_38	bcf 0x11,0		;neni poplach,nuluj flag volani poplachu
lbl_39	bcf PORTA,3			;rozsvit LED
	call lbl_29		;pauza
	decfsz 0x1F,f		;dekrementuj pocet obehu,a opakuj 10x
	goto lbl_40	; lbl_40 = 0x127
	call lbl_24						;vysli prikaz AT+
	movlw 43H	; d'67' b'1000011' a'C'
	call lbl_23
	movlw 4DH	; d'77' b'1001101' a'M'
	call lbl_23
	movlw 47H	; d'71' b'1000111' a'G'
	call lbl_23
	movlw 4CH	; d'76' b'1001100' a'L'
	call lbl_23
	movlw 3DH	; d'61' b'111101' a'='
	call lbl_23
	movlw 30H	; d'48' b'110000' a'0'
	call lbl_23
	movlw 0DH	; d'13' b'1101' a''
	call lbl_23						;vypise prijate neprectene zpravy
lbl_43	call lbl_20					;prijme znak z mobilu
	movlw 4FH	; d'79' b'1001111' a'O'		;testuj prvni znak dosazeni OK na konci SMS
	bcf STATUS,Z
	subwf 0xC,w
	btfsc STATUS,Z					;je znak O, volej rutinu smazani aktualni SMS
	goto lbl_41	; lbl_41 = 0x1DC			;pokud je O, volej smazani SMS
	btfss PORTA,0					;testuj klidovy stav linky,H je v klidu
	goto lbl_42	; lbl_42 = 0x10B			
	movlw 3AH	; d'58' b'111010' a':'		;testuj dosazeni dvojtecky
	subwf 0xC,w
	btfss STATUS,Z
	goto lbl_43	; lbl_43 = 0x146			;dvojtecka neni.opakuj		
	movlw 42H	; 					;nacti do W pocet ctenych byte z MT
	call lbl_26						;zahodi 66 byte ze seriaku a tim jsem na zacatku platnych dat sms
	call lbl_27						;precte a ulozi 12 byte ze seriaku POZOR,pokud se meni sms pro ovladani,musi se zmenit i toto cislo
	movlw '6'	; d'67' b'1000011' a'C'		;zacne porovnavat,tato data jsou pro zapnuti
	bcf STATUS,Z
	subwf 0x13,w
	btfss STATUS,Z
	goto lbl_44	; lbl_44 = 0x199
	movlw '9'	; d'50' b'110010' a'2'
	bcf STATUS,Z
	subwf 0x14,w
	btfss STATUS,Z
	goto lbl_44
	movlw 'B'	; d'50' b'110010' a'2'
	bcf STATUS,Z
	subwf 0x15,w
	btfss STATUS,Z
	goto lbl_44
	movlw '3'	; d'54' b'110110' a'6'
	bcf STATUS,Z
	subwf 0x16,w
	btfss STATUS,Z
	goto lbl_44
	movlw 'A'	; d'65' b'1000001' a'A'
	bcf STATUS,Z
	subwf 0x17,w
	btfss STATUS,Z
	goto lbl_44
	movlw '5'	; d'68' b'1000100' a'D'
	bcf STATUS,Z
	subwf 0x18,w
	btfss STATUS,Z
	goto lbl_44
	movlw '0'	; d'65' b'1000001' a'A'
	bcf STATUS,Z
	subwf 0x19,w
	btfss STATUS,Z
	goto lbl_44
	movlw 'D'	; d'53' b'110101' a'5'
	bcf STATUS,Z
	subwf 0x1A,w
	btfss STATUS,Z
	goto lbl_44
	movlw '4'	; d'56' b'111000' a'8'
	bcf STATUS,Z
	subwf 0x1B,w
	btfss STATUS,Z
	goto lbl_44
	movlw '2'	; d'68' b'1000100' a'D'
	bcf STATUS,Z
	subwf 0x1C,w
	btfss STATUS,Z
	goto lbl_44
	movlw 30H	; d'48' b'110000' a'0'
	bcf STATUS,Z
	subwf 0x1D,w
	btfss STATUS,Z
	goto lbl_44
	movlw 31H	; d'49' b'110001' a'1'
	bcf STATUS,Z
	subwf 0x1E,w
	btfss STATUS,Z
	goto lbl_44
	bsf 0x12,0					;prijata zprava je tahle, vysledek porovnani je OK,nastav flag pro zapnuti rele
	movlw 1	; d'0' b'0' a''		;nacti adresu EEPROM
	movwf EEADR
	movf 0x12,w					;priprav data do EEPROM
	movwf EEDATA
	call lbl_45	; lbl_45 = 0x5B		;zapis data do EEPROM
	bsf 0x11,7					;nastav flag ze zprava byla OK prijata
	goto lbl_41					;pokracuj smazanim zpravy
lbl_44	movlw '6'	; d'67' b'1000011' a'C'
	bcf STATUS,Z
	subwf 0x13,w
	btfss STATUS,Z
	goto lbl_41
	movlw '9'	; d'50' b'110010' a'2'
	bcf STATUS,Z
	subwf 0x14,w
	btfss STATUS,Z
	goto lbl_41
	movlw 'B'	; d'50' b'110010' a'2'
	bcf STATUS,Z
	subwf 0x15,w
	btfss STATUS,Z
	goto lbl_41
	movlw '3'	; d'54' b'110110' a'6'
	bcf STATUS,Z
	subwf 0x16,w
	btfss STATUS,Z
	goto lbl_41
	movlw '6'	; d'65' b'1000001' a'A'
	bcf STATUS,Z
	subwf 0x17,w
	btfss STATUS,Z
	goto lbl_41
	movlw '5'	; d'68' b'1000100' a'D'
	bcf STATUS,Z
	subwf 0x18,w
	btfss STATUS,Z
	goto lbl_41
	movlw 'C'	; d'54' b'110110' a'6'
	bcf STATUS,Z
	subwf 0x19,w
	btfss STATUS,Z
	goto lbl_41
	movlw 'D'	; d'53' b'110101' a'5'
	bcf STATUS,Z
	subwf 0x1A,w
	btfss STATUS,Z
	goto lbl_41
	movlw '4'	; d'56' b'111000' a'8'
	bcf STATUS,Z
	subwf 0x1B,w
	btfss STATUS,Z
	goto lbl_41
	movlw '2'	; d'68' b'1000100' a'D'
	bcf STATUS,Z
	subwf 0x1C,w
	btfss STATUS,Z
	goto lbl_41
	movlw 30H	; d'48' b'110000' a'0'
	bcf STATUS,Z
	subwf 0x1D,w
	btfss STATUS,Z
	goto lbl_41
	movlw 31H	; d'49' b'110001' a'1'
	bcf STATUS,Z
	subwf 0x1E,w
	btfss STATUS,Z
	goto lbl_41
	bcf 0x12,0				;prijata zprava je tahle, vysledek porovnani je OK,nastav flag pro vypnuti rele

	movlw 1	; d'0' b'0' a''	;adresa pro zapis do EEPROM
	movwf EEADR				
	movf 0x12,w			;data pro zapis do EEPROM
	movwf EEDATA		
	call lbl_45			;vypal data
	bsf 0x11,7			;nastav flag pro prozvonei,ze SMS byla OK prijata
					;a pokracuj smazanim SMS
;--------------smaze SMS,cislo v prikazu udava pozici zpravy,ktera ma byt smazana
lbl_41	call lbl_24				;posli AT+
	movlw 43H	; d'67' b'1000011' a'C'
	call lbl_23
	movlw 4DH	; d'77' b'1001101' a'M'
	call lbl_23
	movlw 47H	; d'71' b'1000111' a'G'
	call lbl_23
	movlw 44H	; d'68' b'1000100' a'D'
	call lbl_23
	movlw 3DH	; d'61' b'111101' a'='
	call lbl_23
	movlw 31H	; d'49' b'110001' a'1'
	call lbl_23
	movlw 0DH	; d'13' b'1101' a''
	call lbl_23
	goto lbl_42			;zpet na zacatek 

	END
