#include "global.h"
#include "pidlight.h"
#include "w_pidlight.h"
#include "i_pidlight.h"
#include <stdio.h>

#define SIGNAL_MAX 100
#define SIGNAL_MIN -100

static double Ap_parameter = 1;
static double Tis_parameter = 1;
static double Tds_parameter = 1;
static double Ts_parameter = 0.1;
static double beavatkozo_temp = 0;
static double integrationPart_temp = 0;
static double derivationPart_temp = 0;
static PIDLight_DInput pidLight_DInput_parameter = PIDLight_bindDToHiba;

static double filterT1(double in, double T1, double *temp);

void do_pidLight(void) {
}

void init_pidLight(void) {
	pidLight_setDInput(PIDLight_bindDToHiba);
	pidLight_setParameters(1, 1, 0.001);
}

void pidLight_setSamplingTime(double Ts) {
	Ts_parameter = Ts;
}

void pidLight_setParameters(double Ap, double Ti, double Td) {
	integrationPart_temp = 0;
	derivationPart_temp = 0;
	Ap_parameter = Ap;
	if (Ti == 0) {
		Tis_parameter = 0;
	} else {
		Tis_parameter = Ts_parameter / Ti;
	}
	if (Td == 0) {
		Tds_parameter = 0;
	} else {
		Tds_parameter = Td / Ts_parameter;
	}
}

void pidLight_setDInput(PIDLight_DInput pidLight_DInput) {
	pidLight_DInput_parameter = pidLight_DInput;
}

void pidLight_calculate(double alap, double ellenorzo, double *heat, double *cold) {
	if (heat != NULL) {
		if (cold != NULL) {
			double hiba = 0;
			double beavatkozo = 0;

			double proportionalPart = 0;
			double integrationPart = 0;
			double derivationPart = 0;
			double proportionalDerivativePart = 0;

			hiba = alap - ellenorzo;
			
			proportionalPart = Ap_parameter * hiba;
			
			if ((proportionalPart < SIGNAL_MAX) && (proportionalPart > SIGNAL_MIN)) {
				if (Tds_parameter != 0) {
					double derivationInput = 0;
					switch (pidLight_DInput_parameter) {
						case PIDLight_bindDToAlap : {
							derivationInput = alap;
							break;
						}
						case PIDLight_bindDToEllenorzo : {
							derivationInput = ellenorzo;
							break;
						}
						case PIDLight_bindDToHiba : {
							derivationInput = hiba;
							break;
						}
						default : {
							derivationInput = 0;
							break;
						}
					}
					derivationPart = (derivationInput - derivationPart_temp) * Tds_parameter;
					derivationPart_temp = derivationInput;
				}
			
				proportionalDerivativePart = proportionalPart + derivationPart;
				
				if ((proportionalDerivativePart < SIGNAL_MAX) && (proportionalDerivativePart > SIGNAL_MIN)) {
					if (Tis_parameter != 0) {
						integrationPart_temp += hiba;
						integrationPart = integrationPart_temp * Tis_parameter;
						if (integrationPart > SIGNAL_MAX) {
							integrationPart = SIGNAL_MAX;
						} else if (integrationPart < SIGNAL_MIN) {
							integrationPart = SIGNAL_MIN;
						}
					}
				}
			} else {
				proportionalDerivativePart = proportionalPart;
			}
			beavatkozo = proportionalDerivativePart + integrationPart;
			if (beavatkozo > SIGNAL_MAX) {
				beavatkozo = SIGNAL_MAX;
			} else if (beavatkozo < SIGNAL_MIN) {
				beavatkozo = SIGNAL_MIN;
			}

			beavatkozo = filterT1(beavatkozo, 0.5, &beavatkozo_temp);
		
			if (beavatkozo > 0) {
				*heat = beavatkozo;
				*cold = 0;
			} else {
				*heat = 0;
				*cold = beavatkozo;
			}
			
		} else {
		}
	} else {
	}
}

void isr_pidLight1ms(void) {
}

static double filterT1(double in, double T1, double *temp) {
	double result = 0;
	double reciproctcsillag = Ts_parameter / T1 ;
	
	result = (reciproctcsillag * in) + ((1 - reciproctcsillag) * (*temp));
	*temp = result;

	return result;
}
