#include "ringBuffer.h"
#include <string.h>
#include "mal.h"

int ringBuffer_initBuffer(RingBuffer *ringBuffer, unsigned char *buffer, unsigned int bufferSize) {
	int result = -1;
	if ((ringBuffer != NULL) && (buffer != NULL) && (bufferSize > 1)) {
		ringBuffer->buffer = buffer;
		ringBuffer->bufferSize = bufferSize;
		ringBuffer->bufferRead = buffer;
		ringBuffer->bufferWrite = buffer;
		ringBuffer->bufferFull = 0;
		result = 0;
	}
	return result;
}

int ringBuffer_getFillness(RingBuffer *ringBuffer, RingBufferFillnes *ringBufferFillnes, unsigned int *cnt) {
	int result = -1;
	if (ringBuffer != NULL) {
		int delta = 0;
		lock_isr();
		delta = (int)ringBuffer->bufferRead - (int)ringBuffer->bufferWrite;
		if (cnt != NULL) {
			*cnt = delta;
		}
		if (delta == 0) {
			if (ringBuffer->bufferFull) {
				if (ringBufferFillnes != NULL) {
					*ringBufferFillnes = RingBuffer_Full;
				}
				result = 0;
			} else {
				if (ringBufferFillnes != NULL) {
					*ringBufferFillnes = RingBuffer_Empty;
				}
				result = 0;
			}
		} else {
			if (ringBufferFillnes != NULL) {
				*ringBufferFillnes = RingBuffer_NotFullNotEmpty;
			}
			result = 0;
		}
		unlock_isr();
	}
	return result;
}

int ringBuffer_addItem(RingBuffer *ringBuffer, unsigned char data) {
	int result = -1;
	if (ringBuffer != NULL) {
		RingBufferFillnes ringBufferFillnes;
		ringBuffer_getFillness(ringBuffer, &ringBufferFillnes, NULL);
		if (ringBufferFillnes != RingBuffer_Full) {
			lock_isr();

			*ringBuffer->bufferWrite = data;
			ringBuffer->bufferWrite++;
			if (ringBuffer->buffer + ringBuffer->bufferSize == ringBuffer->bufferWrite) {
				ringBuffer->bufferWrite = ringBuffer->buffer;
			}
			
			if (ringBuffer->bufferWrite == ringBuffer->bufferRead) {
				ringBuffer->bufferFull = 1;
			}
			
			unlock_isr();
			result = 0;
		}
	}
	return result;
}

int ringBuffer_getItem(RingBuffer *ringBuffer, unsigned char *data) {
	int result = -1;
	if ((ringBuffer != NULL) && (data != NULL)) {
		RingBufferFillnes ringBufferFillnes;
		ringBuffer_getFillness(ringBuffer, &ringBufferFillnes, NULL);
		if (ringBufferFillnes != RingBuffer_Empty) {
			lock_isr();
			*data = *ringBuffer->bufferRead;
			*ringBuffer->bufferRead = 0x00;
			ringBuffer->bufferRead++;
			if (ringBuffer->buffer + ringBuffer->bufferSize == ringBuffer->bufferRead) {
				ringBuffer->bufferRead = ringBuffer->buffer;
			}

			if (ringBuffer->bufferWrite != ringBuffer->bufferRead) {
				ringBuffer->bufferFull = 0;
			}
			
			unlock_isr();
			result = 0;
		}
	}
	return result;
}
