#include "global.h"
#include "mal.h"
#include "serial.h"
#include "i_serial.h"
#include "w_serial.h"

#include "io_states.h"

#include "ringBuffer.h"
#include <string.h>

#define RX_LEN 32
#define TX_LEN 64

RingBuffer myRingBuffer_rs232_tx;
unsigned char rs232_tx[TX_LEN];
RingBuffer myRingBuffer_rs232_rx;
unsigned char rs232_rx[RX_LEN];

Blocking blockingMode = BLOCKING_OFF;

unsigned long missedTxChar = 0;
unsigned long missedRxChar = 0;

void init_serial(void) {	//115200bps init t.b.d 48MHz
	ringBuffer_initBuffer(&myRingBuffer_rs232_tx, rs232_tx, sizeof(rs232_tx) / sizeof(*rs232_tx));
	ringBuffer_initBuffer(&myRingBuffer_rs232_rx, rs232_rx, sizeof(rs232_rx) / sizeof(*rs232_rx));

	RX_TRIS = IN;
	TX_TRIS = OUT;

	IPR1bits.TXIP = 0;
	IPR1bits.RCIP = 0;

	PIE1bits.RCIE = 1;
	
	SPBRGH = 0;
	SPBRG = 103; //115200 Baud
	
	TXSTA = 0b00100000;
	RCSTA = 0b10010000;

	BAUDCON = 0b00000000;
	BAUDCONbits.BRG16 = 1;
	TXSTAbits.BRGH = 1;
}

int isrSerialTx(void) {
	unsigned char data = 0;
	if (ringBuffer_getItem(&myRingBuffer_rs232_tx, &data) != -1) {
		TXREG = data;
	} else {
		PIE1bits.TXIE = 0;
	}
	return 0;
}

int isrSerialRx(unsigned char data) {
	if (ringBuffer_addItem(&myRingBuffer_rs232_rx, data) != -1) {
	} else {
		 missedRxChar++;
	}
	if (RCSTAbits.FERR) {
	}
	if (RCSTAbits.OERR) {
		RCSTAbits.CREN = 0;
		RCSTAbits.CREN = 1;
	}
	return 0;
}

int isCharInBuffer(void) {
	int result = -1;
	unsigned int cnt = 0;
	if (ringBuffer_getFillness(&myRingBuffer_rs232_rx, NULL, &cnt) != -1) {
		result = cnt;
	}
	return result;
}

int getChar(void) {
	int result = -1;
	unsigned char data = 0;
	if (ringBuffer_getItem(&myRingBuffer_rs232_rx, &data) != -1) {
		result = data;
	}
	return result;
}

void putChar(unsigned char data) {
	if (blockingMode == BLOCKING_ON) {
		flush();
	}
	if (ringBuffer_addItem(&myRingBuffer_rs232_tx, data) != -1) {
		if (PIE1bits.TXIE == 0) {
			PIE1bits.TXIE = 1;
		}
	} else {
		missedTxChar++;
	}
}

void flush(void) {
	while (1) {
		RingBufferFillnes ringBufferFillnes;
		if (ringBuffer_getFillness(&myRingBuffer_rs232_tx, &ringBufferFillnes, NULL) != -1) {
			if (ringBufferFillnes == RingBuffer_Empty) {
				break;
			}
		} else {
			break;
		}

	}
}

void setBlockingMode(Blocking newBlockingMode) {
	blockingMode = newBlockingMode;
}