#include <p18f4550.h>
#include "global.h"
#include "tc77.h"
#include "c_tc77.h"
#include "io_states.h"

#if FILTERING_TYPE == MOVING_MEAN_ARRAY
	unsigned int rawTempArray[32];
	unsigned char rawTempArrayCnt = 0;
#endif

static unsigned int TC77RawTemp = 0;
static unsigned char doTc77Read = 0;
static unsigned int readTc77 (void);
static float convertTC77rawTempToTemp (unsigned int rawTemp);
static void tcDelay(void);

float getTC77temp(void) {
	return convertTC77rawTempToTemp(TC77RawTemp);
}

void init_tc77(void) {
	ADCON1 = 0x0E;
	INTCON2bits.RBPU = 0;

	CS = 1;
	CS_TRIS = OUT;

	SCK = 0;
	SCK_TRIS = OUT;

	SIO_TRIS = IN;
}

static unsigned int readTc77(void) {
	unsigned int i = 0;
	unsigned int result = 0;
	unsigned int mask = 0;
	SCK = 0;
	CS = 0;
	tcDelay();
	SIO_TRIS = IN;
	for (i = 0; i < 16; i++) {
		SCK = 0;
		tcDelay();
		if (SIO) {
			mask = 1;
			mask = mask << (15 - i);
			result |= mask;
		}
		SCK = 1;
		tcDelay();
	}
	SIO_TRIS = OUT;
	SIO = 0;
	for (i = 0; i < 16; i++) {
		SCK = 0;
		tcDelay();
		SCK = 1;
		tcDelay();
	}
	CS = 1;
	return result;
}

static float convertTC77rawTempToTemp (unsigned int rawTemp) {
	float result = 0;
	#if FILTERING_TYPE == MOVING_MEAN_ARRAY
		unsigned int temp = 0;
		unsigned int x = 0;
		unsigned long rawMean = 0;
		rawTempArray[rawTempArrayCnt] = rawTemp;
		rawTempArrayCnt++;
		if (rawTempArrayCnt == (sizeof(rawTempArray) / sizeof(*rawTempArray))) {
			rawTempArrayCnt = 0;
		}
		for (x = 0; x < (sizeof(rawTempArray) / sizeof(*rawTempArray)); x++) {
			rawMean += rawTempArray[x];
		}
		rawMean /= (sizeof(rawTempArray) / sizeof(*rawTempArray));

		temp = rawMean;
		temp = temp >> 3;
		result = temp;
		result *= 0.0625;
	#endif
	#if FILTERING_TYPE == PT1_FILTER
		static float tempResult = 0;
		unsigned int temp = 0;
		temp = rawTemp;
		temp = temp >> 3;
		result = temp;
		result *= 0.0625;
		tempResult += (result - tempResult) / 20;
	#endif
	return result;
}

static void tcDelay(void) {
	_asm
		NOP
	_endasm
}

int isr_tc77Cycle100ms(void) {
	doTc77Read = 1;
}

void w_tc77 (void) {
	if (doTc77Read == 1) {
		doTc77Read = 0;
		TC77RawTemp = readTc77();
	}
}
