#ifndef _RINGBUFFER_H_
#define _RINGBUFFER_H_

typedef enum _RingBufferFillnes {
	RingBuffer_Empty,
	RingBuffer_NotFullNotEmpty,
	RingBuffer_Full,
} RingBufferFillnes;

typedef struct _RingBuffer {
	unsigned char *buffer;
	unsigned char *bufferRead;
	unsigned char *bufferWrite;
	unsigned int bufferSize;
	unsigned char bufferFull;
} RingBuffer;

extern int ringBuffer_initBuffer(RingBuffer *ringBuffer, unsigned char *buffer, unsigned int bufferSize);

extern int ringBuffer_getFillness(RingBuffer *ringBuffer, RingBufferFillnes *ringBufferFillnes, unsigned int *cnt);
extern int ringBuffer_addItem(RingBuffer *ringBuffer, unsigned char data);

extern int ringBuffer_getItem(RingBuffer *ringBuffer, unsigned char *data);

#endif
