/*****************************************************************************/
/**                                                                         **/
/**                               m a i n . c                               **/
/**                                                                         **/
/*****************************************************************************/
/**                                                                         **/
/**                  Copyrights(c) 2008 by Andras Huszti,                   **/
/**                              Budapest                                   **/
/**                                                                         **/
/** Project   :    PID library                                              **/
/** Date      :    22.08.2008                                               **/
/** Author    :    A. Huszti                                                **/
/**                                                                         **/
/*****************************************************************************/
/** Content: Short description / summary                                    **/
/**                                                                         **/
/*****************************************************************************/
/** Date       Author        Rev  Changes:                                  **/
/** 22.08.2008 A. Huszti     1.0  Start:                                    **/
/**                                                                         **/
/*****************************************************************************/

/*********************** Compiler options ( #pragma ) ************************/

	#pragma config PLLDIV   = 5         // (20 MHz crystal on PICDEM FS USB board)
	#pragma config CPUDIV   = OSC1_PLL2	
	#pragma config USBDIV   = 2         // Clock source from 96MHz PLL/2
	#pragma config FOSC     = HSPLL_HS
	#pragma config FCMEN    = OFF
	#pragma config IESO     = OFF
	#pragma config PWRT     = ON
	#pragma config BOR      = ON
	#pragma config BORV     = 3
	#pragma config VREGEN   = OFF		//USB Voltage Regulator
	#pragma config WDT      = OFF
	#pragma config WDTPS    = 32768
	#pragma config MCLRE    = ON
	#pragma config LPT1OSC  = OFF
	#pragma config PBADEN   = OFF
//	#pragma config CCP2MX   = ON
	#pragma config STVREN   = ON
	#pragma config LVP      = OFF
//	#pragma config ICPRT    = OFF       // Dedicated In-Circuit Debug/Programming
	#pragma config XINST    = OFF       // Extended Instruction Set
	#pragma config CP0      = OFF
	#pragma config CP1      = OFF
//	#pragma config CP2      = OFF
//	#pragma config CP3      = OFF
	#pragma config CPB      = OFF
//	#pragma config CPD      = OFF
	#pragma config WRT0     = OFF
	#pragma config WRT1     = OFF
//	#pragma config WRT2     = OFF
//	#pragma config WRT3     = OFF
	#pragma config WRTB     = OFF       // Boot Block Write Protection
	#pragma config WRTC     = OFF
//	#pragma config WRTD     = OFF
	#pragma config EBTR0    = OFF
	#pragma config EBTR1    = OFF
//	#pragma config EBTR2    = OFF
//	#pragma config EBTR3    = OFF
	#pragma config EBTRB    = OFF

/******************* Header / include files ( #include ) *********************/

#include <p18f4550.h>
#include "global.h"
#include "main.h"
#include <stdio.h>
#include "pidlight.h"
#include "w_pidlight.h"
#include "i_pidlight.h"

#include "w_serial.h"
#include "i_serial.h"
#include "serial.h"

#include "w_tc77.h"
#include "tc77.h"

#include "mal.h"
/***************** Constant / macro definitions ( #define ) ******************/

/*********************** Type definitions ( typedef ) ************************/

/************************* Global data definitions ***************************/
double alap = 0;
double ellenorzo = 0;
double heat = 0;
double cold = 0;

float temperature_isr = 0;

unsigned char doMain1s = 0;
/****************** Global constant definitions ( const ) ********************/

/******************* Modul global data segment ( static ) ********************/

/***************** Modul global constants ( static const ) *******************/

/****************** Local func/proc prototypes ( static ) ********************/
void InterruptHandlerHigh (void);
	
/** EndOfHeader **************************************************************/

/*****************************************************************************/
/**                                                                         **/
/** Function  :                                                             **/
/** Param In  :                                                             **/
/** Param Out :                                                             **/
/** Return    :                                                             **/
/** Data In   :                                                             **/
/** Data Out  :                                                             **/
/** Remarks   :                                                             **/
/*****************************************************************************/
void main (void) {

/************************** Local data declaration ***************************/

/************************* Static data declaration ***************************/

/****************************** Function Code ********************************/

	//init PWM and TMR2
	CCP1CON = 0b00001100;
	CCP2CON = 0b00001100;

	CCPR1L = 0x00;
	CCP1CONbits.DC1B0 = 0;
	CCP1CONbits.DC1B1 = 0;

	CCPR2L = 0x00;
	CCP2CONbits.DC2B0 = 0;
	CCP2CONbits.DC2B1 = 0;

	PR2 = 0xFF;
	TRISCbits.TRISC1 = OUT;
	TRISCbits.TRISC2 = OUT;

	T2CON = 0b00000000;
	T2CONbits.TMR2ON = 1;
	PIR1bits.TMR2IF = 0;
	PIE1bits.TMR2IE = 0;
	IPR1bits.TMR2IP = 0;

	//init AD using AD0,AD1
	TRISAbits.TRISA0 = IN;
	TRISAbits.TRISA1 = IN;

	ADCON0 = 0b00000001;
	ADCON1 = 0b00001101;
	ADCON2 = 0b10010110;
	//ADCON0bits.GO = 1;

	//IPR1bits.ADIP = 0;
	PIR1bits.ADIF = 0;
	PIE1bits.ADIE = 1;

	//TMR0	100ms 4 * (256 * 148) * 32 / 48000000 = 174 //6C 00
	T0CON = 0b10000100;
	TMR0H = 0x6C;
	TMR0L = 0x00;
	INTCONbits.TMR0IF = 0;
	INTCONbits.TMR0IE = 1;

	init_serial();

	//init Interrupt
	INTCONbits.PEIE = 1;
	INTCONbits.GIE = 1;

	init_tc77();

	printf("\r\nPID light\r\n");

	//PID init
	init_pidLight();

	pidLight_setDInput(PIDLight_bindDToEllenorzo);
	pidLight_setSamplingTime(0.1);		/* Time sclice where doControling is called	1000 = 1000ms = 1s */
	pidLight_setParameters(5, 0, 0); /* PID parameter settings */
	while (1) {
		w_tc77();
		if (doMain1s) {
			doMain1s = 0;
			printf("Tick\r\n");
			{
				float temperature = 0;
				temperature = getTC77temp();
				lock_isr();
				temperature_isr = temperature;
				unlock_isr();
				
				temperature *= 100;
				printf("Temperature: %5.1d.%2.2d\r\n", (int)temperature / 100, (int)temperature % 100);
				
			}
			
			{
				double alap_isr = 0;
				double ellenorzo_isr = 0;
				double heat_isr = 0;
				double cold_isr = 0;
				lock_isr();
				alap_isr = alap;
				ellenorzo_isr = ellenorzo;
				heat_isr = heat;
				cold_isr = -cold;
				unlock_isr();

				printf("Alap: %5.1d Ellenorzo: %5.1d Heat: %5.1d Cold: %5.1d\r\n", (int) alap_isr, (int) ellenorzo_isr, (int)heat_isr, (int)cold_isr);
			}
			
		}
	}
}
/** EndOfFunction ************************************************************/

int _user_putc (char c) {
	putChar(c);
}

int _usart_putc (char c) {
	putChar(c);
}

/*****************************************************************************/
/**                                                                         **/
/** Function  :                                                             **/
/** Param In  :                                                             **/
/** Param Out :                                                             **/
/** Return    :                                                             **/
/** Data In   :                                                             **/
/** Data Out  :                                                             **/
/** Remarks   :                                                             **/
/*****************************************************************************/
#pragma code InterruptVectorHigh = 0x08
void InterruptVectorHigh (void) {
  _asm
    goto InterruptHandlerHigh //jump to interrupt routine
  _endasm
}
/** EndOfFunction ************************************************************/

/*****************************************************************************/
/**                                                                         **/
/** Function  :                                                             **/
/** Param In  :                                                             **/
/** Param Out :                                                             **/
/** Return    :                                                             **/
/** Data In   :                                                             **/
/** Data Out  :                                                             **/
/** Remarks   :                                                             **/
/*****************************************************************************/
#pragma code
#pragma interrupt InterruptHandlerHigh
void InterruptHandlerHigh () {

/************************** Local data declaration ***************************/
	static unsigned long doMain1sCnt = 0;
	unsigned int adresult_temp = 0;

/************************* Static data declaration ***************************/

/****************************** Function Code ********************************/

	if ((PIE1bits.RCIE) && (PIR1bits.RCIF)) {
		isrSerialRx(RCREG);
	}
	if ((PIE1bits.TXIE) && (PIR1bits.TXIF)) {
		isrSerialTx();
	}
	if ((PIR1bits.ADIF) && (PIE1bits.ADIE)) {
		PIR1bits.ADIF = 0;
		adresult_temp = ADRESH;
		adresult_temp <<= 8;
		adresult_temp += ADRESL;
		if ((ADCON0 & 0b00111100) == 0b00000000) {	//AN0
			ADCON0 = (ADCON0 & 0b11000011) | 0b00000100;
			alap = (double)adresult_temp;
			alap *= 100;
			alap /= 1024;
		} else if ((ADCON0 & 0b00111100) == 0b00000100) {	//AN1
			ADCON0 = (ADCON0 & 0b11000011) | 0b00000000;
			ellenorzo = (double)adresult_temp;
			ellenorzo *= 100;
			ellenorzo /= 1024;
			ellenorzo =  temperature_isr;
		} else {	// ???
			ADCON0 = (ADCON0 & 0b11000011) | 0b00000000;
		}
	}

	if ((INTCONbits.TMR0IF) && (INTCONbits.TMR0IE)) {	//100ms
		INTCONbits.TMR0IF = 0;
		TMR0H = 0x6C;
		TMR0L = 0x00;
		pidLight_calculate(alap, ellenorzo, &heat, &cold);
		heat *= 1024;
		heat /= 100;
		cold *= 1024;
		cold /= 100;

		CCPR1L = (((unsigned int) -cold) >> 2) & 0xFF;
		CCP1CONbits.DC1B0 = (((unsigned int) -cold) >> 8) & 0x01;
		CCP1CONbits.DC1B1 = (((unsigned int) -cold) >> 9) & 0x01;

		CCPR2L = (((unsigned int) heat) >> 2) & 0xFF;
		CCP2CONbits.DC2B0 = (((unsigned int) heat) >> 8) & 0x01;
		CCP2CONbits.DC2B1 = (((unsigned int) heat) >> 9) & 0x01;		
		ADCON0bits.GO = 1;

		isr_tc77Cycle100ms();
		doMain1sCnt ++;
		if (doMain1sCnt == 2) {
			doMain1sCnt = 0;
			doMain1s = 1;
		}
	}
}
/** EndOfFunction ************************************************************/

/** EndOfFile main.c *********************************************************/
