'****************************************************************************
'3axstep.bas     Copyright Phil Rayner All right's reserved 13-11-1998
'A basic program made by 1997/1998 (Luberth@wxs.nl)
'Using the core from Luberth Dijkman but heavily modified by Phil Rayner (phil_rayner@totalise.net)
'-new features of use with 5804ICs, setting a datum, recording a log file and running log files,
'     and stopping motion on reaching end stops
'
'
'Be careful when playing with parallel port
'
'For more info about plotter / pcbdriller
'visit my web page at http://www.users.totalise.co.uk/~phil_rayner
'or visit Luberth's at http://home.wxs.nl/~luberth
'
'This file is not to be sold or part of a commercial product without
'prior written permission from Phil Rayner
'All rights reserved
'****************************************************************************
calibx = 700 / 140                           'calibration:mm into steps
caliby = 1000 / 211.5
backlashx = 1                                  'backlash compensation steps
backlashy = 2

CLS
TIMER ON
Starttime = TIMER
OPEN "D:/1qbasic/log.txt" FOR OUTPUT AS #1

x% = 300                        'delay for each step in each direction
y% = 300
z% = 200

PRINT #1, "Time ,"; "xstep ,"; "ystep ,"; "zstep ,"; "x%= ,"; x%; ", y%= ,"; y%; ", z%= ,"; z%
xstep = 0
ystep = 0
zstep = 0

xreal = 0
yreal = 0
zreal = 0

LPT = &H278
LOCATE 1, 1: PRINT "LPT port Hex "; HEX$(LPT); "     LPT port Dec "; LPT

'**************************************************************************
'program that uses sub keycontrol & sub vecout to perform 3 axis control
'**************************************************************************
LOCATE 21, 1: PRINT "Keycontrol with arrowkeys & pgup/pgdn  "
LOCATE 22, 1: PRINT "Or numlock on and use 1 to 9 for xy control 5 for keycounter reset"
LOCATE 23, 1: PRINT "Escape starts vector o/p, h to find home, x,y,z to set positions, d newdatum,"
LOCATE 24, 1: PRINT "p for drill file entry, f for step (log) file entry"

GOSUB keycontrol


DO
	stepdelay = y%
	xstep = 0                                                 'steps
	ystep = 0
	zstep = 0
	GOSUB Vecout
       

LOOP UNTIL INKEY$ = CHR$(27)

CLOSE
END            'of program





'**************************************************************************
'start of the sub vecout
'**************************************************************************

Vecout:

 xmotvaltable = 16

 ymotvaltable = 32

 zmotvaltable = 64
								'save data titles

PRINT #1, Timepast; ","; xstep; ","; ystep; ","; zstep

IF xstep > 0 AND xid < 0 THEN
			xstep = xstep + backlashx         'backlash compensation
			xreal = xreal - backlashx
			END IF

IF xstep < 0 AND xid >= 0 THEN
			xstep = xstep - backlashx
			xreal = xreal + backlashx
			END IF
IF ystep > 0 AND yid < 0 THEN
			ystep = ystep + backlashy
			yreal = yreal - backlashy
			END IF
IF ystep < 0 AND yid >= 0 THEN
			ystep = ystep - backlashy
			yreal = yreal + backlashy
			END IF

IF (xstep = 0 AND ystep = 0 AND zstep = 0) THEN RETURN
IF xstep < 0 THEN
		xdir = 1
		x = ABS(xstep)
		ELSE xdir = 0
		x = xstep
END IF
IF ystep < 0 THEN
		ydir = 2
		y = ABS(ystep)
		ELSE ydir = 1
		y = ystep
END IF
IF zstep < 0 THEN
		zdir = 3
		z = ABS(zstep)
		ELSE zdir = 2
		z = zstep
END IF
	IF x >= y THEN
		 IF x >= z THEN
			firstval = x
			firstaccu = x
			secondval = y
			secondaccu = y
			thirdval = z
			thirdaccu = z
			firstmode = 1 + xdir
			secondmode = 2 + ydir
			thirdmode = 3 + zdir
		ELSE
			firstval = z
			firstaccu = z
			secondval = x
			secondaccu = x
			thirdval = y
			thirdaccu = y
			firstmode = 3 + zdir
			secondmode = 1 + xdir
			thirdmode = 2 + ydir
		END IF
	ELSE
		IF y >= z THEN
			firstval = y
			firstaccu = y
			secondval = x
			secondaccu = x
			thirdval = z
			thirdaccu = z
			firstmode = 2 + ydir
			secondmode = 1 + xdir
			thirdmode = 3 + zdir
		 ELSE
			firstval = z
			firstaccu = z
			secondval = x
			secondaccu = x
			thirdval = y
			thirdaccu = y
			firstmode = 3 + zdir
			secondmode = 1 + xdir
			thirdmode = 2 + ydir
		END IF
	END IF
	 
			LOCATE 13, 20: PRINT "x        "; USING "######"; x
			LOCATE 14, 20: PRINT "y        "; USING "######"; y
			LOCATE 15, 20: PRINT "z        "; USING "######"; z
	 
			LOCATE 16, 20: PRINT "xstep    "; USING "######"; xstep
			LOCATE 17, 20: PRINT "ystep    "; USING "######"; ystep
			LOCATE 18, 20: PRINT "zstep    "; USING "######"; zstep
DO
			LOCATE 10, 1: PRINT "firstval   "; USING "######"; firstval
			LOCATE 11, 1: PRINT "secondval  "; USING "######"; secondval
			LOCATE 12, 1: PRINT "thirdval   "; USING "######"; thirdval
			LOCATE 13, 1: PRINT "firstaccu  "; USING "######"; firstaccu
			LOCATE 14, 1: PRINT "secondaccu "; USING "######"; secondaccu
			LOCATE 15, 1: PRINT "thirdaccu  "; USING "######"; thirdaccu
			LOCATE 16, 1: PRINT "firstmode  "; USING "######"; firstmode
			LOCATE 17, 1: PRINT "secondmode "; USING "######"; secondmode
			LOCATE 18, 1: PRINT "thirdmode  "; USING "######"; thirdmode
	
		SELECT CASE firstmode
			CASE 1
				stepdelay = x%
				xreal = xreal + 1
				xid = 1                'tracks last movement for backlash compensation
				dir = 0
				xoutputValue = xmotvaltable
				GOSUB motoroutput
			 
			CASE 2
				stepdelay = x%
				xreal = xreal - 1
				xid = -1
				dir = 1
				xoutputValue = xmotvaltable + dir
				GOSUB motoroutput
			       
			CASE 3
				stepdelay = y%
				yreal = yreal + 1
				yid = 1
				dir = 0
				youtputValue = ymotvaltable
				GOSUB motoroutput
			 
			CASE 4
				stepdelay = y%
				yreal = yreal - 1
				yid = -1
				dir = 2
				youtputValue = ymotvaltable + dir
				GOSUB motoroutput
			      
			CASE 5
				stepdelay = z%
				zreal = zreal + 1
				dir = 0
				zoutputvalue = zmotvaltable
				GOSUB motoroutput
			       
			 
			CASE 6
				stepdelay = z%
				zreal = zreal - 1
				dir = 4
				zoutputvalue = (zmotvaltable + dir)
				GOSUB motoroutput

		END SELECT

	firstaccu = firstaccu - 1                                           'dec
	secondaccu = secondaccu + secondval
	thirdaccu = thirdaccu + thirdval

IF secondaccu >= firstval THEN
		secondaccu = secondaccu - firstval
		SELECT CASE secondmode
			CASE 1
				stepdelay = x%
				dir = 0
				xid = 1
				xreal = xreal + 1
				xoutputValue = xmotvaltable
				GOSUB motoroutput
			 
			CASE 2
				stepdelay = x%
				xreal = xreal - 1
				xid = -1
				dir = 1
				xoutputValue = xmotvaltable + dir
				GOSUB motoroutput
				

			CASE 3
				stepdelay = y%
				yid = 1
				dir = 0
				yreal = yreal + 1
				youtputValue = ymotvaltable
				GOSUB motoroutput
			 
			CASE 4
				stepdelay = y%
				yreal = yreal - 1
				yid = -1
				dir = 2
				youtputValue = ymotvaltable + dir
				GOSUB motoroutput
				

			CASE 5
				stepdelay = z%
				zreal = zreal + 1
				dir = 0
				zoutputvalue = zmotvaltable
				GOSUB motoroutput
			       
			 
			CASE 6
				stepdelay = z%
				zreal = zreal - 1
				dir = 4
				zoutputvalue = (zmotvaltable + dir)
				GOSUB motoroutput
				
		END SELECT
END IF

 IF thirdaccu >= firstval THEN
		thirdaccu = thirdaccu - firstval
SELECT CASE thirdmode
			CASE 1
				stepdelay = x%
				xreal = xreal + 1
				xid = 1
				dir = 0
				xoutputValue = xmotvaltable
				GOSUB motoroutput
			 
			CASE 2
				stepdelay = x%
				xreal = xreal - 1
				xid = -1
				dir = 1
				xoutputValue = xmotvaltable + dir
				GOSUB motoroutput
			       
			CASE 3
				stepdelay = y%
				yreal = yreal + 1
				yid = 1
				dir = 0
				youtputValue = ymotvaltable
				GOSUB motoroutput
			 
			CASE 4
				stepdelay = y%
				yreal = yreal - 1
				yid = -1
				dir = 2
				youtputValue = ymotvaltable + dir
				GOSUB motoroutput
			       
			CASE 5
				stepdelay = z%
				zreal = zreal + 1
				dir = 0
				zoutputvalue = zmotvaltable
				GOSUB motoroutput
			       
			 
			CASE 6
				stepdelay = z%
				zreal = zreal - 1
				dir = 4
				zoutputvalue = (zmotvaltable + dir)
				GOSUB motoroutput
			     END SELECT
END IF

IF INKEY$ = CHR$(72) THEN PRINT "up"       'on the move adjust by altering datum
IF INKEY$ = CHR$(80) THEN yreal = yreal + 1
IF INKEY$ = CHR$(75) THEN xreal = xreal + 1
IF INKEY$ = CHR$(77) THEN xreal = xreal - 1
IF INKEY$ = CHR$(100) THEN continue$ = "d"         'request depth change


LOCATE 13, 1: PRINT "firstaccu  "; USING "######"; firstaccu
LOOP UNTIL firstaccu <= 0
firstaccu = 0
    
RETURN

'****************************************************************************
'start of sub motoroutput
'****************************************************************************

motoroutput:

 FOR t = 1 TO stepdelay: NEXT t
 limits% = INP(&H279) - 88                       '+128ztop, -16yboard, -64xboard
 IF (limits% = -16 OR limits% = 112) AND youtputValue = 34 THEN
				youtputValue = 0
 END IF
 IF limits% > 0 AND zoutputvalue = 64 AND dril = 0 THEN
				zoutputvalue = 0
 END IF
 IF (limits% = -64 OR limits% = 64) AND xoutputValue = 16 THEN
				xoutputValue = 0
 END IF
 IF (limits% = -80 OR limits% = 48) AND (xoutputValue = 16 OR youtputValue = 34) AND dril = 0 THEN
			xoutputValue = 0
			youtputValue = 0
 END IF

 'IF zreal + zstep < -1000 AND zoutputvalue = 68 THEN    'doesn't work
 '                       zreal = zreal - zstep + 1
 '                       zoutputvalue = 0
 'END IF
 'IF yreal + ystep > 780 AND youtputValue = 32 THEN       'not working
 '                       yreal = yreal - ystep
 '                       youtputValue = 0
 'END IF
 'IF xreal + xstep < -600 AND xoutputValue = 17 THEN      'not working
 '                       xreal = xreal - xstep
 '                       xoutputValue = 0
 'END IF
 



 LOCATE 3, 1: PRINT "xoutputValue       "; USING "###"; xoutputValue
 LOCATE 4, 1: PRINT "youtputValue       "; USING "###"; youtputValue
 LOCATE 5, 1: PRINT "zoutputValue       "; USING "###"; zoutputvalue
 LOCATE 6, 1: PRINT "read               "; USING "###"; limits%
 LOCATE 16, 40: PRINT "xreal "; xreal; "  "
 LOCATE 17, 40: PRINT "yreal "; yreal; "  "
 LOCATE 18, 40: PRINT "zreal "; zreal; "  "


 OUT LPT, xoutputValue + youtputValue + zoutputvalue
 OUT LPT, dir
								'timing
Timepast = TIMER - Starttime
LOCATE 10, 45: PRINT "Time: "; Timepast

 FOR t = 1 TO stepdelay: NEXT t                                 'delay
 dir = 0
 xoutputValue = 0
 youtputValue = 0
 zoutputvalue = 0
   

RETURN

'****************************************************************************
'start of sub keycontrol
'****************************************************************************

keycontrol:

 counter = 0

DO
		DO
				i$ = INKEY$
				i$ = RIGHT$(i$, 1)
		LOOP WHILE i$ = ""
	 
	
		IF i$ = oldi$ THEN
				counter = counter + 1
		ELSE
				counter = 0
		END IF
	 
		oldi$ = i$
	
		LOCATE 19, 1: PRINT "keycontrol counter "; USING "##"; counter
		LOCATE 19, 25: PRINT "< 50 = 1 step & > 50 = 10 steps movement          "
		
 
	SELECT CASE ASC(i$)

		CASE 49                                       '= 1
			IF (counter < 50) THEN
				xstep = -1
				ystep = -1
			ELSE
				xstep = -10
				ystep = -10
				counter = 50
			END IF
			stepdelay = y%
			zstep = 0
			GOSUB Vecout

		CASE 50                                       '= 2
				IF (counter < 50) THEN
					ystep = -1
				ELSE
					ystep = -10
					counter = 50
				END IF
				stepdelay = y%
				xstep = 0
				zstep = 0
				GOSUB Vecout

		CASE 51                                       '= 3
				IF (counter < 50) THEN
					xstep = 1
					ystep = -1
				ELSE
					xstep = 10
					ystep = -10
					counter = 50
				END IF
				stepdelay = y%
				zstep = 0
				GOSUB Vecout

		CASE 52                                       '= 4
				IF (counter < 50) THEN
					xstep = -1
				ELSE
					xstep = -10
					counter = 50
				END IF
				stepdelay = x%
				ystep = 0
				zstep = 0
				GOSUB Vecout

		CASE 53                                       '= 5
				counter = 0                               'reset key counter

		CASE 54                                       '= 6
				IF (counter < 50) THEN
					xstep = 1
				ELSE
					xstep = 10
					counter = 50
				END IF
				stepdelay = x%
				ystep = 0
				zstep = 0
				GOSUB Vecout

		CASE 55                                         '= 7
				IF (counter < 50) THEN
					xstep = 1
					ystep = 1
				ELSE
					xstep = 10
					ystep = 10
					counter = 50
				END IF
				stepdelay = y%
				zstep = 0
				GOSUB Vecout

		CASE 56                                         '= 8
				IF (counter < 50) THEN
					ystep = 1
				ELSE
					ystep = 10
					counter = 50
				END IF
				stepdelay = y%
				xstep = 0
				zstep = 0
				GOSUB Vecout

		CASE 57                                         '= 9
				IF (counter < 50) THEN
					xstep = 1
					ystep = 1
				ELSE
					xstep = 10
					ystep = 10
					counter = 50
				END IF
				stepdelay = y%
				zstep = 0
				GOSUB Vecout

		CASE 72
				IF (counter < 50) THEN
					ystep = 1
				ELSE
					ystep = 10
					counter = 50
				END IF
				stepdelay = y%
				xstep = 0
				zstep = 0
				GOSUB Vecout
	
		CASE 73
				IF counter < 50 THEN
					zstep = 10
				ELSE
					zstep = 100
					counter = 50
				END IF
				stepdelay = z%
				xstep = 0
				ystep = 0
				GOSUB Vecout

		CASE 75
				IF counter < 50 THEN
					xstep = -1
				ELSE
					xstep = -10
					counter = 50
				END IF
				stepdelay = x%
				ystep = 0
				zstep = 0
				GOSUB Vecout
	 
		CASE 77
				IF counter < 50 THEN
					xstep = 1
				ELSE
					xstep = 10
					counter = 50
				END IF
				stepdelay = x%
				ystep = 0
				zstep = 0
				GOSUB Vecout
 
		CASE 80
				IF counter < 50 THEN
					ystep = -1
				ELSE
					ystep = -10
					counter = 50
				END IF
				stepdelay = y%
				xstep = 0
				zstep = 0
				GOSUB Vecout
	
		CASE 81
				IF counter < 50 THEN
					zstep = -10
				ELSE
					zstep = -100
					counter = 50
				END IF
				stepdelay = z%
				xstep = 0
				ystep = 0
				GOSUB Vecout
		CASE 120                                       'x key
				LOCATE 9, 1: INPUT "xposition: "; xpos
				xstep = xpos - xreal
				ystep = 0
				zstep = 0
				stepdelay = x%
				GOSUB Vecout
		CASE 121                                       'y key
				LOCATE 9, 1: INPUT "yposition: "; ypos
				ystep = ypos - yreal
				xstep = 0
				zstep = 0
				stepdelay = y%
				GOSUB Vecout
		CASE 122                                       'z key
				LOCATE 9, 1: INPUT "zposition: "; zpos
				zstep = zpos - zreal
				xstep = 0
				ystep = 0
				stepdelay = z%
				GOSUB Vecout
		CASE 104                                       'h key
				GOSUB homefind

		CASE 100                                       'd key
				GOSUB newdatum

		CASE 102                                       'f key
				GOSUB fileread

		CASE 112                                        'p key
				GOSUB drillfile

	END SELECT
	
LOOP UNTIL i$ = CHR$(27)

RETURN

'****************************************************************************
'start of sub homefind
'****************************************************************************
homefind:
				LOCATE 9, 30: PRINT "Find home"
				zstep = 100: xstep = 0: ystep = 0
				stepdelay = z%
				zreal = 0
				DO
				GOSUB Vecout
				LOOP UNTIL limits% > 0
				zstep = 0: ystep = 0: xstep = 50
				stepdelay = x%
				xreal = 0
				DO
				GOSUB Vecout
				LOOP UNTIL limits% = 64 OR limits% = -64
				ystep = -50: xstep = 0: zstep = 0
				stepdelay = y%
				yreal = 0
				DO
				GOSUB Vecout
				LOOP UNTIL limits% = 48 OR limits% = -80
				LOCATE 9, 45: PRINT "FOUND"
 RETURN

'****************************************************************************
'start of sub newdatum
'****************************************************************************
newdatum:
				counter = 0
				xreal = 0: yreal = 0: zreal = 0
				LOCATE 9, 45: PRINT "New Datum"
RETURN
'****************************************************************************
'start of sub fileread
'****************************************************************************
fileread:
				LOCATE 9, 45: INPUT "Data File: ", file$
				OPEN file$ FOR INPUT AS #2
				Starttime = TIMER
				INPUT #2, a$, b$, c$, d$, e$, x%, f$, y%, g$, z%
				stepdelay = y%
				DO
				INPUT #2, dtime%, xstep, ystep, zstep
				xstep = CINT(xstep): ystep = CINT(ystep): zstep = CINT(zstep)   'rounding data to integers
				DO
				Timepast = TIMER - Starttime
				LOOP UNTIL (dtime% = 0 OR Timepast >= dtime% OR INKEY$ = CHR$(27))
				GOSUB Vecout
				xstep = 0: ystep = 0: zstep = 0
				LOOP UNTIL ((EOF(2)) OR dtime% = 0 OR INKEY$ = CHR$(27))
				LOCATE 10, 45: PRINT "File done"
				CLOSE #2
    RETURN
'****************************************************************************
'start of sub drillfile
'****************************************************************************
drillfile:
GOSUB newdatum
dril = 1                                                'handicap limits check
LOCATE 4, 30: INPUT "Drill file: ", file$
OPEN file$ FOR INPUT AS #2
continue$ = ""
INPUT #2, a$, b$, c$
Dbit = 0
hole = 0
DO
hole = hole + 1
INPUT #2, rad, xposmm, yposmm
LOCATE 5, 30: PRINT "Hole No: "; hole; " Radius: "; rad; "X(mm)="; xposmm; " Y ="; yposmm; "     "
IF rad <> Dbit / 2 THEN GOSUB dbitcheck
GOSUB drill
IF continue$ <> "1" OR limits% <> 0 THEN LOCATE 8, 30: INPUT "a/r/d/Auto(1)/Cnt"; continue$
IF continue$ = "r" THEN GOSUB drill
IF continue$ = "d" THEN GOSUB dbitcheck
LOOP UNTIL (EOF(2) OR continue$ = "a" OR continue$ = "A" OR INKEY$ = CHR$(27))
xstep = -xreal: ystep = -yreal
GOSUB Vecout
xstep = 0: ystep = 0
CLOSE #2
LOCATE 5, 30: PRINT "                                             "
LOCATE 6, 30: PRINT "                                      "
LOCATE 7, 30: PRINT "                                      "
LOCATE 8, 30: PRINT "                                      "
dril = 0                                            'unhandicap limits check
RETURN

drill:
xpos = CINT(xposmm * calibx)                  'convert mm to steps
ypos = CINT(yposmm * caliby)                  'integer no of steps
xstep = xpos - xreal
ystep = ypos - yreal
zstep = 0
stepdelay = y%
GOSUB Vecout
LOCATE 7, 30: PRINT "Drill"
xstep = 0: ystep = 0: zstep = -depth
stepdelay = y%
GOSUB Vecout
zstep = depth
stepdelay = z%
LOCATE 7, 30: PRINT "Up   "
GOSUB Vecout
RETURN

dbitcheck:
DO
LOCATE 6, 30: INPUT "Change drill bit? Diameter"; Dbit
LOCATE 7, 38: INPUT "Depth steps"; depth
LOOP UNTIL (Dbit = 0 OR Dbit = 2 * rad)
RETURN


