/********************************************************************************
*
* Clock : 32.0000Mhz 
*
* Hercules specification:
* -----------------------
*
* Horizontal frequency 18.425 +/-0.500 kHz
* Vertical frequency 50 Hz
* Resolution: 720348
*
* Horizontal video blank time: 9.5us
* Horizontal pulse interval: 8.3us 
* Horizontal retrace time: 7.6us
* Horizontal visible (useful) time: 44.72us
*
* Vertical video blank time: 1.004ms
* Vertical pulse interval: 0.9ms
* Vertical retrace time: 0.4ms
*
* 368 line:
*
* 0       BLANK
* 1..17   VERT SYNC
* 18      BLANK
* 20..367 VISIBLE LINES
*
* 18.422KHz = 54.29us = 1 line time
*
*
*
*
* Horizonal Timing
*
* A (us)                 54.29   Scanline time
* B (us)                 8.3     Sync pulse lenght 
* C (us)                 1.0     Back porch
* D (us)                 44.72   Active video time
* E (us)                 ?       Front porch
* 
*          ______________________          ________
* ________|        VIDEO         |________| VIDEO (next line)
*     |-C-|----------D-----------|-E-|
* __   ______________________________   ___________
*   |_|                              |_|
*   |B|
*   |---------------A----------------|
*
* Vertical Timing
*
* O (ms)                 14.27   14.27   16.68     Total frame time
* P (ms)                 0.06    0.06    0.06      Sync length
* Q (ms)                 1.88    1.08    1.02      Back porch
* R (ms)                 11.13   12.72   15.25     Active video time
* S (ms)                 1.2     0.41    0.35      Front porch
*
*          ______________________          ________
* ________|        VIDEO         |________|  VIDEO (next frame)
*     |-Q-|----------R-----------|-S-|
* __   ______________________________   ___________
*   |_|                              |_|
*   |P|
*   |---------------O----------------|
*
*
*********************************************************************************/

#include <avr/interrupt.h>
#include <inttypes.h>
#include <avr/io.h>
#include <util/delay_basic.h>
#include <avr/pgmspace.h> 


#define BLANK 0x00
#define PIXEL 0x01
#define NOP asm("nop")
#define line_count OCR1B
#define char_line  OCR0A


volatile uint8_t char_table[] PROGMEM ={
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //   //0
0x30, 0x78, 0x78, 0x30, 0x30, 0x00, 0x30, 0x00, // ! //8
0x6C, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, // " //16
0x6C, 0x6C, 0xFE, 0x6C, 0xFE, 0x6C, 0x6C, 0x00, // # //24
0x30, 0x7C, 0xC0, 0x78, 0x0C, 0xF8, 0x30, 0x00, // $ //32
0x00, 0xC6, 0xCC, 0x18, 0x30, 0x66, 0xC6, 0x00, // % //40
0x38, 0x6C, 0x38, 0x76, 0xDC, 0xCC, 0x76, 0x00, // & //48
0x60, 0x60, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, // ' //56
0x18, 0x30, 0x60, 0x60, 0x60, 0x30, 0x18, 0x00, // ( //64
0x60, 0x30, 0x18, 0x18, 0x18, 0x30, 0x60, 0x00, // ) //72
0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00, // * //80
0x00, 0x30, 0x30, 0xFC, 0x30, 0x30, 0x00, 0x00, // + //88
0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x60, // , //96
0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, // - //104
0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, // . //112
0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x80, 0x00, // / //120
0x7C, 0xC6, 0xCE, 0xDE, 0xF6, 0xE6, 0x7C, 0x00, // 0 //128
0x30, 0x70, 0x30, 0x30, 0x30, 0x30, 0xFC, 0x00, // 1 //136
0x78, 0xCC, 0x0C, 0x38, 0x60, 0xCC, 0xFC, 0x00, // 2 //144
0x78, 0xCC, 0x0C, 0x38, 0x0C, 0xCC, 0x78, 0x00, // 3 //152
0x1C, 0x3C, 0x6C, 0xCC, 0xFE, 0x0C, 0x1E, 0x00, // 4 //160
0xFC, 0xC0, 0xF8, 0x0C, 0x0C, 0xCC, 0x78, 0x00, // 5 //168
0x38, 0x60, 0xC0, 0xF8, 0xCC, 0xCC, 0x78, 0x00, // 6 //176
0xFC, 0xCC, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x00, // 7 //184
0x78, 0xCC, 0xCC, 0x78, 0xCC, 0xCC, 0x78, 0x00, // 8 //192
0x78, 0xCC, 0xCC, 0x7C, 0x0C, 0x18, 0x70, 0x00, // 9 //200
0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00, // : //208
0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x60, // , //216
0x18, 0x30, 0x60, 0xC0, 0x60, 0x30, 0x18, 0x00, // < //224
0x00, 0x00, 0xFC, 0x00, 0x00, 0xFC, 0x00, 0x00, // = //232
0x60, 0x30, 0x18, 0x0C, 0x18, 0x30, 0x60, 0x00, // > //240
0x78, 0xCC, 0x0C, 0x18, 0x30, 0x00, 0x30, 0x00, // ? //248
0x7C, 0xC6, 0xDE, 0xDE, 0xDE, 0xC0, 0x78, 0x00, // @ //256
0x30, 0x78, 0xCC, 0xCC, 0xFC, 0xCC, 0xCC, 0x00, // A //264
0xFC, 0x66, 0x66, 0x7C, 0x66, 0x66, 0xFC, 0x00, // B //272
0x3C, 0x66, 0xC0, 0xC0, 0xC0, 0x66, 0x3C, 0x00, // C //280
0xF8, 0x6C, 0x66, 0x66, 0x66, 0x6C, 0xF8, 0x00, // D //288
0xFE, 0x62, 0x68, 0x78, 0x68, 0x62, 0xFE, 0x00, // E //296
0xFE, 0x62, 0x68, 0x78, 0x68, 0x60, 0xF0, 0x00, // F //304
0x3C, 0x66, 0xC0, 0xC0, 0xCE, 0x66, 0x3E, 0x00, // G //312
0xCC, 0xCC, 0xCC, 0xFC, 0xCC, 0xCC, 0xCC, 0x00, // H //320
0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00, // I //328
0x1E, 0x0C, 0x0C, 0x0C, 0xCC, 0xCC, 0x78, 0x00, // J //336
0xE6, 0x66, 0x6C, 0x78, 0x6C, 0x66, 0xE6, 0x00, // K //344
0xF0, 0x60, 0x60, 0x60, 0x62, 0x66, 0xFE, 0x00, // L //352
0xC6, 0xEE, 0xFE, 0xFE, 0xD6, 0xC6, 0xC6, 0x00, // M //360
0xC6, 0xE6, 0xF6, 0xDE, 0xCE, 0xC6, 0xC6, 0x00, // N //368
0x38, 0x6C, 0xC6, 0xC6, 0xC6, 0x6C, 0x38, 0x00, // O //376
0xFC, 0x66, 0x66, 0x7C, 0x60, 0x60, 0xF0, 0x00, // P //384
0x78, 0xCC, 0xCC, 0xCC, 0xDC, 0x78, 0x1C, 0x00, // Q //392
0xFC, 0x66, 0x66, 0x7C, 0x6C, 0x66, 0xE6, 0x00, // R //400
0x78, 0xCC, 0xE0, 0x70, 0x1C, 0xCC, 0x78, 0x00, // S //408
0xFC, 0xB4, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00, // T //416
0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xFC, 0x00, // U //424
0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x78, 0x30, 0x00, // V //432
0xC6, 0xC6, 0xC6, 0xD6, 0xFE, 0xEE, 0xC6, 0x00, // W //440
0xC6, 0xC6, 0x6C, 0x38, 0x38, 0x6C, 0xC6, 0x00, // X //448
0xCC, 0xCC, 0xCC, 0x78, 0x30, 0x30, 0x78, 0x00, // Y //456
0xFE, 0xC6, 0x8C, 0x18, 0x32, 0x66, 0xFE, 0x00  // Z //464
};



int main()
{

  
  // Init port pins
	DDRB = (1<<DDB0)|(1<<DDB1)|(1<<DDB2)|(1<<DDB3)|(1<<DDB4)|(1<<DDB5)|(1<<DDB6)|(1<<DDB7); // B port 0,1,2,3,4,5,6,7 -es PIN output
	DDRD = (1<<DDD0)|(1<<DDD1)|(1<<DDD2)|(1<<DDD3)|(1<<DDD4)|(1<<DDD5)|(1<<DDD6); // D port 0,1,2,3,4,5,6 -os PIN output
	
	// Setup timer1 16bites
    TCCR1B |= (1<<WGM12)|(1<<CS10);  // CTC mode,  No preselect ratio

	TCNT1 = 0;            // timer1 szamlaloja legyen 0
    OCR1A = 1736;         // timer1 Compare A (1737) = 18.422KHz
    
	TIMSK |= (1<<OCIE1A); // timer1 Compare Match A megszakitas bekapcsolas
    	
	PORTD |=  (1<<PIND0)|(1<<PIND1)|(1<<PIND2); //Vert syncn default 1
    
	line_count = 0;
	char_line  = 0;
		
	sei();    //megszakts bekapcsols  

    while(1)
    {
     NOP;
    }
}

void put_char(uint16_t char_pointer)
{
  PORTB = pgm_read_byte(&char_table[char_pointer]);
  NOP;
  PORTB = PORTB<<1;
  NOP;
  PORTB = PORTB<<1;
  NOP;
  PORTB = PORTB<<1;
  NOP;
  PORTB = PORTB<<1;
  NOP;
  PORTB = PORTB<<1;
  NOP;
  PORTB = PORTB<<1;
  NOP;
  PORTB = PORTB<<1;
  NOP;
  NOP;
  NOP;
  PORTB = 0x0;
}

// ----------------------- Megszakts Timer0 Comp A -------------------------
ISR(TIMER1_COMPA_vect)
{ 

 if(line_count==0)
 {
  PORTB = BLANK;
 }
 
 if((line_count>0)&&(line_count<18))
 {
  PORTD &= ~((1<<PIND0)|(1<<PIND1)|(1<<PIND2)); //Aktv 0 a Vert sync
 }
 else
 {
  PORTD |=  (1<<PIND0)|(1<<PIND1)|(1<<PIND2); //Vge a Vert syncnek
 }

 PORTD |=  (1<<PIND3)|(1<<PIND4)|(1<<PIND5);  //Hori sync indul aktv 1
 _delay_loop_1(89);    //Hsync 8.3us
 PORTD &= ~((1<<PIND3)|(1<<PIND4)|(1<<PIND5));  //Vge a Hori syncnek
 
 switch(line_count)
 {
 case 40:
 case 41:
 case 42:
 case 43:
 case 44:
 case 45:
 case 46:
 case 47:
         put_char(264+char_line); //A
         put_char(432+char_line); //V
         put_char(400+char_line); //R
         put_char(0+char_line);   //
         put_char(320+char_line); //H
         put_char(296+char_line); //E
         put_char(400+char_line); //R
         put_char(280+char_line); //C
         put_char(424+char_line); //U
         put_char(352+char_line); //L
         put_char(296+char_line); //E
         put_char(408+char_line); //S
         put_char(0+char_line);   //
         put_char(288+char_line); //D
         put_char(296+char_line); //E
         put_char(360+char_line); //M
         put_char(376+char_line); //O
         PORTB = 0x0;
         char_line++;
         if(char_line==8) char_line = 0;
		 break;
 case 60:
 case 61:
 case 62:
 case 63:
 case 64:
 case 65:
 case 66:
 case 67:
         put_char(264+char_line); //A
         put_char(416+char_line); //T
         put_char(416+char_line); //T
         put_char(328+char_line); //I
         put_char(368+char_line); //N
         put_char(456+char_line); //Y
         put_char(144+char_line); //2
         put_char(152+char_line); //3
         put_char(136+char_line); //1
         put_char(152+char_line); //3
         put_char(0+char_line);   //
         put_char(152+char_line); //3
         put_char(144+char_line); //2
         put_char(360+char_line); //M
         put_char(320+char_line); //H
         put_char(464+char_line); //Z
         PORTB = 0x0;
         char_line++;
         if(char_line==8) char_line = 0;
         break;
 
 case 80:
 case 81:
 case 82:
 case 83:
 case 84:
 case 85:
 case 86:
 case 87:
         put_char(280+char_line); //C
         put_char(408+char_line); //S
         put_char(376+char_line); //O
         put_char(400+char_line); //R
         put_char(288+char_line); //D
         put_char(264+char_line); //A
         put_char(408+char_line); //S
         put_char(0+char_line);   //
         put_char(264+char_line); //A
         put_char(416+char_line); //T
         put_char(416+char_line); //T
         put_char(328+char_line); //I
         put_char(352+char_line); //L
         put_char(264+char_line); //A
         PORTB = 0x0;
         char_line++;
         if(char_line==8) char_line = 0;
         break;
 
 case 100:
 case 101:
 case 102:
 case 103:
 case 104:
 case 105:
 case 106:
 case 107:
          put_char(440+char_line); //W
          put_char(440+char_line); //W
          put_char(440+char_line); //W
          put_char(112+char_line); //.
          put_char(296+char_line); //E
          put_char(312+char_line); //G
          put_char(456+char_line); //Y
          put_char(296+char_line); //E
          put_char(368+char_line); //N
          put_char(328+char_line); //I
          put_char(112+char_line); //.
          put_char(320+char_line); //H
          put_char(424+char_line); //U
          PORTB = 0x0;
          char_line++;
          if(char_line==8) char_line = 0;
          break;
}


/* 
 if((line_count>40)&&(line_count<49))
 {
  put_char(264+char_line); //A
  put_char(432+char_line); //V
  put_char(400+char_line); //R
  put_char(0+char_line);   //
  put_char(320+char_line); //H
  put_char(296+char_line); //E
  put_char(400+char_line); //R
  put_char(280+char_line); //C
  put_char(424+char_line); //U
  put_char(352+char_line); //L
  put_char(296+char_line); //E
  put_char(408+char_line); //S
  put_char(0+char_line);   //
  put_char(288+char_line); //D
  put_char(296+char_line); //E
  put_char(360+char_line); //M
  put_char(376+char_line); //O

  PORTB = 0x0;
  char_line++;
  if(char_line==8) char_line = 0;
 }
 
 if((line_count>60)&&(line_count<69))
 {
  put_char(264+char_line); //A
  put_char(416+char_line); //T
  put_char(416+char_line); //T
  put_char(328+char_line); //I
  put_char(368+char_line); //N
  put_char(456+char_line); //Y
  put_char(144+char_line); //2
  put_char(152+char_line); //3
  put_char(136+char_line); //1
  put_char(152+char_line); //3
  put_char(0+char_line);   //
  put_char(152+char_line); //3
  put_char(144+char_line); //2
  put_char(360+char_line); //M
  put_char(320+char_line); //H
  put_char(464+char_line); //Z
  
  PORTB = 0x0;
  char_line++;
  if(char_line==8) char_line = 0;
 }
 
 if((line_count>80)&&(line_count<89))
 {
  put_char(280+char_line); //C
  put_char(408+char_line); //S
  put_char(376+char_line); //O
  put_char(400+char_line); //R
  put_char(288+char_line); //D
  put_char(264+char_line); //A
  put_char(408+char_line); //S
  put_char(0+char_line);   //
  put_char(264+char_line); //A
  put_char(416+char_line); //T
  put_char(416+char_line); //T
  put_char(328+char_line); //I
  put_char(352+char_line); //L
  put_char(264+char_line); //A
  
  PORTB = 0x0;
  char_line++;
  if(char_line==8) char_line = 0;
 }
 
 if((line_count>100)&&(line_count<109))
 {
  put_char(440+char_line); //W
  put_char(440+char_line); //W
  put_char(440+char_line); //W
  put_char(112+char_line); //.
  put_char(296+char_line); //E
  put_char(312+char_line); //G
  put_char(456+char_line); //Y
  put_char(296+char_line); //E
  put_char(368+char_line); //N
  put_char(328+char_line); //I
  put_char(112+char_line); //.
  put_char(320+char_line); //H
  put_char(424+char_line); //U

  PORTB = 0x0;
  char_line++;
  if(char_line==8) char_line = 0;
 }
 */
 line_count++;
 if(line_count==368) line_count = 0;
}

