
 	LIST P=18F1320
 	#INCLUDE "P18F1320.INC"
 
 	CONFIG OSC=XT,  WDT=OFF, LVP=OFF, MCLRE = OFF, BOR=OFF, DEBUG=OFF, PWRT=off   
	CONFIG EBTRB=off,EBTR1=off,EBTR0=off,WRTD=off,WRTB=off,WRTC=off,WRT1=off,WRT0=off,CP0=off,CP1=off,CPB=off,CPD=off

 ;kdvdelmek kikapcsolsa

;4MHz-es kristllyal egy utastst (amit 4 rajel peridus alatt csinl meg) 0,000001 sec alatt csinl meg.

 

        CBLOCK  0x00                  	;A 0x00 egy szabad memria rsz kezdo" cme
        hours
        mins
        secs
        D2
        D3
        STATUS_TEMP
        WREG_TEMP
        BSR_TEMP
        ENDC

 
        ORG     0x0000		
        GOTO START						; ugras a main prog.

        ORG     0x0008
        BRA RTCisr						; interrupt kezeles.
 
        ORG 0x0018
		BRA RTCisr						; interrupt kezeles.


START   CLRF PORTB
        CLRF LATB       
        MOVLW b'01111111'
        MOVWF ADCON1
        MOVLW b'00000000'
        MOVWF TRISB
        MOVWF TRISA
        CLRF LATB
        CLRF LATA
        CALL RTCinit
        MOVLW b'00000001'
        MOVWF PIE1						;TMR1 int enable
        MOVLW b'11000000'
        MOVWF INTCON					;global int enable

JELEZ
        MOVF secs,W
        MOVWF LATB
        GOTO JELEZ

 

RTCinit

        MOVLW 0x80 						; Preload TMR1 register pair
        MOVWF TMR1H
        CLRF TMR1L
        MOVLW b'01001101' 				; 4-5. bit az oszt
        MOVWF T1CON ;
        CLRF secs 						; Initialize timekeeping registers
        CLRF mins ;
        MOVLW .12
        MOVWF hours
        BSF PIE1, TMR1IE 				; Enable Timer1 interrupt

        RETURN

RTCisr
        MOVFF   STATUS,STATUS_TEMP 		;save STATUS register
        MOVFF   WREG,WREG_TEMP          ;save working register
        MOVFF  BSR,BSR_TEMP              ;save BSR register
 
        MOVLW 0x80 						; Preload TMR1 register pair
        MOVWF TMR1H
        CLRF TMR1L
        BCF PIR1, TMR1IF 				; Clear interrupt flag

        INCF secs, F 					; Increment seconds
        MOVLW .59 						; 60 seconds elapsed?
        CPFSGT secs
 
        bra	done_i 						; No, done
        CLRF secs 						; Clear seconds
        INCF mins, F 					; Increment minutes
        MOVLW .59 						; 60 minutes elapsed?
        CPFSGT mins
        bra	done_i 						; No, done

        CLRF mins 						; clear minutes
        INCF hours, F				 	; Increment hours
        MOVLW .23 						; 24 hours elapsed?
        CPFSGT hours
        
        bra	done_i 						; No, done
        MOVLW .01 						; Reset hours to 1
        MOVWF hours
        
done_i 	MOVFF   BSR_TEMP,BSR              ;restore BSR register
        MOVFF   WREG_TEMP,WREG          ;restore working register
        MOVFF   STATUS_TEMP,STATUS 		;restore STATUS register
        RETFIE

        END