
 	LIST P=18F1320
 	#INCLUDE "P18F1320.INC"
 
 	CONFIG OSC=XT,  WDT=OFF, LVP=OFF, MCLRE = OFF, BOR=OFF, DEBUG=OFF, PWRT=off   
	CONFIG EBTRB=off,EBTR1=off,EBTR0=off,WRTD=off,WRTB=off,WRTC=off,WRT1=off,WRT0=off,CP0=off,CP1=off,CPB=off,CPD=off

 ;kdvdelmek kikapcsolsa

;4MHz-es kristllyal egy utastst (amit 4 rajel peridus alatt csinl meg) 0,000001 sec alatt csinl meg.

 

        CBLOCK  0x00                  	;A 0x00 egy szabad memria rsz kezdo" cme
        hours
        mins
        secs
        D2
        D3
	VAR	
	VAR2		;vrakozsi id a delay szubritunban

        STATUS_TEMP
        WREG_TEMP
        BSR_TEMP
        ENDC

;  D0..D3 --> RB0..RB3
;  R/S --> RB4
;  E --> RB5

;elszr a fels 4 bitet kell elkldeni


        ORG     0x0000		
        bra		START						; ugras a main prog.

        ORG     0x0008
        BRA 	RTCisr						; interrupt kezeles.
 
        ORG 0x0018
		BRA 	RTCisr						; interrupt kezeles.


START
		CLRF	PORTB						; Az egyik elg..
;		CLRF	LATB       
        MOVLW	b'01111111'
        MOVWF	ADCON1
        MOVLW	b'00000000'
        MOVWF	TRISB
        MOVWF	TRISA
;        CLRF LATB
        CLRF	LATA
	CALL L_DELAY
	CALL LCD_INIT
	CALL HELLO_WORLD
	CALL L_DELAY

        rCALL 	RTCinit
        MOVLW 	b'00000001'
        MOVWF 	PIE1						;TMR1 int enable
        MOVLW 	b'11000000'
        MOVWF 	INTCON					;global int enable

JELEZ
        MOVF 	secs,W
        MOVWF 	LATB
        bra	 	JELEZ

 

RTCinit

        MOVLW 	0x80 						; Preload TMR1 register pair
        MOVWF 	TMR1H
        CLRF 	TMR1L
        MOVLW 	b'01001101' 				; 4-5. bit az oszt
        MOVWF 	T1CON ;
        CLRF 	secs 						; Initialize timekeeping registers
        CLRF 	mins ;
        MOVLW 	.12
        MOVWF 	hours
        BSF 	PIE1, TMR1IE 				; Enable Timer1 interrupt

        RETURN

RTCisr
        MOVFF	STATUS,STATUS_TEMP 		;save STATUS register
        MOVFF	WREG,WREG_TEMP          ;save working register
        MOVFF	BSR,BSR_TEMP              ;save BSR register
 
        MOVLW 	0x80 						; Preload TMR1 register pair
        MOVWF 	TMR1H
        CLRF 	TMR1L
        BCF 	PIR1, TMR1IF 				; Clear interrupt flag

        INCF 	secs,F 					; Increment seconds
        MOVLW 	.59 						; 60 seconds elapsed?
        CPFSGT 	secs
 
        bra		done_i 						; No, done
        CLRF 	secs 						; Clear seconds
        INCF 	mins, F 					; Increment minutes
        MOVLW 	.59 						; 60 minutes elapsed?
        CPFSGT 	mins
        bra		done_i 						; No, done

        CLRF 	mins 						; clear minutes
        INCF 	hours, F				 	; Increment hours
        MOVLW 	.23 						; 24 hours elapsed?
        CPFSGT 	hours
		bra		done_i 						; No, done

		MOVLW .01 						; Reset hours to 1
        MOVWF hours
        
done_i
	 	MOVFF   BSR_TEMP,BSR              ;restore BSR register
        MOVFF   WREG_TEMP,WREG          ;restore working register
        MOVFF   STATUS_TEMP,STATUS 		;restore STATUS register
        RETFIE

LCD_INIT
	CLRF LATB
	BSF LATB,5  ;Enable 1
	CALL S_DELAY	
	BCF LATB,5  ;Enable 0
	CALL S_DELAY
	BSF LATB,1  
	CALL S_DELAY
	BSF LATB,5
	CALL S_DELAY
	CLRF LATB
	CALL S_DELAY
	RETURN	 

HELLO_WORLD
	CLRF LATB
	BSF LATB,2
	CALL ENABLE
	CALL S_DELAY		
	BSF LATB,3
	CALL ENABLE   ; 'H'   0100 1000


	MOVLW b'00000110'
	MOVWF LATB
	CALL ENABLE
	MOVLW b'000000101'
	MOVWF LATB
	CALL ENABLE    ;'e'   0110 0101

	MOVLW b'00000110'
	MOVWF LATB
	CALL ENABLE 
	MOVLW b'00001100'
	MOVWF LATB
	CALL ENABLE   ;'l'   0110 1100

	MOVLW b'00000110'
	MOVWF LATB
	CALL ENABLE 
	MOVLW b'00001100'
	MOVWF LATB
	CALL ENABLE   ;'l'   0110 1100

	MOVLW b'00000110'
	MOVWF LATB
	CALL ENABLE
	MOVLW b'00001111'
	MOVWF LATB
	CALL ENABLE  ;'o'   0110 1111

	RETURN



ENABLE   
	CALL S_DELAY
	BSF LATB,4   ;adat md!!
	CALL S_DELAY
	BSF LATB,5  ;Enable 1
	CALL S_DELAY	
	CLRF LATB  ;Enable 0
	CALL S_DELAY
	CALL S_DELAY
	RETURN
	


S_DELAY
	MOVLW d'10'
	MOVWF VAR
VISSZA
	NOP
	DECFSZ VAR
	GOTO VISSZA	
	RETURN	
	
L_DELAY
	MOVLW d'5'
	MOVWF VAR
DEL
	MOVLW d'4'
	MOVWF VAR2
DEL2
	NOP
	NOP
	NOP
	NOP
	NOP
	DECFSZ VAR2,f
	GOTO DEL2
	DECFSZ VAR
	GOTO DEL
	RETURN
	

        END