SETLOCAL

:: Release value
SET RELEASETXT=0.17
SET RELEASE=017

::
SET TODIR=FPGA64_%RELEASE%
SET TOBOOT=%TODIR%\boot
SET TOSRC=%TODIR%\sources
SET TOVHDL=%TOSRC%\vhdl

::
:: Copy readme
::
mkdir %TODIR%
copy readme.txt %TODIR%

::
:: Copy boot images
::
mkdir %TOBOOT%
call makeboot.bat
copy boot %TOBOOT%
echo >%TOBOOT%\8desc.txt FPGA64 %RELEASETXT%

::
:: Make source tree
::
mkdir %TOSRC%
copy makeboot.bat %TOSRC%
copy makerelease.bat %TOSRC%
copy readme.txt %TOSRC%

::
:: Copy roms
::
mkdir %TOSRC%\roms
copy roms %TOSRC%\roms

::
:: Copy quartus project
::
mkdir %TOSRC%\quartus_cone
copy quartus_cone\fpga64_top.bdf %TOSRC%\quartus_cone
copy quartus_cone\fpga64_cone.bsf %TOSRC%\quartus_cone
copy quartus_cone\gbridge.bsf %TOSRC%\quartus_cone
copy quartus_cone\gbridge.tdf %TOSRC%\quartus_cone
copy quartus_cone\quartus_cone.qpf %TOSRC%\quartus_cone
copy quartus_cone\quartus_cone.qsf %TOSRC%\quartus_cone

::
:: Copy vhdl code
::
mkdir %TOVHDL%
copy vhdl\cia6526.vhd %TOVHDL%
copy vhdl\cpu65xx_table.vhd %TOVHDL%
copy vhdl\cpu_6510.vhd %TOVHDL%
copy vhdl\fpga64_buslogic_nommu.vhd %TOVHDL%
copy vhdl\fpga64_bustiming.vhd %TOVHDL%
copy vhdl\fpga64_cone.vhd %TOVHDL%
copy vhdl\fpga64_hexy.vhd %TOVHDL%
copy vhdl\fpga64_hexy_vmode.vhd %TOVHDL%
copy vhdl\fpga64_keyboard_matrix.vhd %TOVHDL%
copy vhdl\fpga64_rgbcolor.vhd %TOVHDL%
copy vhdl\fpga64_rwram.vhd %TOVHDL%
copy vhdl\fpga64_scandoubler.vhd %TOVHDL%
copy vhdl\fpga64_singleram.vhd %TOVHDL%
copy vhdl\io_ps2_keyboard.vhd %TOVHDL%
copy vhdl\vicii_6567_6569.vhd %TOVHDL%


ENDLOCAL
