#include <18F4520.h>
#device adc=10
#include <string.h>

#FUSES NOWDT                    //No Watch Dog Timer
#FUSES WDT128                   //Watch Dog Timer uses 1:128 Postscale
#FUSES Hs                       //High speed Osc (> 4mhz)
#FUSES NOPROTECT                //Code not protected from reading
#FUSES NOBROWNOUT               //No brownout reset
//#FUSES BORV25                   //Brownout reset at 2.5V
#FUSES NOPUT                    //No Power Up Timer
#FUSES NOCPD                    //No EE protection
#FUSES STVREN                   //Stack full/underflow will cause reset
#FUSES NODEBUG                  //No Debug mode for ICD
#FUSES NOLVP                    //No low voltage prgming, B3(PIC16) or B5(PIC18) used for I/O
#FUSES NOWRT                    //Program memory not write protected
#FUSES NOWRTD                   //Data EEPROM not write protected
#FUSES IESO                     //Internal External Switch Over mode enabled
#FUSES NOFCMEN                  //Fail-safe clock monitor disabled
#FUSES NOPBADEN                 //PORTB pins are configured as digital I/O on RESET
#FUSES NOWRTC                   //configuration not registers write protected
#FUSES NOWRTB                   //Boot block not write protected
#FUSES NOEBTR                   //Memory not protected from table reads
#FUSES NOEBTRB                  //Boot block not protected from table reads
#FUSES NOCPB                    //No Boot Block code protection
#FUSES LPT1OSC                  //Timer1 configured for low-power operation
#FUSES MCLR                   //Master Clear pin used for I/O
#FUSES NOXINST                  //Extended set extension and Indexed Addressing             

  #ZERO_RAM
#use delay(clock=20000000)

#use rs232(baud=9600, UART1, errors)

#include <MMC_SPI_FAT32.h>    // As usual you also need to      ////
#include <MMC_SPI_FAT32.c>    // include your device .h file... ////
   void main(void)                                              ////  
   {                                                            ////
      setup_adc_ports(NO_ANALOGS|VSS_VDD);
   setup_adc(ADC_OFF|ADC_TAD_MUL_0);
   setup_psp(PSP_DISABLED);
   setup_spi(SPI_SS_DISABLED);
   setup_wdt(WDT_OFF);
   setup_timer_0(RTCC_INTERNAL);
   setup_timer_1(T1_EXTERNAL|T1_DIV_BY_1|T1_CLK_OUT);
   setup_timer_2(T2_DIV_BY_1, 152, 1);   
//   setup_ccp1(CCP_PWM);   // Configure CCP1 as a PWM
   setup_comparator(NC_NC_NC_NC);
   setup_vref(FALSE);
      char f,filename[20],res,i,c;                              //// 
      while(TRUE)                                               //// 
      {                                                         //// 
         if(MMCInit() == MMC_OK)                                //// 
         {                                                      //// 
            printf("MMC initialized\r\n");                      //// 
            InitFAT();                                          //// 
            strcpy(filename,"DIR/");                            //// 
            f = InitList(filename);                             //// 
            if(f & MMC_ERROR)                                   //// 
               printf("Error");                                 //// 
            else                                                //// 
            {                                                   //// 
               do                                               //// 
               {                                                //// 
                  res = ListFiles(f);                           //// 
                  for(i=0;i<res;i++)                            //// 
                  {                                             //// 
                     printf(FileList[i].name);                  //// 
                     if(FileList[i].isDir)                      //// 
                        printf("\\\r\n");//a "\" with row break //// 
                     else                                       //// 
                        printf("\r\n");                         //// 
                  }                                             //// 
               } while(NextPage(f) == MMC_OK);                  //// 
               CloseList(f); // frees the file, but the list is //// 
            }                // still there...                  //// 
            strcpy(filename,FileList[0].shortName);             //// 
            f = fopen(filename,'r'); // open file for reading    //// 
            if((f & MMC_ERROR) == 0) // No error, same as       //// 
            {                        // if(f < MAXFILES)        //// 
               while(fgetch(&c,f) == MMC_OK)                    //// 
                  printf(c);                                    //// 
               fclose(f);                                       //// 
            }                                                   //// 
            else if(f == MMC_NOT_FOUND)                         //// 
               printf("1st file in list was probebly a dir");   //// 
            else                                                //// 
               printf("Other error\r\n");                       //// 
            while(TRUE)                                         //// 
               ; // Loop forever, program is finished           //// 
         }                                                      //// 
         else                                                   //// 
            printf("MMC init failed!\r\n");                     //// 
         delay_ms(1000);                                        //// 
         printf("Trying once more..\r\n");                      //// 
      }                                                         //// 
   }                                                            //// 
