//========================================================================================
//   NOM:      lcdGraph.c                                                                      
//   Date:     26/04/2003                                                                     
//   Version:  1.11                                                                       
//   Circuit:  circuit final Scope                                    
//   Auteur:   SJ                                                                          
//   Micro:    PIC16F877  24MHz -> tcycl = 0.1666 us (1/6 us)                                                                             
//========================================================================================

#include	"lcdgraph.h"
#include	"lcd.h"
#include "string.h"

// Fusibles de configuration, EEPROM interne (256 octets), nidentification
__CONFIG(WDTDIS & HS & PWRTEN & UNPROTECT & BORDIS & LVPDIS & DEBUGDIS);
//__EEPROM_DATA(0,1,2,3,4,5,6,7,8);
//__IDLOC(1234);

//========================================================================================
//   Macro blocage interruptions
//========================================================================================
/*
static bit tmpGIE2;						// flag pour GIE
#define FLAG_GIE_SAVE2 tmpGIE2 = 0;if (GIE) tmpGIE2 = 1;GIE = 0;
#define FLAG_GIE_REST2 if (tmpGIE2) GIE = 1;
// SAVE+REST = 7 ROM
*/

static bit flagAcq;						// signale la fin de l'acquisition en mode >=50ms/div
static bit flagTransfert;				// flag pour transfert rs232 : si=1 -> transfert
static bit flagClignoTranf;			// flag pour clignotement texte "Presser '#'"

//========================================================================================
// Thus all the 'persistent' variables will be kept together, and you can
// get the bounds of this psect from the following declarations:
// Pour stockage permanent en EEPROM des variables utiliser :
// 		read_from_eeprom(_Lnvram, _Hnvram-_Lnvram); 
// 		write_to_eeprom(_Lnvram, _Hnvram-_Lnvram);
//========================================================================================
extern char     _Lnvram[], _Hnvram[];

//========================================================================================
//   Parametres de reglage du debit du port serie 
//========================================================================================
// 9600\0 19.2k\0 57.6k\0  115k\0    1M";
//#define mDebitLARG 7 	// Largeur de chaines de caract.

// (BRGH=1) SPBRG = Fosc/(16*BaudRate) - 1
const char DebitSPBRG[] =			
//{   103,     51,     16,      8,     0};					// 16MHz 
{   155,     77,     25,      12};								// 24MHz
// 9600   19200   57600   115200 
//Erreur %
// 0.16%   0.16%   2.13%    3.5%     0%						// 16MHz
// 0.16%   0.16%   0.16%    0.16%       						// 24MHz
#define DebitINIT 3 	// 115kbps

//========================================================================================
//   variables main+ISR 
//========================================================================================
#define TMR1_SET	0b00110000 				// Prescaler 1:8, Osc off, Fosc/4, stop timer1
#define TMR1_SET1	0b00000000				// prec 1:1, Osc off, Fosc/4, Stop tmr1

#define INTCON_SET 0b01000000				// GIE = 0, PIE unmasked 

#define OPTION_SET 0b10101000				// Prescaler 1:1 sur RA4

unsigned char lcd_x, lcd_y, lcd_z;		// position sur l'afficheur LCD
unsigned char tmr1H2;						// timer high nb2 -> compteur 16777216
unsigned char cptEch;						// compteur d'echantillons pour base tps >= 50ms/div

unsigned int tempo = 0;						// pour base de Temps acquisition 
static bit tmr1h2Flag = 0;					// flag ISR tmr1h2 (TMR1+8bits)
static bit runStop;							// bit pour mode Run ou Stop (scope)
unsigned char saveFSR;						// sauvegarde de FSR por acq_ech()...


bank1 volatile unsigned char ch3[40];	// @ 0xA0;
#define ADRch3 0xA0;
bank1 volatile unsigned char ch4[40];	// @ 0xC8;
#define ADRch4 0xC8;

bank2 volatile signed char ch1[80];		// @ 0x120;	// max 96
#define ADRch1 0x10;							// 0x111 (bank2 Reg=0x100)

bank3 volatile signed char ch2[80];		// @ 0x1A0;	// max 96
#define ADRch2 0x90;							// 0x191 (bank3 Reg=0x190)
// VERIFIER LES ADRESSES DANS LE .LST	
#define ADRch2_1 0x80						// delta  (ch2-ch1)
//#define ADRch1_2 0x79						// delta -  (ch1-ch2+1)

//========================================================================================
// Tableaux pour gammes ...
//========================================================================================
const unsigned char
tabGain[8] = {254,  252,  246,  237,  220,  182,  141,  95};		// 254->253, 252->251, 246->245
//         10mV  20mV  50mV 100mV 200mV 500mV    1V   2V /div sonde x1
//        100mV 200mV 500mV   1V    2V    5V    10V  20V /div sonde x10

// Amplification verticale en Volts (10mV  20V / div)
const char   
tabStrGain[] = 
{' ','1','0','m',0,' ','2','0','m',0,' ','5','0','m',0,		// " 10m"," 20m"," 50m"
 '1','0','0','m',0,'2','0','0','m',0,'5','0','0','m',0,		// "100m","200m","500m"
 ' ',' ',' ','1',0,' ',' ',' ','2',0,' ',' ',' ','5',0,		// "   1","   2","   5"
 ' ',' ','1','0',0,' ',' ','2','0',0}; 							// "  10","  20"  // 11*5<255
// sonde x1  : tabGain[0-7] -> tabStrGain[0-7]   
// sonde x10 : tabGain[0-7] -> tabStrGain[3-10]  (+3)
#define SONDEx1	0
#define SONDEx10	3

// Base de temps (12s/div  100s/div)
const char
tabStrTime[] = 
{' ','1','2','u',0,' ','3','3','u',0,' ','5','0','u',0,		// " 12", " 29", " 50",
 '1','0','0','u',0,'2','0','0','u',0,'5','0','0','u',0,		//	"100", "200", "500",
 ' ',' ','1','m',0,' ',' ','2','m',0,' ',' ','5','m',0,		//	"  1m", "  2m", "  5m",
 ' ','1','0','m',0,' ','2','0','m',0,' ','5','0','m',0,		// " 10m", " 20m", " 50m",
 '1','0','0','m',0,'2','0','0','m',0,'5','0','0','m',0,		//	"100m", "200m", "500m",
 ' ',' ',' ','1',0,' ',' ',' ','2',0,' ',' ',' ','5',0,		//	"   1", "   2", "   5",
 ' ',' ','1','0',0,' ',' ','2','0',0,' ',' ','5','0',0,		//	"  10", "  20", "  50",
 ' ','1','0','0',0};														//	" 100"}; 	
// 22 gammes*4octets = 88 octets
#define tabStrTimeSIZE 22 


// Parametres de la base de temps (timer1)
const unsigned int
tabTime[]={	// base de temps burst (rafale) 12us/div  20ms/div sans ISR : TMR1H-TMR1L
				0x0100, 0x0101, 0x0000,		// 0x0100 : 1CH 12us/div ; 0x0101 : 2CH 29us/div ; 50us/div
				0xFFD9, 0xFF8E, 0xFEAD,		// 100us/div ; 200us/div ; 500us/div
				0xFD36, 0xFA48, 0xF17E,		// 1ms/div   ; 2ms/div   ; 5ms/div 
				0xE2D8, 0xC58C,				// 10ms/div  ; 20ms/div
				// base de temps ISR 50ms/div  100s/div avec ISR	: tmr1H2-TMR1H	; TMR1L = 0xFF;
				0xFFED, 0xFFDB, 0xFFB6,		// 50ms/div  ; 100ms/div ; 200ms/div
				0xFF48, 0xFE91, 0xFD23,		// 500ms/div ; 1s/div    ; 2s/div
				0xF8D8, 0xF1B1, 0xE363,		// 5s/div    ; 10s/div   ; 20s/div 
				0xB879, 0x70F2};				// 50s/div   ; 100s/div
#define tabTimeSIZE 22	// 11  #DEBUG: 11 ok jusqu'a 20ms/div




const unsigned char
tabTrig[]=
"Auto>\0Auto<\0Norm>\0Norm<\0Manu ";
#define tabTrigSIZE 5
	
//========================================================================================
//   initialise le timer 1 pour des temporisations 
//========================================================================================
// temporisation 16 bits    tmr1H2-TMR1H
void
init_TMR1(){	//unsigned int tempo){
	TMR1ON = 0;								// timer1 off
	tmr1H2 = tempo >>8;		//0;
	TMR1H = tempo & 0xFF;	//tempo>>8;
	TMR1L = 0;					//tempo & 0xFF;
	
	T1CON = TMR1_SET;						// Prescaler 1:8, Osc off, Fosc/4, stop timer1
	INTCON = INTCON_SET;					// GIE = 0, PIE unmasked
	PIE1 = 0b00000001;					// TMR1 

	tmr1h2Flag = 0;						// flag ISR tmr1h2 pour main
	TMR1ON = 1; 							// timer1 on
	GIE = 1;									// interruption ON
}


/*void
init_RCIE(){//#debug
	INTCON = 0;	// #debug
	PIE1 = 0;	// #debug
	
	PEIE = 1;								// periph isr on
	RCIE = 1;								// rx 232
	GIE = 1;									// isr global on
	
}*/

//========================================================================================
//   INTERRUPTIONS 
//========================================================================================
static void interrupt
isr(void){
	if (TMR1IF) {
		tmr1H2++;
		if (tmr1H2==0) {					// mode 50ms/div  100s/div
			// remise en route TMR1 avec tempo	
			tmr1H2 = tempo >> 8;		
			TMR1H = tempo & 0xFF;	
			tmr1h2Flag = 1;				// flag ISR pour main
		}
		TMR1IF = 0;							// efface le flag ISR
	}
	
	if (T0IF) {
		//	TMR0 = TMR0_SET;  efface le compteur
		//	TMR0high++;
			T0IF = 0; 						// efface le flag 	ISR
	}
	/*if (RCIF) {
		if (OERR==1) { 					//overrun Error
			CREN = 0;
			CREN = 1;
			clavTmp = RCREG;
		}
		RCIF = 0;							// reset flag ISR
		clavTmp = RCREG;					// retourne le caractere recu
	}	*/
	
}

//========================================================================================
// conversion acquisition -> lcd										[0-255]->[63-0]
//========================================================================================
unsigned char
convert_lcd(unsigned char canal, unsigned char index){
	unsigned char tmp;
	tmp = somme_ch(canal, index);
	if (tmp>4)	return (63-(tmp>>2))+1;				// conversion [0-255]->[63-0]
	else return 62;										// saturation bas (sinon pb superposition cadre)
}

//========================================================================================
//	Somme canal (pour calcul de la moyenne d'un canal)	/!\ A MODIFIER AVEC INDF FSR dans lcd_chab
//========================================================================================
unsigned char
somme_ch(unsigned char canal, unsigned char index){
	if (canal==CHA) return (ch1[index]);							// canal A
	else {
		if (canal==CHB) return (ch2[index]);						// canal B
		else {
			if (canal==CHC) return (ch3[index]);					// canal C
			else {
				return (ch4[index]);										// canal D
			}
		}
	}
}

//========================================================================================
// affiche les voies A et B en mode dot
//========================================================================================
/*lcd_ch_dot(unsigned char canal){
	unsigned char coordY = 12, compt1;
// affichage
	for(compt1=0; compt1<80; compt1++){							// mode dot
		lcd_plot(convert_lcd(canal, compt1), coordY++, 1);
	}
}*/

//========================================================================================
// affiche les voies A ou B en mode continu : renvoie la moyenne du canal
//========================================================================================
unsigned char
lcd_ch_ab(unsigned char canal){
	unsigned char coordY = 12, ValOld, Val, compt1;
	//signed char ecart, cpt;
	unsigned int somme = 0;

	ValOld = convert_lcd(canal, 0);
	for(compt1=0; compt1<80; compt1++){
		Val = convert_lcd(canal, compt1);						// CHx, index
		somme += somme_ch(canal, compt1);						// moyenne canal
		
		// fonction d'affichage d'une ligne entre 2 points
		lcd_ch_ab_once(Val, &ValOld, coordY);					

		coordY++;														// point suivant
	}
	return (somme/80L);												// moyenne
}



//========================================================================================
// affiche une ligne entre 2 points (mode scope)
//========================================================================================
lcd_ch_ab_once(unsigned char Val, unsigned char * ValOld, unsigned char coordY){
	signed char ecart, cpt;
	lcd_plot(Val, coordY, 1);									// affiche le point mesur (mode dot)

	ecart = *ValOld-Val;
	if (ecart!=0){
		if (ecart>0) {
			if (ecart<8){ 											// diagonale montante
				for(cpt = ecart>>1; cpt>=0; cpt--){			// >= sinon manque 1 point (>>1 /2)
					lcd_plot((*ValOld)--, coordY-1, 1);	
				}
				for(cpt = ecart>>1; cpt>0; cpt--){			// /2			
					lcd_plot((*ValOld)--, coordY, 1);
				}
			}
			else {													// si ecart>=8  : front montant
				while(*ValOld & 0x07){							//ValOld%8	// zone de bits <8
					lcd_plot((*ValOld)--, coordY-1, 1);	
				}			
				lcd_plot(*ValOld, coordY-1, 1);				///sinon manque 1 point en bas
				while(*ValOld-Val>=8){							// zone de paquet de 8 bits
					*ValOld-=8;
					lcd_plot_8(*ValOld, coordY-1);
				}
				for(cpt = *ValOld-Val; cpt>=0; cpt--){		// zone de bits <8
					lcd_plot((*ValOld)--, coordY-1, 1);	
				}					
			}	
		}
		else {														// ecart<0
			if (ecart>-8){											// diagonale descendante
				for(cpt = ecart>>1; cpt<0; cpt++){			// /2   < ok ; <= 1 point de trop	
					lcd_plot((*ValOld)++, coordY-1, 1);
				}
				for(cpt = ecart>>1; cpt<0; cpt++){ 			// /2   <
					lcd_plot((*ValOld)++, coordY, 1);
				}
			}
			else {													// si ecart<=-8  : front descendant
				while(*ValOld & 0x07){							// ValOld%8!=0	// zone de bits <8
					lcd_plot((*ValOld)++, coordY-1, 1);	
				}			
				while(*ValOld-Val<=-8){							// zone de paquet de 8 bits
					lcd_plot_8(*ValOld, coordY-1);
					*ValOld = *ValOld + 8;//+=8;
				}
				for(cpt = *ValOld-Val; cpt<=0; cpt++){		// zone de bits <8
					lcd_plot((*ValOld)++, coordY-1, 1);	
				}					
			}
		}
	}
	*ValOld = Val;													// stockage pour ecart point suivant
}

//========================================================================================
// affiche les voies A et B en mode dot XY
//========================================================================================
lcd_ch_dotXY(void){
	unsigned char compt1; //coordX, coordY, tmp
// affichage dot XY
	for(compt1=1; compt1<80; compt1++){				// point 0 ???							
		lcd_ch_dotXY_once(compt1);
		/*tmp = ch1[compt1];
		coordX = (tmp >> 2) + 20;
		coordY = convert_lcd(CHB, compt1);
		lcd_plot(coordY , coordX, 1);					// CHB, CHA*/
	}
}

//========================================================================================
// affiche un point en mode XY
//========================================================================================
lcd_ch_dotXY_once(unsigned char compt){
	unsigned char coordX, coordY, tmp; //,compt1
	tmp = ch1[compt];
	coordX = (tmp >> 2) + 20;
	coordY = convert_lcd(CHB, compt);
	lcd_plot(coordY , coordX, 1);					// CHB, CHA*/
}


//========================================================================================
//   Menus de configuration 
//========================================================================================
menu_bord(void){
	lcd_clear();
	lcd_line_V(0, 1, 0, 63);
	lcd_line_V(127, 1, 0, 63);
}

//========================================================================================
//   Menu dessin (test fct plot x,y)		// 200 octets ROM
//========================================================================================
menu_dessin(unsigned char clav, unsigned char *c_x, unsigned char *c_y){

switch(clav){
	case 1:	(*c_x)--;
				(*c_y)--;
				break;
	case 2:	(*c_x)--;
				break;
	case 3:	(*c_x)--;
				(*c_y)++;
				break;
	case 4:	(*c_y)--;
				break;
	case 5:	(*c_x) = 32;
				(*c_y) = 64;
				lcd_clear();
				lcd_string_loc_lc("Fenetre de dessin",0,13);
				break;
	case 6:	(*c_y)++;
				break;
	case 7:	(*c_x)++;
				(*c_y)--;
				break;
	case 8:	(*c_x)++;
				break;
	case 9:	(*c_x)++;
				(*c_y)++;
				break;
	} 
	if (clav)	{
		lcd_plot(*c_x, *c_y, 1);
		tempo_x65ms(3);
		lcd_uchar("Cx=", 7,  4, *c_x);
		lcd_uchar("Cy=", 7, 90, *c_y);
	}	
	if (*c_x==8)   *c_x = 55;		// 0 63
	if (*c_x==56)  *c_x = 8;		// 64 0
	if (*c_y==0)   *c_y = 127;
	if (*c_y==128) *c_y = 0;
}

//========================================================================================
// Menu parametres oscilloscope
//========================================================================================
param_scope(unsigned char *gamme1, unsigned char *gamme2, unsigned char *timeB, unsigned char sonde1,
				unsigned char sonde2, unsigned char trigType, unsigned char clav){

	if ((clav==1)&&(*gamme1>=1)) (*gamme1)--;
	if ((clav==2)&&(*gamme1<=6)) (*gamme1)++;
///	if (clav==3) CHA_AC_RL = !CHA_AC_RL;	remplace par : relais_ac_dc_clav(..)

	if ((clav==4)&&(*gamme2>=1)) (*gamme2)--;
	if ((clav==5)&&(*gamme2<=6)) (*gamme2)++;
///	if (clav==6) CHB_AC_RL = !CHB_AC_RL;

	if ((clav>=1)&&(clav<=5)){ //&&(clav!=3)){
		ds1267(tabGain[*gamme2], tabGain[*gamme1]); 
	}

	if ((clav==7)&&(*timeB>0)) (*timeB)--;
	if ((clav==8)&&(*timeB<tabTimeSIZE-1)) (*timeB)++;
	//############ TEST pour >=50ms/div
	if ((clav==7)||(clav==8)) tempo = tabTime[*timeB];	


	lcd_string_loc_lc("A ", 0, 96);
	lcd_ac_dc(CHA_AC_RL);											// "ac" | "dc"
	lcd_string_loc_lc(&tabStrGain[((*gamme1)+sonde1)*5],1,96);	// *5 = <<2 + 1
	lcd_putchar('V');
							
	lcd_string_loc_lc("B ", 2, 96);
	lcd_ac_dc(CHB_AC_RL);											// "ac" | "dc"
	lcd_string_loc_lc(&tabStrGain[((*gamme2)+sonde2)*5],3,96);	// *5 = <<2 + 1
	lcd_putchar('V');
	
	lcd_string_loc_lc("Time/", 4, 96);
	lcd_string_loc_lc(&tabStrTime[(*timeB)*5],5,96);		// *5 = <<2 + 1
	lcd_putchar('s');													// secondes
	
	if (*timeB<=10) {													// 12us/div  20ms/div
		if (trigType<tabTrigSIZE) {								// Auto> / Auto< / Norm> / Norm< / Manuel
			lcd_string_loc_lc("Trig", 6,96);
			lcd_string_loc_lc(&tabTrig[trigType*6], 7, 96);	// *6 = <<2 + <<1		
		}
		//else lcd_string_loc_lc("XY", 0, 0);
		else {
			lcd_string_loc_lc("    ", 6,96);
			lcd_string_loc_lc("    ", 7,96+6);
		}							
	}
	else {																// 50ms/div  100s/div
		//if (trigType<tabTrigSIZE) {	
			lcd_string_loc_lc("Ech=", 6,96);							// Numero de l'echantillon
			lcd_uchar("  ",7,96, cptEch);								// 000  080
		//}
	}
}

//========================================================================================
// Commutation des relais AC/DC CHA+B
//========================================================================================
relais_ac_dc_clav(unsigned char clav){
	if (clav==3) CHA_AC_RL = !CHA_AC_RL;	
	if (clav==6) CHB_AC_RL = !CHB_AC_RL;	
}

//========================================================================================
//  initialisation des parametres
//========================================================================================
init_system(void){
	//=============== INITIALISATION DES PORTS I/O ===============//
	PORTA = 0;								// Sorties portA a 0
	PORTB = 0;								// sorties portB a 0
	PORTC = 0;								// sorties portC a 0
	PORTD = 0;								// sorties portD a 0
	PORTE = 0;								// sorties portE a 0
	
	OC = 1;									// latch 573 HZ
	ADC = 1;									// MAX114 HZ

//	ADCON0 = 0x85;							// 0b10000101 (Fosc/32, RA0, GO, 0, A/D on)
	ADCON0 = 0xC5;
	ADCON1 = 0x0E;							// 0b00001110 (left justify (8bits), RA0 ana)

	TRISA = 0b11011011;	 				// '1' entree ; '0' sortie
	TRISB = 0b11000001;					// '1' entree ; '0' sortie
	TRISC = 0b10011000;	 				// '1' entree ; '0' sortie
	TRISD = 0b00000000;	 				// '1' entree ; '0' sortie
	TRISE = 0b00000100;	 				// 'PortE+ mode portD (p37) 1' entree ; '0' sortie

	OPTION = OPTION_SET; 				// charge masque registre option
	INTCON = 0b01100000; 				// masque interruption, PIE, tmr0:RA4
	PIE1   = 0b00000001; 				// timer1
	//PIE2 = 0b00000000;
	T1CON = TMR1_SET;

	//========= INITIALISATION DES PERIPHERIQUES =========//

	init232(DebitSPBRG[DebitINIT]);	// port serie, pas de parite, 8bits, 1 stop
	i2c_init();								// initialisation Bus I2C
	TEMPO();
	lcd_init_both(64);					// initialisation du LCD (X=0, Y=0, Z=0)
}

//========================================================================================
//  initialisation Affichage Introduction
//========================================================================================
init_intro(void){
	tx232_puts("* Seb Scope *\n\r");
	tx232_puts("(c)by Seb 24-05-2003\n\r");
	lcd_bitmap(bmp0);			// seb scope
	tempo_x65ms(50);
	//lcd_bitmap(bmp1);			// winamp
	//tempo_x65ms(50);
}

//========================================================================================
// acquisition  666khz ( 1.5us/pts soit 12us/div (8pts) )	(front=TRIG_UP/DOWN)
//========================================================================================
acq_ch_12us(unsigned char canal, unsigned char trigger, unsigned char front, unsigned char timeout){
	unsigned char cpt;
	if (canal==ANA_CHA){
		IRP = 1;									// bank2/3
		FSR = ADRch1;							// bank2 adr 0x110 (0x10 + 0x80) 	
	}
	if (canal==ANA_CHB){
		IRP = 1;									// bank2/3
		FSR = ADRch2;
	}

	// (trigger bloquant avec test rapide clavier toutes les 10ms)
	ana_trig(ANA_CHA, trigger, front, 0x0000, timeout);	

	for(cpt = 80; cpt!=0; cpt--){
		ADC = 0;									// acquisition
		asm("nop");//asm("nop");
		INDF =  CAN_PORT;						// valeur n-1
		ADC = 1;
		FSR++;
	}
}

//========================================================================================
// acquisition de 50us  20ms/div sur CHA+CHB
// 25 instr par boucle soit 4.1666us/ech -> 33.3us/div (8pts)
//========================================================================================
acq_ch_33us(unsigned char trigger, unsigned char front, unsigned char timeout){
	unsigned char cpt;

	IRP = 1;										// bank2/3			// pointe sur tableau ch1 [0]
	FSR = ADRch1;								// bank2 adr 0x110 (0x10 + 0x80) 	

	ana_trig(ANA_CHA, trigger, front, 0x0000, timeout);							// while (trigger)
	
	CAN_A0 = 0;
			
	for(cpt = 80; cpt!=0; cpt--){															// cycles (total)
		CAN_A0 = 0;								// CHB pour echantillon suivant		// +1		(1)
		ADC = 0;									// acquisition	CHB						// +1		(2)
		asm("nop");																				// +1		(3)
		INDF =  CAN_PORT;						// valeur n-1	(CHA)						// +2		(5)
		ADC = 1;																					// +1		(7)

		//asm("nop");asm("nop");				// 600us min		// +2		(7)
		FSR += ADRch2_1;						// +0x80										// +2		(9)

		// sinon bug CHB = f(CHA)
		ADC = 0;																					// +1 	(10)
		ADC = 1;																					// +1		(11)

		CAN_A0 = 1;								// CHA pour echantillon suivant		// +1		(12)
		asm("nop");								// 185ns										// +1		(13)
		ADC = 0;									// acquisition CHA						// +1		(14)
		asm("nop");																				// +1		(15)
		INDF = CAN_PORT;						// valeur n-1 (CHB)						// +2		(17)
		ADC = 1;																					// +1		(18)
		FSR -= 0x7F;  							// 0x90 -> 0x11							// +2		(20)
		
		ADC = 0;																					// +1		(21)
		ADC = 1;																					// +1		(22)
	}																								// +3		(25)
	ADC = 1;										// libere le portD
}


//========================================================================================
// acquisition de 50us  20ms/div sur CHA+CHB
//========================================================================================
acq_ch_50us_20ms(unsigned char trigger, unsigned char front, unsigned char timeout){ //unsigned int tempo, 
	unsigned char cpt;

	IRP = 1;										// bank2/3
	FSR = ADRch1;								// bank2 adr 0x110 (0x10 + 0x80) 	

	ana_trig(ANA_CHA, trigger, front, tempo, timeout);								// while (trigger)

	CAN_A0 = 0;
			
	for(cpt = 80; cpt!=0; cpt--){															// cycles
		CAN_A0 = 0;								// CHB pour echantillon suivant		// +1		(1)
		asm("nop");																				// +1		(2)
		ADC = 0;									// acquisition	CHB						// +1		(3)
		asm("nop");																				// +1		(4)
		INDF =  CAN_PORT;						// valeur n-1	(CHA)						// +2		(6)
		ADC = 1;																					// +1		(7)

		asm("nop");asm("nop");																// +2		(9)
		FSR += ADRch2_1;						// +0x80										// +2		(11)
		
		ADC = 0;									// acquisition CHB						// +1		(12)

		/// 2 mesures sur CHB sinon CHB = f(CHA) + CHB
		ADC = 1;																					// +1		(13)
		CAN_A0 = 1;								// CHA pour echantillon suivant		// +1		(14)
		ADC = 0;									// acq CHA									// +1		(15)
		asm("nop");																				// +1		(16)
		INDF = CAN_PORT;						// valeur n-1 (CHB)						// +2		(18)
		ADC = 1;																					// +1		(19)
		FSR -= 0x7F;  // 0x90 -> 0x11														// +2		(21)

		// 6.25s, 12.5s, 25s, 62.5s, 125s, 250s, 625s, 1.25ms,2.5ms
		// 0xFFFF, 

		// tempo xx us		(6.25us a 2500us) - 5.1666us acquisition
		// initialisation TMR1(tempo);	// prescaler 1 -> 0-65535*tcyc = 0-10922.5us
		TMR1H = tempo >> 8;																	// +2		(23)
		TMR1L = tempo & 0x00FF;																// +2		(25)
		T1CON = 0b00000001;					// presc 1:1 osc/4 stop timer1 on	// +2		(27)
		while(TMR1H != 0); 																	// + xx us +3 (30)
		TMR1ON = 0;								// stop timer1								// +1		(31)
		
		ADC = 0;									// maj echantillon	(CHA)				// +1		(32)
		asm("nop");																				// +1		(33)
		ADC = 1;																					// +1		(34)
	}												// decfsz + goto							// +3		(37)
	ADC = 1;										// libere le portD
}

//========================================================================================
// acquisition de 50ms/div  100s/div sur CHA+CHB AVEC ISR TMR1 !!!
// stockage + affichage sur ISR timer1
//     mode cardiogramme??? ############
//		 si eff==0 : efface puis retrace grille
//========================================================================================
acq_ch_50ms_100s(unsigned char eff){  //unsigned int tempo, 
	//unsigned char cpt;

	GIE = 0;										// bloque ISR (debordement stack)
	if (eff==0) {
		lcd_eff_grille();							// effacement LCD 92 1ere colonnes
		lcd_grille();								// affichage grille						
	}
	
	IRP = 1;										// pointeur bank2/3
	FSR = ADRch1;								// bank2 adr 0x110 (0x10 + 0x80) 	

	saveFSR = FSR;
	init_TMR1(); //tempo);					// init base de temps
	///acq_ech();									// acquisition du 1er echantillon
	flagAcq = 0;
}

//========================================================================================
// acquisition d'un echantillon sur CH1 + 2 (avec FSR)
// 	pour acquisition de 50ms/div  100s/div sur CHA+CHB AVEC ISR TMR1 !!!
//========================================================================================
acq_ech(void){
	FSR = saveFSR;															// remise  jour FSR
	CAN_TRIS = 0xFF;														// input sur bus
	CAN_A1 = 1;																// CHA ou B
	CAN_A0 = 1;																// CHA

	ADC = 0;	asm("nop"); ADC = 1;	asm("nop"); 					// mesure pour mj canal
	ADC = 0;	asm("nop"); ADC = 1;	asm("nop"); 					// mesure reelle CHA 
	asm("nop"); asm("nop");asm("nop");asm("nop");				// min 610ns
	ADC = 0;	asm("nop"); 
	IRP = 1;																	// bank2/3	(precaution !)
	INDF = CAN_PORT;														// lit mesure n-1 (CHA)
	ADC = 1;	

	// Mesure CHB
	CAN_A0 = 0;																// CHB pour echantillon suivant			
	
	asm("nop"); asm("nop"); 
	FSR += ADRch2_1;														// +0x80											

	ADC = 0;	asm("nop");	ADC = 1;	asm("nop");						// mesure pour mj canal
	ADC = 0;	asm("nop"); ADC = 1;	asm("nop"); 					// mesure reelle CHB 
	 
	/////ADC = 0;	asm("nop"); 											// acquisition CHB		
			
	asm("nop");	 asm("nop");asm("nop");asm("nop");				// min 610ns	
	ADC = 0;	asm("nop"); 												// acquisition CHB		
			
	INDF = CAN_PORT;														// valeur n-1 (CHB)						
	FSR -= 0x7F;  															// recalage pointeur 0x90 -> 0x11														

	ADC = 1;																	// libere le portD
	cptEch++;																// inc. cpt echantillons
	saveFSR = FSR;															// sauvegarde FSR
}
//################################################################################################

//========================================================================================
// Switch acquisition 12us/div  100s/div
// timeB : [0-10]  -> [12us/div-20ms/div]
//         [11-21] -> [50ms/div-100s/div]
//========================================================================================
acquisition(unsigned char trigger, unsigned char front, unsigned char timeout, unsigned char timeB){
	// fait dans main //tempo = tabTime[timeB];			// calcul base de temps (TMR0)
	if (timeB==0) acq_ch_12us(ANA_CHA, trigger, front, timeout);	// 1CH 12us/div
	else {
		if (timeB==1) acq_ch_33us(trigger, front, timeout);		// 2CH 33us/div						
		else {
			if (timeB<=10) {										// 2CH 50us/div - 20ms/div sans ISR
				//         base tps, level trig., timeout trig.
				acq_ch_50us_20ms(trigger, front, timeout);//tempo, 
			}
			else {													// 2CH 50ms/div - 100s/div avec ISR timer1
				////######debug  acq_ch_50ms_100s(0); //tempo
			}
		}
	}
}

//========================================================================================
// Transfert data CHA/B/C/D
//========================================================================================
transfert_ch(unsigned char canal){
	unsigned char cpt, data;
	if (canal==ANA_CHA){
		IRP = 1;														// bank2/3
		FSR = ADRch1;												// bank2 adr 0x110 (0x10 + 0x80) 	
	}
	if (canal==ANA_CHB){
		IRP = 1;														// bank2/3
		FSR = ADRch2;
	}

	tx232('\n');													//	OU tx232_puts("\n\r");	
	for(cpt = 80; cpt!=0; cpt--){								// 96???
		IRP = 1;														// bank2/3
		data = INDF;
		tx232_2ascii(data);
		FSR++;
	}
}

//========================================================================================
// Transfert data rs232			(30ms  115200bps)
//========================================================================================
transfert232(unsigned char g1, unsigned char g2, unsigned char timeB,
				 unsigned char trigType, unsigned char trigger){
	
	tx232_puts("\n\r* Seb Scope *  DATA\n\r\x04");		// 0x04 : Ctrl+D (start)
	
	// --- Canal A ---	
	tx232_puts("Canal A : ");													
	tx232_puts(&tabStrGain[(g1)*5]);	// *5 = <<2 + 1
	tx232('V');
	if (CHA_AC_RL) tx232_puts("dc");
	else tx232_puts("ac");
	transfert_ch(ANA_CHA);

	// --- Canal B ---
	tx232_puts("\n\rCanal B : ");								
	tx232_puts(&tabStrGain[(g2)*5]);	// *5 = <<2 + 1
	tx232('V');
	if (CHB_AC_RL) tx232_puts("dc");
	else tx232_puts("ac");							
	transfert_ch(ANA_CHB);
	
	// --- Base de temps ---
	tx232_puts("\n\rTime /div");								
	tx232_puts(&tabStrTime[timeB*5]);// *5 = <<2 + 1

	// --- Trigger ---
	tx232_puts("s\n\rTrig ");									// secondes, Trigger
	tx232_puts(&tabTrig[trigType*6]);
	tx232_2ascii(trigger);
	tx232_puts(" \x1B");											// 0x1B : Esc (stop)
	flagTransfert = 0;											// RAZ flag
}

//========================================================================================
//   MAIN   
//========================================================================================
void
main(void){
	volatile unsigned char clav; 
	unsigned char c_x=32, c_y=64;//, c_z = 0;
	unsigned char cpt, tmpVolt, ana1, ana2, ana3, ana4, gain1 = 127, gain2 = 127;
	unsigned char gamme1 = 6, gamme2 = 6;						// gamme1/2 : attenuation d'entree
	unsigned char sonde1 = SONDEx1, sonde2 = SONDEx1;		// sonde x1(0) ou x10(3)
	unsigned char menu_bmp = 0, cpt_barre, timeB = 9;//0;
	///unsigned int tempo = 0;										// pour base Tps
	//                trig manu, trig declench, front,  Auto/Manu/...
	unsigned char trigSet = 127, trigger = 127, front=2, trigType = 0;
	//            timeout trig, tps rafraichissement, , nbAcq modeXY
	unsigned char timeout = 40, refresh = 40, tmr0H, nbRefresh = 8, nbRefreshCpt;
	unsigned char moyA = 127, moyB = 127;						// moyenne des canaux A et B
	unsigned char cptEchOld = 0;

//	CONFIGURATIONS DES ENTREES / SORTIES
	init_system();
	runStop = 1;														// RUN

	ds1267(gain2, gain1);
	CHA_AC_RL = DC;
	CHB_AC_RL = DC;
	CHC_AC_RL = AC;
	CHD_AC_RL = AC;

//	AFFICHAGE DE L'INTRODUCTION
	init_intro();
	
	for(;;){
		clav = ENTER;
/*		clav = clavier();												// lecture touche
		
		goto menu_princ;	// ### debug
	
		lcd_string_loc_lc("Bp ", 0, 96);	// 94
		lcd_putchar(clav+0x30);

		if (clav==10){

		}
*/			

	//-------------------------------------------------------------------------------------
	// MENU PRINCIPAL //
		if (clav==ENTER){
		menu_princ:	
			//menu_config();													// affiche menu de config.
			clavier_antirebond(ENTER);										// antirebond touche ENTER
			clav = RETOUR;// rafraichissement
			do{
				if (clav == RETOUR) menu_config();						// affiche menu de config.+refresh
				clav = clavier();
			//--------------------------------------------------------------------------------
			// MENU SCOPE //
				if (clav==1) {													
					clavier_antirebond(1);									// antirebond touche 1
					clav = RETOUR;
					do{
						if (clav == RETOUR) menu_scope();				// refresh
						clav = clavier();
					//--------------------------------------------------------------------------
					// 1 : Oscilloscope
						if (clav==1){			
							ds1267(tabGain[gamme2], tabGain[gamme1]);
							clavier_antirebond(1);
							clav = 12;
							///tmr0H = refresh;								// compteur TMR0h
							TMR0 = 0;
							OPTION = OPTION_TMR0;							// T0IF toutes les 10ms
							lcd_clear();	
							lcd_grille();
							flagAcq = 1; cptEch = 0;	
							do{
								if (runStop==0) {								// mode stop
									lcd_string_loc_lc("STOP ",7,96);		// Trigger STOP
									if (timeB<=10) {
										T0IF = 0;	
									}
									else {
										tmr1h2Flag = 0; 
									}								
								}
								
								if (timeB<=10) {								// <= 20ms/div (sans ISR)
									GIE = 0;				// bloquer timeB>10  ou  TMR1IE = 0
									if (T0IF) {
										tmr0H--;
										T0IF = 0;
									}
									if ((tmr0H == 0) && (clav == 0)) clav = 12;
									cptEch = 0; flagAcq = 1;//##########  cptEchOld = 0;	
								}
								else {											// >= 50ms/div (ISR)
									if ((cptEch==0)&&(flagAcq==1)){
										cptEchOld = 0; 
										tempo = tabTime[timeB];				// calcul base de temps (TMR0)
										//acquisition(trigger, front, timeout, timeB);//?? direct??
										acq_ch_50ms_100s(0); //tempo //programmation TMR1 + GIE=1
									}

									if (tmr1h2Flag==1) {						// interruption timer1
										acq_ech();								// cptEch++; dans acq_ech
										if (cptEch==1) {						// 1ere ValOld
											ana3 = convert_lcd(CHA, 0);	// ValOld de ana1
											ana4 = convert_lcd(CHB, 0);	// ValOld de ana2
										}
										if (cptEch>=80) {
											cptEch = 0;
											cptEchOld = 0;
											flagAcq = 1;						// signale la fin de l'acquisition
											// transfert automatique
											//transfert232(gamme1+sonde1, gamme2+sonde2, timeB, tabTrigSIZE-1, 0);
											flagTransfert = 1;
											// Persistance affichage (refresh -> tmr0 pour <=20ms/div)
											for(cpt=refresh/7; cpt>0; cpt--){ 
												tempo_x65ms(1); 	
												if ((clav=clavier())!=0) break;
											}
										}
										lcd_uchar("  ",7,96, cptEch);		// Compteur Echantillons
										tmr1h2Flag = 0;						// raz flag ISR tmr1h2
									}

									if (cptEchOld != cptEch) {				// Affichage des points
									
										for(cptEchOld=cptEchOld; cptEchOld<cptEch; cptEchOld++) {
											//FLAG_GIE_SAVE2;					// bloquer ISR debordement									
											ana1 = convert_lcd(CHA, cptEchOld);				// CHx, index
											lcd_ch_ab_once(ana1, &ana3, cptEchOld+13);	// 12? Val, &ValOld, nEch
											ana2 = convert_lcd(CHB, cptEchOld);				// CHx, index
											lcd_ch_ab_once(ana2, &ana4, cptEchOld+13);	// 12? Val, &ValOld, nEch
											//FLAG_GIE_REST2;
										}	
									}
									//lcd_start_ch(1);		// curseurs 'A' 'B'

								}
								
								//########DEBUG transfert rs232
								if (flagTransfert) { //(clav==13) {								// '13 (accessible que par rs232) 	
									transfert232(gamme1+sonde1, gamme2+sonde2, timeB, trigType, trigger);	
								}

								if (clav==10) {								// '0' Run/Stop
									runStop = !runStop;
								}
								
								if ((clav==12)&&(timeB<=10)) {			// '#' // timeB pour bloquer 1er refresh
									tmr0H = refresh;

									tempo = tabTime[timeB];					// calcul base de temps (TMR0)
									acquisition(trigger, front, timeout, timeB);	// acquisition

									lcd_eff_grille();							// effacement LCD 92 1ere colonnes
									lcd_grille();								// affichage grille	
									moyA = lcd_ch_ab(CHA);					// display CHA
									if (timeB!=0) moyB = lcd_ch_ab(CHB);// display CHB
									lcd_start_ch(timeB);						// curseur CHA+B
									
									// transfert automatique
									//transfert232(gamme1+sonde1, gamme2+sonde2, timeB, trigType, trigger);	
									flagTransfert = 1;
								}
								// '0' '9' '#' pour regler triger	: '9' TypeTrigger, '3' trig+8, '6' trig-8 
								
								if (clav==9) {									// Type de Trigger : Auto>,<, Norm>,<
									trigType++;
									if (trigType>=tabTrigSIZE) trigType = 0;
								}
								if (clav){
									if (trigType&0x01)	front = TRIG_DOWN;	// front desc.
									else						front = TRIG_UP; 		// front mont.
									if (trigType&0x02){						// Mode NORMAL
										if (clav==3)	trigSet+=8;
										if (clav==6)	trigSet-=8;
										trigger = trigSet;					
										// REFRESH curseur Trigger
									}									
									else {										// Mode AUTOMATIQUE
										trigger = moyA;						// mode Auto moyenne canal A
										relais_ac_dc_clav(clav);			// commut. AC/DC CHA+B
									}
									///FLAG_GIE_SAVE2;								// bloquer ISR debordement									
									lcd_trig(trigger);						// affiche curseur trig
									param_scope(&gamme1, &gamme2, &timeB, sonde1, sonde2, trigType, clav);
									///FLAG_GIE_REST2;
									clavier_antirebond(clav);
								}
								clav = clavier();
							}while(clav!=ECHAP);
							clavier_antirebond(ECHAP);
							GIE = 0;
							cptEch = 0; cptEchOld = 0;
							clav = RETOUR;
						}

					//--------------------------------------------------------------------------
					// 2 : Mode xy
						if (clav==2){
							ds1267(tabGain[gamme2], tabGain[gamme1]);
							clavier_antirebond(2);
							clav = 9;//12;
							TMR0 = 0;
							OPTION = OPTION_TMR0;							// T0IF toutes les 10ms
							lcd_clear();
							nbRefreshCpt = 1; cptEch = 0; flagAcq = 1;// pour >=50ms/div (aff grille)
							do{
								
								if (timeB<=10) {								// <=20ms/div
									if (T0IF) {
										tmr0H--;
										T0IF = 0;
									}
									if ((tmr0H == 0) && (clav==0)) clav = 12;
									cptEch = 0; flagAcq = 1;
								}
								else {											// >=50ms/div
									if ((cptEch==0)&&(flagAcq==1)){ //##nbRefreshCpt
										cptEchOld = 0; 
										tempo = tabTime[timeB];				// calcul base de temps (TMR0)
										nbRefreshCpt--;
										//lcd_uchar("!",6,50, nbRefreshCpt);		//# Compteur Echantillons
										acq_ch_50ms_100s(nbRefreshCpt);//si 0 effGrille
										//tempo //programmation TMR1 + GIE=1
									}

									if (tmr1h2Flag==1) {						// interruption timer1
										acq_ech();								// cptEch++; dans acq_ech
										if (cptEch>=80) {
											cptEch = 0;
											cptEchOld = 0;
											flagAcq = 1;						// signale la fin de l'acquisition
											// transfert automatique
											//transfert232(gamme1+sonde1, gamme2+sonde2, timeB, tabTrigSIZE-1, 0);
											flagTransfert = 1;
										}
										lcd_uchar("  ",7,96, cptEch);		// Compteur Echantillons
										tmr1h2Flag = 0;						// raz flag ISR tmr1h2
									}

									if (cptEchOld != cptEch) {				// Affichage des points
										for(cptEchOld=cptEchOld; cptEchOld<cptEch; cptEchOld++) {
											lcd_ch_dotXY_once(cptEchOld);	// trace les points
										}	
									}
								}
								
								//########DEBUG transfert rs232
								if (flagTransfert){ //(clav==13) {
									transfert232(gamme1+sonde1, gamme2+sonde2, timeB, tabTrigSIZE-1, 0);
									//, trigType, trigger);	// trigType= 0; pas de declench!!
								}

								if ((clav==9) || (nbRefreshCpt==0)) {
									if (timeB<=10) {	
										lcd_eff_grille();							// effacement LCD 92 1ere colonnes
										lcd_grille();
									}
									lcd_string_loc_lc("XY", 0, 0);		
									nbRefreshCpt = nbRefresh;
									goto mode_xy_0;
								}

								if (clav==12){
									mode_xy_0:
									tmr0H = refresh;
									nbRefreshCpt--;
									if (timeB<=10) { 
										tempo = tabTime[timeB];					// calcul base de temps (TMR0)################
										acquisition(0, TRIG_UP, 0, timeB);	// trigger:0, front, timeout 0
										lcd_ch_dotXY();							// Affichage
										// #transfert automatique
										//transfert232(gamme1+sonde1, gamme2+sonde2, timeB, trigType, trigger);	// trigType= 0; pas de declench!!
										flagTransfert = 1;
									}
								}
								if (clav) {
									//lcd_grille();		
									relais_ac_dc_clav(clav);				// commut. AC/DC
									param_scope(&gamme1, &gamme2, &timeB, sonde1, sonde2, tabTrigSIZE+1, clav);
									if (timeB==0) timeB++;					// supprime le mode 1 CH 12us/div 
									clavier_antirebond(clav);
								}
								clav = clavier();
							}while(clav!=ECHAP);
							clavier_antirebond(ECHAP);
							clav = RETOUR;
						}
					//--------------------------------------------------------------------------
					// 3 : Fast Fourier Transform
										
					//--------------------------------------------------------------------------
					// 4 : Parametres Scope
						if (clav==4){			
							clavier_antirebond(4);
							lcd_clear();
							clav = DISPLAY;
							do{
								if ((clav==1)&&(trigSet<255))		trigSet-=8;
								if ((clav==2)&&(trigSet>0)) 		trigSet+=8;
								if ((clav==4)&&(timeout>10)) 		timeout-=10;
								if ((clav==5)&&(timeout<250))		timeout+=10;
								if ((clav==7)&&(refresh>10)) 		refresh-=10;
								if ((clav==8)&&(refresh<250))		refresh+=10;
								if (clav==10) {
									nbRefresh++;
									if (nbRefresh==0) nbRefresh = 10;
									if (nbRefresh>20) nbRefresh = 0;
								}
								if (clav==9) {
									if (sonde1 == SONDEx1)	sonde1 = SONDEx10;			// x10
									else							sonde1 = SONDEx1;				// x1
								}
								if (clav==12) {
									if (sonde2 == SONDEx1)	sonde2 = SONDEx10;
									else							sonde2 = SONDEx1;
								}
								relais_ac_dc_clav(clav);					// commutation AC/DC (clav==3||6)
								
								if (clav){
									lcd_string_loc_lc("Sonde 1 x1", 1, 4);
									if (sonde1==SONDEx10) lcd_putchar('0');
									else lcd_putchar(' ');
									lcd_string_loc_lc("A ", 1, 96);
									lcd_ac_dc(CHA_AC_RL);					// "ac" | "dc"
									
									lcd_string_loc_lc("Sonde 2 x1", 2, 4);
									if (sonde2==SONDEx10) lcd_putchar('0');
									else lcd_putchar(' ');
									lcd_string_loc_lc("B ", 2, 96);
									lcd_ac_dc(CHB_AC_RL);					// "ac" | "dc"
									
									lcd_string_loc_lc("Trigger", 3, 4);	// canal, level, manu/auto...
									lcd_uchar("=", 3, 4+7*6, trigSet);									
									lcd_string_loc_lc("Timeout", 4, 4);
									lcd_uchar("=", 4, 4+7*6, timeout);
									lcd_puts("0ms");  //x10ms");
									lcd_string_loc_lc("Refresh", 5, 4);
									lcd_uchar("=", 5, 4+7*6, refresh);
									lcd_puts("0ms");  //x10ms");																		
									lcd_string_loc_lc("NbRefresh", 6, 4);
									lcd_uchar("=", 6, 4+9*6, nbRefresh);
									clavier_antirebond(clav);
								}

								clav = clavier();
							}while(clav!=ECHAP);
							clavier_antirebond(ECHAP);
							clav = RETOUR;
						}
						
					//--------------------------------------------------------------------------
					// 5 : Datalog 4 voies		// un ech toutes les xx minutes
					
					//--------------------------------------------------------------------------
					// 6 : Parametres Datalog 4

					}while(clav!=ECHAP);
					clavier_antirebond(ECHAP);
					clav = RETOUR;
				}				



			//--------------------------------------------------------------------------------
			// MENU ANALYSEUR LOG8 //
				if (clav==2){													
					clavier_antirebond(2);									// antirebond touche 2
					clav = RETOUR;
					lcd_clear();
					do{
						if (clav == RETOUR) menu_log8();					// refresh 
						clav = clavier();
						
					//--------------------------------------------------------------------------
					// 1 : Analyseur log8
						if (clav==1){			
							clavier_antirebond(1);
							lcd_clear();
							do{
								//if (clav){
								//}
								//             123456789012345678901
								lcd_string_loc_lc("Entrees logiques = ",0, 0); 								
								//lcd_goto(7, 0);								// ligne, colonne	
								lcd_hexa(read_log8());						
							
								if (clav) clavier_antirebond(clav);

								clav = clavier();
							}while(clav!=ECHAP);
							clavier_antirebond(ECHAP);
							clav = RETOUR;
						}
						
					//--------------------------------------------------------------------------
					// 2 : Parametres log8
					
					//--------------------------------------------------------------------------
					// 3 : Calibrage scope
						if (clav==3){
							clavier_antirebond(3);
							lcd_clear();
							cpt = 1;
							do{
								cpt--;
								if (cpt==0) {
									tmpVolt = ana12();
									ana1 = ana_114(ANA_CHA);
									ana2 = ana_114(ANA_CHB);
									ana3 = ana_114(ANA_CHC);
									ana4 = ana_114(ANA_CHD);
									cpt = 255;
								}
						
								lcd_uchar("V(12v)=", 1, 4, tmpVolt);
								lcd_uchar("CHA=", 2, 4, ana1);
								lcd_goto(2, 60);
								lcd_hexa(gain1);
								lcd_uchar("CHB=", 3, 4, ana2);
								lcd_goto(3, 60);
								lcd_hexa(gain2);
								lcd_uchar("CHC=", 4, 4, ana3);
								lcd_uchar("CHD=", 5, 4, ana4);	

								if (clav==1) ds1267(gain2, ++gain1);
								if (clav==2) ds1267(gain2, --gain1);
								if (clav==4) ds1267(++gain2, gain1);
								if (clav==5) ds1267(--gain2, gain1);
						
								if (clav==7) LUM_RL = !LUM_RL;

								lcd_string_loc_lc("Backlight O", 7, 4);
								if (LUM_RL) lcd_puts("N ");				// ON
								else lcd_puts("FF");							// OFF
						
								if (clav) clavier_antirebond(clav);
								clav = clavier();
							}while(clav!=ECHAP);
							clavier_antirebond(ECHAP);
							clav = RETOUR;
						}
					
					}while(clav!=ECHAP);					
					clavier_antirebond(ECHAP);								// antirebond touche ECHAP
					clav = RETOUR;
				}


			//--------------------------------------------------------------------------------
			// MENU DESSIN //
				if (clav==3){							
					clavier_antirebond(3);
					clav = 5;//lcd_clear();
					do{
						menu_dessin(clav, &c_x, &c_y);
						clav = clavier();
					}while(clav!=ECHAP);
					clavier_antirebond(ECHAP);
					clav = RETOUR;
				}

			//--------------------------------------------------------------------------------
			// MENU TRANSFERT DATA //
			// cmd.exe avec Try=5; wdt=1ms;COMx=115k;
				if (clav==4){
					clavier_antirebond(4);									// antirebond touche 5
					clav = DISPLAY;
					//lcd_clear();
					menu_tranf();
					cpt = 1;
					cpt_barre = 0;
					do{
						if (clav==(0x41-'0')) { // 'A' => 'A' ; 'B' (bootloader)
							//                 123456789012345678901
							lcd_string_loc_lc("DOWNLOAD ON" ,6, 56);//LCD_CENT(11));
							#asm
								ljmp 0x0000  ; RESET ==> bootloader
							#endasm 
						}
						if (clav==1) {
							transfert232(gamme1+sonde1, gamme2+sonde2, timeB, trigType, trigger);
						}
						cpt--;
						if (cpt==0) {
							flagClignoTranf = !flagClignoTranf;
							if (flagClignoTranf) {
								//                 123456789012345678901
								lcd_string_loc_lc("Detection !" ,6, 56);//LCD_CENT(11));
								//tempo_x65ms(2);
							}
							else {
								lcd_string_loc_lc("           " ,6, 56);//LCD_CENT(11));
								cpt = 128;
							}
						}
						clav = clavier();
					}while(clav!=ECHAP);					
					clavier_antirebond(ECHAP);								// antirebond touche ECHAP
					clav = RETOUR;
				}

			//--------------------------------------------------------------------------------
			// MENU BITMAP VIEWER //
				if (clav==5){
					clavier_antirebond(5);									// antirebond touche 5
					clav = DISPLAY;
					do{
						if (clav==3) menu_bmp+=4;
						if (clav==1) menu_bmp-=4;
						if (clav) {
							lcd_bitmap(menu_bmp);
							clavier_antirebond(clav);						// antirebond
						}
						clav = clavier();
					}while(clav!=ECHAP);					
					clavier_antirebond(ECHAP);								// antirebond touche ECHAP
					clav = RETOUR;
				}

			}while(clav!=ECHAP);
			//while(clav==ECHAP);
		}
	
			
	} // fin du for(;;)
}

//EOF//

