#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


unsigned char
calc_bmp(unsigned int x_out, unsigned char* entree){
	unsigned char sortie, rot;//, bit0, bit1, bit2, bit3, bit4, bit5, bit6, bit7;
	unsigned int adrBase; // [0-1023]

	adrBase = x_out/8;				//128*(x_out/64) + (x_out/8);
	if (x_out/64) adrBase+= (x_out/64)*128 - 8*(x_out/64);

	rot = 7-(x_out%8);
	rot = pow(2, rot);		// 2^rot : pour masquage

	// negatif

    sortie = 0;
	if (entree[adrBase] & rot) ; else sortie+=1; //bit0=0; else bit0=1;
	if (entree[adrBase+16] & rot) ; else sortie+=2; //bit1=0; else bit1=1;
	if (entree[adrBase+32] & rot) ; else sortie+=4; //bit2=0; else bit2=1;
	if (entree[adrBase+48] & rot) ; else sortie+=8; //bit3=0; else bit3=1;
	if (entree[adrBase+64] & rot) ; else sortie+=16; //bit4=0; else bit4=1;
	if (entree[adrBase+80] & rot) ; else sortie+=32; //bit5=0; else bit5=1;
	if (entree[adrBase+96] & rot) ; else sortie+=64; //bit6=0; else bit6=1;
	if (entree[adrBase+112] & rot) ; else sortie+=128; //bit7=0; else bit7=1;

	//sortie = bit7*128 + bit6*64 + bit5*32 + bit4*16 +bit3*8 + bit2*4 + bit1*2 + bit0;

	return sortie;
}



int main(int argc, char *argv[]){
	FILE *fpBmp, *fpBin, *fpC;
	int cpt, cptOut, z, x;
	char dataT[65], data[1024], dataOut[1024], y, reponse;
    char bmpFichier[32], binFichier[32], tampon[30];


	printf("\n---------------------------------------------------------------\n");
	printf("|          Conversion Bitmap n&b 128*64 pixels                |\n");
	printf("|          en fichier binaire pour EEprom I2c                 |\n");
	printf("|          ou en fichier 'C'                                  |\n");
	printf("---------------------------------------------------------------\n");



	if (argc!=3) {
		printf("\nbmp2i2c.exe fichierBMP.bmp fichierBIN.bin\n");

		printf("\nFichier BMP : ");
		fflush(stdin);
		scanf("%s", bmpFichier);
        fpBmp = fopen(bmpFichier, "rb");
		if (fpBmp == NULL) {
			printf("Erreur lors de l'ouverture du fichier : fichier inexistant !\n");
			exit(1);
        }

		printf("\nFichier BIN : ");
		fflush(stdin);
		scanf("%s", binFichier);
		fpBin = fopen(binFichier, "wb");
		// fopen si Fichier existant Ecraser O/N?
		if (fpBin == NULL) {
			printf("Erreur lors de l'ouverture du fichier.\n");
			exit(1);
        }
	}

    else{
		fpBmp = fopen(argv[1], "rb");				// ouverture Bmp (binaire)
		fpBin = fopen(argv[2], "wb");				// ouverture en ecriture fichier bin

		if ((fpBmp == NULL)||(fpBin == NULL)) {
			printf("\n\nErreur lors de l'ouverture du fichier");
			exit(1);
        }
		printf("Ouverture de :\n\t%s\net\n\t%s\nOK\n\n", argv[1], argv[2]);
    }

	fread(&dataT, sizeof(char), 62, fpBmp);  	// saute entete (62 octets)
	if (!strncmp(dataT, "BM>", 3)) printf("\nFichier source BMP dtect\n");
	else  {
		printf("\nFormat de fichier source BMP incorrect (noir & blanc 128*64)\n");
		exit(1);
	}
   
	////fwrite(&dataT, sizeof(char), 62, fpBin);  // debug pour voir BMP output

	// lecture du bitmap (1024 octets)
	printf("Nombre de caractres lus (bmp) : %d.\n",fread(&data, sizeof(char), 1024, fpBmp));

	// miroir horizontal
    cptOut = 0;  cpt = 1008;
	for(y=0; y<64; y++){
    	for(x=0; x<16; x++){
			dataOut[cptOut++] = data[cpt++];
		}
		cpt-=32;		// 2*16
	}

    // vide le tampon
	for(x=0; x<1024; x++){
		data[x] = 0;
	}

    // conversion Bmp -> Bin
    for(x=0; x<512; x++){
    	data[x] = calc_bmp(x, dataOut);					// lcd cote gauche
		data[x+512] = calc_bmp(x, &dataOut[8]);         // lcd cote droit
   	}

	// stockage dans fichier Bin
	fwrite(&data, sizeof(char), 1024, fpBin);
  
	fclose(fpBmp); 										// fermeture Bmp
	fclose(fpBin);                                      // fermeture Bin
	printf("Conversion finie\n\n");


	// fichier c : fichier_bmp[1024] = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
	// 								 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07}

	printf("\nVoulez vous crer un fichier 'C' (O\\N) ?\n");
	fflush(stdin);
	scanf("%c", &reponse);
	if ((reponse=='n')||(reponse=='N')) {
		printf("\nTermin !!!\n");
		exit(0);
    }

	printf("\nFichier 'C' : ");
	fflush(stdin);
	scanf("%s", binFichier);
	printf("Ouverture de %s\n",binFichier);
	fpC = fopen(binFichier, "w");
	// fopen si Fichier existant Ecraser O/N?
	if (fpC == NULL) {
		printf("Erreur lors de l'ouverture du fichier.\n");
		exit(1);
	}

    // Suppression du '.' dans le nom du fichier cible
	for(x=0; x<32; x++){
    	if(binFichier[x]=='.') binFichier[x]='_';
	}

    // Creation du fichier 'C'
	fprintf(fpC, "\n// Image pour lcd 128*64 pixels\n\nconst unsigned char %s[1024] = {",
			binFichier);
	for(x=0; x<1024; x++){
		if ((x%16)==0) fputs("\n\t\t", fpC);
		if(x!=1023) fprintf(fpC, "0x%02X, ", data[x] & 0xFF);
		else fprintf(fpC, "0x%02X\n};\n\n//\tCree par Bmp2I2c.exe by Seb (c) 2002",
					 data[x] & 0xFF);
	}

    fclose(fpC); 				// Fermeture du fichier

	printf("\nFINI\n");
	return 0;
}

// EOF //
