// lcd_port.h
//   configuration des entrees sorties

#ifndef LCD_PORT_H
#define LCD_PORT_H
#include <pic1687x.h>

//--- TIMER0 ---
#define OPTION_TMR0 0b10000111	// pullUp off, tmr0-> presc 256

//--- RELAIS ---
#define CHA_AC_RL	RA5		// Relais sortie A AC_DC (AC=0, DC=1) 
#define CHB_AC_RL	RA2		// Relais sortie B AC_DC (AC=0, DC=1) 
#define CHC_AC_RL	RE1		// Relais sortie C AC_DC (AC=0, DC=1) 
#define CHD_AC_RL	RE0		// Relais sortie D AC_DC (AC=0, DC=1) 


//--- CLAVIER ---
#define TRIS_CLAV	0b01110000	// D0-D3 : out D4-D6 : IN
#define TRIS_NORM	0b00000000	// data output
#define CLAV_DATA	PORTD		// data port
#define CLAV_PORT	0x08		// port clavier ASM


//--- ANALOGIQUE ---
#define V_SUP		RA1		// entree ana surveillance 12V pour stockage param (mise hors tension)


//--- AFFICHEUR LCD graphique ---
#define LCD_RS_DI	RB2		// Data / commande
#define LCD_R_W	RB4		// lecture / ecriture
#define LCD_EN		RB5		// Enable
#define LCD_DATA	PORTD		// D7-D0
#define LUM_RL		RB3		// backlight faible / fort
#define LCD_TRIS	TRISD		//
#define LCD_CS1	RC5		// chip select lcd cot gauche
#define LCD_CS2	RB1		// chip select lcd cot droit


//--- DS1267 : BUS 3 fils --- (potentiometres pour gain 0.004  255)
#define DS_RST		RC0		// /reset
#define DS_CLK		RD1		// horloge (sur bus de donnees PORTD)
#define DS_DQ		RD0		// donnees ( "     ""      " )
#define DS_DQ_asm	0x08,0x00	// PORTD,0
#define DS_TRIS	0x00		// pour CLK et DQ

//--- MAX114 : CAN 8 bits 4 voies ---
#define ADC			RC2		// conversion donnees (/RD-/WR-/CS)
#define CAN_A0		RC5		//	connect avec CS1 
#define CAN_A1		RB1		// connect avec CS2
#define INT			RA4		// interruption pour fin de converssion (compteur du nombre de mesures)
#define CAN_PORT	PORTD		// port de donnes mesures/LCD/clavier...
#define CAN_TRIS	TRISD		//


//--- LOG 8 bits : port numrique 8 bits + clock ---
#define OC			RC1		// chip select  0: transparant, 1:HZ
#define CLK_LOG	RB0		// clock
#define LOG_PORT	PORTD		// donnes
#define LOG_TRIS	TRISD		//


//--- BUS I2C ---
#define SCL			RC4		// clock 
#define SDA			RC3		// data


//--- PORT SERIE UART 9600bds/115kbds ---
#define RX232		RC7		// port serie
#define TX232		RC6		// idem 


#endif

