;Tutorial 5.2 - Nigel Goodwin 2002
;Sony SIRC IR transmitter
     LIST    p=16F628         ; Processzor tpust kzli az assemblerrel.
     include "P16F628.inc"    ; Alaprtelmezett belltsok a chip-hez.
     __config 0x3D18          ; Konfigurcis rtkek belltsa.
                              ; (_BODEN_OFF _WDT_OFF _LVP_OFF _MCLRE_OFF)
                              ; (_INTRC_OSC_NOCLKOUT)

     cblock  0x20             ; Az ltalnos cl regiszterek kezdcme.
             count1           ; Szmllk a ksleltet rutinhoz.
             counta
             countb
             count            ; Szmll a ciklus-rutinokhoz.
             Delay_Count
             Bit_Cntr
             Data_Byte
             Dev_Byte
             Rcv_Byte
             Pulse
     endc


IR_PORT  Equ PORTB            ; PortB-hez rendeljk az IR-adt.
IR_TRIS  Equ TRISB
IR_Out   Equ 0x01
IR_In    Equ 0x02
Ser_Out  Equ 0x01
Ser_In   Equ 0x02
SW1      Equ 7                ; Belltja a kapcsolk konstansait.
SW2      Equ 6
SW3      Equ 5
SW4      Equ 4

TV_ID    Equ 0x01             ; Az eszkzkdot 01-re lltja (TV).

But1     Equ 0x00             ; Szmbillentyk azonosti.
But2     Equ 0x01
But3     Equ 0x02
But4     Equ 0x03
But5     Equ 0x04
But6     Equ 0x05
But7     Equ 0x06
But8     Equ 0x07
But9     Equ 0x08
ProgUp   Equ d'16'            ; Nyomgombokhoz tartoz kdok.
ProgDn   Equ d'17'
VolUp    Equ d'18'
VolDn    Equ d'19'


     org     0x0000           ; Belltja a 16F628-as kezdeti cmt
                              ; (itt indul a program).

     goto    Start

     org     0x005     

Start
     movlw   0x07             ; Kikapcsoljuk a kompartort
     movwf   CMCON            ; (gy a 16F84-re hasonlt).

     clrf    IR_PORT          ; Trli a PortB kimeneteit.
      

     bsf     STATUS,RP0       ; Kivlasztjuk a Register Page 1-et.
     movlw   b'11111101'      ; PortB sszes kapuja bemenet (kivve RB1).
     movwf   IR_TRIS
     movlw   0xff             ; PortA sszes kapuja bemenet.
     movwf   PORTA
     bcf     STATUS,RP0       ; Vissza a Register Page 0-ra.

Read_Sw
     btfss   PORTA,SW1
     call    Switch1
     btfss   PORTA,SW2
     call    Switch2
     btfss   PORTA,SW3
     call    Switch3
     btfss   PORTA,SW4
     call    Switch4
     call    Delay27
     goto    Read_Sw

Switch1
     movlw   ProgUp           ; Konstans bemozgatsa a W regiszterbe.
     call    Xmit_RS232       ; Szubrutin hvsa.
     retlw   0x00             ; Visszatrs a hvs helyre.

Switch2
     movlw   ProgDn
     call    Xmit_RS232
     retlw   0x00

Switch3
     movlw   VolUp
     call    Xmit_RS232
     retlw   0x00

Switch4
     movlw   VolDn
     call    Xmit_RS232
     retlw   0x00

TX_Start
     movlw   d'92'
     call    IR_pulse
     movlw   d'23'
     call    NO_pulse
     retlw   0x00

TX_One
     movlw   d'46'
     call    IR_pulse
     movlw   d'23'
     call    NO_pulse
     retlw   0x00

TX_Zero
     movlw   d'23'
     call    IR_pulse
     movlw   d'23'
     call    NO_pulse
     retlw   0x00

IR_pulse              
     movwf   count            ; IR-LED villogtatsa 38kHz-en.
irloop
     bSF     IR_PORT,IR_Out 
     NOP
     NOP
     NOP
     NOP 
     NOP
     NOP
     NOP
     bCF     IR_PORT,IR_Out
     NOP
     NOP
     NOP
     NOP
     NOP
     NOP     
     NOP
     NOP     
     NOP
     NOP
     NOP
     NOP
     NOP
     NOP
     DECFSZ  count,F
     goTO    irloop     
     retLW   0

NO_pulse              
     movwf   count            ; Nem villogtatja az IR LED-et.
irloop2
     bCF     IR_PORT,IR_Out 
     NOP
     NOP
     NOP
     NOP
     NOP
     NOP
     NOP
     NOP 
     NOP
     NOP
     NOP
     bCF     IR_PORT,IR_Out
     NOP
     NOP     
     NOP
     NOP     
     NOP
     NOP
     NOP
     NOP
     NOP
     NOP
     DECFSZ  count,F
     goTO    irloop2     
     retLW   0

Xmit_RS232
     MOVWF   Data_Byte        ; W-t bemozgatja Data_Byte-ba.
     movLW   0x07             ; Belltja a 7 bites adat-kimenetet.
     movWF   Bit_Cntr
     call    TX_Start         ; Elkldi a start-bitet.
Ser_Loop
     RRF     Data_Byte,f      ; Elkld egy bitet.
     bTFSC   STATUS,C
     call    TX_One
     bTFSS   STATUS,C
     call    TX_Zero
     DECFSZ  Bit_Cntr,f       ; Teszteli, hogy minden rendben van-e.
     goTO    Ser_Loop
                              ; Most elkldi az eszkz azonostjt.
     movlw   D'1'
     movwf   Dev_Byte         ; Az eszkzt TV-re lltja.
     movLW   0x05             ; Bellt 5 kimeneti eszkz-bitet.
     movWF   Bit_Cntr
Ser_Loop2
    RRF      Dev_Byte,f       ; Elkld egy bitet.
    bTFSC    STATUS,C
    call     TX_One
    bTFSS    STATUS,C
    call     TX_Zero
    DECFSZ   Bit_Cntr,f       ; Teszteli, hogy minden rendben van-e.
    goTO     Ser_Loop2
    Retlw    0x00



; Ksleltet rutinok.

Delay255
     movlw   0xff             ; A ksleltets 255ms.
     goto    d0
Delay100
     movlw   d'100'           ; A ksleltets 100ms.
     goto    d0
Delay50
     movlw   d'50'            ; A ksleltets 50ms.
     goto    d0
Delay27
     movlw   d'27'            ; A ksleltets 27ms.
     goto    d0
Delay20
     movlw   d'20'            ; A ksleltets 20ms.
     goto    d0
Delay5
     movlw   0x05             ; A ksleltets 5.000 ms (4 MHz rajel).
d0
     movwf   count1
d1
     movlw   0xC7             ; A ksleltets 1ms.
     movwf   counta
     movlw   0x01
     movwf   countb
Delay_0
     decfsz  counta,f
     goto    $+2
     decfsz  countb,f
     goto    Delay_0

     decfsz  count1,f
     goto    d1
     retlw   0x00

; Ksleltet rutinok vge.

     end