;Tutorial 5_3
;Read SIRC IR and toggle LED display, save settings in EEPROM data memory.
;Nigel Goodwin 2002
     LIST    p=16F628         ; Processzor tpust kzli az assemblerrel.
     include "P16F628.inc"    ; Alaprtelmezett belltsok a chip-hez.
     __config 0x3D18          ; Konfigurcis rtkek belltsa.
                              ; (_BODEN_OFF _WDT_OFF _LVP_OFF _MCLRE_OFF)
                              ; (_INTRC_OSC_NOCLKOUT)
     ERRORLEVEL  0,-302       ; Elnyomja a bankvlts zeneteit.

     cblock  0x20             ; Az ltalnos cl regiszterek kezdcme.
             count1           ; Szmllk a ksleltet rutinhoz.
             counta
             countb
             count            ; Szmll a ciklus-rutinokhoz.
             LoX
             Bit_Cntr
             Cmd_Byte
             Dev_Byte
             Flags
             Flags2
             tmp1             ; tmeneti trolk.
             tmp2
             tmp3
             lastdev
             lastkey

     endc

LED_PORT Equ PORTB            ; PortB a LED-kijelz (vagy rel-kimenet).
LED_TRIS Equ TRISB

IR_PORT  Equ PORTA            ; PortA az IR vev.
IR_TRIS  Equ TRISA
IR_In    Equ 0x02             ; Bemenet hozzrendelse az IR-adathoz.

OUT_PORT Equ PORTB
LED0     Equ 0x00
LED1     Equ 0x01
LED2     Equ 0x02
LED3     Equ 0x03
LED4     Equ 0x04
LED5     Equ 0x05
LED6     Equ 0x06
LED7     Equ 0x07

EEPROM_Addr  Equ 0x00         ; A felhasznlt EEPROM byte cme.

ErrFlag      Equ 0x00
StartFlag    Equ 0x01         ; Zszl a fogadott bitnek.
One          Equ 0x02
Zero         Equ 0x03

New          Equ 0x07         ; Zszl a gomb elengedsnek jelzsre.

TV_ID        Equ 0x01         ; TV eszkz azonostja.

But1     Equ 0x00             ; Szmbillentyk azonosti.
But2     Equ 0x01
But3     Equ 0x02
But4     Equ 0x03
But5     Equ 0x04
But6     Equ 0x05
But7     Equ 0x06
But8     Equ 0x07
But9     Equ 0x08

     org     0x0000
     goto    Start

     org     0x0004
     retfie

Start
     movlw   0x07             ; Kikapcsoljuk a kompartort
     movwf   CMCON            ; (gy a 16F84-re hasonlt).

Initialise
     clrf    count
     clrf    PORTA
     clrf    PORTB
     clrf    Flags
     clrf    Dev_Byte
     clrf    Cmd_Byte

SetPorts
;****_***|***_****************_*******************************************
     bsf     STATUS,RP0       ; Kivlasztjuk a Register Page 1-et.
     movlw   0x00             ; sszes LED kapu kimenet.
     movwf   LED_TRIS
     movlw   b'11111111'      ; sszes IR kapu bemenet.
     movwf   IR_TRIS
     bcf     STATUS,RP0       ; Vissza a Register Page 0-ra.

     call    EE_Read          ; Elz belltsok visszatltse EEPROM-bl

Main
     call    ReadIR           ; IR jel beolvassa.
     call    ProcKeys         ; A fogadott parancsok feldolgozsa.
     goto    Main             ; Vgtelen ciklus.

ProcKeys
     btfss   Flags2,New
     retlw   0x00             ; Visszatrs, ha nem volt gombnyoms.
     movlw   TV_ID            ; TV azonost kd ellenrzse.
     subwf   Dev_Byte,W
     btfss   STATUS,Z
     retlw   0x00             ; Visszatrs, ah nem j kd.

     movlw   But1             ; Az 1. gomb tesztelse.
     subwf   Cmd_Byte,W
     btfss   STATUS,Z
     goto    Key1             ; Ha helyes a kd, akkor kvetkez gomb.

     movf    LED_PORT,W       ; PortB olvassa (LED sttusz),
     movwf   tmp3             ; majd trolsa temp regiszterben,
     btfss   tmp3,LED0        ; majd a LED bit tesztelse tkapcsolshoz.
     bsf     LED_PORT,LED0    ; LED bekapcsolsa.
     btfsc   tmp3,LED0
     bcf     LED_PORT,LED0    ; LED kikapcsolsa.
     bcf     Flags2,New       ; tlpi a New zszlt.
     call    EE_Write         ; EEPROM-ba menti a belltsokat.
     retlw   0x00

Key1
     movlw   But2             ; 2. gomb tesztelse.
     subwf   Cmd_Byte,W
     btfss   STATUS,Z
     goto    Key2             ; Ha helyes a kd, akkor kvetkez gomb.

     movf    LED_PORT,W       ; PortB olvassa (LED sttusz),
     movwf   tmp3             ; majd trolsa temp regiszterben,
     btfss   tmp3,LED1        ; majd a LED bit tesztelse tkapcsolshoz.
     bsf     LED_PORT,LED1    ; LED bekapcsolsa.
     btfsc   tmp3,LED1
     bcf     LED_PORT,LED1    ; LED kikapcsolsa.
     bcf     Flags2,New       ; tlpi a New zszlt.
     call    EE_Write         ; EEPROM-ba menti a belltsokat.
     retlw   0x00

Key2
     movlw   But3
     subwf   Cmd_Byte,W
     btfss   STATUS,Z
     goto    Key3

     movf    LED_PORT,W
     movwf   tmp3
     btfss   tmp3,LED2
     bsf     LED_PORT,LED2
     btfsc   tmp3,LED2
     bcf     LED_PORT,LED2
     bcf     Flags2,New
     call    EE_Write
     retlw   0x00

Key3
     movlw   But4
     subwf   Cmd_Byte,W
     btfss   STATUS,Z
     goto    Key4

     movf    LED_PORT,W
     movwf   tmp3
     btfss   tmp3,LED3
     bsf     LED_PORT,LED3
     btfsc   tmp3,LED3
     bcf     LED_PORT,LED3
     bcf     Flags2,New
     call    EE_Write
     retlw   0x00

Key4
     movlw   But5
     subwf   Cmd_Byte,W
     btfss   STATUS,Z
     goto    Key5

     movf    LED_PORT,W
     movwf   tmp3
     btfss   tmp3,LED4
     bsf     LED_PORT,LED4
     btfsc   tmp3,LED4
     bcf     LED_PORT,LED4
     bcf     Flags2,New
     call    EE_Write
     retlw   0x00

Key5
     movlw   But6
     subwf   Cmd_Byte,W
     btfss   STATUS,Z
     goto    Key6

     movf    LED_PORT,W
     movwf   tmp3
     btfss   tmp3,LED5
     bsf     LED_PORT,LED5
     btfsc   tmp3,LED5
     bcf     LED_PORT,LED5
     bcf     Flags2,New
     call    EE_Write
     retlw   0x00

Key6
     movlw   But7
     subwf   Cmd_Byte,W
     btfss   STATUS,Z
     goto    Key7

     movf    LED_PORT,W
     movwf   tmp3
     btfss   tmp3,LED6
     bsf     LED_PORT,LED6
     btfsc   tmp3,LED6
     bcf     LED_PORT,LED6
     bcf     Flags2,New
     call    EE_Write
     retlw   0x00

Key7
     movlw   But8
     subwf   Cmd_Byte,W
     btfss   STATUS,Z
     retlw   0X00

     movf    LED_PORT,W
     movwf   tmp3
     btfss   tmp3,LED7
     bsf     LED_PORT,LED7
     btfsc   tmp3,LED7
     bcf     LED_PORT,LED7
     bcf     Flags2,New
     call    EE_Write
     retlw   0x00

EE_Read
     bsf     STATUS,RP0       ; Bank 1 kivlasztsa.
     movlw   EEPROM_Addr
     movwf   EEADR            ; Cm az EEPROM olvasshoz.
     bsf     EECON1,RD        ; EEPROM olvassa.
     movf    EEDATA,W         ; EEDATA a W regiszterbe.
     bcf     STATUS,RP0       ; Bank 0 kivlasztsa.
     movwf   LED_PORT         ; Elz rtk visszalltsa.
     retlw   0x00

EE_Write
     movf    LED_PORT,W       ; Aktulis rtk olvassa.
     bsf     STATUS,RP0       ; Bank 1 kivlasztsa.
     bsf     EECON1,WREN      ; rs engedlyezse.
     movwf   EEDATA           ; Belltja az EEPROM adatot.
     movlw   EEPROM_Addr
     movwf   EEADR            ; Belltja az EEPROM cmet.
     movlw   0x55
     movwf   EECON2           ; 55h rsa.
     movlw   0xAA
     movwf   EECON2           ; AAh rsa.
     bsf     EECON1,WR        ; Belltja a WR bitet.
                              ; rs kezdete.
     bcf     STATUS,RP0       ; Bank 0 kivlasztsa.

     btfss   PIR1,EEIF        ; Vrakozik az rs befejezsre.
     goto    $-1
     bcf     PIR1,EEIF        ; Trli az 'rs ksz' zszlt.
     bsf     STATUS,RP0       ; Bank 1 kivlasztsa.
     bcf     EECON1,WREN      ; Irs letiltsa.
     bcf     STATUS,RP0       ; Bank 0 kivlasztsa.
     retlw   0x00


; IR rutinok.

; IR-jel olvassa.
ReadIR
     call    Read_Pulse
     btfss   Flags,StartFlag
     goto    ReadIR           ; Start-impulzusra vr (2.4ms).

Get_Data
     movlw   0x07             ; Elkszti 7 bit beolvasst.
     movwf   Bit_Cntr
     clrf    Cmd_Byte
Next_RcvBit2
     call    Read_Pulse
     btfsc   Flags,StartFlag  ; Eltr Start bit esetn vge.
     goto    ReadIR
     btfsc   Flags,ErrFlag    ; Ha hiba, vge.
     goto    ReadIR

     bcf     STATUS,C
     btfss   Flags,Zero
     bsf     STATUS,C
     rrf     Cmd_Byte,f
     decfsz  Bit_Cntr,f
     goto    Next_RcvBit2

     rrf     Cmd_Byte,f       ; Rendezi a 7 bites csoportot.

Get_Cmd
     movlw   0x05             ; Elkszti 5 bit beolvasst.
     movwf   Bit_Cntr
     clrf    Dev_Byte
Next_RcvBit
     call    Read_Pulse
     btfsc   Flags,StartFlag  ; Eltr Start bit esetn vge.
     goto    ReadIR
     btfsc   Flags,ErrFlag    ; Ha hiba, vge.
     goto    ReadIR

     bcf     STATUS,C
     btfss   Flags,Zero
     bsf     STATUS,C
     rrf     Dev_Byte,f
     decfsz  Bit_Cntr,f
     goto    Next_RcvBit

     rrf     Dev_Byte,f       ; Rendezi az 5 bites csoportot.
     rrf     Dev_Byte,f
     rrf     Dev_Byte,f

     retlw  0x00
; IR-jel olvass vge.


; Beolvas egy impulzust s belltja a StartFlag, a One, a Zero, vagy az
; ErrFlag zszlt. Az IR vev kimenete ltalban magas szint. Akkor vlt
; alacsonyra, ha jelet vesz.

Read_Pulse
     clrf    LoX
     btfss   IR_PORT,IR_In    ; Vrakozik a magas szintre.
     goto    $-1
     clrf    tmp1
     movlw   0xC0             ; Ksleltets a gombnyomsok kztt.
     movwf   tmp2

Still_High
     btfss   IR_PORT,IR_In    ; Vrakozik az alacsony szintre.
     goto    Next
     incfsz  tmp1,f
     goto    Still_High
     incfsz  tmp2,f
     goto    Still_High
     bsf     Flags2,New       ; Gombnyomskor belltja a New zszlt.
     goto    Still_High

Next
     nop
     nop
     nop
     nop
     nop                       ; Ksleltets az impulzus sklzshoz
     nop                       ; (8 bitesre).
     nop
     nop
     nop
     nop
     nop
     nop
     incf    LoX,f
     btfss   IR_PORT,IR_In
     goto    Next             ; Vrakozik a magas szintre.


; Impulzus-ellenrz rutinok.
; Ellenrzik, hogy Start, One, Zero, vagy Error tpusak-e.
     
Chk_Pulse
     clrf    Flags

TryError
     movf    LoX,W            ; Ellenrzs, ha az impulzus tl rvid.
     addlw   d'255' - d'20'   ; Ha a LoX <= 20.
     btfsc   STATUS,C
     goto    TryZero
     bsf     Flags,ErrFlag    ; Hibt tallt, belltja az Error zszlt.
     retlw   0x00

TryZero
     movf    LoX,W            ; Ellenrzs, ha zr.
     addlw   d'255' - d'60'   ; Ha a LoX <= 60.
     btfsc   STATUS,C
     goto    TryOne
     bsf     Flags,Zero       ; Zrt tallt, belltja a Zero zszlt.
     retlw   0x00

TryOne
     movf    LoX,W            ; Ellenrzs, ha 1.
     addlw   d'255' - d'112'  ; Ha a LoX <= 112.
     btfsc   STATUS,C
     goto    TryStart
     bsf     Flags,One        ; Egyet tallt, belltja a One zszlt.
     retlw   0x00

TryStart
     movf    LoX,W            ; Ellenrzs, ha Start.
     addlw   d'255' - d'180'  ; Ha a LoX <= 180
     btfsc   STATUS,C
     goto    NoMatch
     bsf     Flags,StartFlag   ; Start-impulzust tallt, belltja a zszlt
     retlw   0x00
NoMatch
                              ; Ha az impulzus tl hossz.
     bsf     Flags,ErrFlag    ; Hibt tallt, belltja az Error zszlt.
     retlw   0x00

; Impulzus-ellenrz rutinok vge.



; Ksleltet rutinok.

Delay255
     movlw   0xff             ; A ksleltets 255ms.
     goto    d0
Delay100
     movlw   d'100'           ; A ksleltets 100ms.
     goto    d0
Delay50
     movlw   d'50'            ; A ksleltets 50ms.
     goto    d0
Delay20
     movlw   d'20'            ; A ksleltets 20ms.
     goto    d0
Delay5
     movlw   0x05             ; A ksleltets 5.000 ms (4 MHz rajel).
d0
     movwf   count1
d1
     movlw   0xC7
     movwf   counta
     movlw   0x01
     movwf   countb
Delay_0
     decfsz  counta,f
     goto    $+2
     decfsz  countb,f
     goto    Delay_0

     decfsz  count1,f
     goto    d1
     retlw   0x00

; Ksleltet rutinok vge.


     end